function showToast(message, type = "green", time = 3000, useSwal = false) {

    if (useSwal) {
        if (type == "yellow") {
            Swal.fire({
                title: 'Processing...',
                text: message,
                icon: 'info',
                allowOutsideClick: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
        } else if (type == "green") {
            Swal.fire({
                title: 'Success',
                text: message,
                icon: 'success',
                confirmButtonText: 'OK'
            });
        } else {
            Swal.fire({
                title: 'Failed',
                text: message,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        }
        return;
    }


    var color;
    if (type == "green") {
        color = "#198754";
    } else if (type == "red") {
        color = "#dc3545";

    } else if (type == "yellow") {
        color = "#ffc107";

    } else {
        color = "#0d6efd";

    }


    Toastify({
        text: message,
        duration: time, // duration in milliseconds
        close: true, // show close button
        gravity: "top", // "top" or "bottom"
        position: "right", // "left", "center" or "right"
        backgroundColor: color, // custom background color
    }).showToast();

}

function dprocessCallBack(useSwal = false) {
    showToast("Processing", "yellow", 5000, useSwal);
}

function derrorCallBack(msg, useSwal = false) {

        var the_msg = msg;
        if (typeof msg !== 'object') {
            try {
                the_msg = JSON.parse(msg);
            } catch (e) {

            }
        }
        if (the_msg && the_msg.message) {
            the_msg = the_msg.message;
        } else if (the_msg && the_msg.data && the_msg.data.message) {
            the_msg = the_msg.data.message;
        }


    showToast(the_msg, "red", 4000, useSwal);
    setTimeout(function(){
        location.reload();
    }, 3000);
}

function dsuccessCallBack(res, useSwal = false) {
    if (res == "100") {
        showToast("Transaction Successful", "green", 4000, useSwal);
        setTimeout(function () {
            location.reload();
        }, 1000);
        return;
    }

    // Attempt to parse JSON if it's a string not "100"
    var data = res;
    if (typeof res !== 'object') {
        try {
            data = JSON.parse(res);
        } catch (e) {
            // Not JSON, assume error or raw message
            // If it's just a string and not "100", maybe an error?
            // But legacy behavior might be strict.
            // Let's check if we should show error if useSwal is on
            if (useSwal && res != "100") {
                 // showToast(res, "red", 4000, useSwal); // Risky if HTML returned
            }
        }
    }

    // Standard VtuPress Response Check
    if (data && (data.status === 'success' || data.success === true || data == "100")) {
        var msg = data.message || "Transaction Successful";
        showToast(msg, "green", 4000, useSwal);
        setTimeout(function () {
             location.reload();
        }, 1500);
    } else {
        // Find Error Message
        var msg = "An error occurred";
        if (data && data.message) {
            msg = data.message;
        } else if (data && data.data && data.data.message) {
            msg = data.data.message;
        }
        // showToast(msg, "red", 4000, useSwal);
        derrorCallBack(msg,true);
    }
}

function doAjax(url, data, request_type, response_type = "text", successCallback = dsuccessCallBack, processCallBack = dprocessCallBack, errorCallBack = derrorCallBack, useSwal = false) {

    if (url == "") {
        showToast("URL is not defined", "red", 2000, useSwal);
        return;
    } else if (!data || typeof data !== 'object') {
        showToast("Data object is not defined", "red", 2000, useSwal);
        return;
    } else if (request_type.toLowerCase() != 'post' && request_type.toLowerCase() != 'get') {
        showToast("Type must be either post or get", "red", 2000, useSwal);
        return;
    }
    
    if(!data.disable_process){
        processCallBack(useSwal);
    }
    // Call process callback with useSwal

    data['_nonce'] = vtupressobj.nonce;
    jQuery.ajax({
        url: url,
        data: data,
        dataType: response_type,
        "cache": false,
        "async": true,
        type: request_type.toUpperCase(),
        error: function (jqXHR, exception) {
            var msg = "";
            if (jqXHR.status === 0) {
                msg = "No Connection.\n Verify Network.";
            } else if (jqXHR.status == 403) {
                msg = "Access Forbidden [403].";
            } else if (jqXHR.status == 404) {
                msg = "Requested page not found. [404]";
            } else if (jqXHR.status == 500) {
                msg = "Internal Server Error [500].";
            } else if (exception === "parsererror") {
                msg = "Requested JSON parse failed.";
            } else if (exception === "timeout") {
                msg = "Time out error.";
            } else if (exception === "abort") {
                msg = "Ajax request aborted.";
            } else {
                msg = "Uncaught Error.\n" + jqXHR.responseText;
            }

            errorCallBack(msg, useSwal);
        },
        success: function (response) {
            successCallback(response, useSwal);
        }


    });

}
