<?php
if (!defined('ABSPATH')) {
    die("Not Allowed");
}

// if(!class_exists('Vtupress')){
//     include_once ABSPATH.'/wp-content/plugins/vtupress/includes/class.php';
// }
// include_once VTUPRESS_PATH . "/includes/class.php";
class Vtupress_Template_Container
{
    protected static array $instances = [];

    public static function get(string $id)
    {

        $registry = vtupress_template_registry();

        if (!isset($registry[$id])) {
            return null;
        } elseif (!class_exists($registry[$id])) {
            return null;
        }

        $key = $id;

        if (!isset(self::$instances[$key])) {
            $class = $registry[$id];
            self::$instances[$key] = new $class();
        }

        return self::$instances[$key];
    }

    public static function all(): array
    {
        $services = [];

        foreach (vtupress_template_registry() as $id => $class) {
            $services[$id] = self::get($id);
        }

        return $services;
    }

}


abstract class Template_class extends Vtupress
{
    public $id;
    public $name;
    public $description;
    public $status;
    public $template_url;
    public $template_path;
    public $thumbnail;
    public $custom;
    public $entry;
    public $login;

    public $current_timestamp;

    public $developer_mode;

    public $images_url;

    public $vtupress_admin_url;

    public $vtupress_templates_path;

    public $vtupress_templates_url;

    public $country;
    public $country_data;

    public function __construct()
    {
        $this->vtupress_templates_path = plugin_dir_path(__FILE__);
        $this->vtupress_templates_url = plugin_dir_url(__FILE__);
        $this->country = Vtupress_Country_Context::get();
        $this->country_data = $this->country_data();
    }

    public function country_data()
    {
        $country_array = Vtupress_Country_Manager::all();

        $country = isset($country_array[$this->country]) ? $country_array[$this->country] : false;
        $iso = $country["iso"] ?? '';
        $flag = $country["flag"] ?? '';
        $currency = $country["currency"];
        $currency_symbol = $country["symbol"];
        $country_code = $country["code"];
        $country_networks = $country["networks"] ?? '';
        $currency_name = $country["name"];
        $slogan = $country["slogan"];

        $country_json = json_encode($country_array);

        return [
            "country" => $this->country,
            "country_array" => $country_array,
            "country_json" => $country_json,
            "iso" => $iso,
            "flag" => $flag,
            "currency" => $currency,
            "currency_symbol" => $currency_symbol,
            "country_code" => $country_code,
            "country_networks" => $country_networks,
            "currency_name" => $currency_name,
            "slogan" => $slogan
        ];
    }

    private function default_settings(array $fields): array
    {
        $defaults = [];

        foreach ($fields as $key => $field) {
            if (
                isset($field['render']['value']) &&
                is_array($field['render']['value'])
            ) {
                $values = $field['render']['value'] ?? [];

                $firstKey = array_key_first($values);

                if ($firstKey !== null) {
                    $defaults[$key] = is_string($firstKey) ? $firstKey : $values[$firstKey];
                } else {
                    $defaults[$key] = '';
                }

            } else {
                $defaults[$key] = $field['render']['value'] ?? '';
            }
        }

        return $defaults;
    }

    public function global_enqueue()
    {
        wp_enqueue_style("global-sweet-css", $this->vtupress_templates_url . "/sweet/sweet.min.css", [], '1.0.0');
        wp_enqueue_style("global-toast-css", $this->vtupress_templates_url . "/assets/css/toast.css", [], '1.0.0');
        wp_enqueue_style("global-print-css", $this->vtupress_templates_url . "/assets/css/print.css", [], '1.0.0');
        wp_enqueue_style("global-fontawesome-1", $this->vtupress_templates_url . "/assets/fontawesome/css/all.css", [], '1.0.0');
        wp_enqueue_style("global-bs-css", $this->vtupress_templates_url . "/assets/bs/bootstrap.min.css", [], '1.0.0');

        wp_enqueue_script('jquery');
        wp_enqueue_script('jquery-ui-core');
        wp_enqueue_script("global-toast-js", $this->vtupress_templates_url . "/assets/js/toast.js", [], '1.0.0');
        wp_enqueue_script("global-sweet-js", $this->vtupress_templates_url . "/assets/js/sweet.js", [], '1.0.0');
        wp_enqueue_script("global-print-js", $this->vtupress_templates_url . "/assets/js/print.js", [], '1.0.0');
        wp_enqueue_script("global-pdf-js", "https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js", [], '0.10.1');
        wp_enqueue_script("global-custom-js", $this->vtupress_templates_url . "/assets/js/custom.js", [], rand(1111, 2222));
        wp_enqueue_script("global-bs-js", $this->vtupress_templates_url . "/assets/bs/bootstrap.min.js", [], '1.0.0');
        wp_localize_script('global-custom-js', 'vtupressInitPluginData', array(
            // 'nonce' => wp_create_nonce('vtupress_nonce'),
            'ajax_url' => admin_url('admin-ajax.php'),
        ));

    }

    public function enqueue_this_template_scripts()
    {

        global $post;

        if (!$post instanceof WP_Post) {
            return;
        }

        if (has_shortcode($post->post_content, 'vpaccount')) {
            $this->global_enqueue();
            $this->enqueue_template_scripts();
        }

    }

    public function maybe_save_settings(): void
    {
        if (
            empty($_POST['vtupress_template_save']) ||
            empty($_POST['_wpnonce']) ||
            !wp_verify_nonce($_POST['_wpnonce'], 'vtupress_save_template_' . $this->id)
        ) {
            return;
        }

        if (!current_user_can('manage_options')) {
            return;
        }


        $settings = [];
        $save_fields = $this->default_settings($this->form_fields());
        foreach ($save_fields as $key => $val) {

            $value = $_POST[$key] ?? '';

            if (is_array($value)) {
                $settings[$key] = array_map('sanitize_text_field', $value);
            } elseif (filter_var($value, FILTER_VALIDATE_URL)) {
                $settings[$key] = esc_url_raw($value);
            } else {
                $settings[$key] = sanitize_textarea_field($value);
            }

        }

        Vtupress_option::update($this->get_key(), $settings);

        add_action('vtupress_notices', function () {
            echo '<div class="alert alert-success"><p>Template settings saved.</p></div>';
        });
    }

    public function make_active($pg = "null")
    {
        if (!isset($_GET["vend"]) && $pg == "null") {
            echo "active";
        } elseif ($_GET["vend"] == "dashboard" && $pg == "null") {
            echo "active";
        } elseif (isset($_GET["smile"])) {
            if ($pg == "smile") {
                echo "active";
            }
        } elseif (isset($_GET["vend"])) {
            if ($_GET["vend"] == $pg) {
                echo "active";
            }
        } else {
            //do nothing
        }
    }

    protected function formData(): void
    {

        $form = $this->form_fields();
        $this->render($form);
    }
    private function render(array $form): void
    {
        $settings = $this->get_settings();

        ?>
        <div class="container-fluid container-md">
            <div class="row bg-info bordered-bottom">
                <div class="col-12 d-flex justify-content-center align-items-center py-2">
                    <span class="heading">
                        <h3 class="text-white "><i class="mdi mdi-bank me-2"></i><?php echo ucfirst($this->name); ?> Template
                            Settings
                        </h3>
                    </span>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12 d-flex flex-column justify-content-center">
                                    <h4 class="card-name"><?php echo ucfirst($this->name); ?> template Information</h4>
                                    <p class="card-text"><?php echo $this->description; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <form method="post" class="row rounded bg-white p-2 bordered py-md-3 px-md-3 toSave ">
                <!-- <form method="post"> -->
                <div class="col-12 my-3">
                    <?php do_action('vtupress_notices'); ?>
                </div>

                <?php wp_nonce_field('vtupress_save_template_' . $this->id); ?>
                <input type="hidden" name="vtupress_template_save" value="1">
                <?php

                foreach ($form as $key => $value) {

                    $show = $value["show"] ?? true;
                    if (!$show) {
                        continue;
                    }
                    $column = esc_html($value["column"] ?? "4");
                    $class = esc_html($value["class"] ?? "");
                    $inner_class = esc_html($value["render"]["class"] ?? "");

                    ?>
                    <div class="col-6 col-md-<?php echo $column . " " . $class; ?> my-3">
                        <label
                            for="<?php echo esc_html($value['label'] ?? ''); ?>"><?php echo esc_html($value['label'] ?? ''); ?>:</label>
                        <?php
                        //is_bool($value["render"]["value"])
                        if (is_array($value["render"]["value"])) {
                            ?>
                            <select name="<?php echo $key; ?>" class="form-control <?php echo $inner_class; ?>">
                                <?php foreach ($value["render"]["value"] as $key2 => $value2) {
                                    if (is_string($key2)) {
                                        $f_key = $key2;
                                        $f_value = $value2;
                                    } else {
                                        $f_key = strtolower($value2);
                                        $f_value = ucfirst($value2);
                                    }
                                    ?>
                                    <option value="<?php echo esc_attr($f_key); ?>" <?php selected($settings[$key] ?? '', $f_key); ?>>
                                        <?php echo esc_html($f_value); ?>
                                    </option>

                                <?php } ?>
                            </select>

                            <?php
                        } else {
                            $type = esc_html($value["render"]["type"] ?? 'text');
                            $field_value = esc_html($value["render"]["value"] ?? '');
                            ?>
                            <input class="form-control  <?php echo $inner_class; ?>" id="<?php echo $key; ?>"
                                type="<?php echo $type; ?>" name="<?php echo $key; ?>"
                                value="<?php echo $settings[$key] ?? $field_value; ?>">
                            <?php
                        }
                        ?>

                        <small><?php echo esc_html($value["description"] ?? ''); ?></small>
                    </div>

                    <?php
                }
                ?>
                <?php submit_button('Save template Settings'); ?>
                <!-- </form> -->
            </form>
        </div>
        <?php
    }
    public function get_settings(): array
    {
        return wp_parse_args(
            Vtupress_Option::get($this->get_key(), []),
            $this->default_settings($this->form_fields())
        );
    }
    protected function get_key(): string
    {
        return 'vtupress_template_' . $this->id;
    }

    private function get_menu_array($location)
    {

        $menus = [];

        $locations = get_nav_menu_locations();
        if (empty($locations[$location])) {
            return $menus;
        }

        $items = wp_get_nav_menu_items($locations[$location]);
        if (!$items) {
            return $menus;
        }

        // Index by parent
        $indexed = [];
        foreach ($items as $item) {
            $indexed[$item->menu_item_parent][] = $item;
        }

        foreach ($indexed[0] ?? [] as $item) {

            // icon from CSS class
            $icon = 'fas fa-angle-right';
            foreach ((array) $item->classes as $class) {
                if (strpos($class, 'fa-') !== false) {
                    $icon = $class;
                    break;
                }
            }

            $url = basename(untrailingslashit($item->url));
            $url = (stripos($url, '&wp') >= 0) ? ltrim($url, "/") : $url;
            $wp = get_post_meta($item->ID, '_vtupress_load', true) === '1';


            $menu = [
                'title' => $item->title,
                'url' => $url,
                'icon' => $icon,
                'wp' => true,
                'in_vtupress' => $wp,
                'active' => [],
                'children' => [],
            ];

            // children
            if (isset($indexed[$item->ID])) {
                foreach ($indexed[$item->ID] as $child) {
                    $url = basename(untrailingslashit($child->url));
                    //  $url = (stripos($url, '&wp') >= 0 )? ltrim($url,"/") : $url;
                    $wp = get_post_meta($child->ID, '_vtupress_load', true) === '1';

                    $menu['children'][] = [
                        'title' => $child->title,
                        'url' => $url,
                        'wp' => true,
                        'in_vtupress' => $wp
                    ];

                    // add child slugs for active detection
                    $menu['active'][] = basename(untrailingslashit($child->url));
                }
            }

            $menus[] = $menu;
        }

        return $menus;
    }

    public function menus(): array
    {

        $services = Vtupress_Service_Container::all(true);
        $menus = [];

        /** Dashboard */
        $menus[] = [
            'title' => 'Dashboard',
            'url' => 'dashboard',
            'icon' => 'fas fa-home',
            'active' => [null],
            'children' => [],
        ];

        /** Before services (WP menu) */
        $menus = array_merge($menus, $this->get_menu_array('vtupress-main'));

        /** History */
        $history_children = [
            [
                'title' => 'Wallet',
                'url' => 'history/wallet'
            ]
        ];

        /** Services */
        foreach ($services as $s) {

            if ($s->status != 'on')
                continue;

            $menus[] = [
                'title' => ucfirst(preg_replace("/_|-/", " ", $s->name)),
                'url' => $s->id,
                'icon' => str_replace('fa-solid', 'fas', $s->icon),
                'active' => [$s->id],
                'children' => [],
            ];

            $history_children[] = [
                'title' => ucfirst(preg_replace("/_|-/", " ", $s->name)),
                'url' => 'history/' . $s->id,
            ];
        }

        /** After services (WP menu) */
        $menus = array_merge($menus, $this->get_menu_array('vtupress-footer'));


        // foreach ($services as $s) {
        //     if ($s->status !== 'on')
        //         continue;
        //     if (!empty($s->custom_id) && Vtupress_option::get($s->custom_id, 'no') !== 'yes')
        //         continue;
        //     $history_children[] = [
        //         'title' => ucfirst(preg_replace("/_|-/", " ", $s->name)),
        //         'url' => 'history/' . $s->id,
        //     ];
        // }

        $menus[] = [
            'title' => 'History',
            'icon' => 'fas fa-history',
            'active' => array_column($history_children, 'url'),
            'children' => $history_children,
        ];


        /** Account */
        $account_children = [
            [
                'title' => 'Update Account',
                'url' => 'account'
            ],
            [
                'title' => 'Verify Account',
                'url' => 'kyc'
            ]
        ];
        if (!empty($account_children)):

            $menus[] = [
                'title' => 'Account',
                'icon' => 'fas fa-user',
                'active' => array_column($account_children, 'url'),
                'children' => $account_children,
            ];
        endif;

        $menus[] = [
            'title' => 'Developers APi',
            'url' => 'developer',
            'icon' => 'fas fa-code',
            'active' => '/developer',
            'children' => [],
        ];

        $menus[] = [
            'title' => 'Logout',
            'url' => wp_logout_url(get_permalink()),
            'icon' => 'fas fa-sign-out-alt',
            'active' => 'logout',
            'children' => [],
        ];


        return $menus;


    }
    //enqueue admin scripts
    abstract public function enqueue_template_scripts();

    //render admin page
    abstract public function render_user_dashboard();

    abstract public function form_fields();

    abstract public function render_menu();

    abstract public function render_admin_form();


}
class Msorg extends Template_class
{
    public function __construct()
    {

        parent::__construct();

        $this->status = true;
        $this->id = "msorg";
        $this->name = "Msorg";
        $this->description = "Msorg script styled template for VtuPress. Powerful, modern, and intuitive template for your website.";
        $this->template_url = $this->vtupress_templates_url . "/templates/msorg/";
        $this->template_path = $this->vtupress_templates_path . "/templates/msorg/";
        $this->thumbnail = $this->vtupress_templates_url . "/images/msorg.png";
        $this->custom = "";
        $this->entry = "dashboard.php";
        $this->login = "access.php";

    }

    public function enqueue_template_scripts()
    {
        //enqueue admin scripts here

        wp_enqueue_style("datatables-css", $this->template_url . "/msorg_template/datatables.css", [], '1.0.0');
        wp_enqueue_style("w3-css", $this->template_url . "/msorg_template/w3.css", [], '1.0.0');
        wp_enqueue_style("fonts-css", $this->template_url . "/msorg_template/fonts.min.css", [], '1.0.0');
        wp_enqueue_style("fonts2-css", $this->template_url . "/msorg_template/fonts.min2.css", [], '1.0.0');
        wp_enqueue_style("atlantis-css", $this->template_url . "/msorg_template/atlantis.css", [], '1.0.0');
        wp_enqueue_style("mtd-icon-font", $this->vtupress_templates_url . "/assets/icons/material-design-iconic-font/css/material-design-iconic-font.min.css", [], '1.0.0');
        wp_enqueue_style("mtd-css", $this->vtupress_templates_url . "/assets/icons/material-design-iconic-font/css/materialdesignicons.min.css", [], '1.0.0');
        wp_enqueue_style("mtd-css", $this->vtupress_templates_url . "/assets/icons/material-design-iconic-font/css/materialdesignicons.min.css", [], '1.0.0');
        wp_enqueue_style("custom-css", $this->template_url . "/msorg_template/custom.css", [], '1.0.0');
        
        wp_enqueue_script("datatables-js", $this->template_url . "/msorg_template/datatables.js", [], '1.0.0');
        wp_enqueue_script("init-js", $this->template_url . "/msorg_template/init.js", [], '1.0.0');
        wp_enqueue_script("analytics-js", $this->template_url . "/msorg_template/analytics.js", [], '1.0.0');
        wp_enqueue_script("webfonts-js", $this->template_url . "/msorg_template/webfont.min.js", [], '1.0.0');

        wp_enqueue_script('vtupress-popper', $this->template_url . '/msorg_template/popper.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-bootstrap', $this->template_url . '/msorg_template/bootstrap.min.js', ['jquery', 'vtupress-popper'], null, true);
        wp_enqueue_script('vtupress-jquery-ui-touch', $this->template_url . '/msorg_template/jquery.ui.touch-punch.min.js', ['jquery', 'jquery-ui-core'], null, true);
        wp_enqueue_script('vtupress-scrollbar', $this->template_url . '/msorg_template/jquery.scrollbar.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-moment', $this->template_url . '/msorg_template/moment.min.js', [], null, true);
        wp_enqueue_script('vtupress-chart', $this->template_url . '/msorg_template/chart.min.js', [], null, true);
        wp_enqueue_script('vtupress-sparkline', $this->template_url . '/msorg_template/jquery.sparkline.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-datatables', $this->template_url . '/msorg_template/datatables.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-notify', $this->template_url . '/msorg_template/bootstrap-notify.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-toggle', $this->template_url . '/msorg_template/bootstrap-toggle.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-dropzone', $this->template_url . '/msorg_template/dropzone.min.js', [], null, true);
        wp_enqueue_script('vtupress-fullcalendar', $this->template_url . '/msorg_template/fullcalendar.min.js', ['jquery', 'vtupress-moment'], null, true);
        wp_enqueue_script('vtupress-datetimepicker', $this->template_url . '/msorg_template/bootstrap-datetimepicker.min.js', ['jquery', 'vtupress-moment'], null, true);
        wp_enqueue_script('vtupress-tagsinput', $this->template_url . '/msorg_template/bootstrap-tagsinput.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-bootstrapwizard', $this->template_url . '/msorg_template/bootstrapwizard.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-validate', $this->template_url . '/msorg_template/jquery.validate.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-summernote', $this->template_url . '/msorg_template/summernote-bs4.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-select2', $this->template_url . '/msorg_template/select2.full.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-sweetalert', $this->template_url . '/msorg_template/sweetalert.min.js', [], null, true);
        wp_enqueue_script('vtupress-owl', $this->template_url . '/msorg_template/owl.carousel.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-magnific', $this->template_url . '/msorg_template/jquery.magnific-popup.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-loadingoverlay', $this->template_url . '/msorg_template/loadingoverlay.min.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-qrcode', $this->template_url . '/msorg_template/qrcode.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-html2pdf', $this->template_url . '/msorg_template/html2pdf.js', ['jquery'], null, true);
        wp_enqueue_script('vtupress-jspdf',  'https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js', [], null, true);

    }

    public function form_fields()
    {
        $fields = [
            "palette_settings" => [
                "label" => "Color Palettes (Auto-fill)",
                "description" => "Select a predefined color scheme to auto-fill the colors below.",
                "render" => [
                    "value" => [
                        "custom" => "Custom (Do not change)",
                        "01" => "01. Midnight Aurora", // #1e293b, #0f172a | #1a2035
                        "02" => "02. Deep Oceanic",   // #0f3443, #30e8bf | #0a1921
                        "03" => "03. Slate Frost",    // #2c3e50, #000000 | #111827
                        "04" => "04. Royal Glass",    // #051937, #004d7a | #020c1b
                        "05" => "05. Violet Night",   // #2d1b4e, #1a1a2e | #12122b
                        "06" => "06. Emerald Dusk",   // #064e3b, #022c22 | #022c22
                        "07" => "07. Carbon Fiber",   // #232526, #414345 | #1a1a1a
                        "08" => "08. Electric Indigo", // #4338ca, #1e1b4b | #1e1b4b
                        "09" => "09. Cyberpunk Blue",  // #000428, #004e92 | #000212
                        "10" => "10. Arctic Mist",     // #334d50, #cbcaa5 | #1e293b
                        "11" => "11. Dark Nebula",     // #000000, #434343 | #0a0a0a
                        "12" => "12. Steel Teal",      // #243b55, #141e30 | #0f172a
                        "13" => "13. Amethyst Dream",  // #4b0082, #000000 | #1a1033
                        "14" => "14. Crimson Night",   // #450a0a, #000000 | #280000
                        "15" => "15. Forest Shadow",   // #065f46, #064e3b | #022c22
                        "16" => "16. Space Gray",      // #414345, #232526 | #1e1e1e
                        "17" => "17. Twilight Rose",   // #312e81, #1e1b4b | #1e1b4b
                        "18" => "18. Deep Sapphire",   // #1e3a8a, #172554 | #1e3a8a
                        "19" => "19. Obsidian",        // #0f172a, #020617 | #020617
                        "20" => "20. Phantom Purple",  // #1e1b4b, #312e81 | #1a1033
                        "21" => "21. Purple Blue",      // #F83AC3, #121068 | #121068
                        "22" => "22. Default Purple",      // #680ee3, #090d54 | #1a2035
                    ]
                ]
            ],
            "color_from" => [
                "label" => "Color From",
                "description" => "",
                "render" => [
                    "value" => "#F83AC3"
                ]
            ],
            "color_to" => [
                "label" => "Color To",
                "description" => "",
                "render" => [
                    "value" => "#121068"
                ]
            ],
            "sidebar_color" => [
                "label" => "Sidebar Color",
                "description" => "",
                "render" => [
                    "value" => "#1a2035"
                ]
            ],
            "enable_ref_message" => [
                "label" => "Enable ref message",
                "description" => "",
                "render" => [
                    "value" => ["yes", "no"]
                ]
            ],
            "ref_message" => [
                "label" => "Referrer message",
                "description" => "",
                "render" => [
                    "value" => "To enjoy our referral program, refer friends and family to our website and ensure they upgrade their accounts. EARN immediately the person upgrade his/her account to RESELLER/TOP USERS . THIS IS PARTNERSHIP PROFIT"
                ]
            ],
            "enable_ref_link_copy_button" => [
                "label" => "Enable ref. copy button",
                "description" => "",
                "render" => [
                    "value" => ["yes", "no"]
                ]
            ],
            "enable_ctt_message" => [
                "label" => "Enable CTA message",
                "description" => "",
                "render" => [
                    "value" => ["yes", "no"]
                ]
            ],
            "ctt_message" => [
                "label" => "CTA message",
                "description" => "",
                "render" => [
                    "value" => "Own a retailer website and retail all our services; Such as DATA AND AIRTIME"
                ]
            ],
            "enable_ctt_button" => [
                "label" => "Enable CTA button",
                "description" => "",
                "render" => [
                    "value" => ["yes", "no"]
                ]
            ],
            "ctt_button_link" => [
                "label" => "CTA link",
                "description" => "",
                "render" => [
                    "value" => ""
                ]
            ],
            "enable_scroll_message" => [
                "label" => "Enable scrolling message",
                "description" => "",
                "render" => [
                    "value" => ["yes", "no"]
                ]
            ],
            "scroll_message" => [
                "label" => "Scrolling message",
                "description" => "",
                "render" => [
                    "value" => "Welcome"
                ]
            ],
            "enable_faq_button" => [
                "label" => "Enable FAQ button",
                "description" => "",
                "render" => [
                    "value" => ["yes", "no"]
                ]
            ],
            "faq_link" => [
                "label" => "FAQ link",
                "description" => "",
                "render" => [
                    "value" => ""
                ]
            ],
            "enable_download_button" => [
                "label" => "Enable download button",
                "description" => "",
                "render" => [
                    "value" => ["yes", "no"]
                ]
            ],
            "download_link" => [
                "label" => "Download link",
                "description" => "",
                "render" => [
                    "value" => "#"
                ]
            ]
        ];

        return $fields;
    }

    public function render_user_dashboard()
    {


        $enqueue_path = __DIR__ . "/enqueue.php";
        include_once($enqueue_path);
        
        global $wpdb;
        $msorg = $this->get_settings();

        $pallet = $msorg["palette_settings"];
        $color_from = $msorg["color_from"];
        $color_to = $msorg["color_to"];
        $color_sidebar = $msorg["sidebar_color"];
        if ($pallet != "custom") {
            $colors = [
                "01" => ["#1e293b", "#0f172a", "#1a2035"],
                "02" => ["#0f3443", "#30e8bf", "#0a1921"],
                "03" => ["#2c3e50", "#000000", "#111827"],
                "04" => ["#051937", "#004d7a", "#020c1b"],
                "05" => ["#2d1b4e", "#1a1a2e", "#12122b"],
                "06" => ["#064e3b", "#022c22", "#022c22"],
                "07" => ["#232526", "#414345", "#1a1a1a"],
                "08" => ["#4338ca", "#1e1b4b", "#1e1b4b"],
                "09" => ["#000428", "#004e92", "#000212"],
                "10" => ["#334d50", "#cbcaa5", "#1e293b"],
                "11" => ["#000000", "#434343", "#0a0a0a"],
                "12" => ["#243b55", "#141e30", "#0f172a"],
                "13" => ["#4b0082", "#000000", "#1a1033"],
                "14" => ["#450a0a", "#000000", "#280000"],
                "15" => ["#065f46", "#064e3b", "#022c22"],
                "16" => ["#414345", "#232526", "#1e1e1e"],
                "17" => ["#312e81", "#1e1b4b", "#1e1b4b"],
                "18" => ["#1e3a8a", "#172554", "#1e3a8a"],
                "19" => ["#0f172a", "#020617", "#020617"],
                "20" => ["#1e1b4b", "#312e81", "#1a1033"],
                "21" => ["#F83AC3", "#121068", "#121068"],
                "22" => ["#680ee3", "#090d54", "#090d54"],
            ];

            $selected_color = $colors[$pallet];
            $color_from = $selected_color[0];
            $color_to = $selected_color[1];
            $color_sidebar = $selected_color[2];
        }
        if (is_user_logged_in()) {
            $country = $this->country_data['country'];
            $iso = $this->country_data['iso'];
            $flag = $this->country_data['flag'];
            $currency = $this->country_data['currency'];
            $currency_symbol = $this->country_data['currency_symbol'];
            $country_code = $this->country_data['country_code'];
            $slogan = $this->country_data['slogan'];
            $country_networks = $this->country_data['country_networks'];
            $currency_name = $this->country_data['currency_name'];
            include_once VTUPRESS_PATH . "/user/pre_check.php";
            include_once $this->template_path . $this->entry;
            return;
        }
        include_once $this->template_path . $this->login;

    }

    public function render_admin_form()
    {
        ?>
        <script>
            jQuery(document).ready(function ($) {
                const palettes = {
                    "01": { from: "#1e293b", to: "#0f172a", side: "#1a2035" },
                    "02": { from: "#0f3443", to: "#30e8bf", side: "#0a1921" },
                    "03": { from: "#2c3e50", to: "#000000", side: "#111827" },
                    "04": { from: "#051937", to: "#004d7a", side: "#020c1b" },
                    "05": { from: "#2d1b4e", to: "#1a1a2e", side: "#12122b" },
                    "06": { from: "#064e3b", to: "#022c22", side: "#022c22" },
                    "07": { from: "#232526", to: "#414345", side: "#1a1a1a" },
                    "08": { from: "#4338ca", to: "#1e1b4b", side: "#1e1b4b" },
                    "09": { from: "#000428", to: "#004e92", side: "#000212" },
                    "10": { from: "#334d50", to: "#cbcaa5", side: "#1e293b" },
                    "11": { from: "#000000", to: "#434343", side: "#0a0a0a" },
                    "12": { from: "#243b55", to: "#141e30", side: "#0f172a" },
                    "13": { from: "#4b0082", to: "#000000", side: "#1a1033" },
                    "14": { from: "#450a0a", to: "#000000", side: "#280000" },
                    "15": { from: "#065f46", to: "#064e3b", side: "#022c22" },
                    "16": { from: "#414345", to: "#232526", side: "#1e1e1e" },
                    "17": { from: "#312e81", to: "#1e1b4b", side: "#1e1b4b" },
                    "18": { from: "#1e3a8a", to: "#172554", side: "#1e3a8a" },
                    "19": { from: "#0f172a", to: "#020617", side: "#020617" },
                    "20": { from: "#1e1b4b", to: "#312e81", side: "#1a1033" },
                    "21": { from: "#F83AC3", to: "#121068", side: "#121068" },
                    "22": { from: "#680ee3", to: "#090d54", side: "#1a2035" }
                };

                $('select[name="palette_settings"]').change(function () {
                    const val = $(this).val();
                    if (palettes[val]) {
                        $('#color_from').val(palettes[val].from);
                        $('#color_to').val(palettes[val].to);
                        $('#sidebar_color').val(palettes[val].side);
                    }
                });
            });
        </script>
        <?php
        $this->maybe_save_settings();
        $this->formData();
    }

    public function render_menu()
    {
        $menus = $this->menus();
        ?>
        <ul class="nav nav-primary">
            <?php foreach ($menus as $menu): ?>

                <?php if (empty($menu['children'])):
                    $url = isset($menu["wp"]) ? (($menu["in_vtupress"] == 1) ? $this->vtupress_resolve_url($menu['url']) . "?wp"
                        : home_url($menu['url'])) : $this->vtupress_resolve_url($menu['url']);

                    ?>

                    <li class="nav-item <?php $this->make_active($menu['active'][0] ?? null); ?>">
                        <a href="<?php echo esc_url($url); ?>">
                            <i class="<?php echo esc_attr($menu['icon']); ?>"></i>
                            <p><?php echo esc_html($menu['title']); ?></p>
                        </a>
                    </li>

                <?php else:
                    $control = sanitize_title($menu['title']) . 'Control';
                    ?>

                    <li class="nav-item
                <?php foreach ($menu['active'] as $a)
                    $this->make_active(basename($a)); ?>">
                        <a data-toggle="collapse" href="#<?php echo $control; ?>" aria-controls="<?php echo $control; ?>"
                            aria-expanded="false">
                            <i class="<?php echo esc_attr($menu['icon']); ?>"></i>
                            <p><?php echo esc_html($menu['title']); ?></p>
                            <span class="caret"></span>
                        </a>

                        <div class="collapse" id="<?php echo $control; ?>">
                            <ul class="nav nav-collapse">
                                <?php foreach ($menu['children'] as $child):
                                    $url = isset($child["wp"]) ? (($child["in_vtupress"] == 1) ? $this->vtupress_resolve_url($child['url']) . "?wp" : home_url($child['url'])) : $this->vtupress_resolve_url($child['url']);


                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url($url); ?>">
                                            <span class="sub-item"><?php echo esc_html($child['title']); ?></span>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </li>

                <?php endif; ?>

            <?php endforeach; ?>
        </ul>
        <?php

    }

}
class Classic extends Template_class
{
    public function __construct()
    {
        parent::__construct();

        $this->status = false;
        $this->id = "classic";
        $this->name = "Classic";
        $this->description = "Classic is a minimalist, modern, and user-friendly template for your website.";
        $this->template_url = $this->vtupress_templates_url . "/templates/classic/";
        $this->template_path = $this->vtupress_templates_path . "/templates/classic/";
        $this->thumbnail = $this->vtupress_templates_url . "/images/classic.png";
        $this->custom = "";
        $this->entry = "dashboard.html";
        $this->login = "access.php";

    }

    public function form_fields()
    {

    }
    public function enqueue_template_scripts()
    {
        //enqueue admin scripts here

    }

    public function render_user_dashboard()
    {
    }
    public function render_admin_form()
    {
        $this->formData();
    }

    public function render_menu()
    {
    }

}
class Opay extends Template_class
{
    public function __construct()
    {
        parent::__construct();

        $this->status = false;
        $this->id = "opay";
        $this->name = "Opay";
        $this->description = "Opay is a simple, user-friendly, and modern template for your website.";
        $this->template_url = $this->vtupress_templates_url . "/templates/opay/";
        $this->template_path = $this->vtupress_templates_path . "/templates/opay/";
        $this->thumbnail = $this->vtupress_templates_url . "/images/opay.png";
        $this->custom = "beast67093e5eb9b0b";
        $this->entry = "dashboard.php";
        $this->login = "access.php";

    }

    public function enqueue_template_scripts()
    {
        //enqueue admin scripts here

    }

    public function form_fields()
    {

    }

    public function render_user_dashboard()
    {
    }

    public function render_admin_form()
    {
        $this->formData();
    }

    public function render_menu()
    {
    }

}


function vtupress_template_registry()
{

    $templates = [];
    $templates['msorg'] = Msorg::class;
    $templates['classic'] = Classic::class;
    $templates['opay'] = Opay::class;

    // Let other classes register safely
    $templates = apply_filters('vtupress_template_registry', $templates);

    return $templates;
}