<?php
if(!defined('ABSPATH')){ die("access denied"); }
?>
<!-- Custom CSS for Activate Section -->
<style>
    :root {
        --vp-primary-color: <?php echo $color_from; ?>;
        --vp-secondary-color: <?php echo $color_to; ?>;
    }

    .vtupress-activate-wrapper {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
        background: transparent;
    }

    .vtupress-activate-card {
        width: 100%;
        max-width: 450px;
        background: #fff;
        border-radius: 12px;
        padding: 40px 30px;
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
        text-align: center;
        animation: vpFadeIn 0.6s ease-out;
        position: relative;
        overflow: hidden;
    }
    
    .vtupress-activate-card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 6px;
        background: linear-gradient(90deg, var(--vp-primary-color), var(--vp-secondary-color));
    }

    @keyframes vpFadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .vp-logo-area {
        margin-bottom: 20px;
        display: inline-block;
        padding: 10px;
        border-radius: 50%;
        background: #f8f9fa;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }

    .vp-logo-area img {
        height: 70px;
        width: 70px;
        object-fit: contain;
    }

    .vp-title {
        color: #333;
        font-weight: 700;
        margin-bottom: 30px;
        font-size: 1.5rem;
    }

    .vp-form-group {
        margin-bottom: 20px;
        text-align: left;
    }

    .vp-label {
        font-weight: 600;
        color: #666;
        margin-bottom: 8px;
        display: block;
        font-size: 0.9rem;
    }

    .vp-form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 2px solid #eaebed;
        background: #fff;
        height: 48px;
        font-size: 0.95rem;
        transition: all 0.2s;
        width: 100%;
        color: #333;
    }

    .vp-form-control:focus {
        border-color: var(--vp-primary-color);
        box-shadow: 0 0 0 3px rgba(0,0,0,0.05);
        outline: none;
    }
    
    .vp-btn-primary {
        border-radius: 8px;
        padding: 14px;
        font-weight: 700;
        background: linear-gradient(90deg, var(--vp-primary-color), var(--vp-secondary-color)) !important;
        border: none !important;
        width: 100%;
        color: white;
        font-size: 1rem;
        cursor: pointer;
        transition: opacity 0.2s, transform 0.2s;
        margin-top: 10px;
        outline: none !important;
    }
    .vp-btn-primary:hover { opacity: 0.95; }

    .vp-account-links {
        margin-top: 25px;
        font-size: 0.9rem;
        color: #888;
    }
    .vp-account-links a {
        color: var(--vp-primary-color);
        font-weight: 600;
        text-decoration: none;
    }

</style>

<div class="vtupress-activate-wrapper">
    <div class="vtupress-activate-card">
        
        <div class="vp-logo-area">
             <a href="<?php echo home_url(); ?>">
                <img src="<?php echo get_site_icon_url(100, plugins_url('vtupress-templates/templates/msorg/msorg_template/vlogo.png')); ?>" alt="Logo"/>
            </a>
        </div>
        
        <h3 class="vp-title">Activate Account</h3>

        <form method="POST" class="activate-form">
            
            <div class="vp-form-group">
                <label for="username" class="vp-label">Username</label>
                <input type="text" name="user" class="vp-form-control" required="" id="username" placeholder="Username">
            </div>

            <div class="vp-form-group">
                <label for="activate" class="vp-label">Activation Code</label>
                <input type="text" name="verify" class="vp-form-control" required="" id="activate" placeholder="Enter Code">
            </div>

            <div class="vp-form-group" style="margin-top: 30px;">
                <button type="button" class="btn btn-primary vp-btn-primary activate-now" id="activate-btn">
                    Activate Now
                </button>
            </div>

            <div class="vp-account-links">
                <p class="mb-2">Already have an account?</p>
                <a href="<?= home_url("/$slug/login/");?>">Login Here</a>
                <span class="mx-2">|</span>
                <a href="<?= home_url("/$slug/register/");?>">Sign Up</a>
            </div>
        </form>
    </div>
</div>

<script>

jQuery(document).ready(function($) {
    $(".activate-now").click(function () {
        var btn = $(this);
        var originalText = btn.html();
        
        btn.html('<i class="fas fa-spinner fa-spin"></i> Processing...');
        btn.prop('disabled', true);

        var obj = {};
        
        // Collect Inputs
        var toatl_input = $(".activate-form input").length;
        for (var run_obj = 0; run_obj < toatl_input; run_obj++) {
            var current_input = $(".activate-form input").eq(run_obj);
            var obj_name = current_input.attr("name");
            var obj_value = current_input.val();
            if (obj_name) {
                obj[obj_name] = obj_value;
            }
        }
        
        if (!obj.user || !obj.verify) {
            swal({
                title: "Error!",
                text: "Please enter username and activation code",
                icon: "error",
                button: "Okay",
            });
            btn.html(originalText);
            btn.prop('disabled', false);
            return;
        }

        obj['action'] = 'vtupress_activate_user';
        obj['disable_process'] = true;

        doAjax(
            vtupressobj.ajax_url,
            obj,
            'post',
            'json',
            function(data) {
                btn.html(originalText);
                btn.prop('disabled', false);

                if (data.status == "100" || data.status == 100) {
                     swal({
                        title: "Activation Successful!",
                        text: "You can now login.",
                        icon: "success",
                        timer: 2000,
                        buttons: false,
                    }).then(() => {
                        window.location.href = window.location.href.replace('activate','')+'/login';
                    });
                } else {
                    swal({
                        title: "Error!",
                        text: data.message || "Activation Failed",
                        icon: "error",
                        button: "Retry",
                    });
                }
            }
        );
    });
});
</script>