<?php
if(!defined('ABSPATH')){
    die("access denied");
}
?>
<!-- Custom CSS for Login Section -->
<style>
    :root {
        --vp-primary-color: <?php echo $color_from; ?>;
        --vp-secondary-color: <?php echo $color_to; ?>;
    }

    .vtupress-login-wrapper {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
        background: transparent;
    }

    .vtupress-login-card {
        width: 100%;
        max-width: 400px;
        background: #fff;
        border-radius: 12px;
        padding: 40px 30px;
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
        text-align: center;
        animation: vpFadeIn 0.6s ease-out;
        position: relative;
        overflow: hidden;
    }
    
    /* Top detailed bar */
    .vtupress-login-card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 6px;
        background: linear-gradient(90deg, var(--vp-primary-color), var(--vp-secondary-color));
    }

    @keyframes vpFadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .vp-logo-area {
        margin-bottom: 20px;
        display: inline-block;
        padding: 10px;
        border-radius: 50%;
        background: #f8f9fa;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }

    .vp-logo-area img {
        height: 70px;
        width: 70px;
        object-fit: contain;
    }

    .vp-login-title {
        color: #333;
        font-weight: 700;
        margin-bottom: 30px;
        font-size: 1.5rem;
        letter-spacing: -0.5px;
    }

    .vp-form-group {
        margin-bottom: 20px;
        text-align: left;
    }

    .vp-label {
        font-weight: 600;
        color: #666;
        margin-bottom: 8px;
        display: block;
        font-size: 0.9rem;
    }

    .vp-form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 2px solid #eaebed;
        background: #fff;
        height: 48px;
        font-size: 0.95rem;
        transition: all 0.2s;
        width: 100%;
        color: #333;
    }

    .vp-form-control:focus {
        border-color: var(--vp-primary-color);
        box-shadow: 0 0 0 3px rgba(0,0,0,0.05);
        outline: none;
    }
    
    .vp-btn-primary {
        border-radius: 8px;
        padding: 14px;
        font-weight: 700;
        background: linear-gradient(90deg, var(--vp-primary-color), var(--vp-secondary-color)) !important;
        border: none !important;
        width: 100%;
        color: white;
        font-size: 1rem;
        cursor: pointer;
        transition: opacity 0.2s, transform 0.2s;
        margin-top: 10px;
        outline: none !important;
    }

    .vp-btn-primary:active {
        transform: scale(0.98);
    }
    
    .vp-btn-primary:hover {
        opacity: 0.95;
    }

    .vp-account-links {
        margin-top: 25px;
        font-size: 0.9rem;
        color: #888;
    }

    .vp-account-links a {
        color: var(--vp-primary-color);
        font-weight: 600;
        text-decoration: none;
    }

    .vp-account-links a:hover {
        text-decoration: underline;
    }
    
    .vp-asterisk {
        color: #dc3545;
        margin-left: 2px;
    }
    
    .forgot-link {
        font-size: 0.85rem; 
        color: #888; 
        float: right;
        margin-top: 5px;
    }
    
    .forgot-link:hover {
        color: var(--vp-primary-color);
    }

</style>

<div class="vtupress-login-wrapper">
    <div class="vtupress-login-card">
        
        <div class="vp-logo-area">
            <a href="<?php echo home_url(); ?>">
                <img src="<?php echo get_site_icon_url(100, plugins_url('vtupress-templates/templates/msorg/msorg_template/vlogo.png')); ?>" alt="Logo"/>
            </a>
        </div>
        
        <h3 class="vp-login-title">Sign In</h3>

        <form method="POST" class="loginit">
            
            <div id="div_id_username" class="vp-form-group">
                <label for="id_username" class="vp-label">
                    Username<span class="vp-asterisk">*</span>
                </label>
                <input type="text" name="username" autofocus="" id="id_username" 
                       autocapitalize="none" autocomplete="username" 
                       class="vp-form-control textinput textInput form-control" required="" placeholder="Enter Username">
            </div>

            <div id="div_id_password" class="vp-form-group">
                <label for="password" class="vp-label">
                    Password<span class="vp-asterisk">*</span>
                </label>
                <input type="password" name="password" id="password" 
                       autocomplete="current-password" class="vp-form-control textinput textInput form-control" 
                       required="" placeholder="Enter Password">
                <a href="?reset_password" class="forgot-link">Forgot Password?</a>
            </div>

            <div class="vp-form-group" style="margin-top: 30px;">
                <button type="button" class="btn btn-primary vp-btn-primary loginow" id="loginow">
                    Sign In
                </button>
            </div>

            <div class="vp-account-links">
                <p class="mb-2">Don't have an account?</p>
                <a href="<?= home_url("/$slug/register/");?>" id="show-signup">Create Account</a>
                <span class="mx-2">|</span>
                <a href="<?= home_url("/$slug/activate/");?>" id="show-activate">Activate Account</a>
            </div>
        </form>
    </div>
</div>

<script>

jQuery(document).ready(function($) {
    $(".loginow").click(function () {
        var btn = $(this);
        var originalText = btn.html();
        btn.html('<i class="fas fa-spinner fa-spin"></i> Processing...');
        btn.prop('disabled', true);

        var obj = {};
        
        // Collect Inputs
        var toatl_input = $(".loginit input").length;
        for (var run_obj = 0; run_obj < toatl_input; run_obj++) {
            var current_input = $(".loginit input").eq(run_obj);
            var obj_name = current_input.attr("name");
            var obj_value = current_input.val();
            if (obj_name) {
                obj[obj_name] = obj_value;
            }
        }
        
        if (!obj.username || !obj.password) {
            swal({
                title: "Error!",
                text: "All fields are required",
                icon: "error",
                button: "Okay",
            });
            btn.html(originalText);
            btn.prop('disabled', false);
            return;
        }

        obj['action'] = 'vtupress_login_user';
        obj['disable_process'] = true;

        doAjax(
            vtupressobj.ajax_url,
            obj,
            'post',
            'json',
            function(data) {
                btn.html(originalText);
                btn.prop('disabled', false);

                if (data.status == "100" || data.status == 100) {
                    swal({
                        title: "Welcome Back!",
                        text: "Login Successful",
                        icon: "success",
                        timer: 2000,
                        buttons: false,
                    }).then(() => {
                        // let searchParams = new URLSearchParams(window.location.search);
                        // if (searchParams.has('vend')) {
                        //     window.location.href = "/vpaccount?" + searchParams + "#";
                        // } else {
                        //     window.location.href = "/vpaccount?" + data.name;
                        // }
                         window.location.href = location.href.replace('/login','');
                    });
                } else {
                    swal({
                        title: "Error!",
                        text: data.message || "Login Failed",
                        icon: "error",
                        button: "Retry",
                    });
                }
            }
        );
    });
});
</script>