<script>
	function greet() {

		var greeting;
		var time = new Date().getHours();
		if (time < 10) {
			greeting = "Good morning,";
		} else if (time < 20) {
			greeting = "Good day,";
		} else {
			greeting = "Good evening,";
		}
		document.getElementById("greet").innerHTML = greeting;
	}

	$(document).ready(function () { 
        greet(); 

        // FRONTEND ACCOUNT GENERATION
        $(document).on("click", ".generate_account", function(e) {
            e.preventDefault();
            
            var btn = $(this);
            var gateway = btn.data("gateway");
            var userId = btn.data("user-id") || "<?php echo get_current_user_id(); ?>";
            var bankName = btn.data("bank-name");

            swal({
                title: "Generate Account?",
                text: "Generate " + bankName + " account?",
                icon: "info",
                buttons: {
                    cancel: {
                        text: "Cancel",
                        visible: true,
                        className: "btn btn-danger"
                    },
                    confirm: {
                        text: "Yes, Generate",
                        className: "btn btn-success"
                    }
                }
            }).then((willGenerate) => {
                if (willGenerate) {
                    swal("Generating...", {
                        buttons: false,
                        closeOnClickOutside: false,
                        closeOnEsc: false,
                    });

                    $.ajax({
                        url: "<?php echo admin_url('admin-ajax.php'); ?>",
                        type: "POST",
                        data: {
                            action: "vtupress_generate_virtual_account",
                            gateway: gateway,
                            user_id: userId
                        },
                        dataType: "json",
                        success: function(response) {
                            if (response.success) {
                                swal("Success!", "Account generated successfully.", "success")
                                    .then(() => {
                                        location.reload();
                                    });
                            } else {
                                swal("Error", response.data.message || "Failed to generate account", "error");
                            }
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            swal("Error", "Request failed: " + textStatus, "error");
                        }
                    });
                }
            });
        });
    });
</script>
<div class="container">
	<?php
	$showArray = [];
	$showArray["showbtn"] = "";
	$showArray["showmodal"] = "";
	function banksbtn()
	{
		global $showArray;
		if (!empty($showArray["showbtn"])) {
			$msg = "";
		} else {
			$msg = "active";
			$showArray["showbtn"] = "active";
		}

		return $msg;
	}

	function banksmodal()
	{
		global $array;
		if (!empty($array["showmodal"])) {
			$msg = "";
		} else {
			$msg = "show active";
			$array["showmodal"] = "show active";
		}

		return $msg;
	}
	if ($notification_settings["popup_notification"] == "yes") {
		$meq = preg_replace('/\n|\t|\s|\r/', " ", $notification_settings["popup_message"]);
		?>
		<script>
			jQuery(window).on("load", function () {
				var word = "<?php echo $meq; ?>";
				swal({
					title: "NOTIFICATION",
					text: "<?php echo $meq; ?>",
					icon: "info",
					button: "Okay"
				});
			});
		</script>
		<?php
	}
	?>
	<div class="panel-header bg-secondary-gradient  py-3 bubble-shadow" style="">
		<div class="page-inner py-5">
			<div class="d-flex align-items-left align-items-md-center flex-column flex-md-row py-4">
				<div>
					<h2 class="text-white pb-2 fw-bold text-uppercase">Welcome to <?php echo get_bloginfo("name"); ?>
					</h2>
					<h5 class="text-white mb-2" style="font-size: 14px;">
						<p>
							<?php
							if (strtolower($msorg["enable_ref_message"]) == "yes") {
								echo $msorg["ref_message"];
							}

							?>
						</p>
					</h5>

					<?php
					if (strtolower($msorg["enable_ref_link_copy_button"]) == "yes") {
						?>
						<p class="mb-0 text-white" style="font-size: 13px;"> <b>Referal Link:</b>
							<span class="data-toggle="
								id="mytext"><?php echo home_url("/$slug/register/{$user['id']}"); ?></span>
							<span class="badge badge-dark" onclick="CopyToClipboard(&#39;mytext&#39;);"
								style="cursor: pointer;">copy</span>

						</p>
						<?php
					}

					?>

				</div>
				<div class="ml-md-auto py-2 py-md-0">
					<button type="button" class="btn btn-warning btn-round mr-2" data-bs-toggle="modal"
						data-bs-target="#WalletModal">
						Fund Wallet
					</button>
				</div>
				<?php if (current_user_can("administrator") || current_user_can("vtupress_admin") || current_user_can("vtupress_sales") || current_user_can("vtupress_user")) { ?>
					<div class="ml-md-auto py-2 py-md-0">
						<a href="/wp-admin/admin.php?page=vtupanel" role="button" class="btn btn-warning btn-round mr-2">
							Admin Dashboard
						</a>
					</div>
				<?php } ?>



			</div>

			<?php
			if (strtolower($msorg["enable_download_button"]) == "yes") {
				?>
				<a href="<?php echo $msorg['download_link']; ?>" style="margin-top:10px">
					<img src="<?php echo $this->vtupress_templates_url . "/images/templates/"; ?>/en_badge_web_generic.png"
						style="height:110px;">
				</a>
				<?php
			}
			?>

		</div>
	</div>


	<div class="page-inner mt--5">


		<div class="row mt--2">
			<div class="col-md-12">

				<div class="card full-height">
					<div class="card-body">
						<div class="card-title"><span id="greet">Good day,</span>
							<b><?php echo ucfirst($user["first_name"]); ?></b>
						</div>


						<hr>
						<p class="text-center " style="font-size:20px;"><b> Package : <?php echo $user["plan"]; ?> </b>
						</p>
					</div>

					<?php
					if (strtolower($msorg["enable_ctt_message"]) == "yes") {
						?>
						<p
							style="margin:10px; background-image:linear-gradient(45deg,#477f9a,#465abdd9);background-color:#ff0000;border-radius:10px;color:white;padding:7px;font-size:14px;">
							<span style="color:orange"><b>**NEW**</b></span>
							&nbsp; <?php echo $msorg["ctt_message"]; ?>
							<?php
							if (strtolower($msorg["enable_ctt_button"]) == "yes") {
								?>
								<a class="w3-btn  w3-border w3-round-large" href="<?php echo $msorg['ctt_button_link']; ?>"
									style="background-color:white;color:blue;">Click Here</a>
								<?php
							}
							?>
						</p>
						<?php
					}
					function accountNumber($aza, $generate)
					{
						$aza = strtolower($aza);

						if (empty($aza) || $aza == "false" || $aza == "null") {
							echo "<span class='btn btn-primary generate_account' for='$generate'><i class='fa fa-history'></i> Generate Account Number</span>";
						} else {
							echo $aza;
						}
					}


					$bvn = $user["bvn"];
					$nin = $user["nin"];


					###This is to show aza
					Vtupress_Gateway_Container::render_account_tabs($user["userId"] ?? get_current_user_id(), 'frontend');
					?>






					<?php
					if ($msorg["enable_scroll_message"] == "yes") {
						?>
						<marquee style="background-color: white; color:#d1026d; padding: 10px; font-size: 25px;">
							<?php echo $msorg["scroll_message"]; ?>
						</marquee>
						<?php
					}
					?>



					<div class="row d-flex justify-content-center">
						<div class="col-6 col-lg-3">
							<div class="card p-3">
								<div class="d-flex align-items-center">
									<span class="stamp stamp-md bg-warning mr-3">
										<i class="fas fa-history"></i>
									</span>
									<div>
										<h5 class="mb-1"><b><a href="?vend=history&for=wallet"> Wallet summary</a></b>
										</h5>

									</div>
								</div>
							</div>
						</div>






					</div>
				</div>
			</div>
		</div>
	</div>




	<div class="container-fluid-md px-5">
		<div class="row mb-3 mt-3 ">
			<div class="col-sm-6 col-md-4">
				<div class="card card-stats card-round">
					<div class="card-body ">
						<div class="row align-items-center">
							<div class="col-icon">
								<div class="icon-big text-center icon-primary bubble-shadow-small">
									<i class="fas fa-wallet"></i>
								</div>
							</div>
							<div class="col col-stats ml-3 ml-sm-0">
								<div class="numbers">
									<p class="card-category">Wallet Balance</p>
									<h4 class="card-title">₦ <?php echo do_shortcode("[vtupress get='balance']"); ?>
									</h4>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>


			<div class="col-sm-6 col-md-4">
				<div class="card card-stats card-round">
					<div class="card-body">
						<div class="row align-items-center">
							<div class="col-icon">
								<div class="icon-big text-center icon-info bubble-shadow-small">
									<i class="flaticon-coins"></i>
								</div>
							</div>
							<div class="col col-stats ml-3 ml-sm-0">
								<div class="numbers">
									<p class="card-category">Commissions</p>
									<h4 class="card-title">₦ <?php echo do_shortcode("[vtupress get='commission']"); ?>
									</h4>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-sm-6 col-md-4">
				<div class="card card-stats card-round">
					<div class="card-body">
						<div class="row align-items-center">
							<div class="col-icon">
								<div class="icon-big text-center icon-secondary bubble-shadow-small">
									<i class="fas fa-users"></i>
								</div>
							</div>
							<div class="col col-stats ml-3 ml-sm-0">
								<div class="numbers">
									<p class="card-category"> My Total Referral </p>
									<h4 class="card-title"><?php echo do_shortcode("[vtupress get='referrers']"); ?>
									</h4>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>


		</div>


		<div class="row">
			<div class="col-md-4">
				<div class="card card-dark bg-info-gradient">
					<div class="card-body bubble-shadow">
						<h3>Notifications</h3>
						<h5 class="op-9">
							<?php echo html_entity_decode($notification_settings["popup_message"]); ?>
						</h5>

					</div>
				</div>
			</div>

			<?php
			if (strtolower($msorg["enable_faq_button"]) == "yes") {
				?>

				<div class="col-md-4">
					<div class="card card-dark bg-info-gradient">
						<div class="card-body bubble-shadow">
							<h3>FAQs:</h3>
							<h5 class="op-9">Please go through them to have a better knowledge of this platform</h5>
							<a href="<?php echo $msorg["faq_link"]; ?>" class="btn btn-primary text-white">
								<i class="fas fa-question"></i> FAQs
							</a>
						</div>
					</div>
				</div>
				<?php
			}
			?>

			<div class="col-md-4">
				<div class="card card-dark bg-info-gradient">
					<div class="card-body bubble-shadow">
						<h3>Support Team:</h3>
						<h5 class="op-9">Have anything to say to us? Please contact our Support Team on Whatsapp </h5>

						<a href="whatsapp://send?phone=234<?php echo $settings["admin_whatsapp"]; ?>&amp;text=Hi,+I+need+your+help+with"
							class="btn btn-success mb-2"> <i class="fab fa-whatsapp"></i> Whatsapp us</a>

					</div>
				</div>
			</div>
			<?php if (!empty($settings["whatsapp_group_link"])): ?>
				<div class="col-md-4">
					<div class="card card-dark bg-info-gradient">
						<div class="card-body bubble-shadow">
							<h3>Support Team:</h3>
							<h5 class="op-9">Get latest updates and information on our business whatsapp group </h5>


							<a href="<?php echo $settings["whatsapp_group_link"]; ?>" class="btn btn-success"> <i
									class="fab fa-whatsapp"></i> Join our whatsapp group</a>


						</div>
					</div>
				</div>
			<?php endif; ?>
		</div>


		<div class="row">
			<div class="col-12 py-2 mt-4">
				<h2>Our Services:</h2>
			</div>
			<?php
			foreach ($services as $service):
				if (
					$service->status == "on"
				) {
					?>
					<div class="col-6 col-sm-4 col-lg-3">
						<a href="<?php echo home_url("/$slug/{$service->id}"); ?>">
							<div class="card">
								<div class="card-body p-3 text-center">
									<span style="font-size: 30px;">
										<img src="<?php echo !empty($service->image) ? $service->image :  VTUPRESS_URL . "/images/service/services.webp";  ?>"
											height="100px">
									</span>
									<div class="h4 m-2 text-dark"><?php echo ucwords($service->name); ?></div>
								</div>
							</div>
						</a>
					</div>
					<?php
				}

			endforeach;
			?>
		</div>

		<div class="m-3 row row-card-no-pd">
			<div class="col-12">
				<div class="card-title fw-bold">TRANSACTION STATISTICS</div>
				<hr>
			</div>
			<div class="col-sm-6 col-md-4">
				<div class="card card-stats card-round">
					<div class="card-body ">
						<div class="row">
							<div class="col-5">
								<div class="icon-big text-center">
									<i class="flaticon-chart-pie text-warning"></i>
								</div>
							</div>
							<div class="col-7 col-stats">
								<div class="numbers">
									<p class="card-category">WALLET BALANCE</p>
									<h4 class="card-title">
										₦<?php echo number_format(intval(do_shortcode("[vtupress get='balance']"))); ?>
									</h4>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-sm-6 col-md-4">
				<div class="card card-stats card-round">
					<div class="card-body ">
						<div class="row">
							<div class="col-5">
								<div class="icon-big text-center">
									<i class="flaticon-coins text-success"></i>
								</div>
							</div>
							<div class="col-7 col-stats">
								<div class="numbers">
									<p class="card-category">TRANSACTIONS</p>
									<h4 class="card-title">₦
										<?php echo do_shortcode("[vtupress get='successful_transactions']"); ?>
									</h4>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php if ($transaction_settings["enable_total_spent"] == "yes"): ?>
				<div class="col-sm-6 col-md-4">
					<div class="card card-stats card-round">
						<div class="card-body">
							<div class="row">
								<div class="col-5">
									<div class="icon-big text-center">
										<i class="flaticon-error text-danger"></i>
									</div>
								</div>
								<div class="col-7 col-stats">
									<div class="numbers">
										<p class="card-category">TOTAL SPENT</p>
										<h4 class="card-title">₦
											<?php echo number_format(intval(do_shortcode("[vtupress get='transaction_amount']"))); ?>
										</h4>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php endif; ?>
		</div>

		<div class="row mt-5 container-fluid">


		</div>
	</div>