<?php
function make_active($pg = "null")
{
    if (!isset($_GET["vend"]) && $pg == "null") {
        echo "active";
    } elseif ($_GET["vend"] == "dashboard" && $pg == "null") {
        echo "active";
    } elseif (isset($_GET["smile"])) {
        if ($pg == "smile") {
            echo "active";
        }
    } elseif (isset($_GET["vend"])) {
        if ($_GET["vend"] == $pg) {
            echo "active";
        }
    } else {
        //do nothing
    }
}
?>
<ul class="nav nav-primary">

    <li class="nav-item <?php make_active(); ?>">

        <a href="/vpaccount">
            <i class="fas fa-home"></i>
            <p>Dashboard</p>
        </a>
    </li>

    <?php
    /**
     * ##############
     * #############
     * Before services
     * ##############
     * ##############
     */
    $locations = get_nav_menu_locations();

    if ( isset( $locations['vtupress-main'] ) ) {
        wp_nav_menu( [
            'menu'        => $locations['vtupress-main'],
            'container'   => false,
            'items_wrap'  => '<ul class="nav">%3$s</ul>',
            'walker'      => new VTUPress_Menu_Walker(),
            'fallback_cb' => false,
        ] );
    }




    ?>


    <?php
    foreach ($services as $thisService):
        if ($thisService->status != "on") {
            continue;
        }
        if (!empty($thisService->custom_id) && Vtupress_option::get($thisService->custom_id, "no") != "yes"):
            continue;
        endif;
        $icon = str_replace("fa-solid", "fas", $thisService->icon);
        $loadUrl = $thisService->id;
        $name = ucfirst(preg_replace("/_|-/", " ", $thisService->name));

        ?>
        <li class="nav-item <?php make_active($loadUrl); ?>">

            <a href="<?php echo $loadUrl; ?>">
                <i class="<?php echo $icon; ?>"></i>
                <p><?php echo $name; ?></p>
            </a>
        </li>

        <?php

    endforeach;

    /**
     * ###############
     * ###############
     * After Services
     * ###############
     * ###############
     * 
     */

        if ( isset( $locations['vtupress-footer'] ) ) {
        wp_nav_menu( [
            'menu'        => $locations['vtupress-footer'],
            'container'   => false,
            'items_wrap'  => '<ul class="nav">%3$s</ul>',
            'walker'      => new VTUPress_Menu_Walker(),
            'fallback_cb' => false,
        ] );
    }

    ?>


    <!--History-->


    <li class="nav-item <?php make_active("history"); ?>">

        <a data-toggle="collapse" href="#historyControl" aria-controls="historyControl" aria-expanded="false">
            <i class="fas fa-history"></i>
            <p>History</p>
            <span class="caret"></span>
        </a>
        <div class="collapse" id="historyControl">
            <ul class="nav nav-collapse">
                <li>
                    <a href="/history/wallet"> <span class="sub-item">Wallet</span> </a>
                </li>
                <?php
                foreach ($services as $thisService):
                    if ($thisService->status != "on") {
                        continue;
                    }
                    if (!empty($thisService->custom_id) && Vtupress_option::get($thisService->custom_id, "no") != "yes"):
                        continue;
                    endif;
                    $name = ucfirst(preg_replace("/_|-/", " ", $thisService->name));

                    ?>
                        <li>
                            <a href="/history/<?php echo $thisService->id;?>"> <span class="sub-item"><?php echo $name;?></span> </a>
                        </li>

                    <?php

                endforeach;
                ?>
            </ul>
        </div>
    </li>


    <!--End Of History-->

    <li class="nav-item <?php make_active("wallet");
    make_active("withdraw");
    make_active("transfer"); ?>">

        <a data-toggle="collapse" href="#walletControl" aria-controls="walletControl" aria-expanded="false">
            <i class="fas fa-credit-card"></i>
            <p>Funds</p>
            <span class="caret"></span>
        </a>
        <div class="collapse" id="walletControl">
            <ul class="nav nav-collapse">
                <li>
                    <a href="/wallet"> <span class="sub-item">Wallet Top-Up</span> </a>
                </li>
                <li>
                    <a href="/wallet/manual"> <span class="sub-item">Manual Transfer</span> </a>
                </li>
                <li>
                    <a href="/wallet/coupon"> <span class="sub-item">Coupon Funding</span> </a>
                </li>
            </ul>
        </div>
    </li>


    <li
        class="nav-item <?php make_active("kyc");
        make_active("upgrade");
        make_active("changepin");
        make_active("changeemail"); ?>">

        <a data-toggle="collapse" href="#accountControl" aria-controls="accountControl" aria-expanded="false">
            <i class="fas fa-user"></i>
            <p>Account</p>
            <span class="caret"></span>
        </a>
        <div class="collapse" id="accountControl">
            <ul class="nav nav-collapse">
                <li>
                    <a href="/wallet"> <span class="sub-item">Fund Wallet</span> </a>
                </li>
            </ul>
        </div>
    </li>




    <?php
    if (is_plugin_active("vprest/vprest.php") && vp_option_array($option_array, "resell") == "yes" && strtolower($level[0]->developer) == "yes") {
        ?>
        <li class="nav-item <?php make_active("developer"); ?>">

            <a href="/developer">
                <i class="fas fa-code"></i>
                <p>Developer's API</p>
            </a>
        </li>
        <?php
    }
    ?>


    <li class="nav-item">
        <a href="<?php echo wp_logout_url(get_permalink()); ?>">
            <i class="fas fa-sign-out-alt"></i>
            <p>Logout</p>
        </a>
    </li>

    <li class="nav-item">
        <a href="#version">
            <?php
            $vtupress_version = get_plugin_data(ABSPATH . "wp-content/plugins/vtupress/vtupress.php")["Version"];
            $theme_version = get_plugin_data(ABSPATH . "wp-content/plugins/vtupress-templates/vtupress-templates.php")["Version"];
            ?>
            <i class="fas fa-info"></i>
            <p>Plugin <?php echo $vtupress_version; ?></p>
            <p>Theme <?php echo $theme_version; ?></p>
        </a>
    </li>
</ul>