<?php
if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;
$user_id = get_current_user_id();
$vp_id = (new Users())->getUser($user_id, true, true)["id"];
$wallet_table = $wpdb->prefix . 'vtupress_wallet';

// User context: filtered by user_id
$transactions = $wpdb->get_results(
    $wpdb->prepare(
        "SELECT * FROM $wallet_table WHERE user_id = %d ORDER BY id DESC LIMIT 1000",
        $vp_id
    ),
    ARRAY_A
);

$summary = [
    'credit' => 0,
    'debit' => 0,
    'refund' => 0,
    'credit_amount' => 0.00,
    'debit_amount' => 0.00,
    'refund_amount' => 0.00
];

foreach ($transactions as $txn) {
    if ($txn['type'] == 'credit') {
        $summary['credit']++;
        $summary['credit_amount'] += (float) $txn['fund_amount'];
    } elseif ($txn['type'] == 'debit') {
        $summary['debit']++;
        $summary['debit_amount'] += (float) $txn['fund_amount'];
    } elseif ($txn['type'] == 'refund') {
        $summary['refund']++;
        $summary['refund_amount'] += (float) $txn['fund_amount'];
    }
}
$currency_symbol = '₦'; // Assuming default, or fetch from settings if preferred
?>

<div class="container-fluid history-container mt-4">
    <style>
        .history-container * {
            font-family: 'Roboto', sans-serif;
        }

        /* Glassmorphism Styling */
        .vtupress-summary {
            padding: 20px 0;
        }

        .vtupress-glass {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 15px;
            padding: 20px;
            transition: all 0.3s ease;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.07);
            display: flex;
            align-items: center;
            height: 100%;
        }

        .vtupress-glass:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 40px 0 rgba(31, 38, 135, 0.12);
            background: rgba(255, 255, 255, 0.85);
        }

        .glass-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-size: 1.6rem;
        }

        .glass-content h6 {
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #6c757d;
        }

        .glass-content h3 {
            margin: 0;
            font-weight: 700;
            color: #2d3436;
        }

        /* Status Specific Accents */
        .glass-pending .glass-icon {
            background: rgba(255, 193, 7, 0.15);
            color: #ffc107;
        }

        .glass-success .glass-icon {
            background: rgba(40, 167, 69, 0.15);
            color: #28a745;
        }

        .glass-failed .glass-icon {
            background: rgba(220, 53, 69, 0.15);
            color: #dc3545;
        }
    </style>

    <div class="row mb-4 vtupress-summary">
        <!-- Credit Card -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="vtupress-glass glass-success">
                <div class="glass-icon"><i class="mdi mdi-arrow-down-bold-circle-outline"></i></div>
                <div class="glass-content">
                    <h6>Total Credited</h6>
                    <h3><?= $currency_symbol . number_format($summary['credit_amount'], 2) ?></h3>
                    <small><?= $summary['credit'] ?> Transactions</small>
                </div>
            </div>
        </div>

        <!-- Refund Card -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="vtupress-glass glass-pending">
                <div class="glass-icon"><i class="mdi mdi-refresh"></i></div>
                <div class="glass-content">
                    <h6>Total Refunded</h6>
                    <h3><?= $currency_symbol . number_format($summary['refund_amount'], 2) ?></h3>
                    <small><?= $summary['refund'] ?> Transactions</small>
                </div>
            </div>
        </div>

        <!-- Debit Card -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="vtupress-glass glass-failed">
                <div class="glass-icon"><i class="mdi mdi-arrow-up-bold-circle-outline"></i></div>
                <div class="glass-content">
                    <h6>Total Debited</h6>
                    <h3><?= $currency_symbol . number_format($summary['debit_amount'], 2) ?></h3>
                    <small><?= $summary['debit'] ?> Transactions</small>
                </div>
            </div>
        </div>
    </div>

    <?php if (empty($transactions)): ?>
        <div class="alert alert-info">No Wallet History found.</div>
        <?php return;
    endif; ?>

    <div class="table-responsive">
        <table id="vtupress-wallet-history" class="table table-hover">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Old Bal</th>
                    <th>New Bal</th>
                    <th>Description</th>
                    <th>Status</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $txn): ?>
                    <tr>
                        <td><?= $txn['id'] ?></td>
                        <td>
                            <?php
                            $badgeClass = 'bg-primary';
                            if ($txn['type'] == 'credit')
                                $badgeClass = 'bg-success';
                            elseif ($txn['type'] == 'debit')
                                $badgeClass = 'bg-danger';
                            elseif ($txn['type'] == 'refund')
                                $badgeClass = 'bg-warning text-dark';
                            ?>
                            <span class="badge <?= $badgeClass ?>">
                                <?= strtoupper($txn['type']) ?>
                            </span>
                        </td>
                        <td><?= $currency_symbol . number_format($txn['fund_amount'], 2) ?></td>
                        <td><?= $currency_symbol . number_format($txn['before_amount'], 2) ?></td>
                        <td><?= $currency_symbol . number_format($txn['now_amount'], 2) ?></td>
                        <td><?= esc_html($txn['name']) ?></td>
                        <td>
                            <span
                                class="badge <?= ($txn['status'] == 'success' || $txn['status'] == 'successful') ? 'bg-success' : 'bg-warning' ?>">
                                <?= ucfirst($txn['status']) ?>
                            </span>
                        </td>
                        <td><?= $txn['the_time'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <script>
        jQuery(function ($) {
            if ($.fn.DataTable) {
                $('#vtupress-wallet-history').DataTable({
                    pageLength: 25,
                    order: [
                        [0, 'desc']
                    ],
                    responsive: true,
                    language: {
                        search: "_INPUT_",
                        searchPlaceholder: "Search records..."
                    }
                });
            }
        });
    </script>
</div>