<?php
if(!defined('ABSPATH')){
    die("access denied");
}
?>
<!-- Custom CSS for Signup Section -->
<style>
    :root {
        --vp-primary-color: <?php echo $color_from; ?>;
        --vp-secondary-color: <?php echo $color_to; ?>;
    }

    .vtupress-signup-wrapper {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
        background: transparent;
    }

    .vtupress-signup-card {
        width: 100%;
        max-width: 500px; /* Slightly wider for signup */
        background: #fff;
        border-radius: 12px;
        padding: 40px 30px;
        box-shadow: 0 15px 35px rgba(0,0,0,0.1);
        text-align: center;
        animation: vpFadeIn 0.6s ease-out;
        position: relative;
        overflow: hidden;
    }
    
    /* Top detailed bar */
    .vtupress-signup-card::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 6px;
        background: linear-gradient(90deg, var(--vp-primary-color), var(--vp-secondary-color));
    }

    @keyframes vpFadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .vp-logo-area {
        margin-bottom: 20px;
        display: inline-block;
        padding: 10px;
        border-radius: 50%;
        background: #f8f9fa;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }

    .vp-logo-area img {
        height: 70px;
        width: 70px;
        object-fit: contain;
    }

    .vp-signup-title {
        color: #333;
        font-weight: 700;
        margin-bottom: 30px;
        font-size: 1.5rem;
        letter-spacing: -0.5px;
    }

    .vp-form-group {
        margin-bottom: 20px;
        text-align: left;
    }

    .vp-label {
        font-weight: 600;
        color: #666;
        margin-bottom: 8px;
        display: block;
        font-size: 0.9rem;
    }

    .vp-form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 2px solid #eaebed;
        background: #fff;
        height: 48px;
        font-size: 0.95rem;
        transition: all 0.2s;
        width: 100%;
        color: #333;
    }

    .vp-form-control:focus {
        border-color: var(--vp-primary-color);
        box-shadow: 0 0 0 3px rgba(0,0,0,0.05);
        outline: none;
    }
    
    .vp-btn-primary {
        border-radius: 8px;
        padding: 14px;
        font-weight: 700;
        background: linear-gradient(90deg, var(--vp-primary-color), var(--vp-secondary-color)) !important;
        border: none !important;
        width: 100%;
        color: white;
        font-size: 1rem;
        cursor: pointer;
        transition: opacity 0.2s, transform 0.2s;
        margin-top: 10px;
        outline: none !important;
    }

    .vp-btn-primary:active {
        transform: scale(0.98);
    }
    
    .vp-btn-primary:hover {
        opacity: 0.95;
    }

    .vp-account-links {
        margin-top: 25px;
        font-size: 0.9rem;
        color: #888;
    }

    .vp-account-links a {
        color: var(--vp-primary-color);
        font-weight: 600;
        text-decoration: none;
    }

    .vp-account-links a:hover {
        text-decoration: underline;
    }
    
    .vp-asterisk {
        color: #dc3545;
        margin-left: 2px;
    }
    
    .vp-row {
        display: flex;
        gap: 15px;
    }
    .vp-col {
        flex: 1;
    }
    @media (max-width: 576px) {
        .vp-row {
            flex-direction: column;
            gap: 0;
        }
    }

</style>

<div class="vtupress-signup-wrapper">
    <div class="vtupress-signup-card">
        
        <div class="vp-logo-area">
             <a href="<?php echo home_url(); ?>">
                <img src="<?php echo get_site_icon_url(100, plugins_url('vtupress-templates/templates/msorg/msorg_template/vlogo.png')); ?>" alt="Logo"/>
            </a>
        </div>
        
        <h3 class="vp-signup-title">Create Account</h3>

        <form method="POST" class="signup">
            
            <div class="vp-row">
                <div class="vp-col">
                    <div class="vp-form-group">
                        <label for="id_firstname" class="vp-label">FirstName<span class="vp-asterisk">*</span></label>
                        <input type="text" name="fun" class="vp-form-control fun" required="" id="id_firstname" placeholder="First Name">
                    </div>
                </div>
                <div class="vp-col">
                     <div class="vp-form-group">
                        <label for="id_lastname" class="vp-label">LastName<span class="vp-asterisk">*</span></label>
                        <input type="text" name="lun" class="vp-form-control lun" required="" id="id_lastname" placeholder="Last Name">
                    </div>
                </div>
            </div>

            <div class="vp-form-group">
                <label for="id_username" class="vp-label">Username<span class="vp-asterisk">*</span></label>
                <input type="text" name="username" class="vp-form-control username" required="" id="id_username" placeholder="Username">
            </div>
            
            <div class="vp-form-group">
                <label for="id_email" class="vp-label">Email<span class="vp-asterisk">*</span></label>
                <input type="email" name="email" class="vp-form-control email" required="" id="id_email" placeholder="Email Address">
            </div>

             <div class="vp-row">
                <div class="vp-col">
                    <div class="vp-form-group">
                        <label for="id_phone" class="vp-label">Phone<span class="vp-asterisk">*</span></label>
                        <input type="text" name="phone" maxlength="15" minlength="11" class="vp-form-control phone" required="" id="id_phone" placeholder="Phone Number">
                    </div>
                </div>
                <div class="vp-col">
                     <div class="vp-form-group">
                        <label for="country" class="vp-label">Country<span class="vp-asterisk">*</span></label>
                         <select name="country" class="vp-form-control country" id="country">
                             <?php foreach(Vtupress_Country_Manager::enabled() as $key):?>
                                <option value="<?= strtolower($key);?>"><?= ucfirst($key);?></option>
                            <?php endforeach;?>
                         </select>
                    </div>
                </div>
            </div>

            <div class="vp-row">
                <div class="vp-col">
                     <div class="vp-form-group">
                        <label for="password" class="vp-label">Password<span class="vp-asterisk">*</span></label>
                        <input type="password" name="pswd" class="vp-form-control" required="" id="password" placeholder="Password">
                    </div>
                </div>
               <div class="vp-col">
                     <div class="vp-form-group">
                        <label for="cpwd" class="vp-label">Confirm Password<span class="vp-asterisk">*</span></label>
                        <input type="password" name="cpwd" class="vp-form-control" required="" id="cpwd" placeholder="Confirm Password">
                    </div>
                </div>
            </div>
            
            <div class="vp-form-group">
                 <label for="pin" class="vp-label">Transaction Pin<span class="vp-asterisk">*</span></label>
                 <input type="password" name="pin" maxlength="4" minlength="4" class="vp-form-control" required="" id="pin" placeholder="4 Digit Pin">
            </div>
            <div class="vp-form-group">
                <label for="referral" class="vp-label">Referral ID (Optional)</label>
                <input type="number" name="referral" class="vp-form-control" id="referral" placeholder="Referral Username" value="<?php echo isset($_GET['ref']) ? esc_attr($_GET['ref']) : 1; ?>">
            </div>

            <div class="vp-form-group" style="margin-top: 30px;">
                <button type="button" class="btn btn-primary vp-btn-primary process" id="process">
                    Register
                </button>
            </div>

            <div class="vp-account-links">
                <p class="mb-2">Already have an account?</p>
                <a href="<?= home_url("/$slug/login/");?>" id="show-login">Login Here</a>
            </div>
        </form>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    $(".process").click(function () {
        var btn = $(this);
        var originalText = btn.html();
        
        btn.html('<i class="fas fa-spinner fa-spin"></i> Processing...');
        btn.prop('disabled', true);

        var obj = {};
        
        // Collect Inputs
        var toatl_input = $(".signup input, .signup select").length;
        for (var run_obj = 0; run_obj < toatl_input; run_obj++) {
            var current_input = $(".signup input, .signup select").eq(run_obj);
            var obj_name = current_input.attr("name");
            var obj_value = current_input.val();
            if (obj_name) {
                obj[obj_name] = obj_value;
            }
        }
        
        // Validation for empty fields (basic check)
        var requiredFields = ['username', 'email', 'fun', 'lun', 'phone', 'pswd','country', 'cpwd', 'pin'];
        var empty = false;
        requiredFields.forEach(function(field) {
            if(!obj[field]) empty = true;
        });

        if (empty) {
            swal({
                title: "Error!",
                text: "Please fill all required fields",
                icon: "error",
                button: "Okay",
            });
            btn.html(originalText);
            btn.prop('disabled', false);
            return;
        }

        if(obj.pswd != obj.cpwd){
             swal({
                title: "Error!",
                text: "Passwords do not match",
                icon: "error",
                button: "Okay",
            });
            btn.html(originalText);
            btn.prop('disabled', false);
            return;
        }

        obj['action'] = 'vtupress_register_user';
        obj['disable_process'] = true;

        doAjax(
            vtupressobj.ajax_url,
            obj,
            'post',
            'json',
            function(data) {
                btn.html(originalText);
                btn.prop('disabled', false);

                if (data.status == "100" || data.status == 100) {
                    var msg = data.message || "Welcome on board!";
                    swal({
                        title: "Registration Successful",
                        text: msg,
                        icon: "success",
                        timer: 2000,
                        buttons: false,
                    }).then(() => {
                        window.location.href = window.location.href.replace('register','')+'/login';
                    });
                } else {
                    swal({
                        title: "Error!",
                        text: data.message || "Registration Failed",
                        icon: "error",
                        button: "Retry",
                    });
                }
            }
        );
    });
});
</script>