jQuery("body").addClass("folded");
jQuery(document).ready(function(){

    setTimeout(()=>{
      loaderJs.hide();
    },2000);
  
      jQuery(".notice").hide();
  });


    
  jQuery("[data-wploader]").click(function(){
        var input = jQuery(this).data("wploader");
        var img = jQuery(this).data("img");
        if(!input){
          console.log("No Target");

          return;
        }
        console.log("Logged...");
        var mediaUploader;


                // If the uploader object has already been created, reopen it.
          if (mediaUploader) {
              mediaUploader.open();
              return;
          }
          // Extend the wp.media object
          mediaUploader = wp.media({
              title: 'Choose Image',
              button: {
                  text: 'Choose Image'
              },
              multiple: false,
              library: {
                  type: 'image' // 'image', 'video', 'audio', or custom MIME
              }
          });

          // When a file is selected, grab the URL and set it as the text field's value
          mediaUploader.on('select', function() {
              var attachment = mediaUploader.state().get('selection').first().toJSON();
              // console.log("Selected "+attachment.url);
              jQuery(input).val(attachment.url);
              if(jQuery(img)){
                jQuery(img).attr("src",attachment.url);
              }
          });

          // Open the uploader dialog
          mediaUploader.open();

  });

  jQuery("[change-access]").click(function($){
      var current_status = jQuery(this).data("status");
      var user_id = jQuery(this).data("user-id");
      var change_to = current_status == "blocked" ? "allowed" : "blocked";
      if(!current_status || !user_id){
        return;
      }
      var obj = {};
      obj.userid = user_id;
      obj.change_to = change_to;
      obj.run = "change_access";
      obj.admin_save = "user_manager";


      bootbox.confirm({
                message: "Are you sure you want to "+change_to.replace("ed","")+" access for this user?",
                buttons: {
                    confirm: {
                        label: 'Yes',
                        className: 'btn-success'
                    },
                    cancel: {
                        label: 'No',
                        className: 'btn-danger'
                    }
                },
                centerVertical: true,
                callback: function (result) {
                    if (result) {
                            function success_response(res){
                              console.log(res);
                            }
                            //Add ajax call to indexUrl with post data
                            doAjax(vtupressInitPluginData.ajax_url,obj,"post");
                    }
                }
      });
  });


  
  jQuery(".notice").hide();

  function switchAjaxResponse(response){
    if(response == "100"){
      showToast("Switched successfully","green",3000);
         // Reload the page after 3 seconds
        setTimeout(function(){
            location.reload();
        },1000);
    }else{
      showToast("Failed to switch \n"+response,"red",4000);
    }


  }
  
  function showToast(message, type = "green", time = 3000, useSwal = false) {

    if (useSwal) {
        if (type == "yellow") {
            Swal.fire({
                title: 'Processing...',
                text: message,
                icon: 'info',
                allowOutsideClick: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
        } else if (type == "green") {
            Swal.fire({
                title: 'Success',
                text: message,
                icon: 'success',
                confirmButtonText: 'OK'
            });
        } else {
            Swal.fire({
                title: 'Failed',
                text: message,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        }
        return;
    }


    var color;
    if (type == "green") {
        color = "#198754";
    } else if (type == "red") {
        color = "#dc3545";

    } else if (type == "yellow") {
        color = "#ffc107";

    } else {
        color = "#0d6efd";

    }


    Toastify({
        text: message,
        duration: time, // duration in milliseconds
        close: true, // show close button
        gravity: "top", // "top" or "bottom"
        position: "right", // "left", "center" or "right"
        backgroundColor: color, // custom background color
    }).showToast();

}

function dprocessCallBack(useSwal = false) {
    showToast("Processing", "yellow", 5000, useSwal);
}

function derrorCallBack(msg, useSwal = false) {

        var the_msg = msg;
        if (typeof msg !== 'object') {
            try {
                the_msg = JSON.parse(msg);
            } catch (e) {

            }
        }
        if (the_msg && the_msg.message) {
            the_msg = the_msg.message;
        } else if (the_msg && the_msg.data && the_msg.data.message) {
            the_msg = the_msg.data.message;
        }


    showToast(the_msg, "red", 4000, useSwal);
}

function dsuccessCallBack(res, useSwal = false) {
    if (res == "100") {
        showToast("Successful", "green", 4000, useSwal);
        setTimeout(function () {
            location.reload();
        }, 1000);
        return;
    }

    // Attempt to parse JSON if it's a string not "100"
    var data = res;
    if (typeof res !== 'object') {
        try {
            data = JSON.parse(res);
        } catch (e) {
            // Not JSON, assume error or raw message
            // If it's just a string and not "100", maybe an error?
            // But legacy behavior might be strict.
            // Let's check if we should show error if useSwal is on
            if (useSwal && res != "100") {
                 // showToast(res, "red", 4000, useSwal); // Risky if HTML returned
            }
        }
    }

    // Standard VtuPress Response Check
    if (data && (data.status === 'success' || data.success === true || data == "100")) {
        var msg = data.message || "Successful";
        showToast(msg, "green", 4000, useSwal);
        setTimeout(function () {
             location.reload();
        }, 1500);
    } else {
        // Find Error Message
        var msg = res;
        if (data && data.message) {
            msg = data.message;
        } else if (data && data.data && data.data.message) {
            msg = data.data.message;
        }
        // showToast(msg, "red", 4000, useSwal);
        derrorCallBack(msg,useSwal);
    }
}

function doAjax(url, data, request_type = "post", response_type = "text", successCallback = dsuccessCallBack, processCallBack = dprocessCallBack, errorCallBack = derrorCallBack, useSwal = false){
  
    // var type = request_type;
    if(url == ""){
      showToast("URL is not defined","red",2000, useSwal);
      return;
    }
    else if (!data || typeof data !== 'object') {
      showToast("Data object is not defined","red",2000, useSwal);
      return;
    }
    else if (request_type.toLowerCase() != 'post' && request_type.toLowerCase() != 'get'){
      showToast("Type must be either post or get","red",2000, useSwal);
      return;
    }

    if(typeof processCallBack !== "function"){
      dprocessCallBack(useSwal);
    }else{
      processCallBack(useSwal);
    }

  
    data['nonce'] = vtupressInitPluginData.nonce;
    data['action'] = "vtupress_yes_ajax";
    jQuery.ajax({
      url: url,
      data: data,
      dataType: response_type,
      "cache": false,
      "async": true,
      type: request_type.toUpperCase(),
      error: function (jqXHR, exception) {
        loaderJs.hide();
        var msg = "";
        if (jqXHR.status === 0) {
            msg = "No Connection.\n Verify Network.";
        }   else if (jqXHR.status == 403) {
              msg = "Access Forbidden [403].";
        }  else if (jqXHR.status == 404) {
            msg = "Requested page not found. [404]";
        } else if (jqXHR.status == 500) {
                msg = "Internal Server Error [500].";
        } else if (exception === "parsererror") {
              msg = "Requested JSON parse failed.";
        } else if (exception === "timeout") {
              msg = "Time out error.";
        } else if (exception === "abort") {
              msg = "Ajax request aborted.";
        } else {
            msg = "Uncaught Error.\n" + jqXHR.responseText;
        }
        
            if(typeof errorCallBack !== "function"){
              derrorCallBack(msg, useSwal);
            }else{
              errorCallBack(msg, useSwal);
            }
        },
        success: function(response) {
          loaderJs.hide();
            if(typeof successCallback  !== "function"){
              dsuccessCallBack(response, useSwal);
            }else{
              successCallback(response, useSwal);
            }
        }
  
  
    });
  
  }
  
  function changestatus(type){
    var obj = {}
    if(jQuery("input."+type).is(":checked")){
    obj["set_status"] = "checked";
    }
    else{
    obj["set_status"] = "unchecked";
    }
    obj["set_control"] = type;
  
  
    jQuery.ajax({
        url: vtupressInitPluginData.controls,
        data: obj,
        dataType: "text",
        "cache": false,
        "async": true,
        error: function (jqXHR, exception) {
          loaderJs.hide();
              var msg = "";
              if (jqXHR.status === 0) {
                  msg = "No Connection.\n Verify Network.";
              }   else if (jqXHR.status == 403) {
                    msg = "Access Forbidden [403].";
              }  else if (jqXHR.status == 404) {
                  msg = "Requested page not found. [404]";
              } else if (jqXHR.status == 500) {
                      msg = "Internal Server Error [500].";
              } else if (exception === "parsererror") {
                    msg = "Requested JSON parse failed.";
              } else if (exception === "timeout") {
                    msg = "Time out error.";
              } else if (exception === "abort") {
                    msg = "Ajax request aborted.";
              } else {
                  msg = "Uncaught Error.\n" + jqXHR.responseText;
              }
        
          swal({
            title: "Error!",
            text: msg,
            icon: "error",
            button: "Okay",
          });
    },
    success: function(data) {
        loaderJs.hide();
              if(data == "100" ){
                location.reload();
              }
              else{
                  swal({
                  title: "Error",
                  text: data,
                  icon: "error",
                  button: "Okay",
                });
            }
      },
    type: "POST"
    });
  
  }

  jQuery(".createLevelPackage").click(function(){
      var val = jQuery(".createlevelName").val();
      if(val == ""){
        showToast("Please enter a valid package name");
        return;
      }

      var obj = {};
      obj.level_name = val;
      obj.level_action = "create_level";
      obj.admin_save = "level_url";
      loaderJs.show();
      doAjax(vtupressInitPluginData.ajax_url,obj,'post',createdPackage);


      function createdPackage(res){
        loaderJs.hide();
        if(res == "100"){
          showToast("Package Created","green",3000);
          setTimeout(()=>{
            location.reload();
          },2000);
        }
        else{
          showToast(res,"red",5000);
        }

      }
  });
  
  //delegation
  jQuery('body').on('click',"[goto]", function(){
    var link = jQuery(this).attr("goto");
    //window.open(link, "_blank");
    window.location.href = link;
  });
  
  
  
  
  
  var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
  (function(){
  var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
  s1.async=true;
  s1.src='https://embed.tawk.to/64a33990cc26a871b02624d7/1h4ephnkm';
  s1.charset='UTF-8';
  s1.setAttribute('crossorigin','*');
  s0.parentNode.insertBefore(s1,s0);
  })();