<?php

if (!defined('ABSPATH')) {
  die("Not Allowed");
}

?>

<div class="container-scroller">
  <div class="row p-0 m-0 proBanner d-none" id="proBanner">
    <div class="col-md-12 p-0 m-0">
      <div class="card-body card-body-padding d-flex align-items-center justify-content-between">
        <div class="ps-lg-3">
          <div class="d-flex align-items-center justify-content-between">
            <p class="mb-0 font-weight-medium me-3 buy-now-text">Free 24/7 customer support, updates, and more with
              vtupress!</p>
            <a href="#" target="_blank" class="btn me-2 buy-now-btn border-0">Buy Now</a>
          </div>
        </div>
        <div class="d-flex align-items-center justify-content-between">
          <a href="#"><i class="mdi mdi-home me-3 text-white"></i></a>
          <button id="bannerClose" class="btn border-0 p-0">
            <i class="mdi mdi-close text-white mr-0"></i>
          </button>
        </div>
      </div>
    </div>
  </div>
  <!-- partial:partials/_navbar.html -->
  <nav class="navbar default-layout-navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
    <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-start">
      <a class="navbar-brand brand-logo d-md-flex justiy-content-end" href="index.html"><img
          src="<?php echo $this->admin_url; ?>/assets/images/logo.svg" alt="logo" /></a>
      <a class="navbar-brand brand-logo-mini d-md-none" href="index.html"><img
          src="<?php echo $this->admin_url; ?>/assets/images/logo-mini.svg" alt="logo" /></a>
    </div>
    <div class="navbar-menu-wrapper d-flex align-items-stretch flex-md-grow-1">
      <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
        <span class="mdi mdi-menu"></span>
      </button>
      <div class="search-field d-none d-md-block">
        <form class="d-flex align-items-center h-100" action="#">
          <div class="input-group">
            <div class="input-group-prepend bg-transparent">
              <i class="input-group-text border-0 mdi mdi-magnify"></i>
            </div>
            <input type="text" class="form-control bg-transparent border-0" placeholder="Search User" style="
    padding: 0 1rem !important;
">
          </div>
        </form>
      </div>
      <ul class="navbar-nav navbar-nav-right">
        <li class="nav-item">
          <select id="header_country_switch" class="form-control form-control-sm border-0 text-dark"
            style="background:transparent; font-weight:bold; cursor:pointer;">
            <?php
            $enabled_countries = Vtupress_Country_Manager::enabled();
            $current_country = Vtupress_Country_Context::get();
            foreach ($enabled_countries as $code):
              ?>
              <option value="<?php echo esc_attr($code); ?>" <?php echo $current_country == $code ? 'selected' : ''; ?>>
                <?php echo ucfirst($code); ?>
              </option>
            <?php endforeach; ?>
          </select>
          <script>
            jQuery(document).ready(function ($) {
              $('#header_country_switch').change(function () {
                var new_country = $(this).val();
                var original_text = $(this).find('option:selected').text();

                if (confirm('Switch admin context to ' + new_country + '?')) {
                  $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                      action: 'switch_admin_country',
                      country: new_country
                    },
                    success: function (response) {
                      if (response == 'success') {
                        location.reload();
                      } else {
                        alert('Failed to switch country: ' + response);
                      }
                    },
                    error: function () {
                      alert('Error connecting to server.');
                    }
                  });
                }
              });
            });
          </script>
        </li>
        <li class="nav-item nav-profile dropdown">
          <a class="nav-link dropdown-toggle" id="profileDropdown" href="#" data-bs-toggle="dropdown"
            aria-expanded="false">
            <div class="nav-profile-img">
              <img src="<?php echo $this->admin_url; ?>/assets/images/faces/face1.jpg" alt="image">
              <span class="availability-status online"></span>
            </div>
            <div class="nav-profile-text">
              <p class="mb-1 text-black">Quick Access</p>
            </div>
          </a>
          <div class="dropdown-menu navbar-dropdown" aria-labelledby="profileDropdown">
            <!-- <a class="dropdown-item d-none" href="#">
              <i class="mdi mdi-cached me-2 text-success"></i> Activity Log 
            </a> -->
            <div class="dropdown-divider"></div>
            <a class="dropdown-item" href="#" onclick="confirmLogout(event)">
              <i class="mdi mdi-logout me-2 text-primary"></i> Signout </a>
          </div>
        </li>
        <li class="nav-item d-none d-lg-block full-screen-link">
          <a class="nav-link">
            <i class="mdi mdi-fullscreen" id="fullscreen-button"></i>
          </a>
        </li>
        <li class="nav-item dropdown d-none">
          <a class="nav-link count-indicator dropdown-toggle" id="messageDropdown" href="#" data-bs-toggle="dropdown"
            aria-expanded="false">
            <i class="mdi mdi-email-outline"></i>
            <span class="count-symbol bg-warning"></span>
          </a>
          <div class="dropdown-menu dropdown-menu-end navbar-dropdown preview-list" aria-labelledby="messageDropdown">
            <h6 class="p-3 mb-0">Messages</h6>
            <div class="dropdown-divider"></div>
            <a class="dropdown-item preview-item">
              <div class="preview-thumbnail">
                <img src="<?php echo $this->admin_url; ?>/assets/images/faces/face4.jpg" alt="image"
                  class="profile-pic">
              </div>
              <div class="preview-item-content d-flex align-items-start flex-column justify-content-center">
                <h6 class="preview-subject ellipsis mb-1 font-weight-normal">Mark send you a message</h6>
                <p class="text-gray mb-0"> 1 Minutes ago </p>
              </div>
            </a>
            <div class="dropdown-divider"></div>
            <a class="dropdown-item preview-item">
              <div class="preview-thumbnail">
                <img src="<?php echo $this->admin_url; ?>/assets/images/faces/face2.jpg" alt="image"
                  class="profile-pic">
              </div>
              <div class="preview-item-content d-flex align-items-start flex-column justify-content-center">
                <h6 class="preview-subject ellipsis mb-1 font-weight-normal">Cregh send you a message</h6>
                <p class="text-gray mb-0"> 15 Minutes ago </p>
              </div>
            </a>
            <div class="dropdown-divider"></div>
            <a class="dropdown-item preview-item">
              <div class="preview-thumbnail">
                <img src="<?php echo $this->admin_url; ?>/assets/images/faces/face3.jpg" alt="image"
                  class="profile-pic">
              </div>
              <div class="preview-item-content d-flex align-items-start flex-column justify-content-center">
                <h6 class="preview-subject ellipsis mb-1 font-weight-normal">Profile picture updated</h6>
                <p class="text-gray mb-0"> 18 Minutes ago </p>
              </div>
            </a>
            <div class="dropdown-divider"></div>
            <h6 class="p-3 mb-0 text-center">4 new messages</h6>
          </div>
        </li>
        <li class="nav-item dropdown">
          <a class="nav-link count-indicator dropdown-toggle" id="notificationDropdown" href="#"
            data-bs-toggle="dropdown">
            <i class="mdi mdi-bell-outline"></i>
            <span class="count-symbol bg-danger"></span>
          </a>
          <div class="dropdown-menu dropdown-menu-end navbar-dropdown preview-list"
            aria-labelledby="notificationDropdown">
            <h6 class="p-3 mb-0">Notifications</h6>
            <div class="dropdown-divider"></div>
            <?php
            global $wpdb;
            $header_notifs = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}vtupress_notifications ORDER BY id DESC LIMIT 5");
            if ($header_notifs) {
                foreach ($header_notifs as $h_notif) {
                    // Excerpt Logic
                    $msg_words = explode(' ', $h_notif->message);
                    $excerpt = implode(' ', array_slice($msg_words, 0, 20));
                    if (count($msg_words) > 20) $excerpt .= '...';
                    
                    // Determine icon based on type (simple heuristic)
                    $icon_class = 'mdi-bell-ring';
                    $bg_class = 'bg-info';
                    if (stripos($h_notif->type, 'withdrawal') !== false) {
                        $icon_class = 'mdi-cash-multiple';
                        $bg_class = 'bg-success';
                    } elseif (stripos($h_notif->type, 'kyc') !== false) {
                        $icon_class = 'mdi-account-card-details';
                        $bg_class = 'bg-warning';
                    }
            ?>
            <a class="dropdown-item preview-item" href="?page=vtupanel&adminpage=notifications">
              <div class="preview-thumbnail">
                <div class="preview-icon <?php echo $bg_class; ?>">
                  <i class="mdi <?php echo $icon_class; ?>"></i>
                </div>
              </div>
              <div class="preview-item-content d-flex align-items-start flex-column justify-content-center">
                <h6 class="preview-subject font-weight-normal mb-1"><?php echo esc_html($h_notif->title); ?></h6>
                <p class="text-gray ellipsis mb-0" style="white-space: normal; font-size: 0.8rem;"> <?php echo esc_html($excerpt); ?> </p>
              </div>
            </a>
            <div class="dropdown-divider"></div>
            <?php
                }
            } else {
            ?>
            <div class="p-3 text-center">No new notifications</div>
            <div class="dropdown-divider"></div>
            <?php } ?>
            <a href="?page=vtupanel&adminpage=notifications"><h6 class="p-3 mb-0 text-center">See all notifications</h6></a>
          </div>
        </li>
        <li class="nav-item nav-logout d-none d-lg-block">
          <a class="nav-link" href="#" onclick="confirmLogout(event)">
            <i class="mdi mdi-power"></i>
          </a>
        </li>
        <li class="nav-item nav-settings d-none ">
          <a class="nav-link" href="#">
            <i class="mdi mdi-format-line-spacing"></i>
          </a>
        </li>
      </ul>
      <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button"
        data-toggle="offcanvas">
        <span class="mdi mdi-menu"></span>
      </button>
    </div>
  </nav>
  <!-- partial -->
  <div class="container-fluid page-body-wrapper">

    <div class="right-sidebar-toggler-wrapper">
      <div class="sidebar-toggler d-none" id="settings-trigger"><i class="mdi mdi-palette"></i></div>
      <div class="sidebar-toggler d-none" id="chat-toggler"><i class="mdi mdi-chat-processing"></i></div>
      <div class="sidebar-toggler"><a href="https://vtupress.com/doc" target="_blank"><i
            class="mdi mdi-file-document-outline"></i></a></div>
      <div class="sidebar-toggler d-none"><a href="#" target="_blank"><i class="mdi mdi-cart"></i></a></div>
    </div>
    <div class="theme-setting-wrapper">
      <div id="theme-settings" class="settings-panel">
        <i class="settings-close mdi mdi-close"></i>
        <p class="settings-heading">SIDEBAR SKINS</p>
        <div class="sidebar-bg-options selected" id="sidebar-light-theme">
          <div class="img-ss rounded-circle bg-light border me-3"></div>Light
        </div>
        <div class="sidebar-bg-options" id="sidebar-dark-theme">
          <div class="img-ss rounded-circle bg-dark border me-3"></div>Dark
        </div>
        <p class="settings-heading mt-2">HEADER SKINS</p>
        <div class="color-tiles mx-0 px-4">
          <div class="tiles success"></div>
          <div class="tiles warning"></div>
          <div class="tiles danger"></div>
          <div class="tiles info"></div>
          <div class="tiles dark"></div>
          <div class="tiles default"></div>
        </div>
      </div>
      <div id="layout-settings" class="settings-panel">
        <i class="settings-close mdi mdi-close"></i>
        <div class="d-flex align-items-center justify-content-between border-bottom">
          <p class="settings-heading font-weight-bold border-top-0 mb-3 ps-3 pt-0 border-bottom-0 pb-0">Template Demos
          </p>
        </div>
        <div class="demo-screen-wrapper">
          <a href="#" target="_blank" class="demo-thumb-image" id="theme-light-switch">
            <img src="<?php echo $this->admin_url; ?>/assets/images/screenshots/vertical-light.jpg" alt="demo image">
          </a>
          <a href="#" target="_blank" class="demo-thumb-image">
            <img src="<?php echo $this->admin_url; ?>/assets/images/screenshots/vertical-dark.jpg" alt="demo image">
          </a>
          <a href="#" target="_blank" class="demo-thumb-image" id="theme-dark-switch">
            <img src="<?php echo $this->admin_url; ?>/assets/images/screenshots/horizontal-light.jpg" alt="demo image">
          </a>
          <a href="#" target="_blank" class="demo-thumb-image">
            <img src="<?php echo $this->admin_url; ?>/assets/images/screenshots/horizontal-dark.jpg" alt="demo image">
          </a>
        </div>
      </div>
    </div>
    <div id="right-sidebar" class="settings-panel">
      <i class="settings-close mdi mdi-close"></i>
      <ul class="nav nav-tabs" id="setting-panel" role="tablist">
        <li class="nav-item" role="presentation">
          <a class="nav-link active" id="todo-tab" data-bs-toggle="tab" href="#" role="tab" aria-controls="todo-section"
            aria-expanded="true" aria-selected="true">TO DO LIST</a>
        </li>
        <li class="nav-item" role="presentation">
          <a class="nav-link" id="chats-tab" data-bs-toggle="tab" href="#" role="tab" aria-controls="chats-section"
            aria-selected="false" tabindex="-1">CHATS</a>
        </li>
      </ul>
      <div class="tab-content" id="setting-content">
        <div class="tab-pane fade show active scroll-wrapper ps ps--active-y" id="todo-section" role="tabpanel"
          aria-labelledby="todo-section">
          <div class="add-items d-flex px-3 mb-0">
            <form class="form w-100">
              <div class="form-group d-flex">
                <input type="text" class="form-control todo-list-input" placeholder="Add To-do">
                <button type="submit" class="add btn btn-primary todo-list-add-btn" id="add-task">Add</button>
              </div>
            </form>
          </div>
          <div class="list-wrapper px-3">
            <ul class="d-flex flex-column-reverse todo-list">
              <li>
                <div class="form-check">
                  <label class="form-check-label">
                    <input class="checkbox" type="checkbox"> Team review meeting at 3.00 PM <i
                      class="input-helper"></i></label>
                </div>
                <i class="remove mdi mdi-close-circle-outline"></i>
              </li>
              <li>
                <div class="form-check">
                  <label class="form-check-label">
                    <input class="checkbox" type="checkbox"> Prepare for presentation <i
                      class="input-helper"></i></label>
                </div>
                <i class="remove mdi mdi-close-circle-outline"></i>
              </li>
              <li>
                <div class="form-check">
                  <label class="form-check-label">
                    <input class="checkbox" type="checkbox"> Resolve all the low priority tickets due today <i
                      class="input-helper"></i></label>
                </div>
                <i class="remove mdi mdi-close-circle-outline"></i>
              </li>
              <li class="completed">
                <div class="form-check">
                  <label class="form-check-label">
                    <input class="checkbox" type="checkbox" checked=""> Schedule meeting for next week <i
                      class="input-helper"></i></label>
                </div>
                <i class="remove mdi mdi-close-circle-outline"></i>
              </li>
              <li class="completed">
                <div class="form-check">
                  <label class="form-check-label">
                    <input class="checkbox" type="checkbox" checked=""> Project review <i
                      class="input-helper"></i></label>
                </div>
                <i class="remove mdi mdi-close-circle-outline"></i>
              </li>
            </ul>
          </div>
          <div class="events py-4 border-bottom px-3">
            <div class="wrapper d-flex mb-2">
              <i class="mdi mdi-circle-outline text-primary me-2"></i>
              <span>Feb 11 2018</span>
            </div>
            <p class="mb-0 font-weight-thin text-gray">Creating component page</p>
            <p class="text-gray mb-0">build a js based app</p>
          </div>
          <div class="events pt-4 px-3">
            <div class="wrapper d-flex mb-2">
              <i class="mdi mdi-circle-outline text-primary me-2"></i>
              <span>Feb 7 2018</span>
            </div>
            <p class="mb-0 font-weight-thin text-gray">Meeting with Alisa</p>
            <p class="text-gray mb-0 ">Call Sarah Graves</p>
          </div>
          <div class="ps__rail-x" style="left: 0px; bottom: 0px;">
            <div class="ps__thumb-x" tabindex="0" style="left: 0px; width: 0px;"></div>
          </div>
          <div class="ps__rail-y" style="top: 0px; height: 642px; right: 0px;">
            <div class="ps__thumb-y" tabindex="0" style="top: 0px; height: 617px;"></div>
          </div>
        </div>
        <!-- To do section tab ends -->
        <div class="tab-pane fade" id="chats-section" role="tabpanel" aria-labelledby="chats-section">
          <div class="d-flex align-items-center justify-content-between border-bottom">
            <p class="settings-heading border-top-0 mb-3 ps-3 pt-0 border-bottom-0 pb-0">Friends</p>
            <small class="settings-heading border-top-0 mb-3 pt-0 border-bottom-0 pb-0 pe-3 font-weight-normal">See
              All</small>
          </div>
          <ul class="chat-list">
            <li class="list active">
              <div class="profile"><img src="<?php echo $this->admin_url; ?>/assets/images/faces/face1.jpg"
                  alt="image"><span class="online"></span></div>
              <div class="info">
                <p>Thomas Douglas</p>
                <p>Available</p>
              </div>
              <small class="text-muted my-auto">19 min</small>
            </li>
            <li class="list">
              <div class="profile"><img src="<?php echo $this->admin_url; ?>/assets/images/faces/face2.jpg"
                  alt="image"><span class="offline"></span></div>
              <div class="info">
                <div class="wrapper d-flex">
                  <p>Catherine</p>
                </div>
                <p>Away</p>
              </div>
              <div class="badge badge-success badge-pill my-auto mx-2">4</div>
              <small class="text-muted my-auto">23 min</small>
            </li>
            <li class="list">
              <div class="profile"><img src="<?php echo $this->admin_url; ?>/assets/images/faces/face3.jpg"
                  alt="image"><span class="online"></span></div>
              <div class="info">
                <p>Daniel Russell</p>
                <p>Available</p>
              </div>
              <small class="text-muted my-auto">14 min</small>
            </li>
            <li class="list">
              <div class="profile"><img src="<?php echo $this->admin_url; ?>/assets/images/faces/face4.jpg"
                  alt="image"><span class="offline"></span></div>
              <div class="info">
                <p>James Richardson</p>
                <p>Away</p>
              </div>
              <small class="text-muted my-auto">2 min</small>
            </li>
            <li class="list">
              <div class="profile"><img src="<?php echo $this->admin_url; ?>/assets/images/faces/face5.jpg"
                  alt="image"><span class="online"></span></div>
              <div class="info">
                <p>Madeline Kennedy</p>
                <p>Available</p>
              </div>
              <small class="text-muted my-auto">5 min</small>
            </li>
            <li class="list">
              <div class="profile"><img src="<?php echo $this->admin_url; ?>/assets/images/faces/face6.jpg"
                  alt="image"><span class="online"></span></div>
              <div class="info">
                <p>Sarah Graves</p>
                <p>Available</p>
              </div>
              <small class="text-muted my-auto">47 min</small>
            </li>
          </ul>
        </div>
        <!-- chat tab ends -->
      </div>
    </div>
    
    <script>
      function confirmLogout(e) {
        e.preventDefault();
        Swal.fire({
          title: "Are you sure?",
          text: "You are about to logout",
          icon: "warning",
          showCancelButton: true,
          confirmButtonText: 'Yes, logout',
          cancelButtonText: 'Cancel'
        })
        .then((result) => {
          if (result.isConfirmed) {
            window.location.href = "<?php echo wp_logout_url(); ?>";
          }
        });
      }
    </script>