<?php


class Initiate
{
    private $user_id;
    private $api_key;
    private $balance;
    private $plan;
    private $source;
    private $vtupress_users_db;
    private $userData;
    private $wpuserData;
    private $ref;
    private $transaction_name;
    private $serviceObj;
    private $required;

    private $user_instance;

    public $user;


    public function __construct($user_instance, $user, $wpid, $id, $apikey, $ref, $action, $source)
    {
        if (!$wpid) {
            exit_message(false, "Invalid core .env. wp user account ID");
        }
        $this->user = $user;
        $this->transaction_name = $action;
        $this->user_instance = $user_instance;

        $service = Vtupress_Service_Container::get($action, false, $wpid);
        if (!$service) {
            wp_send_json_error(exit_message(false, 'Service not found for your country', [], false), 200);
        }

        //status
        $service->boot();
        if ($service->status != "on") {
            wp_send_json_error(exit_message(false, 'Service not active', [], false), 200);
        }

        $this->serviceObj = $service;

        $paramLoad = $service->payload;

        $this->required = $paramLoad;

        global $wpdb;

        // Set the vtupress users database table
        $this->vtupress_users_db = $wpdb->prefix . 'vtupress_users';

        // Process user details
        $wpuserData = get_userdata($wpid);

        // Check if user exists
        if (!$wpuserData) {
            exit_message(false, "No core .env. user account");
        }


        // Optionally handle cases where no results are returned
        if (empty($this->user)) {
            exit_message(false, "No user data found in API source");
        }

        // Initialize class properties
        $this->user_id = $id;
        $this->source = $source;
        $this->userData = $user;
        $this->balance = $user["balance"];
        $this->plan = $user["plan"];
        $this->api_key = $user["apikey"];
        // Check if referral key is valid
        if (trim($user["run_code"] ?? '') !== $ref && $source == "frontend") {
            exit_message(false, "Incorrect ref");
        }
        $this->ref = $ref;

    }

    public function __initService($param)
    {
        $general_required = $this->required;
        $source = $this->source;
        $action = $this->transaction_name;
        $settings = $this->serviceObj->get_settings();

        if ($settings["require_pin"] == "yes") {
            if (!isset($param["pin"]) && $source != "api"):
                wp_send_json_error(exit_message(false, 'Pin required', [], false), 200);
            endif;
            $pin = $param["pin"] ?? '';
            if ($source != "api" && $pin != $this->user["pin"]):
                wp_send_json_error(exit_message(false, 'Incorrect pin', [], false), 200);
            endif;
        }

        if (!empty($this->serviceObj->service_types) && !isset($param["type"])) {
            if (!isset($param["plan"])) {
                wp_send_json_error(exit_message(false, 'Plan not found since type not set', [], false), 200);
            }

            [$nt, $pl] = array_map('trim', explode("_", $param["plan"], 3));

            $param["type"] = $pl;

        }


        if (!empty($this->serviceObj->service_types) && isset($param["type"])) {
            $type = $param["type"];

            if ($this->serviceObj->uses_provider && !isset($param["network"]) && $this->serviceObj->uses_plans) {
                if (!isset($param["plan"])) {
                    wp_send_json_error(exit_message(false, 'Plan not found', [], false), 200);
                }

                [$nt] = array_map('trim', explode("_", $param["plan"], 2));

                $param["network"] = $nt;

                // exit_message(false, $nt, [], true);

                // exit;
            }


            if (!empty($this->serviceObj->service_types) && !isset($param["type"])) {
                exit_message(false, "Service type required");
            }


            if (!in_array($type, $settings['service_types'])) {
                wp_send_json_error(exit_message(false, "Service type [$type] not found in array", [], false), 200);
            }

            $service = Vtupress_Service_Container::get($action, $type);

            // wp_send_json_error(exit_message(false,   $service , [], false), 200);

            if (!$service) {
                wp_send_json_error(exit_message(false, "Service type [$type] method not found", [], false), 200);
            }

            //status
            $service->boot();
            $settings = $service->get_settings(false);

            if ($settings["enable"] != "yes") {
                wp_send_json_error(exit_message(false, 'Service type not active', [], false), 200);
            }

            //set amount



            $this->serviceObj = $service;

        }

        foreach ($general_required as $value) {
            if (!isset($param[$value])) {
                exit_message(false, "Missing required parameter: {$value}");
            } elseif (empty($param[$value])) {
                exit_message(false, "Parameter {$value} is empty");
            }
        }



        $result = $this->serviceObj->process_transaction($settings, $this->user_instance, $this->userData, $source, $param);

        global $wpdb;
        $vend_lock = $wpdb->prefix . 'vtupress_vend_lock';
        $wpdb->delete($vend_lock, ['user_id' => $this->user_id]);

        // exit_message(false, "Good", $result, true);

        return wp_send_json($result);

    }




}

