<?php

if(!defined("ABSPATH")):
    die("Not Allowed");
endif;


if(!isset($_POST["_nonce"])):
    $return["status"] = "error";
    $return["message"] = "No nonce";
    echo json_encode($return);
    exit;
endif;

if(!wp_verify_nonce($_POST['_nonce'], 'vtupress_user_nonce')):
    $return["status"] = "error";
    $return["message"] = "Invalid nonce";
    echo json_encode($return);
    exit;
endif;

$id = get_current_user_id();
if($id < 1){
    $return["status"] = "error";
    $return["message"] = "You are not logged in";
    echo json_encode($return);
    exit;
}

$users = new Users();
$user =  $users->getUser($id,true,true); // $id is WP ID, so pass true as 3rd arg

if ($user["access_status"] != 'allowed') {
    $response["status"] = "400";
    $response["status_key"] = "status";
    $response["status_response"] = "You are not currently activated or your account status is not active";
    die(json_encode($response));
}

//check timeout


$settings_table = $wpdb->prefix."vtupress_general_settings";
$gen_settings = $wpdb->get_row("SELECT * FROM $settings_table WHERE set_country = '{$user['set_country']}' ", ARRAY_A);
if(!$gen_settings){
    wp_send_json([
        'status'  => 'error',
        'message' => 'General settings not found for your country'
    ], 400);
}


$current_time = time();

if(isset($gen_settings["set_timeout"]) && !empty($gen_settings["set_timeout"])){
    $timeout = $gen_settings["set_timeout"];
}else{
    $timeout = 60; // minutes
}

if(isset($user["last_active"]) && !empty($user["last_active"])){
    $last_active_str = $user["last_active"];
    // Convert datetime string to timestamp
    $last_active = strtotime($last_active_str);
}else{
    $last_active = 0;
}

$time_difference = $current_time - $last_active; // difference in seconds
$timeout_seconds = $timeout * 60; // convert minutes to seconds

if($time_difference > $timeout_seconds){
    wp_send_json([
        'status'  => 'error',
        'message' => "Session timed out. Please refresh and log in again."
    ], 400);
}