<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header("Access-Control-Allow-Methods: POST");
header("Allow: POST, GET");
header("Access-Control-Allow-Headers: Authorization, X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, connectionid, Access-Control-Request-Method, Access-Control-Allow-Origin");

function getAuthorizationHeader()
{
    // 1. Try standard keys in $_SERVER (your method)
    if (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        return $_SERVER['HTTP_AUTHORIZATION'];
    }
    if (isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        return $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
    }

    // 2. Try getallheaders() (most reliable on FastCGI/Nginx)
    if (function_exists('getallheaders')) {
        $headers = getallheaders();
        if (isset($headers['Authorization'])) {
            return $headers['Authorization'];
        }
    }

    // 3. Fallback/Not found
    return false;
}

$response = [];

$headers = strtolower( getAuthorizationHeader() ?? '');

date_default_timezone_set('Africa/Lagos');

if (!$headers) {

    $response["status"] = "400";
    $response["status_key"] = "authorization";
    $response["status_response"] = "Authorization Header Required";
    // die(json_encode($response));
    wp_send_json($response, 403);
}

$authorizationHeader = $headers;
if (preg_match("/token|bearer/i",$authorizationHeader) === false) {
    $response["status"] = "400";
    $response["status_key"] = "token";
    $response["status_response"] = "Authorization Token Required";
    // die(json_encode($response));
    wp_send_json($response, 403);

}

$token = trim(preg_replace("/Token|Bearer/i", "", $authorizationHeader));

if (strtolower($token) == "null" || strtolower($token) == "false") {
    $response["status"] = "400";
    $response["status_key"] = "token_null";
    $response["status_response"] = "Your Token key Can't Be Nulled";
    // die(json_encode($response));
    wp_send_json($response, 403);

}

$users = new Users();
$confirm_api = $users->verifyApi($token);
$user = $confirm_api ? $users->getUser($confirm_api,true) : false;

if (!$confirm_api) {
    $response["status"] = "400";
    $response["status_key"] = "user";
    $response["status_response"] = "user with key not found";
    die(json_encode($response));
} elseif ($user["access_status"] != 'allowed') {
    $response["status"] = "400";
    $response["status_key"] = "status";
    $response["status_response"] = "You are not currently activated or your account status is not active";
    die(json_encode($response));
}


$user_id = $id = $confirm_api;
$apikey = $token;


$rawData = file_get_contents('php://input');
// Decode JSON data
$data = json_decode($rawData, true);

if (!is_array($data)) {
    $response["status"] = "400";
    $response["status_key"] = "data";
    $response["status_response"] = "POST Data Not Found";
    die(json_encode($response));
}