<?php
defined('ABSPATH');

include_once VTUPRESS_PATH . '/functions.php';
include_once VTUPRESS_PATH . '/includes/class.php';
include_once __DIR__ . '/class.php';

$current_timestamp = current_time('timestamp');
global $wpdb;
/**
 * Detect raw JSON input
 */
$rawData = file_get_contents('php://input');
$data = json_decode($rawData, true);

$source = is_array($data) ? 'api' : 'frontend';

if (is_array($data)) {
    $_POST = array_merge($_POST ?? [], $data);
}

/**
 * Detect source
 */

/**
 * Validate action
 */
if (empty($_POST['action'])) {
    wp_send_json([
        'status' => 'error',
        'message' => 'Missing action'
    ], 400);
}

$action = sanitize_key($_POST['action']);

/**
 * Validate reference
 */

$_POST['ref'] = $_POST['ref'] ?? date('Ymd', $current_timestamp) . date('H', $current_timestamp) . date("i", $current_timestamp) . date("s", $current_timestamp) . uniqid('', false);

$ref = sanitize_text_field($_POST['ref']);

/**
 * Auth handling
 */
if ($source === 'api') {
    include_once __DIR__ . "/header.php";       // sets $id, $apikey
} else {
    include __DIR__ . '/frontend.php';  // sets $id
}

/**
 * Collect parameters
 */
$param = array_map('sanitize_text_field', $_POST);

// 1. Check if Reference already exists (Idempotency)
$existing = $wpdb->get_var($wpdb->prepare("SELECT id FROM {$wpdb->prefix}vtupress_transactions WHERE reference = %s", $ref));
if ($existing) {
    wp_send_json([
        'status' => 'error',
        'message' => 'Duplicate Transaction detected (Ref)'
    ], 200);
}
/**
 * Initiate service
 */

$wpid = $user["userId"] ?? false;
$build = new Initiate($users, $user, $wpid, $id, $apikey ?? null, $ref, $action, $source);
$response = $build->__initService($param);

wp_send_json($response);