<?php
if (!defined('ABSPATH')) {
  die("Not Allowed");
}

global $wpdb;


//Check Php Version
$phpVersion = phpversion();
if (floatval($phpVersion) < floatval("8.0.0") || floatval($phpVersion) > floatval("8.4.0")) {

  $title = "PHP VERSION ERROR ";
  $message = "You are using an incompatible php version of <b>$phpVersion</b>, this might break up your experience. Kindly send a request to your developer or change your php version yourself on cpanel if you use one to not less than <b>7.4</b> and not greater than <b>8.0</b> ";
  dump_error($title, $message);
}

//Set Permalink
if ($permalink = get_option('permalink_structure') != '/%postname%/') {
  update_option('permalink_structure', '/%postname%/');
}

//Remove Wp Footer
add_filter('admin_footer_text', '__return_empty_string', 11);
add_filter('update_footer', '__return_empty_string', 11);

$brun = Vtupress_option::get('vtupress_custom_active') == "yes";


//defines
define("gateway_custom_path", __DIR__ . "/pages/gateway/customs/");

?>
<script>
  // jQuery("title").text("<?php //echo $links; ?>");
</script>

<script src="<?php echo $this->admin_url . '/assets/js/loader.js'; ?>"></script>
<link href="<?php echo $this->admin_url . '/assets/vendors/mdi/css/materialdesignicons.min.css'; ?>">
</link>

<script>
  var style = {
    style: {
      "1,4": {
        bg: "black"
      }
    },
    only: "fill",
    size: "30"
  };

  let loaderJs = new LoaderJs(2, style);
</script>

<?php
if (!$brun) {
  $path = ABSPATH . '/wp-content/plugins/vtupress/globals/admin/pages/';
  include_once $path . 'license.php';
  return;
}

$bwizard = Vtupress_option::get('vtupress_custom_wizard', '');
if (empty($bwizard)) {
  $path = ABSPATH . '/wp-content/plugins/vtupress/globals/admin/pages/';
  include_once $path . 'wizard.php';
  return;
}
?>
<!-- ============================================================== -->
<!-- Topbar header - style you can find in pages.scss -->
<!-- ============================================================== -->

<script>
  loaderJs.show();
</script>
<?php



$messd = $wpdb->prefix . "vtupress_chat";
$noti = $wpdb->prefix . "vtupress_notifications";


$links = "VTUPRESS ";
foreach ($_GET as $key => $value) {
  if ($value != "dashboard") {
    $links .= strtoupper("> $value");
  }
}

$messages = $wpdb->get_results("SELECT * FROM (SELECT * FROM $messd WHERE type='received' AND status = 'unread' ORDER BY id DESC LIMIT 3) AS x GROUP BY user_id");

$notifications = $wpdb->get_results("SELECT * FROM $noti WHERE status = 'unread' ORDER BY id DESC LIMIT 3");



include_once $this->admin_path . 'items-includes/header.php'; ?>

<!-- ============================================================== -->
<!-- End Topbar header -->
<!-- ============================================================== -->
<!-- ============================================================== -->
<!-- Left Sidebar - style you can find in sidebar.scss  -->
<!-- ============================================================== -->

<?php include_once $this->admin_path . 'items-includes/aside.php'; ?>

<!-- ============================================================== -->
<!-- End Left Sidebar - style you can find in sidebar.scss  -->
<!-- ============================================================== -->
<!-- ============================================================== -->
<!-- Page wrapper  -->
<!-- ============================================================== -->

<?php include_once $this->admin_path . 'items-includes/page-wrapper.php'; ?>
<?php include_once $this->admin_path . 'items-includes/footer.php'; ?>

<!-- ============================================================== -->
<!-- End Page wrapper  -->
<!-- ============================================================== -->