<?php
if (!defined('ABSPATH'))
    exit;

global $wpdb;
$users_class = new Users();
$current_wp_user = get_current_user_id();

// Load countries
$all_countries = Vtupress_Country_Manager::all();
$enabled_countries = Vtupress_Country_Manager::enabled();

$licensefor = $this->license_for;
$license_country = $this->license_country;

// Load saved options
$current_country = Vtupress_Option::get('vtupress_business_country', $enabled_countries[0] ?? $license_country);

// Handle POST save
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['vtupress_save_countries'])) {
    if (empty($licensefor)):
        echo '<div class="alert alert-success mt-3">Please reactivate your license to set the license default country!</div>';
    else:

        check_admin_referer('vtupress_country_save', 'vtupress_nonce');

        if (isset($_POST['enabled_countries'])):
            $enabled = $licensefor != "all" ? [$license_country] : array_map('sanitize_text_field', $_POST['enabled_countries'] ?? []);
            Vtupress_Option::update('vtupress_enabled_countries', $enabled);
            $enabled_countries = $enabled;
        endif;

        // Update current country (context)
        if (!empty($_POST['current_country']) && $licensefor == "all") {
            Vtupress_Option::update('vtupress_business_country', sanitize_text_field($_POST['current_country']));
            $current_country = sanitize_text_field($_POST['current_country']);
            if ($current_wp_user) {
                $wpdb->update(
                    $wpdb->prefix . 'vtupress_users',
                    ['set_country' => $current_country],
                    ['userId' => $current_wp_user],
                    ['%s'],
                    ['%d']
                );
            }
        } else {
            Vtupress_Option::update('vtupress_business_country', sanitize_text_field($license_country));
            $current_country = sanitize_text_field($license_country);
            if ($current_wp_user) {
                $wpdb->update(
                    $wpdb->prefix . 'vtupress_users',
                    ['set_country' => $current_country],
                    ['userId' => $current_wp_user],
                    ['%s'],
                    ['%d']
                );
            }
        }

        // Ensure default levels exist for all enabled countries
        foreach ($enabled_countries as $e_country) {
            Vtupress_Country_Manager::initialize_defaults($e_country);
        }

        echo '<div class="alert alert-success mt-3">Countries saved successfully!</div>';

    endif;
}

// --- SORT COUNTRIES: enabled first (alphabetical), then disabled (alphabetical)
$enabled_list = [];
$disabled_list = [];

foreach ($all_countries as $code => $data) {
    if (in_array($code, $enabled_countries)) {
        $enabled_list[$code] = $data;
    } else {
        $disabled_list[$code] = $data;
    }
}

uasort($enabled_list, fn($a, $b) => strcmp($a['name'], $b['name']));
uasort($disabled_list, fn($a, $b) => strcmp($a['name'], $b['name']));
$all_countries = array_merge($enabled_list, $disabled_list);

if ($licensefor != "all"):
    echo '<div class="alert alert-success mt-3">Please you can\'t change your country or enable other countries aside <strong>' . $licensefor . '</strong>!</div>';
endif;
?>

<div class="container-fluid py-3">
    <h1 class="mb-3">VTUPress Country Manager</h1>

    <!-- TOP ROW: Current Country + Current Admin Country -->
    <form method="POST" class="mb-4">
        <?php wp_nonce_field('vtupress_country_save', 'vtupress_nonce'); ?>
        <div class="row g-2 align-items-center">
            <div class="col-auto">
                <label for="current_country" class="form-label mb-0">Business Country:</label>
            </div>
            <div class="col-auto">
                <select name="current_country" id="current_country" class="form-select">
                    <?php foreach ($enabled_countries as $code):
                        $name = ucwords(str_replace("_", " ", $code));
                        $selected = ($code === $current_country) ? 'selected' : '';
                        ?>
                        <option value="<?php echo esc_attr($code); ?>" <?php echo $selected; ?>>
                            <?php echo esc_html($name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-auto">
                <button type="submit" name="vtupress_save_countries" class="btn btn-primary">Save</button>
            </div>
        </div>
    </form>

    <!-- SEARCH BOX -->
    <div class="mb-3">
        <input type="text" id="vtupress-country-search" class="form-control" placeholder="Search countries...">
    </div>

    <!-- COUNTRY GRID -->
    <form method="POST">
        <?php wp_nonce_field('vtupress_country_save', 'vtupress_nonce'); ?>
        <div id="vtupress-country-list" class="row g-3">
            <?php foreach ($all_countries as $code => $data):
                $enabled = in_array($code, $enabled_countries);
                $border = $enabled ? 'border-success' : 'border-secondary';
                $country_name_attr = ucwords(str_replace("_", " ", esc_attr(strtolower($code))));
                ?>
                <div class="col-6 col-sm-4 col-md-3 col-lg-2">
                    <div class="vtupress-country-item card <?php echo $border; ?> d-flex justify-content-center align-items-center flex-column"
                        data-country-name="<?php echo $country_name_attr; ?>"
                        data-country-code="<?php echo esc_attr($code); ?>"
                        style="cursor:pointer; padding:8px; border:2px solid; border-radius:5px; min-height:50px; flex-wrap:wrap;">
                        <span style="font-size:24px;"><?php echo esc_html($data['flag'] ?? ''); ?></span>
                        <span class="text-center"><?php echo esc_html($country_name_attr); ?></span>
                        <input type="checkbox" name="enabled_countries[]" value="<?php echo esc_attr($code); ?>" <?php checked($enabled); ?> style="display:none;">
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="mt-3">
            <button type="submit" <?php echo $licensefor == 'all' ? '' : 'disabled'; ?> name="vtupress_save_countries"
                class="btn btn-primary">Save</button>
        </div>
    </form>
</div>

<script>
    (function () {
        const searchInput = document.getElementById('vtupress-country-search');
        const countryItems = document.querySelectorAll('.vtupress-country-item');

        // Live search filter
        searchInput.addEventListener('input', function () {
            const val = this.value.toLowerCase();
            countryItems.forEach(item => {
                const name = item.dataset.countryName.toLowerCase();
                // console.log(name);
                const col = item.closest('.col-6, .col-sm-4, .col-md-3, .col-lg-2');
                if (!col) return;
                col.style.display = name.includes(val) ? 'block' : 'none';
            });
        });

        // Toggle enable/disable on click
        countryItems.forEach(item => {
            item.addEventListener('click', function () {
                const checkbox = this.querySelector('input[type=checkbox]');
                if (!checkbox) return;
                checkbox.checked = !checkbox.checked;
                if (checkbox.checked) {
                    this.classList.remove('border-secondary');
                    this.classList.add('border-success');
                } else {
                    this.classList.remove('border-success');
                    this.classList.add('border-secondary');
                }
            });
        });
    })();
</script>

<style>
    .vtupress-country-item:hover {
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
    }
</style>