<?php
if (!defined('ABSPATH')) exit;

        $args = [
            'timeout' => 120
        ];
        $swal = '';
// 1. Handle Actions (Activate/Deactivate)
if (isset($_POST['action_type']) && isset($_POST['module_id'])) {
    
    // Security Check (Simple nonce or capability check recommended)
    if (!current_user_can('manage_options')) {
        echo "<div class='alert alert-danger'>Unauthorized</div>";
    } else {
        $mod_id = sanitize_text_field($_POST['module_id']);
        $mod_name = sanitize_text_field($_POST['module_name']);
        
        if ($_POST['action_type'] === 'activate') {
            // REMOTE VERIFICATION
            $api_url =  'https://vtupress.com/wp-json/vtupress/v1/verify-module';
            $response = wp_remote_post($api_url, [
                'timeout' => 120,
                'body' => [
                    'module_id' => $mod_id,
                    'site_url' => home_url()
                ]
            ]);

            // print_r($response);
            
            if (is_wp_error($response)) {
                $swal =  "<div class='alert alert-danger'>Connection failed</div>";
            } else {
                $body = json_decode(wp_remote_retrieve_body($response), true);
            // print_r($body);

                if ($body['status']) {
                    // Success: Activate Locally
                    Vtupress_Option::update("vtupress_custom_" . $mod_id, "yes");
                    $swal = "<div class='alert alert-success'>$mod_name Activated!</div>";
                } else {
                    $swal = "<div class='alert alert-danger'>License Verification Failed: " . $body['message'] . " </div>";
                }
            }
        } elseif ($_POST['action_type'] === 'deactivate') {
            // Deactivate Locally
            Vtupress_Option::update("vtupress_custom_" . $mod_id, "no");
           $swal = "<div class='alert alert-danger'>Deactivated', '$mod_name Deactivated.</div>";
        }
    }
}

// 2. Fetch Modules from API
// User stated $country is available in scope
if(!isset($country)) $country = 'nigeria'; // Fallback just in case

$api_url =  'https://vtupress.com/wp-json/vtupress/v1/modules?country=' . $country;
$response = wp_remote_get($api_url,$args);

$modules = [];
if (!is_wp_error($response)) {
    $modules = json_decode(wp_remote_retrieve_body($response), true);
}

// 3. Group by Type
$grouped = ['all' => $modules];
if ($modules) {
    foreach ($modules as $mod) {
        $type = ucwords(str_replace('_', ' ', $mod['module_type'])); // Payment Gateway
        $grouped[$type][] = $mod;
    }
}
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <div>
                            <h4 class="card-title fw-bold text-primary mb-1"><i class="fa-solid fa-store me-2"></i> Module Store</h4>
                            <p class="text-muted small mb-0">Browse and activate premium extensions for VTUPress. Country: <strong><?php echo esc_html(strtoupper($country)); ?></strong></p>
                        </div>
                        <a href="https://vtupress.com/vpaccount/?site=modules" target="_blank" class="btn btn-outline-primary btn-sm rounded-pill">Visit Official Store</a>
                    </div>
                    <?php if(!empty($swal)) :
                          echo $swal;
                    endif;?>


                    <?php if (empty($modules)): ?>
                        <div class="alert alert-warning text-center">
                            <i class="fa-solid fa-exclamation-triangle me-2"></i> No modules found or API connection failed.
                        </div>
                    <?php else: ?>

                        <!-- Tabs -->
                        <ul class="nav nav-pills mb-4" id="moduleTabs" role="tablist">
                            <?php 
                            $first = true;
                            foreach ($grouped as $type => $mods): 
                                $slug = sanitize_title($type);
                                ?>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link <?php echo $first ? 'active' : ''; ?> rounded-pill px-4" id="tab-<?php echo $slug; ?>" data-bs-toggle="pill" data-bs-target="#content-<?php echo $slug; ?>" type="button" role="tab" aria-selected="<?php echo $first ? 'true' : 'false'; ?>">
                                        <?php echo esc_html($type == 'all' ? 'All Modules' : $type); ?> 
                                        <span class="badge bg-white text-primary ms-1 rounded-pill"><?php echo count($mods); ?></span>
                                    </button>
                                </li>
                                <?php 
                                $first = false; 
                            endforeach; 
                            ?>
                        </ul>

                        <!-- Tab Content -->
                        <div class="tab-content" id="moduleTabsContent">
                            <?php 
                            $first = true;
                            foreach ($grouped as $type => $mods): 
                                $slug = sanitize_title($type);
                                ?>
                                <div class="tab-pane fade <?php echo $first ? 'show active' : ''; ?>" id="content-<?php echo $slug; ?>" role="tabpanel" aria-labelledby="tab-<?php echo $slug; ?>">
                                    <div class="row g-4">
                                        <?php foreach ($mods as $mod): 
                                            // Check Local Activation
                                            $key_key = "vtupress_custom_" . $mod['module_id']; // This is the ID KEY (e.g. payment_point)
                                            $is_active = (Vtupress_Option::get($key_key) == 'yes');
                                            $features = json_decode($mod['features'], true) ?? [];
                                            ?>
                                            <div class="col-md-6 col-lg-4">
                                                <div class="card h-100 border hover-shadow transition-all module-card">
                                                    <div class="card-body d-flex flex-column">
                                                        <div class="d-flex justify-content-between align-items-start mb-3">
                                                            <div>
                                                                <h5 class="fw-bold mb-1 text-dark"><?php echo esc_html($mod['module_name']); ?></h5>
                                                                <span class="badge bg-light text-secondary border"><?php echo ucwords(str_replace('_', ' ', $mod['module_type'])); ?></span>
                                                            </div>
                                                            <h5 class="text-primary fw-bold">₦<?php echo number_format($mod['module_price']); ?></h5>
                                                        </div>

                                                        <p class="text-muted small mb-3 flex-grow-1" style="min-height: 60px;">
                                                            <?php echo esc_html(wp_trim_words($mod['module_description'], 15)); ?>
                                                        </p>

                                                        <div class="bg-light p-3 rounded mb-3">
                                                            <h6 class="small fw-bold text-uppercase text-muted mb-2">Features</h6>
                                                            <ul class="list-unstyled small mb-0">
                                                                <?php 
                                                                $limit = 3;
                                                                $count = 0;
                                                                foreach ($features as $ft) {
                                                                    if ($count >= $limit) break;
                                                                    echo "<li class='mb-1'><i class='fa-solid fa-check-circle text-success me-2'></i>" . esc_html($ft) . "</li>";
                                                                    $count++;
                                                                }
                                                                if (count($features) > $limit) {
                                                                    echo "<li class='text-muted fst-italic'>+" . (count($features) - $limit) . " more...</li>";
                                                                }
                                                                ?>
                                                            </ul>
                                                        </div>

                                                        <!-- Action Form -->
                                                        <form method="post">
                                                            <input type="hidden" name="module_id" value="<?php echo esc_attr($mod['module_id']); ?>">
                                                            <input type="hidden" name="module_name" value="<?php echo esc_attr($mod['module_name']); ?>">
                                                            
                                                            <?php if ($is_active): ?>
                                                                <input type="hidden" name="action_type" value="deactivate">
                                                                <button type="submit" class="btn btn-outline-danger w-100 fw-bold">
                                                                    <i class="fa-solid fa-power-off me-2"></i> Deactivate
                                                                </button>
                                                            <?php else: ?>
                                                                <input type="hidden" name="action_type" value="activate">
                                                                <button type="submit" class="btn btn-success w-100 fw-bold shadow-sm">
                                                                    <i class="fa-solid fa-bolt me-2"></i> Activate
                                                                </button>
                                                            <?php endif; ?>
                                                        </form>

                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                                <?php 
                                $first = false; 
                            endforeach; 
                            ?>
                        </div>

                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .hover-shadow:hover {
        transform: translateY(-5px);
        box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
    }
    .transition-all {
        transition: all 0.3s ease;
    }
    .nav-pills .nav-link.active {
        background-color: #0d6efd;
    }
    .nav-pills .nav-link {
        color: #495057;
        font-weight: 500;
    }
</style>
