<?php

if (!defined('ABSPATH')) {
  die("Not Allowed");
}

global $wpdb;
// $users_table = $wpdb->prefix . "users";
$vtupress_users_table = $wpdb->prefix . "vtupress_users";
$transactions_table = $wpdb->prefix . 'vtupress_transactions';

// --- REAL TIME CALCULATIONS ---

// 1. Revenue & Sales (Successful transactions)
$current_country_context = Vtupress_Country_Context::get();
$currency_symbol = Vtupress_Country_Manager::currency($current_country_context);

$total_revenue = $wpdb->get_var("SELECT SUM(amount) FROM $transactions_table WHERE status = 'success' AND set_country = '$current_country_context'");
$annual_revenue = $wpdb->get_var("SELECT SUM(amount) FROM $transactions_table WHERE status = 'success' AND YEAR(created_at) = YEAR(CURDATE()) AND set_country = '$current_country_context'");
$weekly_sales = $wpdb->get_var("SELECT SUM(amount) FROM $transactions_table WHERE status = 'success' AND YEARWEEK(created_at, 1) = YEARWEEK(CURDATE(), 1) AND set_country = '$current_country_context'");
$weekly_orders = $wpdb->get_var("SELECT COUNT(id) FROM $transactions_table WHERE YEARWEEK(created_at, 1) = YEARWEEK(CURDATE(), 1) AND set_country = '$current_country_context'");

// --- WEEKLY CHART DATA CALCULATION ---
$daily_success_data = [];
$daily_failed_data = [];
$daily_pending_data = [];

for ($i = 0; $i < 7; $i++) {
    // Calculate date for each day of the current week (Starting Sunday)
    $day_date = date('Y-m-d', strtotime("this week -$i days")); // Logic to get dates for the week
    
    // Success amounts for the chart
    $s_val = $wpdb->get_var($wpdb->prepare("SELECT SUM(amount) FROM $transactions_table WHERE status = 'successful' AND DATE(created_at) = DATE(NOW() - INTERVAL (%d) DAY + INTERVAL (6 - WEEKDAY(NOW())) DAY - INTERVAL 6 DAY)", $i));
    
    // We use a simpler approach to get Sunday-Saturday values for the current week
    $days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    $chart_success = [];
    $chart_failed = [];
    $chart_pending = [];

    foreach ($days as $day) {
        $date_query = date('Y-m-d', strtotime($day . " this week"));
        $chart_success[] = floatval($wpdb->get_var("SELECT SUM(amount) FROM $transactions_table WHERE status = 'successful' AND DATE(created_at) = '$date_query' AND set_country = '$current_country_context'")) ?: 0;
        $chart_failed[] = floatval($wpdb->get_var("SELECT SUM(amount) FROM $transactions_table WHERE status = 'failed' AND DATE(created_at) = '$date_query' AND set_country = '$current_country_context'")) ?: 0;
        $chart_pending[] = floatval($wpdb->get_var("SELECT SUM(amount) FROM $transactions_table WHERE status = 'pending' AND DATE(created_at) = '$date_query' AND set_country = '$current_country_context'")) ?: 0;
    }
}

// 2. User Stats
// $all_users_count = count(get_users()); 
$all_users_count = intval($wpdb->get_var("SELECT count(id) FROM $vtupress_users_table WHERE set_country = '$current_country_context'"));

$banned_users = intval($wpdb->get_var("SELECT count(id) FROM $vtupress_users_table WHERE access_status = 'blocked' AND set_country = '$current_country_context'"));
$verified_users = intval($wpdb->get_var("SELECT count(id) FROM $vtupress_users_table WHERE email_verified = 'yes' AND set_country = '$current_country_context'"));

// 3. Online/Active Users (Active within last 15 minutes) - Also filter by country
$online_users_count = intval($wpdb->get_var("SELECT COUNT(id) FROM $vtupress_users_table WHERE last_active >= NOW() - INTERVAL 15 MINUTE AND set_country = '$current_country_context'"));

// 4. Top Data
// Filter top customers by country AND sort by total SUCCESSFUL transaction volume
$top_customer_row = $wpdb->get_row("
    SELECT v.first_name, v.last_name, 
    (SELECT SUM(amount) FROM $transactions_table WHERE user_id = v.id AND status = 'successful' AND set_country = '$current_country_context') as total_spent
    FROM $vtupress_users_table v 
    WHERE v.set_country = '$current_country_context' 
    ORDER BY total_spent DESC LIMIT 1
");
$top_customer_name = $top_customer_row ? $top_customer_row->first_name : "N/A";

$top_5_customers = $wpdb->get_results("
    SELECT v.first_name, v.last_name, v.photo, v.created_at, v.last_active, v.balance,
    (SELECT SUM(amount) FROM $transactions_table WHERE user_id = v.id AND status = 'successful' AND set_country = '$current_country_context') as total_sales,
    (SELECT service FROM $transactions_table WHERE user_id = v.id ORDER BY id DESC LIMIT 1) as last_service
    FROM $vtupress_users_table v 
    WHERE v.set_country = '$current_country_context'
    ORDER BY total_sales DESC LIMIT 5
");

// 5. Airtime vs Data (For Chart)
$airtime_count = $wpdb->get_var("SELECT COUNT(id) FROM $transactions_table WHERE service = 'airtime' AND set_country = '$current_country_context'");
$data_count = $wpdb->get_var("SELECT COUNT(id) FROM $transactions_table WHERE service = 'data' AND set_country = '$current_country_context'");

?>

<div class="content-wrapper">
  <div class="page-header">
    <h3 class="page-title">
      <span class="page-title-icon bg-gradient-primary text-white me-2">
        <i class="mdi mdi-home"></i>
      </span> Dashboard
    </h3>
    <nav aria-label="breadcrumb">
      <ul class="breadcrumb">
        <li class="breadcrumb-item active" aria-current="page">
          <span></span>Overview <i class="mdi mdi-alert-circle-outline icon-sm text-primary align-middle"></i>
        </li>
      </ul>
    </nav>
  </div>

  <div class="container">
    <div class="row">
      <!-- Total Revenue -->
      <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 grid-margin stretch-card">
        <div class="card card-statistics">
          <div class="card-body">
            <div class="clearfix">
              <div class="float-start">
                <i class="mdi mdi-cube text-danger icon-lg"></i>
              </div>
              <div class="float-end">
                <p class="mb-0 text-right">Total Revenue</p>
                <div class="fluid-container">
                  <h3 class="font-weight-medium text-right mb-0"> <?= $currency_symbol . number_format((float) $total_revenue, 0) ?> </h3>
                </div>
              </div>
            </div>
            <p class="text-muted mt-3 mb-0">
              <i class="mdi mdi-alert-octagon me-1" aria-hidden="true"></i> Annual:
              <?= $currency_symbol . number_format((float) $annual_revenue, 0) ?>
            </p>
          </div>
        </div>
      </div>

      <!-- Orders -->
      <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 grid-margin stretch-card">
        <div class="card card-statistics">
          <div class="card-body">
            <div class="clearfix">
              <div class="float-start">
                <i class="mdi mdi-receipt text-warning icon-lg"></i>
              </div>
              <div class="float-end">
                <p class="mb-0 text-right">Orders</p>
                <div class="fluid-container">
                  <h3 class="font-weight-medium text-right mb-0"> <?= number_format($weekly_orders) ?> </h3>
                </div>
              </div>
            </div>
            <p class="text-muted mt-3 mb-0">
              <i class="mdi mdi-bookmark-outline me-1" aria-hidden="true"></i> Weekly Orders
            </p>
          </div>
        </div>
      </div>

      <!-- Sales (Success Amount) -->
      <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 grid-margin stretch-card">
        <div class="card card-statistics">
          <div class="card-body">
            <div class="clearfix">
              <div class="float-start">
                <i class="mdi mdi-poll text-success icon-lg"></i>
              </div>
              <div class="float-end">
                <p class="mb-0 text-right">Sales</p>
                <div class="fluid-container">
                  <h3 class="font-weight-medium text-right mb-0"> <?= $currency_symbol . number_format((float) $weekly_sales, 0) ?> </h3>
                </div>
              </div>
            </div>
            <p class="text-muted mt-3 mb-0">
              <i class="mdi mdi-calendar me-1" aria-hidden="true"></i> Weekly Sales
            </p>
          </div>
        </div>
      </div>

      <!-- Users -->
      <div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 grid-margin stretch-card">
        <div class="card card-statistics">
          <div class="card-body">
            <div class="clearfix">
              <div class="float-start">
                <i class="mdi mdi-account-box-multiple text-info icon-lg"></i>
              </div>
              <div class="float-end">
                <p class="mb-0 text-right">Users</p>
                <div class="fluid-container">
                  <h3 class="font-weight-medium text-right mb-0"> <?= number_format($all_users_count) ?> </h3>
                </div>
              </div>
            </div>
            <p class="text-muted mt-3 mb-0">
              <i class="mdi mdi-reload me-1" aria-hidden="true"></i> Total Customers
            </p>
          </div>
        </div>
      </div>

      <!-- Gradient Cards -->
      <div class="col-md-4 stretch-card grid-margin">
        <div class="card bg-gradient-danger card-img-holder text-white">
          <div class="card-body">
            <img src="<?= $this->admin_url ?>/../assets/images/dashboard/circle.svg" class="card-img-absolute"
              alt="circle-image">
            <h4 class="font-weight-normal mb-3"> Weekly Sales <i class="mdi mdi-chart-line mdi-24px float-end"></i></h4>
            <h2 class="mb-5"><?= $currency_symbol . " " . number_format((float) $weekly_sales, 2) ?></h2>
            <h6 class="card-text">Sold this week</h6>
          </div>
        </div>
      </div>
      <div class="col-md-4 stretch-card grid-margin">
        <div class="card bg-gradient-info card-img-holder text-white">
          <div class="card-body">
            <img src="<?= $this->admin_url ?>/../assets/images/dashboard/circle.svg" class="card-img-absolute"
              alt="circle-image">
            <h4 class="font-weight-normal mb-3"> Weekly Orders <i
                class="mdi mdi-bookmark-outline mdi-24px float-end"></i></h4>
            <h2 class="mb-5"><?= number_format($weekly_orders) ?></h2>
            <h6 class="card-text">Orders this week</h6>
          </div>
        </div>
      </div>
      <div class="col-md-4 stretch-card grid-margin">
        <div class="card bg-gradient-success card-img-holder text-white">
          <div class="card-body">
            <img src="<?= $this->admin_url ?>/../assets/images/dashboard/circle.svg" class="card-img-absolute"
              alt="circle-image">
            <h4 class="font-weight-normal mb-3"> Users Online <i class="mdi mdi-diamond mdi-24px float-end"></i></h4>
            <h2 class="mb-5"><?= number_format($online_users_count) ?></h2>
            <h6 class="card-text">Active within 15 mins</h6>
          </div>
        </div>
      </div>

      <!-- Summary Bar -->
      <div class="col-12 grid-margin">
        <div class="card card-statistics">
          <div class="row">
            <div class="card-col col-xl-3 col-lg-3 col-md-3 col-6 border-right">
              <div class="card-body">
                <div class="d-flex align-items-center justify-content-center flex-column flex-sm-row">
                  <i class="mdi mdi-account-multiple-outline text-primary me-0 me-sm-4 icon-lg"></i>
                  <div class="wrapper text-center text-sm-left">
                    <p class="card-text mb-0">Banned Users</p>
                    <h3 class="mb-0 font-weight-medium"><?= $banned_users ?></h3>
                  </div>
                </div>
              </div>
            </div>
            <div class="card-col col-xl-3 col-lg-3 col-md-3 col-6 border-right">
              <div class="card-body">
                <div class="d-flex align-items-center justify-content-center flex-column flex-sm-row">
                  <i class="mdi mdi-checkbox-marked-circle-outline text-primary me-0 me-sm-4 icon-lg"></i>
                  <div class="wrapper text-center text-sm-left">
                    <p class="card-text mb-0">Email Verified Users</p>
                    <h3 class="mb-0 font-weight-medium"><?= number_format($verified_users) ?></h3>
                  </div>
                </div>
              </div>
            </div>
            <div class="card-col col-xl-3 col-lg-3 col-md-3 col-6 border-right">
              <div class="card-body">
                <div class="d-flex align-items-center justify-content-center flex-column flex-sm-row">
                  <i class="mdi mdi-trophy-outline text-primary me-0 me-sm-4 icon-lg"></i>
                  <div class="wrapper text-center text-sm-left">
                    <p class="card-text mb-0">Top Customer</p>
                    <h3 class="mb-0 font-weight-medium"><?= esc_html($top_customer_name) ?></h3>
                  </div>
                </div>
              </div>
            </div>
            <div class="card-col col-xl-3 col-lg-3 col-md-3 col-6">
              <div class="card-body">
                <div class="d-flex align-items-center justify-content-center flex-column flex-sm-row">
                  <i class="mdi mdi-target text-primary me-0 me-sm-4 icon-lg"></i>
                  <div class="wrapper text-center text-sm-left">
                    <p class="card-text mb-0">Top Sales</p>
                    <h3 class="mb-0 font-weight-medium"><?= $currency_symbol . " " . number_format((float) $weekly_sales, 0) ?></h3>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <!-- Charts -->
      <div class="col-md-7 grid-margin stretch-card">
        <div class="card">
          <div class="card-body">
            <h4 class="card-title float-start">Weekly Sales Statistics</h4>
            <div id="visit-sale-chart-legend" class="rounded-legend legend-horizontal legend-top-right float-end"></div>
            <canvas id="visit-sale-chart" class="mt-4"></canvas>
          </div>
        </div>
      </div>
      <div class="col-md-5 grid-margin stretch-card">
        <div class="card">
          <div class="card-body">
            <h4 class="card-title">Airtime vs Data (Total Volume)</h4>
            <div class="doughnutjs-wrapper d-flex justify-content-center">
              <canvas id="traffic-chart"></canvas>
            </div>
            <div id="traffic-chart-legend" class="rounded-legend legend-vertical legend-bottom-left pt-4"></div>
          </div>
        </div>
      </div>
    </div>

    <!-- Best Customers Table -->
    <div class="row">
      <div class="col-12 grid-margin">
        <div class="card">
          <div class="card-body">
            <h4 class="card-title">Top 5 Best Customers (By Transactions)</h4>
            <div class="table-responsive">
              <table class="table">
                <thead>
                  <tr>
                    <th> Name </th>
                    <th> Balance </th>
                    <th> Last Service </th>
                    <th> Status </th>
                    <th> Reg. Date </th>
                    <th> Last Active </th>
                  </tr>
                </thead>
                <tbody>
                  <?php if ($top_5_customers): ?>
                    <?php foreach ($top_5_customers as $customer):
                      $photo = !empty($customer->photo) ? esc_url($customer->photo) : $this->admin_url . "/assets/images/faces/face1.jpg";
                      $is_online = (strtotime($customer->last_active) > strtotime("-15 minutes"));
                      $status_class = $is_online ? "success" : "danger";
                      $status_text = $is_online ? "Online" : "Offline";
                      ?>
                      <tr>
                        <td>
                          <img src="<?= $photo ?>" class="me-2" alt="image" style="object-fit: cover;">
                          <?= esc_html($customer->first_name . ' ' . $customer->last_name) ?>
                        </td>
                        <td> <?= ucfirst(esc_html($customer->balance ?? '0')) ?> </td>
                        <td> <?= ucfirst(esc_html($customer->last_service ?? 'None')) ?> </td>
                        <td>
                          <label class="badge badge-gradient-<?= $status_class ?>"><?= $status_text ?></label>
                        </td>
                        <td> <?= date('M d, Y', strtotime($customer->created_at)) ?> </td>
                        <td> <?= human_time_diff(strtotime($customer->last_active), current_time('timestamp')) ?> ago </td>
                      </tr>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <tr>
                      <td colspan="5">No customers found with balance.</td>
                    </tr>
                  <?php endif; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function () {

  /* Charts rendered from C:\wamp64\www\crypto\wp-content\plugins\vtupress\admin\assets\js\widgets.js, dashboard.js and dashboard-dark.js*/
    (function ($) {

      if ($("#visit-sale-chart").length) {
        const ctx = document.getElementById('visit-sale-chart');

        var graphGradient1 = ctx.getContext("2d");
        var graphGradient2 = ctx.getContext("2d");
        var graphGradient3 = ctx.getContext("2d");

        var gradientStrokeViolet = graphGradient1.createLinearGradient(0, 0, 0, 181);
        gradientStrokeViolet.addColorStop(0, 'rgba(218, 140, 255, 1)');
        gradientStrokeViolet.addColorStop(1, 'rgba(154, 85, 255, 1)');
        var gradientLegendViolet = 'rgba(154, 85, 255, 1)';

        var gradientStrokeBlue = graphGradient2.createLinearGradient(0, 0, 0, 360);
        gradientStrokeBlue.addColorStop(0, 'rgba(54, 215, 232, 1)');
        gradientStrokeBlue.addColorStop(1, 'rgba(177, 148, 250, 1)');
        var gradientLegendBlue = 'rgba(54, 215, 232, 1)';

        var gradientStrokeRed = graphGradient3.createLinearGradient(0, 0, 0, 300);
        gradientStrokeRed.addColorStop(0, 'rgba(255, 191, 150, 1)');
        gradientStrokeRed.addColorStop(1, 'rgba(254, 112, 150, 1)');
        var gradientLegendRed = 'rgba(254, 112, 150, 1)';

        new Chart(ctx, {
          type: 'bar',
          data: {
            labels: ['SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT'],
            datasets: [{
              label: "Failed",
              borderColor: gradientStrokeViolet,
              backgroundColor: gradientStrokeViolet,
              hoverBackgroundColor: gradientStrokeViolet,
              fillColor: gradientLegendViolet,
              pointRadius: 0,
              borderWidth: 1,
              fill: 'origin',
              data: [<?php echo implode(',', $chart_failed); ?>],
              barPercentage: 0.5,
              categoryPercentage: 0.5,
            },
            {
              label: "Success",
              borderColor: gradientStrokeRed,
              backgroundColor: gradientStrokeRed,
              hoverBackgroundColor: gradientStrokeRed,
              fillColor: gradientLegendRed,
              pointRadius: 0,
              borderWidth: 1,
              fill: 'origin',
              data: [<?php echo implode(',', $chart_success); ?>],
              barPercentage: 0.5,
              categoryPercentage: 0.5,
            },
            {
              label: "Pending",
              borderColor: gradientStrokeBlue,
              backgroundColor: gradientStrokeBlue,
              hoverBackgroundColor: gradientStrokeBlue,
              fillColor: gradientLegendBlue,
              pointRadius: 0,
              borderWidth: 1,
              fill: 'origin',
              data: [<?php echo implode(',', $chart_pending); ?>],
              barPercentage: 0.5,
              categoryPercentage: 0.5,
            }
            ]
          },
          options: {
            responsive: true,
            maintainAspectRatio: true,
            scales: {
              y: { display: false },
              x: { display: true, grid: { display: false } }
            },
            plugins: { legend: { display: false } }
          },
          plugins: [{
            afterDatasetUpdate: function (chart) {
              const chartId = chart.canvas.id;
              const legendId = `${chartId}-legend`;
              const legendContainer = document.getElementById(legendId);
              if(legendContainer.innerHTML === "") {
                const ul = document.createElement('ul');
                for (let i = 0; i < chart.data.datasets.length; i++) {
                  ul.innerHTML += `<li><span style="background-color: ${chart.data.datasets[i].fillColor}"></span>${chart.data.datasets[i].label}</li>`;
                }
                legendContainer.appendChild(ul);
              }
            }
          }]
        });
      }

      if ($("#traffic-chart").length) {
        const ctx = document.getElementById('traffic-chart');
        var graphGradient1 = ctx.getContext('2d');
        var graphGradient2 = ctx.getContext('2d');

        var gradientStrokeBlue = graphGradient1.createLinearGradient(0, 0, 0, 181);
        gradientStrokeBlue.addColorStop(0, 'rgba(54, 215, 232, 1)');
        gradientStrokeBlue.addColorStop(1, 'rgba(177, 148, 250, 1)');
        
        var gradientStrokeGreen = graphGradient2.createLinearGradient(0, 0, 0, 300);
        gradientStrokeGreen.addColorStop(0, 'rgba(6, 185, 157, 1)');
        gradientStrokeGreen.addColorStop(1, 'rgba(132, 217, 210, 1)');

        new Chart(ctx, {
          type: 'doughnut',
          data: {
            labels: ['Airtime', 'Data'],
            datasets: [{
              data: [<?php echo intval($airtime_count); ?>, <?php echo intval($data_count); ?>],
              backgroundColor: [gradientStrokeBlue, gradientStrokeGreen],
              borderColor: [gradientStrokeBlue, gradientStrokeGreen],
              legendColor: ['rgba(54, 215, 232, 1)', 'rgba(6, 185, 157, 1)']
            }]
          },
          options: {
            cutout: 50,
            responsive: true,
            maintainAspectRatio: true,
            plugins: { legend: { display: false } }
          },
          plugins: [{
            afterDatasetUpdate: function (chart) {
              const chartId = chart.canvas.id;
              const legendId = `${chartId}-legend`;
              const legendContainer = document.getElementById(legendId);
              if(legendContainer.innerHTML === "") {
                const ul = document.createElement('ul');
                for (let i = 0; i < chart.data.datasets[0].data.length; i++) {
                  ul.innerHTML += `<li><span style="background-color: ${chart.data.datasets[0].legendColor[i]}"></span>${chart.data.labels[i]}</li>`;
                }
                legendContainer.appendChild(ul);
              }
            }
          }]
        });
      }
    })(jQuery);
  });
</script>