<?php

if (!defined('ABSPATH')) {
    die("Not Allowed");
}

        $services = $this->services();
        foreach ($services as $service => $value):
            $value->maybe_save_settings();
        endforeach;


?>



<div class="container-fluid allServices position-relative">

    <style>
        .allServicesdiv {
            border: 2px solid #003b46;
            border-radius: 10px;

        }

        .allServicesdiv button {
            padding: 8px;
            border-radius: 5px;
            background-color: #07575b;
            color: #ffffff;
        }

        .allServicesdiv {
            position: relative;
            cursor: pointer;
        }

        .allServicesdiv:hover {
            background-color: #f6f7f7 !important;
        }

        .mouseOverDiv {
            background-color: #000000bd;
            display: none;
            color: #ffffff;
            top: 0;
            left: 0;
            border-radius: 10px;
            width: 100%;
            height: 100%;
        }

        .allServicesdiv:hover .mouseOverDiv {
            display: flex;
        }

        .statusicons i:hover {
            color: var(--bs-warning) !important;
        }

        .service-pop-up,
        .service-pop-up2,
        .service-pop-up3 {
            position: absolute;
            top: 0;
            background-color: #0000007d;
            border-radius: 1px;
            width: 100%;
            height: 100%;
            display: none;
            z-index: 999;
            opacity: 0;
        }

        .closeDiv.position-absolute {
            top: 0;
        }

        .main-content-div,
        .main-content-div>.container-fluid {
            min-height: fit-content !important;
            height: fit-content;
        }

    </style>

    <div class="row serviceDetails bg-white my-3">
        <div class="col-12">
            <h2 class=" d-flex justify-content-center my-2 my-md-3 align-items-center">
                <div class="countryDetenSloDiv d-flex flex-column">
                    <span class="">Services For <?php echo ucwords(str_replace("_", " ", $country)); ?></span>
                    <span class="fs-4 text-center"><?php echo ucwords(str_replace("_", " ", $slogan)); ?></span>

                </div>
                <span class="ms-2 imgCover d-inline-block ">
                    <img src="<?php echo "$this->images_url/country/$country.jpeg"; ?>" alt="" width="60" height="60">
                </span>
            </h2>

            <p class="text-center fs-5">Hover your mouse / tap on a service to see more options. The <i
                    class="fa-regular fa-eye text-primary"></i> for visibility, <i
                    class="fa-solid fa-plus text-primary"></i> to add service type and <i
                    class="fa-solid fa-list-check text-primary"></i> to view service type.</p>

        </div>
    </div>

    <div class="row g-md-2 d-flex justify-content-center serviceRow">
        <div class="col-12 p-2">
            <?php do_action("vtupress_notices");?>
        </div>
        <div
            class="allServicesdiv d-none createNewService my-2 py-4 py-md-1 my-md-1 bg-white col-12 col-md-3  me-2 d-flex align-items-center flex-column justify-content-center">

            <div class="createService py-2 px-3 ">

                <div class="d-flex d-flex justify-content-center align-items-center ">
                    <div class="topservicesect d-flex flex-column justify-content-center align-items-center ">
                        <span class=" my-2 my-md-1 d-inline-block "><i
                                class="fs-3 fa-solid fa-plus text-info fw-bold"></i></span>
                        <span class="service_name fw-bold fs-3 text-success text-center">Add Service Menu</span>
                    </div>
                </div>

            </div>
        </div>

        <?php

        foreach ($services as $service => $value):
            // $value->boot();
            $settings = $value->get_settings(false);
            $service_types = $settings["service_types"] ?? [];
            $public_name = $value->name;
            $id = str_replace("_", "", $value->id);
            $status = Vtupress_option::get('vtupress_service_' . $value->id."_{$this->country}" . '_status');

            if (!empty($value->custom_id)) {
                if ($this->get_option($value->custom_id) != "yes") {
                    continue;
                }
            }



            ?>


            <div
                class="allServicesdiv my-2 my-md-1 bg-white col-12 col-md-3  me-2 d-flex align-items-center flex-column justify-content-center">

                <div class="mainService py-2 px-3 ">

                    <div
                        class="d-flex service_<?php echo strtolower($value->name); ?>_left d-flex justify-content-center align-items-center ">
                        <div class="topservicesect d-flex flex-column justify-content-center align-items-center ">
                            <span class="imgCover d-inline-block "><img
                                    src="<?php echo get_images($value->name, "service"); ?>" alt="" width="80"
                                    height="80"></span>
                            <span
                                class="service_name fw-bold fs-3 text-center"><?php echo ucwords(str_replace("_", " ", $value->name)); ?></span>
                        </div>
                    </div>

                    <div class="mouseOverDiv justify-content-center align-items-center position-absolute "
                        service_name="<?php echo strtolower($public_name); ?>"
                        id="<?php echo strtolower($id); ?>">

                        <div class="closeDiv d-none d-flex justify-content-between py-2 px-4 w-100 position-absolute">
                            <?php echo ($status == "on") ? '<i class="fs-3 fa-solid fa-earth-africa text-success"></i>' : '<i class="fs-3 fa-solid fa-earth-africa text-danger"></i>'; ?>
                            <!-- <i class="text-danger deleteService  fs-4  fa-regular fa-circle-xmark"></i> -->
                        </div>

                        <div class="statusicons d-flex fw-bold fs-2">
                            <?php if($status == "on"):?> 
                                <i class="fa-regular fa-eye mx-2 text-success changeStatus" changeTo="off" service_nonce="<?php echo $value->nonce;?>" service_name="<?php echo $value->name; ?>"></i>
                            <?php else : ?> 
                                <i class="text-danger fa-regular fa-eye-slash changeStatus" changeTo="on" service_nonce="<?php echo $value->nonce;?>" service_name="<?php echo $value->name; ?>"></i>
                            <?php endif;?>


                            <i class="fa-solid fa-plus mx-2 addServiceType"
                                    service_nonce="<?php echo $value->nonce;?>"
                                    service_id="<?php echo $value->id; ?>"
                                    service_name="<?php echo $value->name; ?>"
                                    service_types=<?php echo json_encode($service_types);?>></i>

                            <?php if ($service_types && !empty($service_types)) { ?>
                                <i class="fa-solid fa-list-check mx-2 seeServiceTypes"
                                    service_nonce="<?php echo $value->nonce;?>"
                                    service_id="<?php echo $value->id; ?>"
                                    service_name="<?php echo $value->name; ?>"
                                    service_types=<?php echo json_encode($service_types);?>></i>
                            <?php } else {?>
                               <i class="fas fa-chevron-right text-primary mx-2" goto="?page=vtupanel&adminpage=gateway&service=<?php echo $value->id;?>"></i>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>


            <?php
        endforeach;
        ?>

    </div>


</div>

<div class="position-absolute service-pop-up  justify-content-center p-2 p-md-4">

    <div class="main-content-div col p-2 p-md-3 bg-white shadow rounded">
        <div class="close-btn d-flex justify-content-end">
            <i class="fa-solid fa-times text-danger fs-3 close-create-service"></i>
        </div>

        <div class="d-flex flex-column align-items-center">
            <span class="fs-6">New Service Details</span>
            <span class="fs-4">Create with caution <i class="fa-solid fa-triangle-exclamation text-warning"></i></span>
        </div>

        <div class="container-fluid container-md mt-3">
            <div class="row servicesForm">
                <div class="col-12 col-md-3 ">
                    <div class="form-group">
                        <label for="serviceName">Service Name <b class="text-danger">*</b></label>
                        <input type="text" name="create_name" class="form-control" id="serviceName"
                            aria-describedby="serviceName" placeholder="Enter Service Name" required>
                    </div>
                </div>
                <div class="col-12 col-md-3">
                    <div class="form-group">
                        <label for="description">Description <b class="text-danger">*</b></label>
                        <input type="text" name="create_description" class="form-control" id="sdescription"
                            aria-describedby="description" placeholder="Description" required>
                    </div>
                </div>
                <div class="col-12 col-md-3 d-none">
                    <div class="form-group">
                        <label for="option_name">Option Name <b class="text-danger">*</b></label>
                        <input type="text" name="create_option_name" class="form-control" id="optionName"
                            aria-describedby="optionName" placeholder="Enter Option Name" disabled required>
                        <small>This can be thesame name as Service Name</small>
                    </div>
                </div>
                <div class="col-12 col-md-3 d-none">
                    <div class="form-group">
                        <label for="generic_name">Generic Name <b class="text-danger">*</b></label>
                        <input type="text" name="create_generic_name" class="form-control" id="genericName"
                            aria-describedby="genericName" placeholder="Generic Name" disabled required>
                        <small>Combination of the name and the country ISO code e.g servicename_countrycode</small>
                    </div>
                </div>
                <div class="col-12 col-md-3">
                    <div class="form-group">
                        <label for="icon">Icon <b class="text-danger">*</b></label>
                        <input type="text" name="create_icon" class="form-control" id="icon" aria-describedby="icon"
                            placeholder="Fontawesome icon" value="fa-solid fa-list-ul" required>
                        <small>Fontawesome icon e.g fa-solid fa-list-ul</small>
                    </div>
                </div>
                <div class="col-12 col-md-3 d-none">
                    <div class="form-group">
                        <label for="country">Country <b class="text-danger">*</b></label>
                        <input type="text" name="create_country" class="form-control" id="country"
                            aria-describedby="country" placeholder="country" value="<?php echo $iso; ?>" disabled
                            required>
                    </div>
                </div>
                <div class="col-12 col-md-3">
                    <div class="form-group">
                        <label for="file_url">Url <b class="text-danger">*</b></label>
                        <input type="text" name="create_file_url" class="form-control" id="file_url"
                            aria-describedby="file_url" placeholder="File Url" required>
                        <small>Url end to this service (frontend)</small>
                    </div>
                </div>
                <div class="col-12 col-md-3">
                    <div class="form-group">
                        <label for="image">Image</label>
                        <input type="text" name="create_image" class="form-control" id="image" aria-describedby="image"
                            placeholder="Service Image">
                        <small>Url to the service image</small>
                    </div>
                </div>
                <div class="col-12 col-md-3">
                    <div class="form-group">
                        <label for="listOrder">Listing Order <b class="text-danger">*</b></label>
                        <input type="number" name="create_listOrder" class="form-control" id="listOrder"
                            aria-describedby="listOrder" placeholder="List Order" required>
                        <small>Listing order of the service</small>
                    </div>
                </div>
                <div class="col-12 col-md-3">
                    <div class="form-group">
                        <label for="plan">Available for what user package? <b class="text-danger">*</b></label>
                        <select name="create_plan" id="plan" class="form-control" required>
                            <option value="all" selected>All</option>
                        </select>
                    </div>
                </div>
                <div class="col-12 col-md-3">
                    <div class="form-group">
                        <label for="status">Available Now (Status) <b class="text-danger">*</b></label>
                        <select name="create_status" id="status" class="form-control" required>
                            <option value="off">Off</option>
                            <option value="on">On</option>
                        </select>
                    </div>
                </div>
                <div class="col-12 d-flex justify-content-end my-2">
                    <button type="submit" class="btn btn-primary rounded create_new_service">Create Service</button>
                </div>



            </div>
        </div>

    </div>

</div>

<div class="position-absolute service-pop-up2  justify-content-center p-2 p-md-4">

    <div class="main-content-div col p-2 p-md-3 bg-white shadow rounded">
        <div class="close-btn d-flex justify-content-end">
            <i class="fa-solid fa-times text-danger fs-3 close-create-service-type"></i>
        </div>

        <div class="d-flex flex-column align-items-center">
            <span class="fs-6 service_name text-uppercase"></span>
            <span class="fs-4">New Service Type</span>
        </div>

        <div class="container-fluid container-md mt-3">
            <div class="row serviceTypeForm">
                <div class="col-12 col-md-3 w-100 d-flex justify-content-center align-items-center">
                    <div class="form-group my-2">
                        <label for="serviceName">Service Type Name <b class="text-danger">*</b></label>
                        <input type="text" name="border border-secondary create_service_name" class="form-control service_type_name" id="serviceName"
                            aria-describedby="serviceName" placeholder="" required>
                    </div>
                </div>
                <div class="col-12 d-flex justify-content-end my-2">
                    <button type="submit" class="btn btn-primary rounded create_new_service_type">Create
                        ServiceType</button>
                </div>



            </div>
        </div>

    </div>

</div>

<div class="position-absolute service-pop-up3  justify-content-center p-2 p-md-4">

    <div class="main-content-div col p-2 p-md-3 bg-white shadow rounded">
        <div class="close-btn d-flex justify-content-end">
            <i class="fa-solid fa-times text-danger fs-3 close-service-type"></i>
        </div>

        <div class="d-flex flex-column align-items-center">
            <span class="fs-6 service_name text-uppercase"></span>
            <!-- <span class="fs-4">Handle with caution <i class="fa-solid fa-triangle-exclamation text-warning"></i></span> -->
            <span class="fs-4">Service Type</span>
        </div>

        <div class="container-fluid container-md mt-3">
            <div class="row allServiceTypes d-flex justify-content-center align-items-center p-2">
                <div class="spinner-border text-primary" role="status">
                    <span class="sr-only">Loading...</span>
                </div>
            </div>
        </div>

    </div>

</div>



<script>

    function postAndReload(url, data) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = url;

    for (const key in data) {
        if (Array.isArray(data[key])) {
            data[key].forEach(val => {
                const input = document.createElement('input');
                input.type  = 'hidden';
                input.name  = key + '[]';
                input.value = val;
                form.appendChild(input);
            });
        } else {
            const input = document.createElement('input');
            input.type  = 'hidden';
            input.name  = key;
            input.value = data[key];
            form.appendChild(input);
        }
    }

    document.body.appendChild(form);
    form.submit();
}


    var serviceToDelete = "";
    var sucessFullMessage = "Done!";
    var loadedServiceTypes = [];
    var nonce = "";

    // see service types
    jQuery(document).on("click", ".seeServiceTypes", function () {

        // reset per service
        loadedServiceTypes = [];
        nonce = jQuery(this).attr("service_nonce");
        var myserviceId  = jQuery(this).attr("service_id").toLowerCase();
        var myserviceName  = jQuery(this).attr("service_name").toLowerCase();
        var myserviceTypes = jQuery(this).attr("service_types");

        var initialContents = `
            <div class="spinner-border text-primary" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        `;

        jQuery(".allServiceTypes").html(initialContents);
        jQuery(".service-pop-up3").css("display", "flex");
        jQuery(".service-pop-up3 .service_name").text(myserviceName.toUpperCase());

        jQuery('.service-pop-up3').animate({ opacity: 1 }, 400);
        jQuery('html, body').animate({ scrollTop: 0 }, 600);

        // ---- SAFE JSON PARSE ----
        let data = [];
        try {
            data = JSON.parse(myserviceTypes);
        } catch (e) {
            console.error("Invalid service_types JSON", myserviceTypes);
            jQuery(".allServiceTypes").html("<p class='text-danger'>Invalid service types</p>");
            return;
        }

        var temps = '';

        data.forEach(item => {
            item = item.toLowerCase();
            loadedServiceTypes.push(item);

            temps += `
                <div class="col-4 my-2 col-md-3 d-flex justify-content-center service-type-item" data-stype="${item}">
                    <span class="fs-3 cursor-pointer fw-bold rounded shadow p-3 position-relative"
                        goto="?page=vtupanel&adminpage=gateway&service=${myserviceId}&service_type=${item}">
                        ${item.toUpperCase()}
                    </span>

                    <i class="cursor-pointer text-danger deleteServiceType fs-4 fa-regular fa-circle-xmark"
                    sname="${myserviceName}"
                    sid="${myserviceId}"
                    stype="${item}"
                    style="transform: translate(-11px, -5px);"></i>
                </div>
            `;
        });

        jQuery(".allServiceTypes").html(temps);
    });

    // ---- DELETE SERVICE TYPE ----
    jQuery(document).on('click', '.deleteServiceType', function () {

        var stype = jQuery(this).attr('stype').toLowerCase();
        var sname = jQuery(this).attr('sname');
        var sid = jQuery(this).attr('sid');

        if (!loadedServiceTypes.includes(stype)) {
            return;
        }

        if (!confirm(`Remove ${stype.toUpperCase()} from ${sname.toUpperCase()}?`)) {
            return;
        }

        // remove from array
        loadedServiceTypes = loadedServiceTypes.filter(t => t !== stype);

        // remove from UI
        jQuery(this).closest('.service-type-item').fadeOut(200, function () {
            jQuery(this).remove();
        });

        // ---- PREPARE POST PAYLOAD ----

        postAndReload(window.location.href,{
            // vtupress_service_save: 'vtupress_remove_service_type',
            service_name: sname,
            set_service_types: true,
            service_types: loadedServiceTypes,
            _wpnonce: nonce
        });
        
    });

    // Create new service type
    jQuery(".addServiceType").click(function () {
        
        // reset per service
        loadedServiceTypes = [];
        nonce = jQuery(this).attr("service_nonce");
        var myserviceId  = jQuery(this).attr("service_id").toLowerCase();
        var myserviceName  = jQuery(this).attr("service_name").toLowerCase();
        var myserviceTypes = jQuery(this).attr("service_types");

         let data = [];

        jQuery(".service-pop-up2 .service_name").text(myserviceName);
        jQuery(".service-pop-up2").css("display", "flex");
        jQuery('.service-pop-up2').animate(
            { opacity: 1 },
            400, function () {
                jQuery(this).css('display', 'flex'); // After fading out, set display back to none
            });

            if(myserviceTypes.length >= 1){
                    try {
                        data = JSON.parse(myserviceTypes);
                    } catch (e) {
                        console.error("Invalid service_types JSON", myserviceTypes);
                        jQuery(".serviceTypeForm").html("<p class='text-danger'>Invalid service types. please refresh or contact your developer</p>");
                        return;
                    }

                    data.forEach(item => {
                        item = item.toLowerCase();
                        loadedServiceTypes.push(item);
                    });
            }

        jQuery('html, body').animate({
            scrollTop: 0
        }, 600);
    });

    // ---- Create service type
    jQuery(".create_new_service_type").click(function (event) {
        var obj = {};
        var service_name = jQuery(".service_type_name").val().trim();
        var pat = /^[a-z0-9_]+$/;
        if(!pat.test(service_name)){
            showToast("only small lettered alphanumerical name with _ representing space(optional) is allowed","red",2000);
            return;
        }

        loadedServiceTypes.push(service_name);

       postAndReload(window.location.href,{
            set_service_types: true,
            service_types: loadedServiceTypes,
            _wpnonce: nonce
        });

    });

        //change service status
    jQuery(".changeStatus").click(function () {
        nonce = jQuery(this).attr("service_nonce");
        var myserviceName  = jQuery(this).attr("service_name").toLowerCase();
        var statusTo = jQuery(this).attr("changeTo");
        if(!confirm(`Are you sure you want to turn ${statusTo} ${myserviceName} service?`)){
            return;
        }
        postAndReload(window.location.href,{
            custom_service_status: statusTo,
            _wpnonce: nonce
        });
    });

    function createServiceSuccessfully(response) {

        if (response != "100") {
            showToast(response, "red", 2000);
            return;
        }

        showToast(sucessFullMessage, "green", 2000);

        //reload after 1 secs
        setTimeout(function () {
            window.location.reload();
        }, 1000);

    }

    function deleteServiceSuccessfully(response) {

        if (response != "100") {
            showToast(response, "red", 2000);
            return;
        }

        showToast("Service deleted successfully", "green", 2000);

        jQuery("[generic_name='" + serviceToDelete + "']").animate({ opacity: 0 }, 2000, function () {
            jQuery(this).parents(".allServicesdiv").remove();
        });
    }

    function changeStatusSuccessfully(response) {
        if (response != "100") {
            showToast(response, "red", 2000);
            return;
        }

        showToast("Status changed successfully", "green", 2000);

        //reload after 1 secs
        setTimeout(function () {
            window.location.reload();
        }, 1000);
    }


    // Close service type popup
    jQuery(".close-create-service-type").click(function () {
        jQuery('.service-pop-up2').animate(
            { opacity: 0 },
            400, function () {
                jQuery(this).css('display', 'none'); // After fading out, set display back to none
            });
        //jQuery(".service-pop-up2").css("display","none");
    });

    // Close all service type popup
    jQuery(".close-service-type").click(function () {
        jQuery('.service-pop-up3').animate(
            { opacity: 0 },
            400, function () {
                jQuery(this).css('display', 'none'); // After fading out, set display back to none
            });
        //jQuery(".service-pop-up2").css("display","none");
    });


    // Create new service
    jQuery(".createNewService").click(function () {
        jQuery(".service-pop-up").css("display", "flex");
        jQuery('.service-pop-up').animate(
            { opacity: 1 },
            400, function () {
                jQuery(this).css('display', 'flex'); // After fading out, set display back to none
            });

        jQuery('html, body').animate({
            scrollTop: 0
        }, 600);
    });



    //On servcie name change/input
    jQuery(".service-pop-up #serviceName").on("input", function () {
        jQuery(this).val(jQuery(this).val().toLowerCase());
        var serviceName = jQuery(this).val();
        var pat = /^[a-z_*]+$/;
        var alphaNumerical = serviceName.match(pat);

        if (serviceName == "") {
            jQuery(".service-pop-up #genericName").val("");
            jQuery(".service-pop-up #optionName").val("");
            return;
        }

        else if (!alphaNumerical && serviceName.length > 2) {
            showToast("Service Name must be in small letters only or use _ inplace of spaces", "red", 2000);
            jQuery(this).val("");
            return;
        }



        var genericName = serviceName + "_" + jQuery("#country").val();

        jQuery(".service-pop-up #genericName").val(genericName.replace(" ", "_").toLowerCase());
        jQuery(".service-pop-up #optionName").val(serviceName.toLowerCase());
    });

    //On servcie types name change/input
    jQuery(".service-pop-up2 #serviceTypeName").on("input", function () {
        jQuery(this).val(jQuery(this).val().toLowerCase());
        var serviceName = jQuery(this).val();
        var pat = /^[a-z\s*\d*]+$/;
        var alphaNumerical = serviceName.match(pat);

        if (serviceName == "") {
            jQuery(".service-pop-up2 #optionName").val("");
            return;
        }

        else if (!alphaNumerical && serviceName.length > 2) {
            showToast("Service Name must be in small letters only", "red", 2000);
            jQuery(this).val("");
            return;
        }

        jQuery(".service-pop-up2 #optionName").val(serviceName.toLowerCase());
    });

    //delete div
    jQuery(".deleteService").click(function () {
        var serviceName = jQuery(this).parents("[service_name]").attr("service_name");
        var genericName = jQuery(this).parents("[generic_name]").attr("generic_name");
        serviceToDelete = genericName;
        var obj = {};
        obj["service_action"] = "delete";
        obj["service_name"] = serviceName;
        obj["admin_save"] = "gateway_service_manager";

        doAjax(vtupressInitPluginData.ajax_url, obj, 'post', deleteServiceSuccessfully);


    });

    //create service
    jQuery(".create_new_service").click(function (event) {
        var obj = {};
        var name = "";
        var value = "";
        var inputHasProblem = false;
        var checkFormInputs = jQuery(".servicesForm input, .servicesForm select ");

        checkFormInputs.each(function (index, value) {
            name = "";
            value = "";
            if (jQuery(this).attr('required') == "required" && jQuery(this).val() == "") {
                inputHasProblem = true;
                showToast(jQuery(this).attr('placeholder') + " is required", "red", 2000);
                return false;
            }

            name = jQuery(this).attr('name');
            value = jQuery(this).val();

            obj[name] = value;
        });

        if (inputHasProblem) {
            // event.preventDefault();
            return false;
        }


        sucessFullMessage = obj['create_name'] + " created successfully!";


        obj["service_action"] = "create";
        obj["admin_save"] = "gateway_service_manager";

        //console.log(obj);

        doAjax(vtupressInitPluginData.ajax_url, obj, 'post', createServiceSuccessfully);

    });




</script>