<?php

if (!defined('ABSPATH'))
  exit;

if (current_user_can("vtupress_access_history")) {

  if (isset($_GET["custom"])):
    //transaction webhook, wallet webhook, unrecorded

    return;
  endif;
  ?>

  <div class="container-fluid history-container">
    <!-- <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700" rel="stylesheet"> -->
    <!-- Load Material Design Icons -->
    <!-- <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.4.47/css/materialdesignicons.min.css" rel="stylesheet"> -->

    <style>
      .history-container * {
        font-family: 'Roboto', sans-serif;
      }

      /* Glassmorphism Styling */
      .vtupress-summary {
        padding: 20px 0;
      }

      .vtupress-glass {
        background: rgba(255, 255, 255, 0.7);
        backdrop-filter: blur(10px);
        -webkit-backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.3);
        border-radius: 15px;
        padding: 20px;
        transition: all 0.3s ease;
        box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.07);
        display: flex;
        align-items: center;
        height: 100%;
      }

      .vtupress-glass:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 40px 0 rgba(31, 38, 135, 0.12);
        background: rgba(255, 255, 255, 0.85);
      }

      .glass-icon {
        width: 50px;
        height: 50px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 15px;
        font-size: 1.6rem;
        /* Slightly larger for MDI */
      }

      .glass-content h6 {
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-weight: 600;
        margin-bottom: 5px;
        color: #6c757d;
      }

      .glass-content h3 {
        margin: 0;
        font-weight: 700;
        color: #2d3436;
      }

      /* Status Specific Accents */
      .glass-pending .glass-icon {
        background: rgba(255, 193, 7, 0.15);
        color: #ffc107;
      }

      .glass-success .glass-icon {
        background: rgba(40, 167, 69, 0.15);
        color: #28a745;
      }

      .glass-failed .glass-icon {
        background: rgba(220, 53, 69, 0.15);
        color: #dc3545;
      }

      .glass-amount .glass-icon {
        background: rgba(0, 123, 255, 0.15);
        color: #007bff;
      }

      .swal-button.swal-button--confirm {
        width: fit-content;
        padding: 10px !important;
      }

      #vtupress-history {
        background: white;
        border-radius: 10px;
        overflow: hidden;
        border: none;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
      }

      #vtupress-history thead th {
        background-color: #f8f9fa;
        border-bottom: 2px solid #dee2e6;
        color: #495057;
        font-weight: 600;
      }
    </style>

    <div class="row">
      <div class="col">

        <?php
        $service_key = $_GET['subpage'] ?? null;
        $service = $service_key ? Vtupress_Service_Container::get($service_key) : null;

        if ($service_key === 'wallet') {
          include_once __DIR__ . '/wallet-history.php';
          return;
        }
        if ($service_key === 'wallet-webhook') {
          include_once __DIR__ . '/wallet-webhook.php';
          return;
        }

        if ($service == null):
          ?>
          <div class="alert alert-danger">Service Not Found</div>
          <?php return;
        endif;

        $transactions = $wpdb->get_results(
          $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}vtupress_transactions WHERE service = %s ORDER BY id DESC",
            $service_key ?: ''
          ),
          ARRAY_A
        );

        $summary = [
          'pending' => 0,
          'successful' => 0,
          'failed' => 0,
          'success_amount' => 0.00,
          'profit' => 0.00
        ];

        foreach ($transactions as $txn) {
          $status = strtolower($txn['status'] ?? '');
          if ($status === 'pending')
            $summary['pending']++;
          if ($status === 'success') {
            $summary['successful']++;
            $summary['success_amount'] += (float) ($txn['amount'] ?? 0);
            $summary['profit'] += (float) ($txn['profit'] ?? 0);
          }
          if (in_array($status, ['failed', 'cancled']))
            $summary['failed']++;
        }

        $base_columns = $service->base_history_columns();
        $extra_columns = (method_exists($service, 'history_columns')) ? $service->history_columns() : [];
        ?>

        <div class="row mb-4 vtupress-summary">
          <!-- Pending Card -->
          <div class="col-xl-3 col-md-6 mb-4">
            <div class="vtupress-glass glass-pending">
              <div class="glass-icon">
                <i class="mdi mdi-clock-outline"></i>
              </div>
              <div class="glass-content">
                <h6>Pending</h6>
                <h3><?= number_format($summary['pending']) ?></h3>
              </div>
            </div>
          </div>

          <!-- Success Card -->
          <div class="col-xl-3 col-md-6 mb-4">
            <div class="vtupress-glass glass-success">
              <div class="glass-icon">
                <i class="mdi mdi-check-decagram-outline"></i>
              </div>
              <div class="glass-content">
                <h6>Successful</h6>
                <h3><?= number_format($summary['successful']) ?></h3>
              </div>
            </div>
          </div>

          <!-- Failed Card -->
          <div class="col-xl-3 col-md-6 mb-4">
            <div class="vtupress-glass glass-failed">
              <div class="glass-icon">
                <i class="mdi mdi-close-octagon-outline"></i>
              </div>
              <div class="glass-content">
                <h6>Failed</h6>
                <h3><?= number_format($summary['failed']) ?></h3>
              </div>
            </div>
          </div>

          <!-- Amount Card -->
          <div class="col-xl-3 col-md-6 mb-4">
            <div class="vtupress-glass glass-amount">
              <div class="glass-icon">
                <i class="mdi mdi-currency-ngn"></i>
              </div>
              <div class="glass-content">
                <h6>Total Success</h6>
                <h3>₦<?= number_format($summary['success_amount'], 2) ?></h3>
                <div class="small text-muted mt-1" style="font-size: 0.75rem;">
                   Profit : ₦<?= number_format($summary['profit'], 2) ?>
                </div>
              </div>
            </div>
          </div>
        </div>

        <?php if (empty($transactions)): ?>
          <div class="alert alert-info">No Transaction for this service</div>
          <?php return;
        endif; ?>

        <div class="table-responsive">
          <table id="vtupress-history" class="table table-hover">
            <thead>
              <tr>
                <?php foreach ($base_columns as $label): ?>
                  <th><?= esc_html($label) ?></th>
                <?php endforeach; ?>
                <?php foreach ($extra_columns as $label): ?>
                  <th><?= esc_html($label) ?></th>
                <?php endforeach; ?>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($transactions as $txn): ?>
                <tr data-id="<?= esc_attr($txn['id']) ?>" class="history-row" style="cursor: pointer;">
                  <?php foreach (array_keys($base_columns) as $key): ?>
                    <td><?= esc_html($txn[$key] ?? '-') ?></td>
                  <?php endforeach; ?>
                  <?php foreach (array_keys($extra_columns) as $col): ?>
                    <td>
                      <?= ($service && method_exists($service, 'resolve_history_column'))
                        ? esc_html($service->resolve_history_column($col, (array) $txn))
                        : '-' ?>
                    </td>
                  <?php endforeach; ?>
                  <!-- <td>
                    <?php if ($service && $service instanceof Vtupress_Refundable_Interface && $service->can_refund((array) $txn)): ?>
                      <button class="btn btn-sm btn-outline-warning">
                        <i class="mdi mdi-undo-variant"></i> Refund
                      </button>
                    <?php endif; ?>
                  </td> -->
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

        <script>
          jQuery(function ($) {
            if ($.fn.DataTable) {
              $('#vtupress-history').DataTable({
                pageLength: 25,
                order: [[0, 'desc']],
                responsive: true,
                language: {
                  search: "_INPUT_",
                  searchPlaceholder: "Search records..."
                }
              });
            }

            // Custom Manual Tab Logic
            function activateTab(tabId) {
              $('#receiptTabs .nav-link').removeClass('active').attr('aria-selected', 'false');

              // robustly find the link
              var link = $('#receiptTabs .nav-link[href="' + tabId + '"]');
              if (!link.length) {
                // Try finding via control ID
                var idWithoutHash = tabId.replace('#', '');
                link = $('#receiptTabs .nav-link[aria-controls="' + idWithoutHash + '"]');
              }

              link.addClass('active').attr('aria-selected', 'true');

              $('#receiptTabsContent .tab-pane').removeClass('show active');
              $(tabId).addClass('show active');
            }

            // Click handler for manual tabs
            $('#receiptTabs').on('click', '.nav-link', function (e) {
              e.preventDefault();
              var target = $(this).attr('href');
              activateTab(target);
            });

            // Manual Modal Close Logic (Bypassing potentially broken Bootstrap)
            $(document).on('click', '[data-dismiss="modal"], .modal-backdrop', function (e) {
              // Force manual close
              $('#transactionModal').removeClass('show').css('display', 'none').attr('aria-hidden', 'true').removeAttr('aria-modal');
              $('.modal-backdrop').remove();
              $('body').removeClass('modal-open');
            });

            // Modal Logic
            $('.history-row').on('click', function () {
              var id = $(this).data('id');
              // Use window.jQuery to ensure we get the instance that (hopefully) has Bootstrap attached
              var modal = window.jQuery('#transactionModal');

              // Reset Modal
              $('#receipt-loader').show();
              $('#receipt-data').hide();
              $('#modal-basic').empty();
              $('#modal-details').empty();
              $('#modal-response').empty();

              // Reset Tabs to first tab manually
              activateTab('#tab-basic');

              // Manual Show Logic
              $('#transactionModal').addClass('show').css('display', 'block').removeAttr('aria-hidden').attr('aria-modal', 'true');
              $('body').addClass('modal-open');
              if ($('.modal-backdrop').length === 0) {
                $('body').append('<div class="modal-backdrop fade show"></div>');
              }


              // Fetch Data
              var ajax_url = (typeof vtupressInitPluginData !== 'undefined') ? vtupressInitPluginData.ajax_url : (typeof ajaxurl !== 'undefined' ? ajaxurl : 'admin-ajax.php');

              $.post(ajax_url, {
                action: 'vtupress_history_details',
                id: id
              }, function (response) {
                if (response.success) {
                  var data = response.data;
                  var basic = data.basic;
                  var details = data.details;
                  var apiResponse = data.response;

                  // 1. Header
                  $('.receipt-amount').text('₦' + parseFloat(basic.Amount).toLocaleString());
                  $('.receipt-date').text(basic.Date);
                  var status = basic.Status.toLowerCase();
                  var iconClass = (status === 'success' || status === 'successful') ? 'mdi-check-circle text-success' :
                    (status === 'failed' || status === 'cancelled' ? 'mdi-close-circle text-danger' : 'mdi-clock-outline text-warning');
                  $('.receipt-status-icon i').attr('class', 'mdi ' + iconClass);

                  // 2. Basic Section
                  $.each(basic, function (k, v) {
                    $('#modal-basic').append(`
                                <div class="receipt-item">
                                    <span class="key">${k}</span>
                                    <span class="value">${v}</span>
                                </div>
                            `);
                  });

                  // 3. Details Section
                  if (details && Object.keys(details).length > 0) {
                    $.each(details, function (k, v) {
                      var valDisplay = (typeof v === 'object') ? JSON.stringify(v) : v;
                      $('#modal-details').append(`
                                    <div class="receipt-item">
                                        <span class="key">${k}</span>
                                        <span class="value">${valDisplay}</span>
                                    </div>
                                `);
                    });
                  } else {
                    $('#modal-details').html('<div class="text-muted text-center italic">No additional details</div>');
                  }

                  // 4. Response Section
                  var responseText = (apiResponse !== null) ? apiResponse : '';
                  var isJson = true;
                  if (typeof responseText !== 'string') {
                    responseText = JSON.stringify(responseText, null, 2);
                  } else {
                    try {
                      var parsed = JSON.parse(responseText);
                      responseText = JSON.stringify(parsed, null, 2);
                    } catch (e) {
                      isJson = false;
                    }
                  }

                  if (!isJson && responseText.length > 100) {
                    responseText = responseText.substring(0, 100) + '...';
                  }

                  $('#modal-response').text(responseText);


                  $('#receipt-loader').hide();
                  $('#receipt-data').fadeIn();

                } else {
                  $('#receipt-loader').hide();
                  modal.modal('hide');
                  alert(response.data.message || 'Error loading details');
                }
              }).fail(function () {
                $('#receipt-loader').hide();
                modal.modal('hide');
                alert('Network error');
              });
            });


                
          $('.downloadHistory').on('click', function () {
            var element = document.querySelector(".receipt-content");
            var btn = jQuery(this);
            var originalText = btn.text();
            
            var recipient = '<?= $service_key;?>-'+jQuery(".recipient .value").text() || '';
            btn.text('Downloading...');
            
            var opt = {
              margin: 10,
              filename: recipient + '.pdf',
              image: { type: 'jpeg', quality: 0.98 },
              html2canvas: { scale: 2, logging: true, useCORS: true },
              jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
            };

            html2pdf().set(opt).from(element).save().then(function(){
              btn.text(originalText);
            });
          });
          });
        </script>

        <!-- Receipt Modal -->
        <div class="modal fade" id="transactionModal" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content receipt-content">
              <div class="modal-header border-0 pb-0">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body pt-0">
                <div id="receipt-loader" class="text-center py-5">
                  <div class="spinner-border text-primary" role="status">
                    <span class="sr-only">Loading...</span>
                  </div>
                </div>

                <div id="receipt-data" style="display:none;">

                   <div class="d-flex justify-content-between align-items-center border-bottom pb-3 mb-3">
                        <div class="d-flex align-items-center">
                            <?php 
                            $icon_url = get_site_icon_url();
                            if($icon_url): ?>
                                <img src="<?= esc_url($icon_url) ?>" alt="Site Logo" style="width: 40px; height: 40px; margin-right: 10px; border-radius: 50%;">
                            <?php else: ?>
                                <span style="font-size: 2rem; margin-right: 10px;">🧾</span>
                            <?php endif; ?>
                            <h5 class="mb-0 font-weight-bold"><?= get_bloginfo('name'); ?></h5>
                        </div>
                        <div class="text-right">
                             <small class="text-muted d-block">Receipt</small>
                             
                        </div>
                    </div>

                  <div class="text-center mb-4">
                    <h4 class="modal-title font-weight-bold">Transaction Receipt</h4>
                    <p class="text-muted receipt-date">-</p>
                    <div class="receipt-status-icon my-3">
                      <i class="mdi mdi-check-circle text-success" style="font-size: 4rem;"></i>
                    </div>
                    <h2 class="receipt-amount font-weight-bold">₦0.00</h2>
                  </div>

                  <!-- Nav tabs -->
                  <ul data-html2canvas-ignore="true" class="nav nav-tabs mb-3" id="receiptTabs" role="tablist">
                    <li class="nav-item">
                      <a class="nav-link active" id="basic-tab" data-toggle="tab" href="#tab-basic" role="tab"
                        aria-controls="tab-basic" aria-selected="true">
                        <i class="mdi mdi-information-outline"></i> Basic Details
                      </a>
                    </li>
                    <li class="nav-item" >
                      <a class="nav-link" id="payload-tab" data-toggle="tab" href="#tab-payload" role="tab"
                        aria-controls="tab-payload" aria-selected="false">
                        <i class="mdi mdi-code-json"></i> Payload
                      </a>
                    </li>
                    <li class="nav-item">
                      <a class="nav-link" id="response-tab" data-toggle="tab" href="#tab-response" role="tab"
                        aria-controls="tab-response" aria-selected="false">
                        <i class="mdi mdi-api"></i> Response
                      </a>
                    </li>
                  </ul>

                  <!-- Tab panes -->
                  <div class="tab-content" id="receiptTabsContent">
                    <div class="tab-pane fade show active" id="tab-basic" role="tabpanel" aria-labelledby="basic-tab">
                      <div class="receipt-list" id="modal-basic">
                        <!-- Populated by JS -->
                      </div>
                    </div>
                    <div class="tab-pane fade" id="tab-payload" role="tabpanel" aria-labelledby="payload-tab">
                      <div class="receipt-list" id="modal-details">
                        <!-- Populated by JS -->
                      </div>
                    </div>
                    <div class="tab-pane fade" id="tab-response" role="tabpanel" aria-labelledby="response-tab">
                      <div class="p-3 bg-light rounded">
                        <code id="modal-response"
                          style="white-space: pre-wrap; word-break: break-all; color: #d63384;"></code>
                      </div>
                    </div>
                  </div>

                  <div class="mt-4 text-center border-top pt-3">
                        <small class="text-muted">Receipt generated from <?= get_bloginfo('name'); ?></small>
                  </div>
                </div>
              </div>
              <div class="modal-footer border-0 justify-content-center"  data-html2canvas-ignore="true">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary downloadHistory" >Download</button>
              </div>
            </div>
          </div>
        </div>

        <style>
          .receipt-content {
            border-radius: 15px;
            border: none;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            overflow: hidden;
          }

          /* Tab Styling */
          .nav-tabs {
            border-bottom: 2px solid #f1f3f5;
          }

          .nav-tabs .nav-link {
            border: none;
            color: #6c757d;
            font-weight: 500;
            padding: 12px 20px;
            transition: all 0.2s;
          }

          .nav-tabs .nav-link:hover {
            color: #495057;
            background: #f8f9fa;
          }

          .nav-tabs .nav-link.active {
            color: #0d6efd;
            border-bottom: 2px solid #0d6efd;
            background: transparent;
          }

          .nav-tabs .nav-link i {
            margin-right: 5px;
            font-size: 1.1em;
            vertical-align: middle;
          }

          /* Content Styling */
          .receipt-list .receipt-item {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            padding: 8px 0;
            border-bottom: 1px dashed #e9ecef;
          }

          .receipt-list .receipt-item:last-child {
            border-bottom: none;
          }

          .receipt-item .key {
            color: #6c757d;
            font-weight: 500;
            font-size: 0.9rem;
            flex-shrink: 0;
            margin-right: 15px;
          }

          .receipt-item .value {
            color: #212529;
            font-weight: 600;
            text-align: right;
            font-size: 0.9rem;
            word-break: break-word;
          }

          /* Modal Header aesthetics */
          .modal-header {
            background: #f8f9fa;
            border-bottom: 1px solid #dee2e6;
          }
        </style>

      </div>
    </div>
  </div>
<?php } ?>