<?php
if (!defined('ABSPATH'))
  exit;
if (current_user_can("vtupress_access_users")) {
  $brun = Vtupress_option::get('vtupress_custom_active') == "yes";

  ?>

  <div class="container-fluid license-container">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.4.47/css/materialdesignicons.min.css" rel="stylesheet">
    <style>
      :root {
        --vp-primary: #6366f1;
        --vp-primary-hover: #4f46e5;
        --vp-success: #10b981;
        --vp-success-hover: #059669;
        --vp-danger: #ef4444;
        --vp-danger-hover: #dc2626;
        --vp-bg: #f8fafc;
        --vp-card-bg: #ffffff;
        --vp-text-main: #1e293b;
        --vp-text-muted: #64748b;
        --vp-border: #e2e8f0;
        --vp-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        --vp-shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
      }

      div.license-container * {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
      }

      .license-container {
        background: var(--vp-bg);
        padding: 2rem 0;
        margin: -20px -20px 0 -20px;
        min-height: 100vh;
      }

      .vp-premium-card {
        background: var(--vp-card-bg);
        border-radius: 16px;
        box-shadow: var(--vp-shadow-lg);
        border: 1px solid var(--vp-border);
        overflow: hidden;
        transition: all 0.3s ease;
      }

      .vp-premium-card:hover {
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
      }

      .vp-card-header {
        background: linear-gradient(135deg, var(--vp-primary) 0%, var(--vp-primary-hover) 100%);
        color: white;
        padding: 1.5rem 2rem;
        border-bottom: none;
      }

      .vp-card-header h5 {
        margin: 0;
        font-size: 1.5rem;
        font-weight: 600;
        letter-spacing: -0.025em;
      }

      .vp-card-body {
        padding: 2rem;
      }

      .vp-info-box {
        background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
        border-left: 4px solid var(--vp-primary);
        border-radius: 12px;
        padding: 1.5rem;
        margin-bottom: 2rem;
        box-shadow: var(--vp-shadow);
      }

      .vp-info-box i {
        color: var(--vp-primary);
        font-size: 1.5rem;
        margin-right: 1rem;
      }

      .vp-info-text {
        color: var(--vp-text-main);
        font-size: 0.95rem;
        line-height: 1.6;
        margin: 0;
      }

      .vp-form-label {
        display: flex;
        align-items: center;
        font-weight: 600;
        color: var(--vp-text-main);
        margin-bottom: 0.5rem;
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
      }

      .vp-form-label i {
        margin-right: 0.5rem;
        color: var(--vp-primary);
      }

      .vp-input {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 2px solid var(--vp-border);
        border-radius: 8px;
        font-size: 1rem;
        transition: all 0.2s ease;
        background: white;
      }

      .vp-input:focus {
        outline: none;
        border-color: var(--vp-primary);
        box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
      }

      .vp-btn {
        padding: 0.75rem 1.5rem;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        font-size: 1rem;
        cursor: pointer;
        transition: all 0.2s ease;
        width: 100%;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
      }

      .vp-btn-success {
        background: linear-gradient(135deg, var(--vp-success) 0%, var(--vp-success-hover) 100%);
        color: white;
        box-shadow: var(--vp-shadow);
      }

      .vp-btn-success:hover {
        transform: translateY(-2px);
        box-shadow: var(--vp-shadow-lg);
      }

      .vp-btn-danger {
        background: linear-gradient(135deg, var(--vp-danger) 0%, var(--vp-danger-hover) 100%);
        color: white;
        box-shadow: var(--vp-shadow);
      }

      .vp-btn-danger:hover {
        transform: translateY(-2px);
        box-shadow: var(--vp-shadow-lg);
      }

      .vp-icon-btn {
        width: 48px;
        height: 48px;
        padding: 0;
        border-radius: 8px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        background: white;
        border: 2px solid var(--vp-primary);
        color: var(--vp-primary);
        cursor: pointer;
        transition: all 0.2s ease;
        margin-right: 0.75rem;
      }

      .vp-icon-btn:hover {
        background: var(--vp-primary);
        color: white;
        transform: scale(1.05);
      }

      .vp-btn-group {
        display: flex;
        align-items: center;
        gap: 0;
      }

      @media (max-width: 768px) {
        .vp-card-body {
          padding: 1.5rem;
        }

        .vp-info-box {
          padding: 1rem;
        }

        .vp-btn-group {
          flex-direction: column;
        }

        .vp-icon-btn {
          margin-right: 0;
          margin-bottom: 0.75rem;
        }
      }

      .swal2-popup {
        font-family: 'Inter', sans-serif !important;
      }
    </style>

    <div class="row justify-content-center">
      <div class="col-12 col-lg-10 col-xl-8">
        <div class="vp-premium-card">
          <div class="vp-card-header">
            <h5>
              <i class="mdi mdi-shield-check me-2"></i>
              VTUPress License Activation
            </h5>
          </div>
          <div class="vp-card-body">
            <div class="vp-info-box">
              <div class="d-flex">
                <i class="mdi mdi-information-outline"></i>
                <div class="vp-info-text">
                  <strong>Important Information:</strong><br>
                  • Your URL must be added to your VTUPress account<br>
                  • Add your URL without http://, https://, or www. (e.g., example.com)<br>
                  • If your site requires www. to access, include it in your VTUPress account<br>
                  • URL validation now supports all variations (http/https, www/non-www)
                </div>
              </div>
            </div>

            <div class="row g-3">
              <div class="col-12 col-md-4">
                <label for="vp_user_id" class="vp-form-label">
                  <i class="mdi mdi-account"></i> User ID
                </label>
                <input type="number" id="vp_user_id" class="vp-input" placeholder="e.g 1219"
                  value="<?php echo Vtupress_Option::get('vtupress_id'); ?>">
              </div>

              <div class="col-12 col-md-4">
                <label for="vp_activation_key" class="vp-form-label">
                  <i class="mdi mdi-key"></i> Activation Key
                </label>
                <input type="text" id="vp_activation_key" class="vp-input" placeholder="e.g vtu-58363874"
                  value="<?php echo Vtupress_Option::get('vtupress_activation_key'); ?>">
              </div>

              <div class="col-12 col-md-4">
                <label class="vp-form-label">
                  <i class="mdi mdi-lightning-bolt"></i> Action
                </label>
                <?php if (!$brun) { ?>
                  <button type="button" class="vp-btn vp-btn-success" onclick="vpActivateLicense()">
                    <i class="mdi mdi-check-circle"></i>
                    Activate
                  </button>
                <?php } else { ?>
                  <div class="vp-btn-group">
                    <button type="button" class="vp-icon-btn" onclick="vpActivateLicense()" title="Re-Activate">
                      <i class="mdi mdi-sync"></i>
                    </button>
                    <button type="button" class="vp-btn vp-btn-danger" onclick="vpDeactivateLicense()" style="flex: 1;">
                      <i class="mdi mdi-close-circle"></i>
                      Deactivate
                    </button>
                  </div>
                <?php } ?>
              </div>
            </div>

            <script>
              document.addEventListener('DOMContentLoaded', function () {
                // Make functions globally accessible
                window.vpActivateLicense = function () {
                  var userId = jQuery('#vp_user_id').val();
                  var activationKey = jQuery('#vp_activation_key').val();

                  if (!userId || !activationKey) {
                    Swal.fire({
                      title: 'Missing Information',
                      text: 'Please enter both User ID and Activation Key',
                      icon: 'warning',
                      button: 'OK'
                    });
                    return;
                  }

                  var data = {
                    setactivation: "yea",
                    vtupress_id: userId,
                    vtupress_activation_key: activationKey,
                    admin_save: "license"
                  };

                  doAjax(
                    "<?php echo admin_url('admin-ajax.php'); ?>",
                    data,
                    "post",
                    "json",
                    // Success callback
                    function (response, useSwal) {
                      if (response.status == "100") {
                        Swal.fire({
                          title: 'Success!',
                          text: 'License activated successfully!',
                          icon: 'success',
                          button: 'OK'
                        }).then(() => {
                          location.reload();
                        });
                      } else {
                        Swal.fire({
                          title: 'Activation Failed',
                          text: response.message || 'An error occurred during activation',
                          icon: 'error',
                          button: 'OK'
                        });
                      }
                    },
                    // Process callback
                    function (useSwal) {
                      Swal.fire({
                        title: 'Activating License...',
                        text: 'Please wait while we verify your credentials',
                        icon: 'info',
                        buttons: false,
                        closeOnClickOutside: false
                      });
                    },
                    // Error callback
                    function (msg, useSwal) {
                      Swal.fire({
                        title: 'Connection Error',
                        text: msg,
                        icon: 'error',
                        button: 'OK'
                      });
                    },
                    true // Use SweetAlert
                  );
                };

                window.vpDeactivateLicense = function () {
                  Swal.fire({
                    title: 'Deactivate License?',
                    text: 'Are you sure you want to deactivate your license?',
                    icon: 'warning',
                    buttons: {
                      cancel: {
                        text: 'Cancel',
                        visible: true,
                        className: 'btn-secondary'
                      },
                      confirm: {
                        text: 'Yes, deactivate',
                        className: 'btn-danger'
                      }
                    },
                    dangerMode: true
                  }).then((willDeactivate) => {
                    if (willDeactivate) {
                      var data = {
                        setactivation: "no",
                        vtupress_id: "",
                        vtupress_activation_key: "",
                        admin_save: "license"
                      };


                      doAjax(
                        "<?php echo admin_url('admin-ajax.php'); ?>",
                        data,
                        "post",
                        "json",
                        // Success callback
                        function (response, useSwal) {
                          if (response.status == "200") {
                            Swal.fire({
                              title: 'Success!',
                              text: 'License deactivated successfully!',
                              icon: 'success',
                              button: 'OK'
                            }).then(() => {
                              location.reload();
                            });
                          } else {
                            Swal.fire({
                              title: 'Deactivation Failed',
                              text: response.message || 'An error occurred during activation',
                              icon: 'error',
                              button: 'OK'
                            });
                          }
                        },
                        // Process callback
                        function (useSwal) {
                          Swal.fire({
                            title: 'Dectivating License...',
                            text: 'Please wait while we deactivate license for this site',
                            icon: 'info',
                            buttons: false,
                            closeOnClickOutside: false
                          });
                        },
                        // Error callback
                        function (msg, useSwal) {
                          Swal.fire({
                            title: 'Connection Error',
                            text: msg,
                            icon: 'error',
                            button: 'OK'
                          });
                        },
                        true // Use SweetAlert
                      );
                    }
                  });
                };
              });
            </script>

          </div>
        </div>
      </div>
    </div>

  </div>
  <?php
} ?>