<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!current_user_can('vtupress_access_users')) {
    return;
}

global $wpdb;

include_once $this->globals_path . '/admin/pages/history/functions.php';

$table = $wpdb->prefix . 'vtupress_chat';

/**
 * Determine status filter
 */
$status = $_GET['status'] ?? '';

$where = "type = 'received'";
if ($status === 'unread') {
    $where .= " AND status = 'unread'";
} elseif ($status === 'read') {
    $where .= " AND status = 'read'";
}

/**
 * Fetch messages (latest per user)
 */
$messages = $wpdb->get_results(
    "SELECT * FROM (
        SELECT * FROM {$table}
        WHERE {$where}
        ORDER BY id DESC
        LIMIT 200
    ) AS x
    GROUP BY user_id"
);
?>

<div class="container-fluid license-container">

    <div class="row">
        <div class="col-12">

            <div class="card shadow-sm">
                <div class="card-body">

                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="card-title mb-0">
                            <i class="mdi mdi-message-text"></i> Messages
                        </h4>

                        <div class="btn-group">
                            <a href="<?php echo esc_url(add_query_arg('status', 'unread')); ?>" class="btn btn-danger btn-sm">
                                Unread
                            </a>
                            <a href="<?php echo esc_url(add_query_arg('status', 'read')); ?>" class="btn btn-success btn-sm">
                                Read
                            </a>
                            <a href="<?php echo esc_url(remove_query_arg('status')); ?>" class="btn btn-info btn-sm">
                                All
                            </a>
                        </div>
                    </div>

                    <div class="row">
                        <?php if (empty($messages)) : ?>
                            <div class="col-12 text-center text-muted py-5">
                                <i class="mdi mdi-email-open-outline mdi-48px"></i>
                                <p class="mt-3">No messages found</p>
                            </div>
                        <?php else : ?>
                            <?php foreach ($messages as $message) : ?>
                                <div class="col-md-3 mb-4">
                                    <div class="card border-left-success h-100 shadow-sm">
                                        <div class="card-body">

                                            <div class="d-flex align-items-center mb-2">
                                                <img
                                                    src="<?php echo esc_url($this->admin_url); ?>/assets/images/faces/face1.jpg"
                                                    class="rounded-circle me-2"
                                                    width="40"
                                                    alt="User"
                                                />
                                                <strong class="text-dark">
                                                    <?php echo esc_html($message->name); ?>
                                                </strong>
                                            </div>

                                            <p class="text-muted small mb-3">
                                                <?php echo esc_html(wp_trim_words($message->message, 12)); ?>
                                            </p>

                                            <div class="d-flex justify-content-between align-items-center">
                                                <small class="text-muted">
                                                    <?php echo esc_html($message->the_time); ?>
                                                </small>

                                                <a href="<?php echo esc_url(add_query_arg([
                                                    'page'      => 'vtupanel',
                                                    'adminpage' => 'messages',
                                                    'user_id'   => $message->user_id,
                                                ], admin_url('admin.php'))); ?>"
                                                   class="btn btn-cyan btn-sm text-dark">
                                                    Read
                                                </a>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>
