<?php
if (!defined('ABSPATH'))
  exit;

global $wpdb;

// Define table name
$table_name = $wpdb->prefix . "vtupress_notifications";

// Handle Form Submission / Filters
$current_page = isset($_REQUEST['current_page']) ? intval($_REQUEST['current_page']) : 1;
$limit = isset($_REQUEST['limit_records']) ? intval($_REQUEST['limit_records']) : 10;
$status = isset($_REQUEST['status']) ? sanitize_text_field($_REQUEST['status']) : '';
$type = isset($_REQUEST['type']) ? sanitize_text_field($_REQUEST['type']) : '';
$search = isset($_REQUEST['search']) ? sanitize_text_field($_REQUEST['search']) : '';

// ----------------------
// Handle Bulk / Single Actions (POST)
// ----------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bulk_action'])) {
    
    $action = sanitize_text_field($_POST['bulk_action']);
    $ids = isset($_POST['ids']) ? $_POST['ids'] : [];
    
    // Convert single ID to array if coming from popup "Mark as Read"
    if(isset($_POST['single_id']) && !empty($_POST['single_id'])){
        $ids = [intval($_POST['single_id'])];
    }

    if (!empty($ids) && is_array($ids)) {
        $ids_placeholder = implode(',', array_fill(0, count($ids), '%d'));
        
        if ($action === 'delete') {
            $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id IN ($ids_placeholder)", $ids));
            echo '<div class="alert alert-success">Selected items deleted successfully.</div>';
        } elseif ($action === 'mark_read') {
            $wpdb->query($wpdb->prepare("UPDATE $table_name SET status = 'read' WHERE id IN ($ids_placeholder)", $ids));
            echo '<div class="alert alert-success">Selected items marked as read.</div>';
        }
    }
}

// Calculate Offset
$offset = ($current_page - 1) * $limit;

// Build Query
$where_clauses = [];
if (!empty($status)) {
    $where_clauses[] = "status = '$status'";
}
if (!empty($type)) {
    $where_clauses[] = "type = '$type'";
}
if (!empty($search)) {
    $where_clauses[] = "(id LIKE '%$search%' OR title LIKE '%$search%' OR message LIKE '%$search%' OR user_id LIKE '%$search%')";
}

$where_sql = "";
if (count($where_clauses) > 0) {
    $where_sql = "WHERE " . implode(' AND ', $where_clauses);
}

// Get Total Count for Pagination
$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $table_name $where_sql");
$total_pages = ceil($total_items / $limit);

// Fetch Items
$notifications = $wpdb->get_results("SELECT * FROM $table_name $where_sql ORDER BY id DESC LIMIT $offset, $limit");

// Get Distinct Types for Filter
$types = $wpdb->get_col("SELECT DISTINCT type FROM $table_name");

?>

<div class="row">
    <div class="col-12">
        <link rel="stylesheet" type="text/css" href="<?php echo esc_url($this->admin_url); ?>/assets/extra-libs/multicheck/multicheck.css" />
        <link href="<?php echo esc_url($this->admin_url); ?>/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css" rel="stylesheet" />
        
        <!-- Add standard modal CSS if not present/conflict -->
        <style>
            .clickable-row { cursor: pointer; transition: background-color 0.2s; }
            .clickable-row:hover { background-color: #f8f9fa; }
        </style>

        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-3">All Notifications</h4>

                <form method="post" action="" id="filter-form">
                    <input type="hidden" name="current_page" id="current_page" value="<?php echo $current_page; ?>">
                    <!-- Preserve bulk action inputs for submission via JS -->
                    <input type="hidden" name="bulk_action" id="hidden_bulk_action" value="">
                    <input type="hidden" name="ids[]" id="hidden_bulk_ids" value="">

                    <div class="row mb-4 align-items-end">
                        <div class="col-md-3">
                            <label>Filter by Type</label>
                            <select name="type" class="form-control">
                                <option value="">-- All Types --</option>
                                <?php foreach ($types as $t): ?>
                                    <option value="<?php echo esc_attr($t); ?>" <?php selected($type, $t); ?>><?php echo ucfirst($t); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Filter by Status</label>
                            <select name="status" class="form-control">
                                <option value="">-- All Status --</option>
                                <option value="read" <?php selected($status, 'read'); ?>>Read</option>
                                <option value="unread" <?php selected($status, 'unread'); ?>>Unread</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label>Search</label>
                            <input type="text" name="search" class="form-control" placeholder="Search ID, Title, Msg..." value="<?php echo esc_attr($search); ?>">
                        </div>
                        <div class="col-md-3">
                            <button type="submit" class="btn btn-primary w-100" onclick="resetPage()">
                                <i class="fa fa-filter"></i> Apply Filter
                            </button>
                        </div>
                    </div>

                    <div class="row mb-3 justify-content-between">
                        <div class="col-md-auto">
                            <label class="d-inline-flex align-items-center">
                                Show 
                                <select name="limit_records" class="form-control form-control-sm mx-2" style="width: auto;" onchange="resetPage(); this.form.submit()">
                                    <option value="10" <?php selected($limit, 10); ?>>10</option>
                                    <option value="25" <?php selected($limit, 25); ?>>25</option>
                                    <option value="50" <?php selected($limit, 50); ?>>50</option>
                                    <option value="100" <?php selected($limit, 100); ?>>100</option>
                                </select> 
                                entries
                            </label>
                        </div>
                    </div>
                </form>

                <div class="table-responsive">
                    <table id="zero_config" class="table table-bordered">
                        <thead>
                            <tr>
                                <th class="text-center" style="width: 40px;">
                                    <label class="customcheckbox mb-0">
                                        <input type="checkbox" id="mainCheckbox" />
                                        <span class="checkmark"></span>
                                    </label>
                                </th>
                                <th>ID</th>
                                <th>User ID</th>
                                <th>Type</th>
                                <th>Title</th>
                                <th>Message</th>
                                <th>Time</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($notifications): ?>
                                <?php foreach ($notifications as $row): 
                                    // Excerpt Logic
                                    $msg_words = explode(' ', $row->message);
                                    $excerpt = implode(' ', array_slice($msg_words, 0, 20));
                                    if(count($msg_words) > 20) $excerpt .= '...';
                                ?>
                                    <tr class="clickable-row" 
                                        data-id="<?php echo $row->id; ?>" 
                                        data-title="<?php echo esc_attr($row->title); ?>" 
                                        data-message="<?php echo esc_attr($row->message); ?>"
                                        data-status="<?php echo $row->status; ?>">
                                        
                                        <td class="text-center" onclick="event.stopPropagation();">
                                            <label class="customcheckbox">
                                                <input type="checkbox" class="listCheckbox" name="ids[]" value="<?php echo $row->id; ?>" form="bulk-action-form-dummy" />
                                                <span class="checkmark"></span>
                                            </label>
                                        </td>
                                        <td><?php echo $row->id; ?></td>
                                        <td><?php echo $row->user_id; ?></td>
                                        <td><?php echo $row->type; ?></td>
                                        <td><?php echo $row->title; ?></td>
                                        <td><?php echo $excerpt; ?></td>
                                        <td><?php echo $row->the_time; ?></td>
                                        <td>
                                            <?php if ($row->status == 'unread'): ?>
                                                <span class="badge bg-danger">Unread</span>
                                            <?php else: ?>
                                                <span class="badge bg-success">Read</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center p-3">No notifications found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination Controls -->
                <?php if ($total_pages > 1): ?>
                    <nav aria-label="Page navigation" class="mt-3">
                        <ul class="pagination justify-content-center">
                            <li class="page-item <?php echo $current_page <= 1 ? 'disabled' : ''; ?>">
                                <a class="page-link" href="#" onclick="goToPage(<?php echo $current_page - 1; ?>)" tabindex="-1">Previous</a>
                            </li>

                            <?php if($current_page > 3): ?>
                                <li class="page-item">
                                    <a class="page-link" href="#" onclick="goToPage(1)">1</a>
                                </li>
                                <li class="page-item disabled"><span class="page-link">...</span></li>
                            <?php endif; ?>

                            <?php 
                            $range = 2;
                            for ($i = max(1, $current_page - $range); $i <= min($total_pages, $current_page + $range); $i++): 
                            ?>
                                <li class="page-item <?php echo $current_page == $i ? 'active' : ''; ?>">
                                    <a class="page-link" href="#" onclick="goToPage(<?php echo $i; ?>)"><?php echo $i; ?></a>
                                </li>
                            <?php endfor; ?>

                            <?php if($current_page < $total_pages - 2): ?>
                                <li class="page-item disabled"><span class="page-link">...</span></li>
                                <li class="page-item">
                                    <a class="page-link" href="#" onclick="goToPage(<?php echo $total_pages; ?>)"><?php echo $total_pages; ?></a>
                                </li>
                            <?php endif; ?>

                            <li class="page-item <?php echo $current_page >= $total_pages ? 'disabled' : ''; ?>">
                                <a class="page-link" href="#" onclick="goToPage(<?php echo $current_page + 1; ?>)">Next</a>
                            </li>
                        </ul>
                    </nav>
                <?php endif; ?>

                <?php if($notifications): ?>
                <div class="row align-items-center mt-3">
                    <div class="col-md-auto">
                        <label class="me-2">Bulk Actions:</label>
                    </div>
                    <div class="col-md-auto">
                        <select id="bulk_action_ui" class="form-control">
                            <option value="">--Select--</option>
                            <option value="mark_read">Mark as Read</option>
                            <option value="delete">Delete Selected</option>
                        </select>
                    </div>
                    <div class="col-md-auto">
                        <button class="btn btn-secondary" type="button" onclick="applyBulkAction()">Apply</button>
                    </div>
                </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<!-- Notification Detail Modal -->
<div class="modal fade" id="notificationModal" tabindex="-1" role="dialog" aria-labelledby="notificationModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="notificationModalLabel">Notification Details</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="jQuery('#notificationModal').modal('hide');">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h5 id="modal-notif-title" class="font-weight-bold"></h5>
        <p id="modal-notif-msg" class="mt-3"></p>
      </div>
      <div class="modal-footer">
        <!-- Hidden form for "Mark as Read" inside modal -->
        <form method="post" id="modal-mark-read-form" style="display:inline;">
             <input type="hidden" name="bulk_action" value="mark_read">
             <input type="hidden" name="single_id" id="modal-notif-id" value="">
             <button type="button" class="btn btn-success" id="modal-mark-read-btn" onclick="submitModalRead()">Mark as Read</button>
        </form>
        <button type="button" class="btn btn-secondary" onclick="jQuery('#notificationModal').modal('hide');">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
    function resetPage() {
        document.getElementById('current_page').value = 1;
    }

    function goToPage(page) {
        if (page < 1) return;
        document.getElementById('current_page').value = page;
        document.getElementById('filter-form').submit();
    }
    
    // Checkbox toggling logic
    document.getElementById('mainCheckbox').addEventListener('change', function(e) {
        var checkboxes = document.querySelectorAll('.listCheckbox');
        for (var checkbox of checkboxes) {
            checkbox.checked = this.checked;
        }
    });

    // Row Click - Open Modal
    var rows = document.querySelectorAll('.clickable-row');
    rows.forEach(function(row) {
        row.addEventListener('click', function() {
            var id = this.getAttribute('data-id');
            var title = this.getAttribute('data-title');
            var message = this.getAttribute('data-message');
            var status = this.getAttribute('data-status');

            document.getElementById('modal-notif-title').innerText = title;
            document.getElementById('modal-notif-msg').innerText = message;
            document.getElementById('modal-notif-id').value = id;

            // Show/Hide "Mark as Read" based on status
            if(status === 'read'){
                document.getElementById('modal-mark-read-btn').style.display = 'none';
            } else {
                document.getElementById('modal-mark-read-btn').style.display = 'inline-block';
            }

            jQuery('#notificationModal').modal('show');
        });
    });

    function submitModalRead() {
        // We use the main filter form to submit this action to keep filters? 
        // Or just the modal form. Let's use the modal form, but it might lose filters if we don't include them.
        // Actually, let's append the current filters to the modal form action or hidden inputs if we want to preserve state.
        // For simplicity, simple submit is fine, it will reload page.
        document.getElementById('modal-mark-read-form').submit();
    }

    function applyBulkAction() {
        var action = document.getElementById('bulk_action_ui').value;
        if (!action) {
            Swal.fire("Error", "Please select an action", "error");
            return;
        }

        var checkboxes = document.querySelectorAll('.listCheckbox:checked');
        if (checkboxes.length === 0) {
            Swal.fire("Error", "Please select at least one item", "error");
            return;
        }

        var ids = [];
        checkboxes.forEach(function(cb) {
            ids.push(cb.value);
        });

        Swal.fire({
            title: "Are you sure?",
            text: "You are about to apply this action to " + ids.length + " item(s).",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        .then((willProceed) => {
            if (willProceed) {
                // Prepare the main form to submit these details
                // We need to inject these IDs into the form
                var form = document.getElementById('filter-form');
                document.getElementById('hidden_bulk_action').value = action;
                
                // Clear existing hidden ids if any
                // We can't easily pass array via headers in simple way without building inputs
                // So let's create hidden inputs dynamically
                
                // Remove old dynamic inputs
                var oldInputs = form.querySelectorAll('.dynamic-id-input');
                oldInputs.forEach(el => el.remove());

                ids.forEach(function(id) {
                    var input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'ids[]';
                    input.value = id;
                    input.className = 'dynamic-id-input';
                    form.appendChild(input);
                });

                form.submit();
            }
        });
    }
</script>