<?php

if(!defined("ABSPATH")):
  die("Not Allowed");
endif;

    if($_GET["subpage"] == "coupon"){
?>



<div class="coupon_div row">
    <div class="card col">
                  <div class="card-body">
                      <h5 class="card-title">Coupon</h5>
                      <div class="table-responsive">

                          <div class="input-group mb-2 mt-2">
                              <span class="input-group-text">Enable Coupon System</span>
                              <select name="enable_coupon" class="enable_coupon">
                                  <?php echo get_select_options(['false','true'], Vtupress_Option::get("vtupress_enable_coupon","false"));?>
                              </select>
                          </div>
                          <div class="coupon_form mb-2 mt-2">
                                  <div class="input-group">
                                      <span class="input-group-text">CODE</span>
                                      <input class="form-control coupon_code" type="text" name="">
                                      <span class="input-group-text">Applicable To [USER IDS]</span>
                                      <input class="applicable_to form-control" type="text" name="">
                                      <span class="input-group-text">Amount</span>
                                      <input class="form-control coupon_amount">
                                      <input type="button" class="btn btn-success bg-success text-white form-control coupon_generate1" value="Generate">
                                  </div>
                          </div>

                            <?php
                              ##RUN COUPONS
                              global $wpdb;
                              $table_name = $wpdb->prefix.'vtupress_coupon';
                              $results = $wpdb->get_results( "SELECT * FROM $table_name ORDER BY ID DESC");
                            
                            ?>
                              <table class='table table-striped table-hover table-bordered table-responsive'>
                                  <thead>
                                      <tr>
                                          <th scope='col'>Id</th>
                                          <th scope='col'>Code</th>
                                          <th scope='col'>Applicable To [ID's]</th>
                                          <th scope='col'>Used By [ID's]</th>
                                          <th scope='col'>Amount</th>
                                          <th scope='col'>Status</th>
                                          <th scope='col'>Action</th>
                                      </tr>
                                  </thead>
                                    <?php
                                    foreach($results as $coupon):
                                          $id = $coupon->id;
                                          $code = $coupon->code;
                                          $app = $coupon->applicable_to;
                                          $used = $coupon->used_by;
                                          $status = $coupon->status;
                                          $amount = $coupon->amount;
                                      ?>
                                        <tr rowid="<?php echo $id;?>">
                                          <td scope='col'><?php echo $id;?></td>
                                          <td scope='col'><?php echo $code;?></td>
                                          <td scope='col' appid="<?php echo $id;?>"><?php echo $app;?></td>
                                          <td scope='col'><?php echo $used;?></td>
                                          <td scope='col'><?php echo $amount;?></td>
                                          <td scope='col' class="status<?php echo $id;?>" ><?php echo $status;?></td>
                                          <td scope='col'>
                                            <select class='set_coupon_status_to' theid="<?php echo $id;?>">
                                              <option value='none'>--Select--</option>
                                              <option value='close'>CLOSE</option>
                                              <option value='open'>OPEN</option>
                                              <option value='delete'>DELETE</option>
                                              <option value='edit'>Edit Users ID</option>
                                            </select>
                                          </td>
                                        </tr>
                                    <?php endforeach;?>

                              </table>

                      </div>
                  </div>
    </div>
</div>


<script>
  var readAlert = false;
  var idChanged = 0;
  var edit_value = "";
  function successfullyGenerated(response){
    if(response == "100"){
      showToast("Coupon successfully created","green",4000);
      setTimeout(function(){
        location.reload();
      },2000);
    }
    else{
      showToast(response,"red",4000);
    }
  }

  function statusChanged(response){
    if(response == "100"){
      showToast("Status successfully changed","green",4000);
    }

    jQuery(".status"+idChanged).text(edit_value);

  }

  jQuery(".applicable_to").on("input",function(){
      var val = jQuery(this).val();
      if(val.length == 1 && !readAlert){
        alert("Separate user ids by comma [ , ]");
        readAlert = true;
      }
  });
  jQuery("input.coupon_generate1").on("click",function(){
  
      var obj = {};

      obj["coupon_generate"] = "update";
      obj["coupon_code"] = jQuery(".coupon_code").val();
      obj["applicable_to"] = jQuery(".applicable_to").val();
      obj["coupon_amount"] = jQuery(".coupon_amount").val();
      obj["admin_save"] = "coupon_url";
      doAjax(vtupressInitPluginData.ajax_url,obj,'post',successfullyGenerated);


  });
  jQuery("select.enable_coupon").on("change",function(){
        var obj = {};
        obj["enable_coupon"] = jQuery(this).val();
        obj["admin_save"] = "coupon_url";
        doAjax(vtupressInitPluginData.ajax_url,obj,'post');

  });
  jQuery('.set_coupon_status_to').on('change',function(){
    var obj = {};
    var theid =jQuery(this).attr("theid");
    idChanged = theid;
    edit_value = jQuery(this).val();
    var accepted = false;
    switch(edit_value){
        case'close':
        if(confirm('Want To Close This Coupon?') == true){

          obj["coupon_close_edit"] = "close";
          obj["coupon_id"] = theid;
          accepted = true;

        }

        break;
        case'open':
            if(confirm('Want To Open This Coupon?') == true){
                obj["coupon_open_edit"] = "close";
                obj["coupon_id"] = theid;
                accepted = true;

            }
        break;
        case'delete':
                if(confirm('Want To Delete This Coupon?') == true){
                    obj["coupon_delete_edit"] = "close";
                    obj["coupon_id"] = theid;
                    accepted = true;
          }
        break;
        case'edit':
          let promp = prompt('EDIT USERS ID', jQuery("tr[row='"+theid+"'] td[appid='"+theid+"']").text());

              if (promp != null) {
                
                obj["coupon_edit"] = "edit";
                obj["coupon_user_edit"] = promp;
                obj["coupon_id"] = theid;
                accepted = true;

              }
        break;
        
        
    }

    if(!accepted){
      return;
    }
    obj["admin_save"] = "coupon_url";
    doAjax(vtupressInitPluginData.ajax_url,obj,'post',statusChanged);



  });
</script>


<?php }?>

