<?php

if (!defined("ABSPATH")):
    die("Not Allowed");
endif;

include_once ABSPATH . "wp-content/plugins/vtupress-templates/template_class.php";


if (isset($_GET["edit-template"])):
    include_once __DIR__ . "/edit_template.php";
    return;
endif;

if ($_GET["subpage"] == "template"):
    if (!current_user_can("vtupress_access_general")): ?>
        <div class="bg bg-primary text-white container p-3">
            <span class="fw-bold">Permission Not Granted!</span>
        </div>
        <?php return;
    endif;

    if (!vtupress_is_plugin_active("vtupress-templates/vtupress-templates.php")):
        echo "<div class='bg bg-primary text-white container p-3' >
            <span class='fw-bold'>VtuPress Templates Plugin is not active!</span>
        </div>";
        return;
    endif;


    $all_templates = Vtupress_Template_Container::all();

    ?>

    <div class="container-fluid container-md">
        <div class="row">
            <div class="col-md-12">
                <!--Add template  card -->
                <span class="fw-bold fs-3">Templates</span>
            </div>
        </div>
        <div class="row">
            <?php $current_template = Vtupress_Option::get("vtupress_template", "msorg");
            foreach ($all_templates as $template):
                $status = true;
                $id = $template->id;
                $templates_image = $template->thumbnail;
                $name = $template->name;
                $description = $template->description;
                $template_status = $template->status;

                if (!empty($template->custom)):
                    $code = $template->custom;
                    if (Vtupress_Option::get($code, "false") == "false"):
                        $status = false;
                    endif;
                endif;

                ?>
                <div class="col-12 col-md-4 ">
                    <div class="card shadow-sm p-3 mb-5 bg-white rounded">
                        <img src="<?php echo $templates_image; ?>" alt="<?php echo $name; ?>" class="card-img-top">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo $name; ?></h5>
                            <p class="card-text"><?php echo $description; ?></p>
                            <?php if (!$template_status): ?>
                                <a href="#" class="btn btn-danger">Coming Soon</a>
                            <?php elseif ($status): ?>
                                <?php if ($current_template != strtolower($name)): ?>
                                    <a href="#" class="btn btn-primary activateTemplate"
                                        template="<?php echo strtolower($id); ?>">Activate</a>
                                <?php else: ?>
                                    <div class="d-flex justify-content-center align-items-center">
                                        <a href="#" class="btn btn-secondary">Active</a>
                                        <?php if (!empty($template->form_fields())): ?>
                                            <a class="fas fa-cog fs-4 mx-2 pointer"
                                                href="<?php echo add_query_arg("edit-template", $template->id); ?>"></a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <a href="#" class="btn btn-primary my-2">View Template</a>
                                <a href="#" class="btn btn-primary ">Purchase</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    </div>


    <script>
        function templateChanged(response) {
            if (response == "100") {
                showToast("Successfully changed your template", "green", 3000);

                setTimeout(function () {
                    window.location.reload();
                }, 3000);
                return
            }
            showToast(response, "red", 3000);
        }
        jQuery(".activateTemplate").click(function (e) {
            e.preventDefault();
            var template = jQuery(this).attr("template");
            var obj = {};
            obj["save"] = "template";
            obj["template"] = template;
            obj["admin_save"] = "save_system_settings";

            doAjax(vtupressInitPluginData.ajax_url, obj, 'post', templateChanged);
        });

    </script>

<?php endif; ?>