<?php
if (!defined('ABSPATH'))
  exit;
include_once($this->globals_path . "/admin/pages/users/functions.php");

$table_name = $wpdb->prefix . "vtupress_users";
global $wpdb;

$users = new Users();
$users->syncUsers();

$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 50;
$page = isset($_GET['paged']) ? intval($_GET['paged']) : 1;
$search_term = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';
$offset = ($page - 1) * $limit;

// Build Query
$query = "SELECT * FROM $table_name";
$count_query = "SELECT COUNT(*) FROM $table_name";
$where_clauses = [];

if (!empty($search_term)) {
    // Search in VP Users (ID, Phone, APIKey)
    $vp_where = "userId LIKE '%$search_term%' OR phone LIKE '%$search_term%' OR apikey LIKE '%$search_term%'";
    
    // Search in WP Users (Username, Email) to get IDs
    $wp_user_ids = $wpdb->get_col($wpdb->prepare(
        "SELECT ID FROM {$wpdb->users} WHERE user_login LIKE %s OR user_email LIKE %s",
        '%' . $search_term . '%',
        '%' . $search_term . '%'
    ));
    
    if (!empty($wp_user_ids)) {
        $ids_list = implode(',', array_map('intval', $wp_user_ids));
        $vp_where .= " OR userId IN ($ids_list)";
    }
    
    $where_clauses[] = "($vp_where)";
}

if (!empty($where_clauses)) {
    $where_sql = " WHERE " . implode(' AND ', $where_clauses);
    $query .= $where_sql;
    $count_query .= $where_sql;
}

// Order and Limit
$query .= " ORDER BY id DESC LIMIT $limit OFFSET $offset";

$total_users = $wpdb->get_var($count_query);
$total_pages = ceil($total_users / $limit);
$users = $wpdb->get_results($query);

$sn = $offset + 1;
?>

<link rel="stylesheet" type="text/css" href="<?php echo esc_url($this->admin_url); ?>/assets/extra-libs/multicheck/multicheck.css" />
<link href="<?php echo esc_url($this->admin_url); ?>/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css" rel="stylesheet" />

<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="card-title mb-0">Users Listing (<?php echo number_format($total_users); ?>)</h4>
            <div>
                 <a href="<?php echo add_query_arg("sync", true); ?>" class="btn btn-primary btn-sm mx-2">Sync Users</a>
            </div>
        </div>

        <!-- Filter & Bulk Actions -->
        <form method="GET" class="mb-4">
            <input type="hidden" name="page" value="vtupanel">
            <input type="hidden" name="adminpage" value="users">
            <input type="hidden" name="subpage" value="all">
            
            <div class="row align-items-end">
                <div class="col-md-2">
                    <label>Limit</label>
                    <select name="limit" class="form-control" onchange="this.form.submit()">
                        <?php foreach ([50, 100, 200, 500, 700, 1000] as $opt): ?>
                            <option value="<?php echo $opt; ?>" <?php selected($limit, $opt); ?>><?php echo $opt; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label>Search (Username, Email, ID, Phone, API)</label>
                    <div class="input-group">
                        <input type="text" name="s" class="form-control" value="<?php echo esc_attr($search_term); ?>" placeholder="Search...">
                        <button class="btn btn-outline-secondary" type="submit">Search</button>
                    </div>
                </div>
                 <div class="col-md-6 text-end" id="bulk-actions" style="display:none;">
                    <label class="d-block">&nbsp;</label>
                    <button type="button" class="btn btn-warning btn-sm mx-1 bulk-action" data-action="block">Block Selected</button>
                    <button type="button" class="btn btn-success btn-sm mx-1 bulk-action" data-action="allow">Allow Selected</button>
                    <button type="button" class="btn btn-danger btn-sm mx-1 bulk-action" data-action="delete">Delete Selected</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-striped">
              <thead>
                <tr>
                  <th>
                      <input type="checkbox" id="select-all">
                  </th>
                  <th>ID</th>
                  <th>Name</th>
                  <th>Email</th>
                  <th>Plan</th>
                  <th>Phone</th>
                  <th>Balance</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
                <?php if ($users): ?>
                    <?php foreach ($users as $user):
                      $userData = get_userdata($user->userId); 
                      // Skip if WP user doesn't exist (integrity check)
                      if (!$userData) continue;
                      ?>
                      <tr>
                        <td>
                            <input type="checkbox" class="user-checkbox" value="<?php echo $user->userId; ?>">
                        </td>
                        <td><?php echo $user->userId; ?></td>
                        <td><?php echo ucfirst($userData->user_login); ?></td>
                        <td><?php echo strtolower($userData->user_email); ?></td>
                        <td><?php echo ucfirst($user->plan); ?></td>
                        <td><?php echo $user->phone; ?></td>
                        <td><?php echo number_format($user->balance, 2); ?></td>
                        <td>
                          <span class="badge badge-<?php echo ($user->access_status == 'allowed' || $user->access_status == "true") ? 'success' : 'danger'; ?>">
                            <?php echo $user->access_status; ?>
                          </span>
                        </td>
                        <td>
                            <a href="?page=vtupanel&adminpage=users&subpage=info&id=<?php echo $user->userId; ?>" class="btn btn-info btn-sm">View</a>
                        </td>
                      </tr>
                      <?php $sn++; endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="9" class="text-center">No users found.</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_pages > 1): ?>
        <nav aria-label="Page navigation" class="mt-4">
          <ul class="pagination justify-content-center">
            <?php 
            $base_url = remove_query_arg('paged');
            
            // Previous
            if ($page > 1) {
                echo '<li class="page-item"><a class="page-link" href="' . add_query_arg('paged', $page - 1, $base_url) . '">Previous</a></li>';
            }
            
            // Numbers (simplified range)
            $range = 3;
            for ($i = max(1, $page - $range); $i <= min($total_pages, $page + $range); $i++) {
                 $active = ($i == $page) ? 'active' : '';
                 echo '<li class="page-item ' . $active . '"><a class="page-link" href="' . add_query_arg('paged', $i, $base_url) . '">' . $i . '</a></li>';
            }

            // Next
            if ($page < $total_pages) {
                echo '<li class="page-item"><a class="page-link" href="' . add_query_arg('paged', $page + 1, $base_url) . '">Next</a></li>';
            }
            ?>
          </ul>
        </nav>
        <?php endif; ?>

      </div>
    </div>
  </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Select All Logic
    $('#select-all').on('click', function() {
        $('.user-checkbox').prop('checked', this.checked);
        toggleBulkActions();
    });

    $('.user-checkbox').on('change', function() {
        toggleBulkActions();
    });

    function toggleBulkActions() {
        var selected = $('.user-checkbox:checked').length;
        if (selected > 0) {
            $('#bulk-actions').fadeIn();
        } else {
            $('#bulk-actions').fadeOut();
        }
    }

    // Bulk Action Handler
    $('.bulk-action').on('click', function() {
        var action = $(this).data('action');
        var selected = [];
        $('.user-checkbox:checked').each(function() {
            selected.push($(this).val());
        });

        if (selected.length === 0) return;

        if (action === 'delete') {
            Swal.fire({
                title: 'Bulk Delete Users?',
                text: "Are you sure? This cannot be undone.",
                icon: 'warning',
                showCancelButton: true,
                showDenyButton: true,
                confirmButtonText: 'Delete VP Member Only',
                denyButtonText: 'Delete VP & WP Users',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#3085d6',
                denyButtonColor: '#d33',
            }).then((result) => {
                if (result.isDismissed) return;
                var type = result.isDenied ? 'both' : 'vpmember';
                processBulkAction('delete_user', selected, {type: type});
            });
        } else if (action === 'block' || action === 'allow') {
             var status = (action === 'block') ? 'blocked' : 'allowed'; // Or 'true' based on DB schema
             // DB schema seems to use 'allowed'/'true' or 'blocked'/'false'. Let's stick to what is viewed.
             // Line 175 checks for 'allowed' or 'true'.
             
             Swal.fire({
                title: action === 'block' ? 'Block Users?' : 'Allow Users?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Yes, do it!'
            }).then((result) => {
                if (result.isConfirmed) {
                     processBulkAction('change_access', selected, {change_to: status});
                }
            });
        }
    });

    function processBulkAction(run_action, ids, extra_data = {}) {
        Swal.fire({
            title: 'Processing...',
            html: 'Please wait...',
            allowOutsideClick: false,
            showConfirmButton: false,
            willOpen: () => { Swal.showLoading(); }
        });

        // We'll use a loop promise to handle them sequentially or batched to avoid timeout?
        // Actually, we can just send the array to backend if we implement a bulk endpoint.
        // But the user requested "if we click delete...".
        // Current users.php handles single ID. modifying it to handle bulk would be cleaner.
        // For now, let's implement a loop in JS to use existing endpoints to be safe.
        
        let promises = ids.map(id => {
            return new Promise((resolve, reject) => {
                let data = {
                    action: 'vtupress_yes_ajax', // or whatever the hook is
                    run: run_action,
                    userid: id,
                    
                    ...extra_data
                };
                
                // Add nonce if available
                if (typeof vtupressInitPluginData !== 'undefined') {
                    data.nonce = vtupressInitPluginData.nonce;
                    data.admin_save = 'user_manager'; // triggers user.php
                }

                $.post(vtupressInitPluginData.ajax_url, data, function(res) {
                    resolve(res);
                });
            });
        });

        Promise.all(promises).then((results) => {
            Swal.fire('Completed', 'Action processed for selected users', 'success').then(() => {
                location.reload();
            });
        });
    }
});
</script>