<?php
if (!defined('ABSPATH')) {
  die("Not Allowed");
}

if (!isset($_GET["id"])): ?>
  <div class="alert alert-light text-dark">
    No User ID found
  </div>
  <?php
  return;
endif;

$id = absint($_GET["id"]);
if (!$id) {
  echo '<div class="alert alert-light text-dark">Invalid User ID</div>';
  return;
}

$gateway_array = Vtupress_Gateway_Container::all();

global $wpdb;


/**
 * HANDLE USER UPDATE (SAME PAGE POST)
 */
if (
  isset($_POST['vtupress_update_user']) &&
  isset($_POST['_wpnonce']) &&
  wp_verify_nonce($_POST['_wpnonce'], 'vtupress_edit_user')
) {

  if (!current_user_can('manage_options')) {
    wp_die('Permission denied');
  }

  $user_id = intval($_POST['user_id']);
  $table = $wpdb->prefix . 'vtupress_users';

  $wpdb->update(
    $table,
    [
      'first_name' => sanitize_text_field($_POST['first_name']),
      'last_name' => sanitize_text_field($_POST['last_name']),
      'phone' => sanitize_text_field($_POST['phone']),
      'balance' => floatval($_POST['balance']),
      'pin' => floatval($_POST['pin']),
      'plan' => sanitize_text_field($_POST['plan']),
      'access_status' => sanitize_text_field($_POST['access_status']),
      'address' => sanitize_textarea_field($_POST['address']),
      'about' => sanitize_textarea_field($_POST['about']),
    ],
    ['userId' => $user_id],
    null,
    ['%d']
  );

  echo '<div class="alert alert-success">User updated successfully</div>';
}

/* ================= LEVELS ================= */
$table_name = $wpdb->prefix . "vtupress_levels";
$level = $wpdb->get_results(
  $wpdb->prepare(
    "SELECT * FROM $table_name WHERE set_country = %s",
    $this->country
  )
);

/* ================= USER ================= */
$table_name = $wpdb->prefix . "vtupress_users";
$user = $wpdb->get_row(
  $wpdb->prepare(
    "SELECT * FROM $table_name WHERE userId = %d",
    $id
  )
);

if (!$user): ?>
  <div class="alert alert-light">
    No User With ID (<?php echo esc_html($id); ?>) found
  </div>
  <?php
  return;
endif;


$vtu_id = $user->id;

/* ================= TRANSACTIONS ================= */
$table_name = $wpdb->prefix . "vtupress_transactions";

$successful_transactions = (int) $wpdb->get_var(
  $wpdb->prepare(
    "SELECT COUNT(id) FROM $table_name WHERE user_id=%d AND status='success'",
    $vtu_id
  )
);

$sales = (float) $wpdb->get_var(
  $wpdb->prepare(
    "SELECT SUM(CAST(amount AS DECIMAL(10,2))) FROM $table_name WHERE user_id=%d AND status='success'",
    $vtu_id
  )
);

$failed_transactions = (int) $wpdb->get_var(
  $wpdb->prepare(
    "SELECT COUNT(id) FROM $table_name WHERE user_id=%d AND status='failed'",
    $vtu_id
  )
);

$frontend_transactions = (int) $wpdb->get_var(
  $wpdb->prepare(
    "SELECT COUNT(id) FROM $table_name WHERE user_id=%d AND via='frontend'",
    $vtu_id
  )
);

$api_transactions = (int) $wpdb->get_var(
  $wpdb->prepare(
    "SELECT COUNT(id) FROM $table_name WHERE user_id=%d AND via='api'",
    $vtu_id
  )
);

$userData = get_userdata($id);

/* ================= GATEWAY ================= */
$manual_gateway = $gateway_array["manual"] ?? null;
$manual_gateway = $manual_gateway ? $manual_gateway->get_settings() : [];

/* ================= ACCOUNTS ================= */
$accounts_table = $wpdb->prefix . 'vtupress_userAccounts';
$my_accounts = $wpdb->get_results(
  $wpdb->prepare(
    "SELECT * FROM $accounts_table WHERE userId=%d AND set_country=%s",
    $id,
    $this->country
  ),
  ARRAY_A
);

$allow_acccess = ($user->access_status === "allowed" || $user->access_status === "true");


?>


<div class="card">
  <div class="card-body">
    <div class="d-flex mb-4">
      <h5 class="me-2 font-weight-semibold border-right pe-2 me-2"><?php echo ucfirst($userData->user_login); ?></h5>
      <h5 class="font-weight-semibold">WP_ID <?php echo $id; ?> | VP_ID <?= $vtu_id;?></h5>
      <button type="button" class="btn btn-sm mx-2 btn-gradient-warning my-2" data-bs-toggle="modal"
        data-bs-target="#vtupressEditUserModal">
        Edit
      </button>


    </div>
    <div class="row mx-sm-0">

      <div class="col-md-12 mb-5 pt-2 border px-0">
        <div class="card rounded shadow-none">
          <div class="card-body">
            <div class="row">
              <div class="col-sm-6 col-lg-5 d-lg-flex">
                <div class="user-avatar mb-auto">
                  <img src="<?php echo !empty($user->photo)? $user->photo :$this->admin_url."/assets/images/faces/face1.jpg"; ?>" alt="profile image"
                    class="profile-img img-lg rounded-circle">
                  <span class="edit-avatar-icon " data-wploader=".profile-image" data-img=".profile-img"><i
                      class="mdi mdi-camera"></i></span>
                </div>
                <div class="wrapper pl-lg-4">
                  <div class="wrapper d-flex align-items-center">
                    <h4 class="mb-0 font-weight-medium pointer">
                      <?php echo $user->first_name . " " . $user->last_name; ?>
                    </h4>
                    <div class="badge badge-secondary text-dark mt-2 ms-2 pointer">
                      <?php echo strtoupper($user->plan); ?>
                    </div>
                  </div>
                  <div class="wrapper d-flex align-items-center font-weight-medium text-muted">
                    <i class="mdi mdi-map-marker-outline me-2"></i>
                    <p class="mb-0 text-muted">
                      <?php echo $user->all_plans == "" ? "No Previous Plans" : $user->all_plans; ?>
                    </p>
                  </div>
                  <div class="wrapper d-flex align-items-start pt-3">
                    <div class="badge badge-<?php echo $allow_acccess ? "success" : "danger"; ?> text-dark me-2 pointer"
                      change-access="true" data-status="<?php echo $user->access_status; ?>"
                      data-user-id="<?php echo $id; ?>">
                      <i class="mdi mdi-check-circle-outline icon-sm"></i>
                    </div>
                    <div class="badge badge-primary text-dark me-2 pointer email_user_icon">
                      <i class="mdi mdi-email-outline icon-sm"></i>
                    </div>
                    <div class="badge badge-secondary text-dark me-2 pointer">
                      <i class="mdi mdi-format-list-bulleted icon-sm  "></i>
                    </div>
                    <div class="wrapper ps-2 d-none d-sm-block">
                      <h6 class="mt-n1 mb-0 font-weight-medium"><?php echo number_format($successful_transactions); ?>
                      </h6>
                      <p class="text-muted">Reports</p>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-6 my-3 my-md-1 col-lg-5">
                <div class="d-flex align-items-center w-100">
                  <input type="text" class="form-control profile-image d-none" />

                  <p class="mb-0 me-3 font-weight-semibold">Progress</p>
                  <div class="progress progress-md w-100">
                    <div class="progress-bar bg-success" role="progressbar" style="width: 67%" aria-valuenow="67"
                      aria-valuemin="0" aria-valuemax="100"></div>
                  </div>
                  <p class="mb-0 ms-3 font-weight-semibold">67%</p>
                </div>
                <small for="" class="fw-bold">Address</small>
                <p class="text-muted mt-4"><?php echo $user->address == "" ? "No Address" : $user->address; ?></p>
                <small for="" class="fw-bold mt-2">About</small>
                <p class="text-muted mt-4"><?php echo $user->about == "" ? "No About" : $user->about; ?></p>
              </div>
              <div class="col-sm-6 col-lg-2">
                <div class="wrapper d-flex flex-md-column">

                  <button type="button" class="btn btn-sm mx-2 btn-gradient-success my-2 login_as_user">Login</button>
                  <!-- Hide delete for admins -->
                  <?php if (!user_can($userData, 'manage_options')): ?>
                    <button type="button" class="btn btn-sm mx-2 btn-gradient-danger my-2 delete_user_btn">Delete</button>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
          <div class="wrapper border-top border-bottom">
            <div class="card-body">
              <div class="row">
                <div class="col-6 col-md d-flex">
                  <div
                    class="d-inline-flex align-items-center justify-content-center border rounded-circle px-2 py-2 my-auto text-muted">
                    <i class="mdi mdi-currency-ngn icon-sm my-0 "></i>
                  </div>
                  <div class="wrapper ps-3">
                    <p class="mb-0 font-weight-medium text-muted">BALANCE</p>
                    <h4 class="font-weight-semibold mb-0"><?php echo number_format($user->balance); ?> <span
                        class="changeBalance mx-2 pointer d-none">🖋️</span></h4>

                  </div>
                </div>
                <div class="col-6 col-md d-flex">
                  <div
                    class="d-inline-flex align-items-center justify-content-center border rounded-circle px-2 py-2 my-auto text-muted">
                    <i class="mdi mdi-account-plus icon-sm my-0 "></i>
                  </div>
                  <div class="wrapper ps-3">
                    <p class="mb-0 font-weight-medium text-muted">REFFERERS</p>
                    <h4 class="font-weight-semibold mb-0"><?php echo $user->referrers; ?></h4>
                  </div>
                </div>
                <div class="col-6 col-md d-flex">
                  <div
                    class="d-inline-flex align-items-center justify-content-center border rounded-circle px-2 py-2 my-auto text-muted">
                    <i class="mdi mdi-server-security icon-sm my-0 "></i>
                  </div>
                  <div class="wrapper ps-3">
                    <p class="mb-0 font-weight-medium text-muted">SALES</p>
                    <h4 class="font-weight-semibold mb-0"><?php echo $sales ?></h4>
                  </div>
                </div>
                <div class="col-6 col-md d-flex">
                  <div
                    class="d-inline-flex align-items-center justify-content-center border rounded-circle px-2 py-2 my-auto text-muted">
                    <i class="mdi mdi-chart-arc icon-sm my-0 "></i>
                  </div>
                  <div class="wrapper ps-3">
                    <p class="mb-0 font-weight-medium text-muted">PERFORMANCE</p>
                    <h4 class="font-weight-semibold mb-0 text-primary">49.65%</h4>
                  </div>
                </div>
                <div class="col d-flex align-items-center d-none">
                  <div class="image-grouped ms-auto">
                    <img src="<?php echo $this->admin_url; ?>/assets/images/faces/face20.jpg" data-bs-toggle="tooltip"
                      data-bs-placement="top" title="" alt="profile image" data-original-title="Mary Sharp">
                    <img src="<?php echo $this->admin_url; ?>/assets/images/faces/face17.jpg" data-bs-toggle="tooltip"
                      data-bs-placement="top" title="" alt="profile image" data-original-title="Cory Medina">
                    <img src="<?php echo $this->admin_url; ?>/assets/images/faces/face14.jpg" data-bs-toggle="tooltip"
                      data-bs-placement="top" title="" alt="profile image" data-original-title="Clyde Hammond">
                    <div class="text-avatar" data-bs-toggle="tooltip" data-bs-placement="top" title=""
                      data-original-title="4 More Peoples"><span class="d-block pt-2">+4</span></div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!--Account Number-->
          <!--BANK DETAILS-->
          <?php

          function accountNumber($aza, $generate)
          {
            $aza = strtolower($aza);

            if (empty($aza) || $aza == "false" || $aza == "null") {
              echo "<span class='btn btn-primary generate_account' for='$generate'><i class='fa fa-history'></i> Generate Account Number</span>";
            } else {
              echo $aza;
            }
          }


          $bvn = $user->bvn;
          $nin = $user->nin;


          ###This is to show aza
          Vtupress_Gateway_Container::render_account_tabs($id, 'admin');
          ?>
          <!-- End oF Account Number-->
        </div>


      </div>
    </div>
  </div>
</div>



<div class="modal fade" id="vtupressEditUserModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Edit User</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <form method="post">

          <?php wp_nonce_field('vtupress_edit_user'); ?>

          <input type="hidden" name="vtupress_update_user" value="1">
          <input type="hidden" name="user_id" value="<?php echo esc_attr($id); ?>">

          <div class="row">

            <div class="col-md-6 mb-3">
              <label>First Name</label>
              <input type="text" name="first_name" class="form-control"
                value="<?php echo esc_attr($user->first_name); ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label>Last Name</label>
              <input type="text" name="last_name" class="form-control"
                value="<?php echo esc_attr($user->last_name); ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label>Phone</label>
              <input type="text" name="phone" class="form-control" value="<?php echo esc_attr($user->phone); ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label>Balance</label>
              <input type="number" step="0.01" name="balance" class="form-control"
                value="<?php echo esc_attr($user->balance); ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label>Pin</label>
              <input type="number" name="pin" class="form-control"
                value="<?php echo esc_attr($user->pin); ?>">
            </div>

            <div class="col-md-6 mb-3">
              <label>Plan</label>
              <select name="plan" class="form-control">
                <?php foreach ($level as $lev): ?>
                  <option value="<?php echo $lev->name; ?>" <?php echo $lev->name == $user->plan ? "selected" : ""; ?>>
                    <?php echo ucfirst($lev->name); ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>

            <div class="col-md-6 mb-3">
              <label>Access Status</label>
              <select name="access_status" class="form-control">
                <option value="allowed" <?php selected($user->access_status, 'allowed'); ?>>Allowed</option>
                <option value="blocked" <?php selected($user->access_status, 'blocked'); ?>>Blocked</option>
              </select>
            </div>

            <div class="col-md-12 mb-3">
              <label>Address</label>
              <textarea name="address" class="form-control"><?php echo esc_textarea($user->address ?? ''); ?></textarea>
            </div>

            <div class="col-md-12 mb-3">
              <label>About</label>
              <textarea name="about" class="form-control"><?php echo esc_textarea($user->about ?? ''); ?></textarea>
            </div>

          </div>

          <div class="text-end">
            <button type="submit" class="btn btn-gradient-success">
              Save Changes
            </button>
          </div>

        </form>

        <div class="alert alert-success d-none" id="vtupressEditSuccess">
          User updated successfully
        </div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <!-- <button class="btn btn-primary" id="vtupressSaveUser">Save Changes</button> -->
      </div>

    </div>
  </div>
</div>
<!-- Email User Modal -->
<div class="modal fade" id="emailUserModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Email User</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label class="form-label">Subject / Header</label>
          <input type="text" class="form-control" id="email_header" placeholder="Important Notice">
        </div>
        <div class="mb-3">
          <label class="form-label">Message Body</label>
          <textarea class="form-control" id="email_body" rows="5" placeholder="Type your message here..."></textarea>
          <small class="text-muted">HTML is allowed.</small>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary send_email_btn">Send Email</button>
      </div>
    </div>
  </div>
</div>

<script>
  jQuery(document).ready(function ($) {

    // LOGIN AS USER
    $(".login_as_user").on("click", function () {
      var obj = {};
      obj["run"] = "impersonate_user";
      obj["admin_save"] = "user_manager";
      obj["action"] = "vtupress_yes_ajax";
      obj["nonce"] = vtupressInitPluginData.nonce;
      obj["userid"] = "<?php echo $id; ?>";

      // Use Swal.fire() for SweetAlert2
      Swal.fire({
        title: "Logging in...",
        text: "Please wait while we redirect you",
        icon: "info",
        showConfirmButton: false,
        allowOutsideClick: false,
        allowEscapeKey: false
      });

      $.post(vtupressInitPluginData.ajax_url, obj, function (res) {
        if (res.status == '100') {
          window.location.href = res.url;
        } else {
          Swal.fire("Error", res.message || "Login failed", "error");
        }
      }, 'json');
    });

    // EMAIL USER POPUP
    $(".email_user_icon").on("click", function () {
      // Check if bootstrap is defined (Bootstrap 5)
      if (typeof bootstrap !== 'undefined') {
        var myModal = new bootstrap.Modal(document.getElementById('emailUserModal'));
        myModal.show();
      } else {
        // Fallback for Bootstrap 4 / jQuery
        $("#emailUserModal").modal("show");
      }
    });

    $(".send_email_btn").on("click", function () {
      var header = $("#email_header").val();
      var body = $("#email_body").val();

      if (!header || !body) {
        Swal.fire("Error", "Please fill all fields", "error");
        return;
      }

      var obj = {};
      obj["run"] = "email_user";
      obj["admin_save"] = "user_manager";
      obj["userid"] = "<?php echo $id; ?>";
      obj["header"] = header;
      obj["body"] = body;
      obj['nonce'] = vtupressInitPluginData.nonce;
      obj['action'] = "vtupress_yes_ajax";

      var $btn = $(this);
      $btn.text("Sending...").prop("disabled", true);

      $.post(vtupressInitPluginData.ajax_url, obj, function (res) {
        $btn.text("Send Email").prop("disabled", false);
        if (res == '100') {
          // Hide modal logic (BS5 vs jQuery)
          var modalEl = document.getElementById('emailUserModal');
          if (typeof bootstrap !== 'undefined') {
            var modalInstance = bootstrap.Modal.getInstance(modalEl);
            if (modalInstance) modalInstance.hide();
          } else {
            $("#emailUserModal").modal("hide");
          }

          Swal.fire("Success", "Email sent successfully", "success");
          $("#email_header").val("");
          $("#email_body").val("");
        } else {
          Swal.fire("Error", res, "error");
        }
      });
    });

    // DELETE USER
    $(".delete_user_btn").on("click", function () {
      Swal.fire({
        title: "Delete User?",
        text: "Choose deletion type:",
        icon: "warning",
        showCancelButton: true,
        showDenyButton: true,
        confirmButtonText: "Delete VP Member Only",
        denyButtonText: "Delete VP & WP User",
        cancelButtonText: "Cancel",
        confirmButtonColor: '#3085d6',
        denyButtonColor: '#d33',
      })
        .then((result) => {
          if (result.isDismissed) return;

          var type = 'vpmember';
          if (result.isDenied) type = 'both';

          var obj = {};
          obj["run"] = "delete_user";
          // obj["action"] = "delete_user";
          obj["admin_save"] = "user_manager";
          obj["userid"] = "<?php echo $id; ?>";
          obj["type"] = type;
          obj['nonce'] = vtupressInitPluginData.nonce;
          obj['action'] = "vtupress_yes_ajax";

          Swal.fire({
            title: "Deleting...",
            showConfirmButton: false,
            allowOutsideClick: false,
            willOpen: () => {
              Swal.showLoading()
            }
          });

          $.post(vtupressInitPluginData.ajax_url, obj, function (res) {

            if (res == '100') {
              Swal.fire("Deleted!", "User verified deleted.", "success").then(() => {
                window.location.href = "?page=vtupanel&adminpage=users&subpage=all";
              });
            } else {
              Swal.fire("Error", res, "error");
            }
          });
        });
    });

    // GENERATE VIRTUAL ACCOUNT
    $(document).on("click", ".generate_account", function(e) {
      e.preventDefault();
      
      var btn = $(this);
      var gateway = btn.data("gateway");
      var userId = btn.data("user-id");
      var bankName = btn.data("bank-name");

    Swal.fire({
        title: "Generate Account?",
        text: "Generate " + bankName + " account for this user?",
        icon: "question",
        showCancelButton: true,
        confirmButtonText: "Yes, Generate",
        showLoaderOnConfirm: true,
        preConfirm: () => {
          return $.ajax({
            url: vtupressInitPluginData.ajax_url,
            type: "POST",
            data: {
              action: "vtupress_generate_virtual_account",
              gateway: gateway,
              user_id: userId
            },
            dataType: "json"
          }).then(response => {
            if (!response.success) {
              throw new Error(response.data.message || "Failed to generate account");
            }
            return response;
          }).catch(error => {
            Swal.showValidationMessage(
              `Request failed: ${error}`
            )
          });
        },
        allowOutsideClick: () => !Swal.isLoading()
      }).then((result) => {
        if (result.isConfirmed) {
          Swal.fire({
            title: "Success!",
            text: "Account generated successfully.",
            icon: "success"
          }).then(() => {
            location.reload();
          });
        }
      });
    });

  });
</script>