<?php

if (!defined('ABSPATH'))
  exit;

include_once($this->globals_path . "/admin/pages/" . 'users/functions.php');


if (
  isset($_POST['vp_save_kyc'])
  // isset($_POST['vtupress_kyc_nonce']) &&
  // wp_verify_nonce($_POST['vtupress_kyc_nonce'], 'vp_save_kyc_settings')
) {

  global $wpdb;

  $table = $wpdb->prefix . 'vtupress_kyc_settings';

  $wpdb->update(
    $table,
    [
      'enable' => sanitize_text_field($_POST['enable_kyc']),
      'kyc_limit' => intval($_POST['kyc_limit']),
      'duration' => sanitize_text_field($_POST['duration']),
    ],
    ['id' => 1]
  );

  // optional: success notice
  add_action('vtupress_notices', function () {
    echo '<div class="alert alert-success is-dismissible"><p>KYC settings updated.</p></div>';
  });
}


?>

<div class="row">

  <div class="col-12">
    <link rel="stylesheet" type="text/css"
      href="<?php echo esc_url($this->admin_url); ?>/assets/extra-libs/multicheck/multicheck.css" />
    <link href="<?php echo esc_url($this->admin_url); ?>/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css"
      rel="stylesheet" />
    <div class="card">
      <div class="card-body">
        <h5 class="card-title">Settings</h5>
        <div class="table-responsive">
          <?php
          global $wpdb;
          $table_name = $wpdb->prefix . "vtupress_kyc_settings";
          $datas = $wpdb->get_results("SELECT * FROM $table_name WHERE id = 1");
          ?>


          <div class="form-row row">
            <div class="col-12">
              <?php do_action('vtupress_notices'); ?>
            </div>
            <div class="col-12 col-md mb-3 mb-md-1">
              <label for="id">Enable Kyc:</label>
              <select class="enable_kyc form-control">
                <option value="<?php echo $datas[0]->enable; ?>"><?php echo strtoupper($datas[0]->enable); ?></option>
                <option value="yes">YES</option>
                <option value="no">NO</option>
              </select>
            </div>
            <div class="col-12 col-md  mb-3 mb-md-1">
              <label for="key">Transaction Limit Only Applies For Unverified Users:</label>
              <input type="number" name="kyc_limit" class="kyc_limit form-control"
                value="<?php echo $datas[0]->kyc_limit; ?>"><br>
            </div>
            <div class="col-12 col-md  mb-3 mb-md-1">
              <label for="submit">Duration:</label>
              <select class="kyc_duration form-control">
                <option value="<?php echo $datas[0]->duration; ?>"><?php echo strtoupper($datas[0]->duration); ?>
                </option>
                <option value="once">Total Transaction Amount At Once</option>
                <option value="total">Total Transaction Sum</option>
                <option value="day">Per Day</option>
                <option value="month">Per Month</option>
              </select>
            </div>
          </div>
          <script>
            jQuery(function ($) {

              function submitKycSettings() {

                const enable_kyc = $('.enable_kyc').val();
                const kyc_limit = $('.kyc_limit').val();
                const duration = $('.kyc_duration').val();
                // const nonce      = $('input[name="vtupress_kyc_nonce"]').val();

                // build a real form (browser will reload page)
                const form = $('<form>', {
                  method: 'POST',
                  action: window.location.href
                });

                form.append($('<input>', { type: 'hidden', name: 'vp_save_kyc', value: '1' }));
                form.append($('<input>', { type: 'hidden', name: 'enable_kyc', value: enable_kyc }));
                form.append($('<input>', { type: 'hidden', name: 'kyc_limit', value: kyc_limit }));
                form.append($('<input>', { type: 'hidden', name: 'duration', value: duration }));
                // form.append($('<input>', { type: 'hidden', name: 'vtupress_kyc_nonce', value: nonce }));

                $('body').append(form);
                form.submit();
              }

              // auto-submit on change
              $('.enable_kyc, .kyc_duration, .kyc_limit').on('change', submitKycSettings);

            });
          </script>

        </div>
      </div>
    </div><!--End Of Card -->
  </div>


</div>