<?php
if (!defined('ABSPATH')) {
  exit;
}

global $wpdb;
$kyc_table = $wpdb->prefix . 'vtupress_kyc';

// get stats
$total = $wpdb->get_var("SELECT COUNT(*) FROM $kyc_table");
$verified = $wpdb->get_var("SELECT COUNT(*) FROM $kyc_table WHERE status = 'verified'");
$review = $wpdb->get_var("SELECT COUNT(*) FROM $kyc_table WHERE status = 'review'");
$retry = $wpdb->get_var("SELECT COUNT(*) FROM $kyc_table WHERE status = 'retry'");
$ban = $wpdb->get_var("SELECT COUNT(*) FROM $kyc_table WHERE status = 'ban'");

$records = $wpdb->get_results("SELECT * FROM $kyc_table ORDER BY id DESC");
?>

<div class="container-fluid">

  <!-- Stats Row (Iconic Style) -->
  <div class="row mb-4 vtupress-summary">
    <!-- Verified -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="vtupress-glass glass-success">
        <div class="glass-icon"><i class="mdi mdi-check-decagram"></i></div>
        <div class="glass-content">
          <h6>Verified Users</h6>
          <h3><?= $verified ?></h3>
          <small>Approved KYC</small>
        </div>
      </div>
    </div>

    <!-- Review -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="vtupress-glass glass-pending">
        <div class="glass-icon"><i class="mdi mdi-clock-outline"></i></div>
        <div class="glass-content">
          <h6>Under Review</h6>
          <h3><?= $review ?></h3>
          <small>Pending Action</small>
        </div>
      </div>
    </div>

    <!-- Retry -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="vtupress-glass glass-info">
        <div class="glass-icon"><i class="mdi mdi-reload"></i></div>
        <div class="glass-content">
          <h6>Retry Request</h6>
          <h3><?= $retry ?></h3>
          <small>Sent back to user</small>
        </div>
      </div>
    </div>

    <!-- Banned -->
    <div class="col-xl-3 col-md-6 mb-4">
      <div class="vtupress-glass glass-failed">
        <div class="glass-icon"><i class="mdi mdi-block-helper"></i></div>
        <div class="glass-content">
          <h6>Banned Users</h6>
          <h3><?= $ban ?></h3>
          <small>Access Blocked</small>
        </div>
      </div>
    </div>
  </div>

  <!-- Main Card -->
  <div class="card">
    <div class="card-header bg-white">
      <h4 class="card-title mb-0">KYC Verifications List</h4>
    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table id="kycTable" class="table table-hover table-bordered text-center">
          <thead class="thead-light">
            <tr>
              <th>ID</th>
              <th>User Details</th>
              <th>Method</th>
              <th>Documents</th>
              <th>Status.</th>
              <th>Date</th>
              <th>Update Action</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($records):
              foreach ($records as $rec):
                $status_class = 'secondary';
                if ($rec->status == 'verified')
                  $status_class = 'success';
                if ($rec->status == 'review')
                  $status_class = 'warning text-dark';
                if ($rec->status == 'retry')
                  $status_class = 'info';
                if ($rec->status == 'ban')
                  $status_class = 'danger';
                ?>
                <tr>
                  <td><?= $rec->id ?></td>
                  <td class="text-left">
                    <strong><?= esc_html($rec->name) ?></strong><br>
                    <small class="text-muted">VP ID: <?= $rec->user_id ?></small>
                  </td>
                  <td><?= esc_html($rec->method) ?></td>
                  <td>
                    <?php if ($rec->selfie != '#' && !empty($rec->selfie)): ?>
                      <a href="<?= esc_url($rec->selfie) ?>" target="_blank" class="btn btn-sm btn-outline-primary"
                        title="View Selfie"><i class="mdi mdi-camera"></i></a>
                    <?php endif; ?>
                    <?php if ($rec->proof != '#' && !empty($rec->proof)): ?>
                      <a href="<?= esc_url($rec->proof) ?>" target="_blank" class="btn btn-sm btn-outline-primary"
                        title="View Proof"><i class="mdi mdi-file-document"></i></a>
                    <?php endif; ?>
                  </td>
                  <td><span class="badge badge-<?= $status_class ?> p-2"><?= strtoupper($rec->status) ?></span></td>
                  <td><small><?= $rec->the_time ?></small></td>
                  <td>
                    <div class="d-flex justify-content-center align-items-center">
                      <select class="form-control form-control-sm mr-1" id="action_<?= $rec->id ?>"
                        style="width: auto; min-width: 100px;">
                        <option value="">Select Action...</option>
                        <option value="verified" <?= $rec->status == 'verified' ? 'disabled' : '' ?>>Approve</option>
                        <option value="review" <?= $rec->status == 'review' ? 'disabled' : '' ?>>Review</option>
                        <option value="retry" <?= $rec->status == 'retry' ? 'disabled' : '' ?>>Retry</option>
                        <option value="ban" <?= $rec->status == 'ban' ? 'disabled' : '' ?>>Ban</option>
                      </select>
                      <button class="btn btn-sm btn-primary" onclick="processUpdate(<?= $rec->id ?>)">
                        <i class="mdi mdi-check"></i>
                      </button>
                    </div>
                  </td>
                </tr>
              <?php endforeach; else: ?>
              <tr>
                <td colspan="7" class="text-muted">No KYC submissions found.</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
  jQuery(document).ready(function ($) {
    if ($.fn.DataTable) {
      $('#kycTable').DataTable({
        "order": [[0, "desc"]]
      });
    }
  });

  function processUpdate(id) {
    var action = jQuery('#action_' + id).val();
    if (!action) {
      Swal.fire('Warning', 'Please select an action first.', 'warning');
      return;
    }

    /*
    var confirmMsg = 'Are you sure you want to change status to ' + action.toUpperCase() + '?';
    if(action === 'ban') confirmMsg += '\nThis will BLOCK the user from accessing the platform.';
    
    if(!confirm(confirmMsg)) return;
    */

    Swal.fire({
      title: "Are you sure?",
      text: (action === 'ban') ? "This will BLOCK the user from accessing the platform!" : "Change status to " + action.toUpperCase() + "?",
      icon: "warning",
      buttons: true,
      dangerMode: (action === 'ban'),
    })
      .then((willDelete) => {
        if (willDelete) {
          performAjaxUpdate(id, action);
        }
      });
  }

  function performAjaxUpdate(id, action) {
    Swal.fire({
      title: 'Processing...',
      text: 'Updating status...',
      icon: 'info',
      buttons: false,
      closeOnClickOutside: false,
    });

    jQuery.ajax({
      url: ajaxurl,
      type: 'POST',
      data: {
        action: 'vtupress_admin_update_kyc',
        id: id,
        todo: action
      },
      success: function (response) {
        if (response.success) {
          Swal.fire('Success', response.data.message, 'success').then(() => {
            location.reload();
          });
        } else {
          Swal.fire('Error', response.data.message || 'Update failed', 'error');
        }
      },
      error: function (err) {
        Swal.fire('Error', 'Server Error', 'error');
      }
    });
  }
</script>

<style>
  /* Ensure summary boxes match wallet history style */
  .vtupress-summary .vtupress-glass {
    position: relative;
    padding: 20px;
    border-radius: 15px;
    overflow: hidden;
    color: #fff;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
  }

  .glass-success {
    background: linear-gradient(45deg, #11998e, #38ef7d);
  }

  .glass-pending {
    background: linear-gradient(45deg, #fce38a, #f38181);
    color: #fff !important;
  }

  .glass-info {
    background: linear-gradient(45deg, #4facfe, #00f2fe);
  }

  .glass-failed {
    background: linear-gradient(45deg, #ff9966, #ff5e62);
  }

  .glass-icon {
    position: absolute;
    right: 15px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 3rem;
    opacity: 0.3;
  }

  .glass-content h3 {
    font-weight: bold;
    margin: 5px 0;
  }

  .vtupress-glass h6 {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.8rem;
    letter-spacing: 1px;
  }

  /* Table Actions */
  .btn-group-xs>.btn,
  .btn-xs {
    padding: .25rem .4rem;
    font-size: .875rem;
    line-height: 1.5;
    border-radius: .2rem;
  }
</style>