<?php
if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;
$wallet_table = $wpdb->prefix . 'vtupress_wallet';

// Admin context: Show all or filter
// User context: filtered by user_id (But this file is mostly called in Admin context)
// If this file is shared, we check context. But Admin history page is admin-only usually.

$transactions = $wpdb->get_results("SELECT * FROM $wallet_table ORDER BY id DESC LIMIT 1000", ARRAY_A);

$summary = [
    'credit' => 0,
    'debit' => 0,
    'refund' => 0,
    'credit_amount' => 0.00,
    'debit_amount' => 0.00,
    'refund_amount' => 0.00
];

foreach ($transactions as $txn) {
    if ($txn['type'] == 'credit') {
        $summary['credit']++;
        $summary['credit_amount'] += (float) $txn['fund_amount'];
    } elseif ($txn['type'] == 'debit') {
        $summary['debit']++;
        $summary['debit_amount'] += (float) $txn['fund_amount'];
    } elseif ($txn['type'] == 'refund') {
        $summary['refund']++;
        $summary['refund_amount'] += (float) $txn['fund_amount'];
    }
}
?>

<div class="row mb-4 vtupress-summary">
    <!-- Credit Card -->
    <div class="col-xl-4 col-md-6 mb-4">
        <div class="vtupress-glass glass-success">
            <div class="glass-icon"><i class="mdi mdi-arrow-down-bold-circle-outline"></i></div>
            <div class="glass-content">
                <h6>Total Credited</h6>
                <h3>₦
                    <?= number_format($summary['credit_amount'], 2) ?>
                </h3>
                <small>
                    <?= $summary['credit'] ?> Transactions
                </small>
            </div>
        </div>
    </div>

    <!-- Refund Card -->
    <div class="col-xl-4 col-md-6 mb-4">
        <div class="vtupress-glass glass-pending">
            <div class="glass-icon"><i class="mdi mdi-refresh"></i></div>
            <div class="glass-content">
                <h6>Total Refunded</h6>
                <h3>₦<?= number_format($summary['refund_amount'], 2) ?></h3>
                <small><?= $summary['refund'] ?> Transactions</small>
            </div>
        </div>
    </div>

    <!-- Debit Card -->
    <div class="col-xl-4 col-md-6 mb-4">
        <div class="vtupress-glass glass-failed">
            <div class="glass-icon"><i class="mdi mdi-arrow-up-bold-circle-outline"></i></div>
            <div class="glass-content">
                <h6>Total Debited</h6>
                <h3>₦
                    <?= number_format($summary['debit_amount'], 2) ?>
                </h3>
                <small>
                    <?= $summary['debit'] ?> Transactions
                </small>
            </div>
        </div>
    </div>
</div>

<div class="table-responsive">
    <table id="vtupress-wallet-history" class="table table-hover">
        <thead>
            <tr>
                <th>ID</th>
                <th>Type</th>
                <th>Amount</th>
                <th>Old Bal</th>
                <th>New Bal</th>
                <th>Description</th>
                <th>Status</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($transactions as $txn): ?>
                <tr>
                    <td>
                        <?= $txn['id'] ?>
                    </td>
                    <td>
                        <span class="badge <?= ($txn['type'] == 'credit') ? 'bg-success' : 'bg-danger' ?>">
                            <?= strtoupper($txn['type']) ?>
                        </span>
                    </td>
                    <td>₦
                        <?= number_format($txn['fund_amount'], 2) ?>
                    </td>
                    <td>₦
                        <?= number_format($txn['before_amount'], 2) ?>
                    </td>
                    <td>₦
                        <?= number_format($txn['now_amount'], 2) ?>
                    </td>
                    <td>
                        <?= esc_html($txn['name']) ?>
                    </td>
                    <td>
                        <?= ucfirst($txn['status']) ?>
                    </td>
                    <td>
                        <?= $txn['the_time'] ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
    jQuery(function ($) {
        if ($.fn.DataTable) {
            $('#vtupress-wallet-history').DataTable({
                pageLength: 25,
                order: [
                    [0, 'desc']
                ],
                responsive: true
            });
        }
    });
</script>