<?php
if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;
$table_name = $wpdb->prefix . 'vtupress_wallet_webhook';

// Handle Filters
$current_page = isset($_REQUEST['current_page']) ? intval($_REQUEST['current_page']) : 1;
$limit = isset($_REQUEST['limit']) ? intval($_REQUEST['limit']) : 20;
$filter_country = isset($_REQUEST['filter_country']) ? sanitize_text_field($_REQUEST['filter_country']) : '';
$filter_gateway = isset($_REQUEST['filter_gateway']) ? sanitize_text_field($_REQUEST['filter_gateway']) : '';
$filter_status = isset($_REQUEST['filter_status']) ? sanitize_text_field($_REQUEST['filter_status']) : '';
$search_term = isset($_REQUEST['search_term']) ? sanitize_text_field($_REQUEST['search_term']) : '';

// Calculate Offset
$offset = ($current_page - 1) * $limit;

// Build Query
$where_clauses = [];
if (!empty($filter_country)) {
    $where_clauses[] = "set_country = '$filter_country'";
}
if (!empty($filter_gateway)) {
    $where_clauses[] = "gateway = '$filter_gateway'";
}
if (!empty($filter_status)) {
    $where_clauses[] = "status = '$filter_status'";
}
if (!empty($search_term)) {
    $where_clauses[] = "(user_id LIKE '%$search_term%' OR referrence LIKE '%$search_term%')";
}

$where_sql = "";
if (count($where_clauses) > 0) {
    $where_sql = "WHERE " . implode(' AND ', $where_clauses);
}

// Get Total Count
$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $table_name $where_sql");
$total_pages = ceil($total_items / $limit);

// Fetch Data
$transactions = $wpdb->get_results("SELECT * FROM $table_name $where_sql ORDER BY id DESC LIMIT $offset, $limit");

// Fetch Distinct Values for Filters
$countries = $wpdb->get_col("SELECT DISTINCT set_country FROM $table_name");
$gateways = $wpdb->get_col("SELECT DISTINCT gateway FROM $table_name");
$statuses = $wpdb->get_col("SELECT DISTINCT status FROM $table_name");

?>

<div class="card">
    <div class="card-body">
        <h4 class="card-title mb-3">Wallet Webhook History</h4>

        <form method="get" action="" id="webhook-filter-form">
            <input type="hidden" name="page" value="vtupanel">
            <input type="hidden" name="adminpage" value="history">
            <input type="hidden" name="subpage" value="wallet-webhook">
            <input type="hidden" name="current_page" id="current_page" value="<?php echo $current_page; ?>">

            <div class="row align-items-end mb-4">
                <div class="col-md-2">
                    <label>Country</label>
                    <select name="filter_country" class="form-control">
                        <option value="">-- All --</option>
                        <?php foreach ($countries as $c): ?>
                            <option value="<?php echo esc_attr($c); ?>" <?php selected($filter_country, $c); ?>><?php echo ucfirst($c); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label>Gateway</label>
                    <select name="filter_gateway" class="form-control">
                        <option value="">-- All --</option>
                        <?php foreach ($gateways as $g): ?>
                            <option value="<?php echo esc_attr($g); ?>" <?php selected($filter_gateway, $g); ?>><?php echo ucfirst($g); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label>Status</label>
                    <select name="filter_status" class="form-control">
                        <option value="">-- All --</option>
                        <?php foreach ($statuses as $s): ?>
                            <option value="<?php echo esc_attr($s); ?>" <?php selected($filter_status, $s); ?>><?php echo ucfirst($s); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label>Search (User ID / Ref)</label>
                    <input type="text" name="search_term" class="form-control" value="<?php echo esc_attr($search_term); ?>" placeholder="Enter ID or Reference">
                </div>
                <div class="col-md-2">
                    <label>Rows</label>
                    <select name="limit" class="form-control" onchange="this.form.submit()">
                        <option value="20" <?php selected($limit, 20); ?>>20</option>
                        <option value="50" <?php selected($limit, 50); ?>>50</option>
                        <option value="100" <?php selected($limit, 100); ?>>100</option>
                    </select>
                </div>
                <div class="col-md-1">
                    <button type="submit" class="btn btn-primary w-100" onclick="document.getElementById('current_page').value=1">Filter</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User ID</th>
                        <th>Gateway</th>
                        <th>Amount</th>
                        <th>Reference</th>
                        <th>Status</th>
                        <th>Country</th>
                        <th>Response</th>
                        <th>Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($transactions): ?>
                        <?php foreach ($transactions as $row): ?>
                            <tr>
                                <td><?php echo $row->id; ?></td>
                                <td><?php echo $row->user_id; ?></td>
                                <td><?php echo ucfirst($row->gateway); ?></td>
                                <td><?php echo $row->amount; ?></td>
                                <td><?php echo $row->referrence; ?></td>
                                <td>
                                    <?php
                                    $badge_class = 'bg-secondary';
                                    if ($row->status == 'success' || $row->status == 'successful') $badge_class = 'bg-success';
                                    elseif ($row->status == 'failed') $badge_class = 'bg-danger';
                                    elseif ($row->status == 'pending') $badge_class = 'bg-warning';
                                    ?>
                                    <span class="badge <?php echo $badge_class; ?>"><?php echo ucfirst($row->status); ?></span>
                                </td>
                                <td><?php echo $row->set_country; ?></td>
                                <td>
                                    <button class="btn btn-sm btn-info view-response" 
                                            data-response="<?php echo esc_attr($row->response); ?>"
                                            data-id="<?php echo $row->id; ?>">
                                        View
                                    </button>
                                </td>
                                <td><?php echo $row->the_time; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="9" class="text-center">No records found</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_pages > 1): ?>
            <nav aria-label="Page navigation" class="mt-3">
                <ul class="pagination justify-content-center">
                    <li class="page-item <?php echo $current_page <= 1 ? 'disabled' : ''; ?>">
                        <a class="page-link" href="#" onclick="goToPage(<?php echo $current_page - 1; ?>)">Previous</a>
                    </li>
                    
                    <?php
                    $range = 2;
                    for ($i = max(1, $current_page - $range); $i <= min($total_pages, $current_page + $range); $i++):
                    ?>
                        <li class="page-item <?php echo $current_page == $i ? 'active' : ''; ?>">
                            <a class="page-link" href="#" onclick="goToPage(<?php echo $i; ?>)"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; ?>

                    <li class="page-item <?php echo $current_page >= $total_pages ? 'disabled' : ''; ?>">
                        <a class="page-link" href="#" onclick="goToPage(<?php echo $current_page + 1; ?>)">Next</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>

    </div>
</div>

<!-- Response Modal -->
<div class="modal fade" id="webhookResponseModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Webhook Response (ID: <span id="modal-webhook-id"></span>)</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" onclick="jQuery('#webhookResponseModal').modal('hide')">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <pre id="modal-webhook-body" style="background: #f8f9fa; padding: 15px; border-radius: 5px; white-space: pre-wrap; word-break: break-all;"></pre>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="jQuery('#webhookResponseModal').modal('hide')">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    function goToPage(page) {
        if (page < 1) return;
        document.getElementById('current_page').value = page;
        document.getElementById('webhook-filter-form').submit();
    }

    document.addEventListener('DOMContentLoaded', function() {
        var buttons = document.querySelectorAll('.view-response');
        buttons.forEach(function(btn) {
            btn.addEventListener('click', function() {
                var response = this.getAttribute('data-response');
                var id = this.getAttribute('data-id');
                
                // Try to format JSON if possible
                try {
                    var jsonObj = JSON.parse(response);
                    response = JSON.stringify(jsonObj, null, 2);
                } catch (e) {
                    // Not valid JSON, keep as is
                }

                document.getElementById('modal-webhook-id').innerText = id;
                document.getElementById('modal-webhook-body').textContent = response;
                
                jQuery('#webhookResponseModal').modal('show');
            });
        });
    });
</script>
