<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!defined('ABSPATH')) {
    exit;
}
// Detect Legacy
$has_legacy = get_option("vp_options") !== false;
?>
<title>VTUPress Ultimate Wizard</title>
<!-- Fonts & Icons -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;800&display=swap" rel="stylesheet">

<style>
    :root {
        --primary: #4F46E5;
        /* Indigo */
        --secondary: #EC4899;
        /* Pink */
        --bg-color: #F3F4F6;
        --card-bg: #ffffff;
        --text-main: #1F2937;
    }

    body {
        font-family: 'Outfit', sans-serif;
        background: var(--bg-color);
        margin: 0;
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 100vh;
        color: var(--text-main);
        overflow-x: hidden;
    }

    .wizard-container {
        width: 100%;
        max-width: 800px;
        background: var(--card-bg);
        border-radius: 20px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        position: relative;
        min-height: 600px;
        display: flex;
        flex-direction: column;
    }

    .wizard-header {
        background: linear-gradient(135deg, var(--primary), var(--secondary));
        color: white;
        padding: 30px;
        text-align: center;
        position: relative;
    }

    .wizard-header h1 {
        margin: 0;
        font-weight: 800;
        font-size: 2rem;
        letter-spacing: -1px;
    }

    .wizard-header p {
        margin: 5px 0 0;
        opacity: 0.9;
        font-weight: 300;
    }

    .step-content {
        padding: 40px;
        flex: 1;
        display: none;
        /* Hidden by default */
        animation: fadeIn 0.5s ease;
    }

    .step-content.active {
        display: block;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .btn-action {
        background: var(--primary);
        color: white;
        border: none;
        padding: 12px 30px;
        border-radius: 50px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(79, 70, 229, 0.3);
    }

    .btn-action:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 12px rgba(79, 70, 229, 0.4);
    }

    .btn-secondary-action {
        background: #E5E7EB;
        color: var(--text-main);
        box-shadow: none;
    }

    .btn-secondary-action:hover {
        background: #D1D5DB;
    }

    /* SVG Animations */
    .icon-bounce {
        animation: bounce 2s infinite;
    }

    @keyframes bounce {

        0%,
        20%,
        50%,
        80%,
        100% {
            transform: translateY(0);
        }

        40% {
            transform: translateY(-20px);
        }

        60% {
            transform: translateY(-10px);
        }
    }

    .plugin-list-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 15px;
        border-bottom: 1px solid #eee;
    }

    .plugin-status i.fa-check-circle {
        color: #10B981;
    }

    .plugin-status i.fa-times-circle {
        color: #EF4444;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
    }

    .form-control {
        width: 100%;
        padding: 12px;
        border: 2px solid #E5E7EB;
        border-radius: 10px;
        font-family: inherit;
        transition: border-color 0.3s;
    }

    .form-control:focus {
        border-color: var(--primary);
        outline: none;
    }

    /* Balloons */
    .balloon {
        // Placeholder for balloon CSS logic
        position: absolute;
        bottom: -100px;
        width: 50px;
        height: 60px;
        background: red;
        border-radius: 50%;
        animation: floatUp 5s ease-in infinite;
    }

    @keyframes floatUp {
        0% {
            transform: translateY(0) rotate(0deg);
            opacity: 1;
        }

        100% {
            transform: translateY(-800px) rotate(20deg);
            opacity: 0;
        }
    }

    /* Success Confetti/Balloons Container */
    #celebration-container {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        pointer-events: none;
        overflow: hidden;
        display: none;
    }
</style>

<div style="height:90vh !important;" class="container-fluid d-flex justify-content-center align-items-center">

    <div class="wizard-container">
        <div class="wizard-header">
            <h1><i class="fa-solid fa-rocket"></i> VTUPress Ultimate</h1>
            <p>Innovation Redefined</p>
        </div>

        <!-- STEP 1: WELCOME & WARNING -->
        <div id="step-1" class="step-content active text-center">
            <div class="mb-4">
                <i class="fa-solid fa-crown fa-4x text-warning icon-bounce"></i>
            </div>
            <h2 class="mb-3">Welcome Aboard!</h2>
            <p class="lead mb-4">You are about to experience the best innovation that reshapes the global view of
                the
                VTU business.</p>

            <?php if ($has_legacy): ?>
                <div class="alert alert-warning p-3 rounded"
                    style="background: #FFFBEB; border: 1px solid #FCD34D; color: #92400E; text-align: left;">
                    <h4 class="h6"><i class="fa-solid fa-triangle-exclamation"></i> Legacy Version Detected</h4>
                    <p class="small">We noticed <b>VTUPress Legacy</b> was installed. Please verify:</p>
                    <ul class="small mb-2">
                        <li>Halt all transactions immediately.</li>
                        <li>Uninstall all legacy VTUPress plugins/addons.</li>
                        <li>Instruct users not to access the site.</li>
                        <li>Use a maintenance plugin.</li>
                    </ul>
                    <p class="small"><strong>Note:</strong> Balances are secure (sync via Users page later).
                        History/bonuses
                        will be lost.</p>
                </div>
            <?php else: ?>
                <div class="alert alert-success p-3 rounded"
                    style="background: #ECFDF5; border: 1px solid #6EE7B7; color: #065F46;">
                    <i class="fa-solid fa-check-circle"></i> Your environment is clean and ready for VTUPress Ultimate!
                </div>
            <?php endif; ?>

            <button class="btn-action mt-4" onclick="nextStep(2)">Get Started <i
                    class="fa-solid fa-arrow-right"></i></button>
        </div>

        <!-- STEP 2: ENVIRONMENT CHECK -->
        <div id="step-2" class="step-content">
            <h2 class="text-center mb-4">Environment Check</h2>
            <p class="text-center text-muted mb-4">Scanning for conflicting plugins...</p>

            <div id="plugin-check-list" class="bg-light rounded p-3 mb-4" style="max-height: 300px; overflow-y: auto;">
                <div class="text-center py-5">
                    <i class="fa-solid fa-circle-notch fa-spin fa-2x text-primary"></i><br>Scanning...
                </div>
            </div>

            <div class="text-center">
                <button class="btn-action" id="btn-step-2" onclick="nextStep(3)" style="display:none;">Next Step <i
                        class="fa-solid fa-arrow-right"></i></button>
                <button class="btn-action btn-secondary-action" id="btn-step-2-retry" onclick="checkPlugins()"
                    style="display:none;">Re-scan</button>
                <div id="step-2-error" class="text-danger mt-2 small" style="display:none;">Please uninstall
                    conflicting
                    plugins to proceed.</div>
            </div>
        </div>

        <!-- STEP 3: SURVEY -->
        <div id="step-3" class="step-content">
            <h2 class="text-center mb-4">Quick Survey</h2>
            <form id="survey-form">
                <div class="row" style="display:flex; flex-wrap:wrap; gap:20px;">
                    <div class="" style="flex:1;">
                        <div class="form-group">
                            <label class="form-label">Full Name</label>
                            <input type="text" name="full_name" class="form-control" placeholder="John Doe">
                        </div>
                    </div>
                    <div class="" style="flex:1;">
                        <div class="form-group">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" placeholder="john@example.com">
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Where did you hear about VTUPress?</label>
                    <input type="text" name="heard_about" class="form-control">
                </div>

                <div class="form-group">
                    <label class="form-label">Used VTUPress Legacy Version?</label>
                    <select name="used_legacy" class="form-control" onchange="toggleLegacyFields(this.value)">
                        <option value="no">No</option>
                        <option value="yes">Yes</option>
                    </select>
                </div>

                <div id="legacy-fields" style="display:none;">
                    <div class="form-group">
                        <label class="form-label">Legacy Website URL</label>
                        <input type="url" name="legacy_url" class="form-control" placeholder="https://...">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Review of Old Version</label>
                        <textarea name="legacy_review" class="form-control" rows="2"></textarea>
                    </div>
                    <div class="form-group">
                        <label class="form-label">How long have you used it?</label>
                        <input type="text" name="legacy_duration" class="form-control">
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Core Service</label>
                    <select name="core_service" class="form-control">
                        <option value="airtime">Airtime</option>
                        <option value="data">Data</option>
                        <option value="bills">Bills Payment</option>
                        <option value="all">All of the above</option>
                    </select>
                </div>

                <div class="form-check mb-3">
                    <label><input type="checkbox" name="recommend"> I would recommend VTUPress to others</label>
                </div>

                <div class="form-check mb-4">
                    <label><input type="checkbox" name="summit_updates"> Join to get our global summit
                        updates</label>
                </div>

                <div class="text-center">
                    <button type="button" class="btn-action" onclick="submitSurvey()">Next Step <i
                            class="fa-solid fa-arrow-right"></i></button>
                </div>
            </form>
        </div>

        <!-- STEP 3.5: LICENSE REVIEW -->
        <div id="step-license" class="step-content">
            <h2 class="text-center mb-4">License Review</h2>
            <?php
            $license_for = Vtupress_Option::get('vtupress_custom_licensefor', 'all');
            $license_country = Vtupress_Option::get('vtupress_custom_licensecountry', 'NG');
            // Ensure Country Manager is loaded or use existing function
            // It is usually loaded by init, but we are in a direct include wizard context.
            // Assuming class.php is loaded because admin.php includes it.
            $all_countries = class_exists('Vtupress_Country_Manager') ? Vtupress_Country_Manager::all() : [];
            ?>

            <div class="p-4 bg-light rounded text-center mb-4">
                <?php if ($license_for != 'all'): ?>
                    <div class="text-warning mb-3"><i class="fa-solid fa-file-contract fa-3x"></i></div>
                    <p>Your current license only permits you to build and offer services for citizens of
                        <b><?php echo esc_html($license_country); ?></b> only.
                    </p>
                    <p class="small text-muted">Your default business country will be limited to
                        <b><?php echo esc_html($license_country); ?></b>.
                    </p>
                    <p class="small text-muted">You might need to upgrade your license to permit global usage.</p>
                    <input type="hidden" id="selected_country" value="<?php echo esc_attr($license_country); ?>">
                <?php else: ?>
                    <div class="text-success mb-3"><i class="fa-solid fa-globe fa-3x"></i></div>
                    <p>This license permits you to build for all african countries and also offer services to any/all of
                        them.
                    </p>
                    <p>Please select your current default country:</p>
                    <div class="form-group text-left" style="max-width:400px; margin: 0 auto;">
                        <!-- <label class="form-label">Select Business Country</label> -->
                        <select id="selected_country" class="form-control">
                            <?php foreach ($all_countries as $code => $cdata): ?>
                                <option value="<?php echo esc_attr($code); ?>" <?php selected($code, 'nigeria'); ?>>
                                    <?php echo esc_html($code); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                <?php endif; ?>
            </div>

            <div class="text-center">
                <button class="btn-action" onclick="nextStep(4)">Proceed to Setup <i
                        class="fa-solid fa-arrow-right"></i></button>
                <!-- <br><br>
                    <button class="btn-secondary-action btn-sm" onclick="nextStep(3)">Back</button> -->
            </div>
        </div>

        <!-- STEP 4: SETUP & MIGRATION -->
        <div id="step-4" class="step-content">
            <h2 class="text-center mb-4">Installation Setup</h2>

            <?php if ($has_legacy): ?>
                <div class="form-group mb-4">
                    <label class="form-label">Installation Type</label>
                    <div style="display:flex; gap:15px;">
                        <label style="flex:1; border:2px solid #ddd; padding:15px; border-radius:10px; cursor:pointer;"
                            onclick="selectInstallType('new')">
                            <input type="radio" name="install_type" value="install_new" checked>
                            <b>New Installation</b>
                        </label>
                        <label style="flex:1; border:2px solid #ddd; padding:15px; border-radius:10px; cursor:pointer;"
                            onclick="selectInstallType('migrate')">
                            <input type="radio" name="install_type" value="migrate">
                            <b>Migrate from Legacy</b>
                        </label>
                    </div>
                </div>

                <div class="alert alert-warning">
                    <i class="fa-solid fa-triangle-exclamation"></i>
                    Warning: Migration or New Install logic runs here. Ensure you have backed up your data.
                </div>

                <div class="form-check mb-4 p-3 bg-light rounded">
                    <label style="font-weight:600; color: #EF4444;">
                        <input type="checkbox" id="delete_db_check"> Delete Legacy Databases?
                    </label>
                    <p class="small text-muted mt-1">This will PERMANENTLY delete tables like vp_wallet, sairtime, etc.
                        Irreversible!</p>
                </div>
            <?php else: ?>
                <input type="hidden" name="install_type" value="install_new">
                <p class="text-center">Ready to initialize VTUPress Ultimate database tables.</p>
            <?php endif; ?>

            <div class="text-center">
                <button class="btn-action" onclick="finishSetup()">
                    <span id="finish-btn-text">Start Installation</span>
                </button>
            </div>
        </div>

        <!-- STEP 5: SUCCESS -->
        <div id="step-5" class="step-content text-center">
            <div class="mb-4">
                <i class="fa-solid fa-gift fa-4x text-primary icon-bounce"></i>
            </div>
            <h2 class="mb-3">Welcome to Ultimate!</h2>
            <p>VTUPress Ultimate has been successfully installed.</p>
            <p>Let's get this party started!</p>

            <button class="btn-action mt-4" onclick="window.location.reload();">Go to Dashboard</button>

            <div id="celebration-container"></div>
        </div>

    </div>

    <script>
        // Helper to get ajaxurl if not defined (fallback)
        const ajaxUrl = typeof ajaxurl !== 'undefined' ? ajaxurl : '<?php echo admin_url("admin-ajax.php"); ?>';

        // Simple Step Navigation
        function nextStep(step) {
            document.querySelectorAll('.step-content').forEach(el => el.classList.remove('active'));

            // Handle Step 3 -> License -> Step 4
            if (step === 'license') {
                document.getElementById('step-license').classList.add('active');
            } else {
                document.getElementById('step-' + step).classList.add('active');
            }

            if (step === 2) {
                checkPlugins();
            }
        }

        function toggleLegacyFields(val) {
            document.getElementById('legacy-fields').style.display = val === 'yes' ? 'block' : 'none';
        }

        function selectInstallType(type) {
            // Visual toggle logic if needed
        }

        // AJAX: Check Plugins
        function checkPlugins() {
            const list = document.getElementById('plugin-check-list');
            list.innerHTML = '<div class="text-center py-5"><i class="fa-solid fa-circle-notch fa-spin fa-2x text-primary"></i><br>Scanning...</div>';

            const fd = new FormData();
            fd.append('action', 'vp_wizard_action');
            fd.append('wiz_action', 'check_plugins');

            fetch(ajaxUrl, { method: 'POST', body: fd })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        let html = '';
                        let hasIssues = false;

                        data.data.forEach(p => {
                            let statusIcon = p.active
                                ? '<i class="fa-solid fa-circle-xmark text-danger fa-xl"></i>'
                                : '<i class="fa-solid fa-circle-check text-success fa-xl"></i>';

                            // Exclude self logic if needed
                            if (p.path.includes('vtupress/vtupress.php') && p.active) {
                                // Ignore self
                            } else if (p.active) {
                                hasIssues = true;
                            }

                            html += `
                        <div class="plugin-list-item">
                            <div>
                                <strong>${p.name}</strong><br>
                                <span class="small text-muted">${p.path}</span>
                            </div>
                            <div class="plugin-status">
                            ${statusIcon}
                            </div>
                        </div>`;
                        });

                        list.innerHTML = html;

                        if (hasIssues) {
                            document.getElementById('btn-step-2').style.display = 'none';
                            document.getElementById('btn-step-2-retry').style.display = 'inline-block';
                            document.getElementById('step-2-error').style.display = 'block';
                        } else {
                            document.getElementById('btn-step-2').style.display = 'inline-block';
                            document.getElementById('btn-step-2-retry').style.display = 'none';
                            document.getElementById('step-2-error').style.display = 'none';
                        }
                    } else {
                        list.innerHTML = '<div class="text-danger text-center">Error: ' + (data.data || 'Unknown error') + '</div>';
                    }
                })
                .catch(err => {
                    list.innerHTML = '<div class="text-danger text-center">Network Error</div>';
                });
        }

        // AJAX: Submit Survey
        function submitSurvey() {
            const form = document.querySelector('#survey-form');
            // Collect data
            const formData = new FormData(form);
            const data = {};
            formData.forEach((value, key) => data[key] = value);

            const fd = new FormData();
            fd.append('action', 'vp_wizard_action');
            fd.append('wiz_action', 'save_survey');
            // Pass array/obj
            for (const k in data) fd.append('survey_data[' + k + ']', data[k]);

            // Proceed regardless of save success
            fetch(ajaxUrl, { method: 'POST', body: fd })
                .then(() => nextStep('license'));
        }

        // AJAX: Finish Setup
        function finishSetup() {
            const btn = document.querySelector('#step-4 button');
            const originalText = btn.innerHTML;
            btn.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i> Processing...';
            btn.disabled = true;

            let installTypeEl = document.querySelector('input[name="install_type"]:checked');
            if (!installTypeEl) {
                installTypeEl = document.querySelector('input[name="install_type"][type="hidden"]');
            }

            const installType = installTypeEl ? installTypeEl.value : 'install_new';
            const deleteDb = document.getElementById('delete_db_check') ? document.getElementById('delete_db_check').checked : false;
            const selectedCountry = document.getElementById('selected_country') ? document.getElementById('selected_country').value : 'NG';

            const fd = new FormData();
            fd.append('action', 'vp_wizard_action');
            fd.append('wiz_action', 'finish_setup');
            fd.append('setup_type', installType);
            fd.append('delete_db', deleteDb);
            fd.append('selected_country', selectedCountry);

            fetch(ajaxUrl, { method: 'POST', body: fd })
                .then(res => res.text().then(text => {
                    try {
                        return JSON.parse(text);
                    } catch (e) {
                        console.error("Server Error Response:", text);
                        throw new Error("Server returned invalid JSON. See console for details. Response snippet: " + text.substring(0, 100));
                    }
                }))
                .then(data => {
                    if (data.success) {
                        nextStep(5);
                        startCelebration();
                    } else {
                        alert('Error: ' + (data.data || 'Unknown error'));
                        btn.innerHTML = originalText;
                        btn.disabled = false;
                    }
                })
                .catch(err => {
                    console.error(err);
                    alert('Installation Failed: ' + err.message);
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                });
        }

        // Celebration Animation (CSS-based balloons)
        function startCelebration() {
            const container = document.getElementById('celebration-container');
            container.style.display = 'block';

            const colors = ['#EF4444', '#3B82F6', '#10B981', '#F59E0B', '#8B5CF6', '#EC4899'];

            for (let i = 0; i < 30; i++) {
                const b = document.createElement('div');
                b.className = 'balloon';
                b.style.left = Math.random() * 100 + '%';
                b.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
                b.style.animationDuration = (Math.random() * 3 + 3) + 's';
                b.style.animationDelay = (Math.random() * 2) + 's';
                container.appendChild(b);
            }
        }

    </script>

</div>