<?php
if (!defined("ABSPATH"))
    exit;

// Helper function to normalize URLs for comparison
function vtupress_normalize_url($url)
{
    if (empty($url)) {
        return '';
    }

    // Remove protocol (http:// or https://)
    $url = preg_replace("/^https?:\/\//i", "", trim($url));

    // Remove www. prefix
    $url = preg_replace("/^www\./i", "", $url);

    // Remove trailing slash
    $url = rtrim($url, '/');

    // Remove port if present
    $url = preg_replace("/:\d+$/", "", $url);

    // Extract just the domain (remove path)
    $url_parts = parse_url("http://" . $url);
    $normalized = isset($url_parts['host']) ? $url_parts['host'] : $url;

    // Final cleanup: remove any remaining www.
    $normalized = preg_replace("/^www\./i", "", $normalized);

    return strtolower($normalized);
}

if (!isset($_POST["setactivation"])):
    die("Action Needed");
endif;

$action = $_POST["setactivation"];
$setActivation = $_POST['setactivation'];

//get general settings;
if (empty(Vtupress_option::get("vtupress_custom_active", ''))):
    $settings = [
        'whatsapp_group_link' => '-',
        'admin_phone' => '-',
        'admin_whatsapp' => '-'
    ];

else:
    $settings = $wpdb->prefix . 'vtupress_general_settings';
    $settings = $wpdb->get_row("SELECT * FROM $settings LIMIT 1",ARRAY_A);

endif;



$current_timestamp = current_time('timestamp');
$datenow = date("Y-m-d h:i A", $current_timestamp);
$next = date('Y-m-d h:i A', strtotime($datenow . " +12 hours"));

if ($setActivation != "yea") {
    Vtupress_option::update('vtupress_custom_active', 'no');
    Vtupress_option::update("vtupress_custom_security", "no");
    die('{"status":"200","message":"Deactivated!!!"}');
}

Vtupress_option::update('vtupress_activation_key', trim($_POST["vtupress_activation_key"]));
Vtupress_option::update('vtupress_id', trim($_POST["vtupress_id"]));


$vtupress_activation_key = trim($_POST["vtupress_activation_key"]);
$id = trim($_POST['vtupress_id']);

if (empty($id) || empty($vtupress_activation_key)) {
    $obj = new stdClass;
    $obj->status = "200";
    $obj->message = "ID and VTU Press Activation Key Required!";
    $json = json_encode($obj);
    die($json);
}




$user_id = get_current_user_id();
$email = get_userdata($user_id)->user_email;

$url = 'https://vtupress.com/wp-json/vtupress/v1/activate?id=' . $id . '&actkey=' . $vtupress_activation_key . '&url=' . get_site_url() . '&time=' . date("Y-m-d h:i:s") . '&phone=' . $settings["admin_phone"] . '&whatsapp=' . $settings["admin_whatsapp"] . '&plan=' . Vtupress_Option::get("vtupress_plan") . '&w_group=' . $settings["whatsapp_group_link"]  . '&email=' . $email;

$http_args = array(
    'timeout' => 30,
    'sslverify' => false
);

$call = wp_remote_get($url, $http_args);
$response = wp_remote_retrieve_body($call);


if (is_wp_error($call)) {

    $error = $call->get_error_message();
    $obj = new stdClass;
    $obj->status = "200";
    $obj->message = $error;
    $json = json_encode($obj);
    die($json);
} else {

    $resp_code = wp_remote_retrieve_response_code($call);
    if ($resp_code != 200) {

        $obj = new stdClass;
        $obj->status = "200";
        $obj->message = "Error Code:[$resp_code ] \n Can't Get A Supported Feedback From VTUPRESS! \nTRY UPDATE YOUR PLUGIN OR CONTACT SUPPORT";
        $json = json_encode($obj);
        die($json);
    }

    //If empty response from vtupress
    if (empty($response)) {
        die('{"status":"200","message":"Empty String"}');
    }

    //decode
    $en = json_decode($response, true);

    if (!isset($en["status"])) {
        Vtupress_option::update('vtupress_custom_active', 'no');
        Vtupress_option::update('vtupress_access_importer', 'no');
        $obj = new stdClass;
        $obj->status = "200";
        $obj->message = "VTUPRESS Feedback Not Found!";
        $json = json_encode($obj);
        die($json);
    } elseif ($en["status"] == "200") {
        if (!isset($en["message"])) {
            Vtupress_option::update('vtupress_custom_active', 'no');
            Vtupress_option::update('vtupress_access_importer', 'no');
            $obj = new stdClass;
            $obj->status = "200";
            $obj->message = "No Feedback message Found!";
            $json = json_encode($obj);
            die($json);
        } elseif (preg_match("/activation|wrong/i", $en["message"])) {
            Vtupress_option::update('vtupress_custom_active', 'no');
            Vtupress_option::update('vtupress_access_importer', 'no');
            $obj = new stdClass;
            $obj->status = "200";
            $obj->message = "Wrong Credentials";
            $json = json_encode($obj);
            die($json);
        }

    }

    if (!isset($en["url"])) {
        $obj = new stdClass;
        $obj->status = "200";
        $obj->message = $response;
        $json = json_encode($obj);
        die($json);
    }

    $urls = trim($en["url"]);
    $importers = trim($en["importers"]);
    $status = trim($en["status"]);
    $plan = trim($en["plan"]);
    $security = trim($en["security"]);
    $licensefor = trim($en["licensefor"]);
    $licensecountry = trim($en["licensecountry"]);
    // $plans = ["premium", "premium-y", "unlimited"];
    // $allow_imp = ["premium-y", "unlimited"];

    // if (!in_array($plan, $plans)) {
    //     Vtupress_option::update('vtupress_custom_active', 'no');
    //     Vtupress_option::update('vtupress_access_importer', 'no');
    //     $obj = new stdClass;
    //     $obj->status = "200";
    //     $obj->message = "Plan Not Identified";
    //     $json = json_encode($obj);
    //     die($json);
    // }

    // Normalize current site URLs
    $host = vtupress_normalize_url($_SERVER['HTTP_HOST']);
    $siteurl = vtupress_normalize_url(get_site_url());

    $siteExist = false;
    $isImport = false;



    if (is_numeric(stripos($urls, ","))) {
        $explode = explode(",", $urls);
        foreach ($explode as $url) {
            $url = vtupress_normalize_url($url);

            if ($url == $host || $url == $siteurl) {
                $siteExist = true;

                if (is_numeric(stripos($importers, ","))) {
                    $explode = explode(",", $importers);
                    foreach ($explode as $importer_url) {
                        $importer_url = vtupress_normalize_url($importer_url);



                        if ($importer_url == $host || $importer_url == $siteurl) {
                            $isImport = true;
                        }
                    }


                } elseif (vtupress_normalize_url($importers) == $host || vtupress_normalize_url($importers) == $siteurl) {
                    $isImport = true;
                }
            }
        }


    } elseif (vtupress_normalize_url($urls) == $host || vtupress_normalize_url($urls) == $siteurl) {
        $siteExist = true;
    }

    if (!$siteExist) {
        //die json with Url not enlisted
        $obj = new stdClass;
        $obj->status = "200";
        $obj->message = "Url not enlisted!";
        $json = json_encode($obj);
        die($json);
    } else {
        if ($status != "active") {
            Vtupress_option::update('vtupress_custom_active', 'no');
            Vtupress_option::update('vtupress_access_importer', 'no');
            $obj = new stdClass;
            $obj->status = "200";
            $obj->message = "status = $status";
            $json = json_encode($obj);
            die($json);
        } else {
            Vtupress_option::update("vp_check_date", $next);

            if ($security == "yes") {
                Vtupress_option::update("vtupress_custom_security", "yes");
            } else {
                Vtupress_option::update("vtupress_custom_security", "no");
            }
            Vtupress_option::update("vtupress_plan", $plan);
            Vtupress_option::update('vtupress_custom_active', 'yes');
            Vtupress_option::update('vtupress_custom_licensefor', $licensefor);
            Vtupress_option::update('vtupress_custom_licensecountry', $licensecountry);

            if ($isImport) {
                Vtupress_option::update('vtupress_access_importer', 'yes');
            } else {
                Vtupress_option::update('vtupress_access_importer', 'no');
            }

        }
    }

    //status should be 100
    $obj = new stdClass;
    $obj->status = "100";
    $obj->message = "Success";
    $json = json_encode($obj);
    die($json);


}