<?php

if(!defined("ABSPATH")){exit;}

if(!isset($_POST["save"])){
    die("nothing to save");
}

$save = sanitize_text_field($_POST["save"]);
global $wpdb;


switch($save):
    case"general":
        $table_name = $wpdb->prefix.'vtupress_general_settings';
    break;
    case"raptor":
        $table_name = $wpdb->prefix.'vtupress_raptor_settings';

        $_POST["save_raproc"] = "false";

        $apikey = $_POST["save_raptor_apiKey"];
        $conid = $_POST["save_raptor_connectionid"];
        $type = "testConnection";
        $domain = preg_replace("/(?:\/*|https*|:)/","",get_site_url());

        $payload = [
            "verificationType" => $type,
            "domain" => $domain
        ];
        
        $http_args = array(
            'headers' => array(
            'Authorization' => "Token $apikey",
            'connectionid' => $conid,
            'Content-Type' => 'application/json'
            ),
            'body' => json_encode($payload),
            'timeout' => '120',
            'user-agent' => 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)',
            'sslverify' => false
            );
        
            $response =  wp_remote_retrieve_body( wp_remote_post("https://dashboard.raptor.ng/api/v1/verification/",$http_args));
            $json = json_decode($response);
            if(!isset($json->status)){
                die(json_encode(['status'=> false, 'message'=>'Couldn\'t complete connection with raptor']));
            }
            elseif(!$json->status){
                die(json_encode(['status'=> false, 'message'=>$response]));
            }
            
            if($json->processor){
                $_POST["save_raproc"] = "true";
            }


    break;
    case"notification":
        $table_name = $wpdb->prefix.'vtupress_notification_settings';
    break;
    case"transaction":
        $table_name = $wpdb->prefix.'vtupress_transaction_settings';
    break;
    case"template":
        if(!isset($_POST["template"])):
            die("No template selected");
        endif;

        $template = sanitize_text_field($_POST["template"]);

        Vtupress_option::update("vtupress_template",$template);
        die("100");
    break;
    
    default:
        die("Invalid option");
endswitch;


$save = [];

stripslashes_deep($_POST);
$_POST = wp_unslash($_POST);
foreach($_POST as $key => $value):
    if(preg_match("/^save_/",$key)):
        if($key == "save_popup_message"):
            $save[str_replace("save_","",$key)] = htmlspecialchars(preg_replace("/\\\\/","",$value));
        else:
            $save[str_replace("save_","",$key)] = sanitize_text_field($value);
        endif;
    endif;
endforeach;

if(!empty($save)):
    $country = Vtupress_Country_Context::get();
    $settings = $wpdb->get_results("SELECT * FROM $table_name WHERE set_country = '$country'", ARRAY_A);
    if(empty($settings)){
        $updated = $wpdb->insert($table_name,array_merge($save,['set_country'=>$country]));
    }
    else{
        $updated = $wpdb->update($table_name,$save,['set_country'=>$country]);
    }
    if($updated):
        die("100");
    else:
        die("No changes was made");
    endif;
endif;