<?php

if(!defined("ABSPATH")){exit;}

if(!isset($_POST["action"])){
    die("Action not defined");
}

$action = sanitize_text_field($_POST["service_action"]);

//if action is empty

if(empty($action)):
    die("Invalid Action");
endif;

//switch between if action is create of delete

switch($action):
        case 'create':

                $array = [];

                //loop through the post data and use any post key that starts with create_ but remove create_ for each key and use the key and value
                //to create a new post
                foreach($_POST as $key => $value){
                    if(preg_match('/^create_/',$key)){
                        $newKey = str_replace('create_', '', $key);

                        if($key == "name"):
                            $array[$newKey] = trim(str_replace(" ","_",$value));
                        elseif($key != "generic_name"):
                            $array[$newKey] = trim($value);
                        else:
                            $array[$newKey] = trim(str_replace(" ","_",$value));
                        endif;
                    }
                }
                
                $array["type"] = "custom";

                $serviceName = $array["name"];
                $genericName = $array["generic_name"];

                global $wpdb;

                $vtupress_service_table = $wpdb->prefix.'vtupress_services';

                $serviceExist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $vtupress_service_table WHERE name = %s OR generic_name = %s", $serviceName,$genericName));

                if(count($serviceExist) > 0){
                    die("Service already exist");
                }

                
                $inserted = $wpdb->insert($vtupress_service_table, $array);
                
                if(!$inserted){
                    die("Service not inserted");
                }



        break;

        case 'create_type':
            


            $array = [];

            //loop through the post data and use any post key that starts with create_ but remove create_ for each key and use the key and value
            //to create a new post
            foreach($_POST as $key => $value){
                if(preg_match('/^create_/',$key)){
                    $newKey = str_replace('create_', '', $key);

                    if($key != "generic_name"):
                        $array[$newKey] = trim($value);
                    else:
                        $array[$newKey] = trim(str_replace(" ","_",$value));
                    endif;
                }
            }

            
            $serviceName = sanitize_text_field($array["service_name"]);
            
            $array["type"] = "custom";
            $serviceTypeName = $array["name"];

            global $wpdb;

            $vtupress_service_table = $wpdb->prefix.'vtupress_services';

            $serviceExist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $vtupress_service_table WHERE name = %s ", $serviceName));

            if(count($serviceExist) < 1){
                die("Service doesn't exist");
            }

            $vtupress_service_types_table = $wpdb->prefix.'vtupress_serviceTypes';


            $serviceTypeExist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $vtupress_service_types_table WHERE name = %s AND service_name = %s ", $serviceTypeName, $serviceName));

            if(count($serviceTypeExist) > 0){
                die("Service Type already exist");
            }


            
            $inserted = $wpdb->insert($vtupress_service_types_table, $array);
            
            if(!$inserted){
                die("Service not inserted");
            }

            //is useNetworks is yes
            if($serviceExist[0]->useNetwork == "yes"):

                $vtupress_service_networks = $wpdb->prefix.'vtupress_servicesNetworks';
                
                foreach($country_networks as $networks):

                    $value = [
                        'name' => strtolower($networks),
                        'service_name' => $serviceName,
                        'service_type' => $serviceTypeName,
                        'networkId' => '0',//id from api end
                        'ussd' => '*323#',
                        'country' => strtolower($iso),
                        'listOrder' => '1',
                        'status' => 'off',
                    ];

                    $name = $value["name"];
                    $type = $value["service_type"];
                    $result =  $wpdb->get_results("SELECT * FROM $vtupress_service_networks WHERE service_name = '$serviceName' AND name = '$name' AND service_type = '$type' ");
                    if(empty($result)){
                        $ins = $wpdb->insert($vtupress_service_networks, $value);
                        $ins = $wpdb->insert_id;
                        if($wpdb->insert_id < 1){
                            die("Error inserting network");
                        }
                    }


                endforeach;

            endif;
        break;
    
        case 'delete':

            if(!isset($_POST["service_name"])):
                die("Service Name not provided");
            endif;
    
            $serviceName = sanitize_text_field($_POST["service_name"]);

            global $wpdb;

            $vtupress_service_table = $wpdb->prefix.'vtupress_services';
            
            //check if service exist
            $serviceExist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $vtupress_service_table WHERE name = %s", $serviceName));
            
            if(count($serviceExist) == 0){
                die("Service not found");
            }

            //check if its default
            if($serviceExist[0]->type == "default"):
                die("Default service cannot be deleted");
            endif;
            
            $deleted = $wpdb->delete($vtupress_service_table, ['name' => $serviceName]);

            if(!$deleted){
                die("Service not deleted");
            }
    
    break;
    case 'delete-type':

        if(!isset($_POST["name"]) || !isset($_POST["type"])):
            die("Service Name / Service Type not provided");
        endif;

        $serviceName = sanitize_text_field($_POST["name"]);
        $serviceTypeName = sanitize_text_field($_POST["type"]);

        global $wpdb;

        $vtupress_service_table = $wpdb->prefix.'vtupress_services';
        
        //check if service exist
        $serviceExist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $vtupress_service_table WHERE name = %s", $serviceName));
        
        if(count($serviceExist) == 0){
            die("Service not found");
        }

        //check for service type too
        $vtupress_service_types_table = $wpdb->prefix.'vtupress_serviceTypes';


        $serviceTypeExist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $vtupress_service_types_table WHERE name = %s AND service_name = %s ", $serviceTypeName, $serviceName));

        if(count($serviceTypeExist) < 1){
            die("Service Type does not exist");
        }

        //check if its default
        if($serviceTypeExist[0]->type == "default"):
            die("Default serviceType cannot be deleted");
        endif;
        
        $deleted = $wpdb->delete($vtupress_service_types_table, ['name' => $serviceTypeName, 'service_name' => $serviceName]);

        if(!$deleted){
            die("Service not deleted");
        }

break;

        case 'status':
            
                if(!isset($_POST["service_name"])):
                    die("Service Name not provided");
                elseif(!isset($_POST["status"])):
                    die("Status not provided");
                endif;
                
                $serviceName = sanitize_text_field($_POST["service_name"]);
                $status = trim(sanitize_text_field($_POST["status"]));

                $vtupress_service_table = $wpdb->prefix.'vtupress_services';

                //check if service exist
                $serviceExist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $vtupress_service_table WHERE name = %s", $serviceName));
        
                if(count($serviceExist) == 0){
                    die("Service not found");
                }

                $updated = $wpdb->update($vtupress_service_table, ['status' => $status], ['name' => $serviceName]);





        break;

    default:
        die("Invalid Action");
endswitch;



die("100");