<?php
if (!defined('ABSPATH')) {
    die("Not Allowed");
}


function get_icon($icon_key)
{
    $icon_key = strtolower($icon_key);
    if ($icon_key == "pending") {
        return "mdi mdi-network-question";
    } elseif ($icon_key == "successful" || $icon_key == "approved") {
        return "far fa-check-circle";
    } elseif ($icon_key == "failed" || $icon_key == "cancled") {
        return "fas fa-ban";
    } elseif ($icon_key == "banned" || $icon_key == "kycbanned") {
        return "mdi mdi-account-star";
    } elseif ($icon_key == "disapproved") {
        return "mdi mdi-account-remove";
    } else {
        return "mdi mdi-network-question";
    }
}

function firstLevel($value, $second = false)
{
    // print_r($value);
    // return;
    if (!isset($value["title"])):

        if (isset($value["history-key"])):
            $key = $value["history-key"];
            if (isset($value["types"])):
                foreach ($value["types"] as $value):
                    $typ = strtolower($value);
                    $val = [
                        "title" => ucfirst($value),
                        "icon" => get_icon($value),
                        "link" => "?page=vtupanel&adminpage=history&subpage=$key&type=$typ"
                    ];
                    firstLevel($val, true);
                endforeach;


            endif;
        elseif (isset($value["users-key"])):
            $key = $value["users-key"];
            if (isset($value["other-link"])):
                foreach ($value["other-link"] as $value4):
                    firstLevel($value4, true);
                endforeach;

            endif;
            if (isset($value["types"])):
                foreach ($value["types"] as $value):
                    $typ = strtolower($value);
                    $val = [
                        "title" => ucfirst($value),
                        "icon" => get_icon($value),
                        "link" => "?page=vtupanel&adminpage=users&subpage=$typ",
                    ];
                    firstLevel($val, true);
                endforeach;
            endif;

        elseif (isset($value["isavings-key"])):
            $key = $value["isavings-key"];
            if (isset($value["types"])):
                foreach ($value["types"] as $value):

                    $typ = strtolower($value);
                    $val = [
                        "title" => ucfirst($value) . " Settings",
                        "icon" => get_icon($value),
                        "link" => "?page=vtupanel&adminpage=isavings&subpage=$typ-settings",
                    ];
                    firstLevel($val, true);
                endforeach;
            endif;
        else:
            error_log(json_encode($value));
        endif;


        return;
    endif;
    $link = $value["link"];
    $icon = $value["icon"];
    $title = $value["title"];

    ?>
    <li class="nav-item">
        <a class="nav-link" href="<?php echo $link; ?>">

            <?php if (!$second): ?>
                <span class="menu-title"><?php echo ucfirst($title); ?></span>
                <i class="<?php echo $icon; ?> menu-icon"></i>
                <?php
            else:
                echo ucfirst($title);
            endif; ?>

        </a>
    </li>
    <?php
}
function secondLevel($value)
{

    $sub = isset($value["sub"]) ? $value["sub"] : $value["sub-item"];
    $collapseId = str_replace(" ", "-", $value["title"]) . '-' . uniqid();
    ?>
    <li class="nav-item d-flex flex-column">
        <a class="nav-link" style="width:100%;" data-bs-toggle="collapse" href="#<?php echo $collapseId; ?>"
            aria-expanded="false">
            <span class="menu-title"><?php echo ucfirst($value["title"]); ?></span>
            <i class="menu-arrow"></i>
            <i class="<?php echo $value["icon"]; ?> menu-icon"></i>
        </a>
        <div class="collapse" id="<?php echo $collapseId; ?>">
            <ul class="nav flex-column sub-menu">
                <?php
                if (!isset($value["sub-item"])):
                    foreach ($sub as $subItem) {
                        if (isset($subItem["title"])) {
                            // This is a standard submenu item
                            if (isset($subItem["sub-item"])) {
                                // Has its own submenu
                                secondLevel($subItem);
                            } else {
                                firstLevel($subItem);
                            }
                        }
                    }
                else:
                    if (isset($value["sub-item"]["types"])):
                        firstLevel($value["sub-item"]);
                    else:
                        foreach ($value["sub-item"] as $subItem2) {
                            if (!isset($subItem2["sub"])):
                                firstLevel($subItem2);
                            else:
                                secondLevel($subItem2);
                            endif;
                        }
                    endif;
                endif;
                ?>
            </ul>
        </div>
    </li>
    <?php
}

function check_cap($cap)
{
    global $capabilities;
    if (isset($capabilities[$cap]) && $capabilities[$cap]):
        return true;
    else:
        return false;
    endif;
}

abstract class Admin_class
{
    public $id;
    public $title;
    public $description;
    public $admin_init_version = 24;
    public $admin_db_version = 22;
    public $general_init_version = 0;
    public $ajax_url;
    public $admin_url;
    public $admin_path;
    public $globals_path;
    public $globals_url;
    public $images_url;
    public $country;
    public $country_data;
    public $business_currency;
    public $developer_mode;

    public $license_country;
    public $license_for;

    public $pages_path;

    public $pages_url;

    public function __construct()
    {

            $this->ajax_url = admin_url('admin-ajax.php');
            $this->globals_path = VTUPRESS_PATH . "/globals/";
            $this->globals_url = VTUPRESS_URL . "/globals/";
            $this->pages_path = $this->globals_path . "/admin/pages/";
            $this->pages_url = $this->globals_url . "/admin/pages/";
            $this->images_url = VTUPRESS_URL . "images/";
            $this->developer_mode = $this->get_option("developer_mode", true);
            $this->business_currency = $this->get_option("business_currency", "ngn");

            add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_scripts']);
            add_action('wp_ajax_vtupress_yes_ajax', [$this, 'user_ajax']);
            add_action('wp_ajax_nopriv_vtupress_no_ajax', [$this, 'guest_ajax']);
            add_action('wp_ajax_vp_wizard_action', [$this, 'vtupress_wizard_handler']);
        
    }


    /** Core functions
     * 
     * 
     */
    public function get_option($key, $default = false)
    {
        return Vtupress_Option::get("vtupress_{$key}", $default);
    }

    public function update($key, $value)
    {
        return Vtupress_option::update("vtupress_{$key}", $value);
    }

    public function get_ui_option($key, $default = false)
    {
        return Vtupress_Option::get("vtupress_admin_ui{$this->id}_{$key}", $default);
    }

    public function update_ui_option($key, $value)
    {
        return Vtupress_option::update("vtupress_admin_ui{$this->id}_{$key}", $value);
    }

    public function vtupress_wizard_handler()
    {
        // Security Check
        if (!current_user_can('manage_options')) {
            wp_send_json_error("Unauthorized");
        }

        $action = $_POST['wiz_action'];

        if ($action === 'check_plugins') {
            $plugins_to_check = [
                'vtupress/vtupress.php' => 'VTUPress Core',
                'vtupress_woocommerce/vtupress_woocommerce.php' => 'VTUPress WooCommerce',
                'vtupress-bot/plugin.php' => 'VTUPress Bot',
                'vpussd/vpussd.php' => 'VP USSD',
                'vpsms/vpsms.php' => 'VP SMS',
                'vprest/vprest.php' => 'VP API',
                'vpmlm/vpmlm.php' => 'VP MLM',
                'vpepin/vpepin.php' => 'VP E-Pin',
                'vpdatas/vpdatas.php' => 'VP Data',
                'vpcards/vpcards.php' => 'VP Cards',
                'opay/opay.php' => 'Opay Integration',
                'msorg_template/msorg_template.php' => 'Msorg Template',
                'bi-firewall/bi-guardian.php' => 'BI Firewall',
                'bcmv/bcmv.php' => 'BCMV'
            ];

            include_once(ABSPATH . 'wp-admin/includes/plugin.php');
            $results = [];

            foreach ($plugins_to_check as $path => $name) {
                $is_active = vtupress_is_plugin_active($path);
                $results[] = [
                    'name' => $name,
                    'path' => $path,
                    'active' => $is_active
                ];
            }

            wp_send_json_success($results);
        }

        if ($action === 'save_survey') {
            $survey_data = $_POST['survey_data'] ?? [];
            update_option('vtupress_wizard_survey', $survey_data);
            wp_send_json_success();
        }

        if ($action === 'finish_setup') {
                $setup_type = $_POST['setup_type'];
                $delete_db = $_POST['delete_db'] === 'true';
                $selected_country = sanitize_text_field($_POST['selected_country'] ?? '');

                // Validate License Limits
                $license_for = Vtupress_Option::get('vtupress_custom_licensefor', 'nigeria');
                $license_country = Vtupress_Option::get('vtupress_custom_licensecountry', 'nigeria');

                if ($license_for != 'all') {
                    // Enforce license country
                    $selected_country = $license_country;
                } else {
                    // If global license but no country selected (fallback to NG or error?)
                    if (empty($selected_country)) {
                        $selected_country = 'nigeria';
                    }
                }

                // Save Business Country
                Vtupress_Option::update('vtupress_business_country', $selected_country);

                // 1. Run DB Migration/Creation
                self::vtupress_sortDbs();

                // 2. Migrate some setups
                if($setup_type == 'migrate'){

                    //CORE SETTINGs
                    if(!empty(get_option('vp_options'))){
                        global $wpdb;

                        $options_json = get_option("vp_options");
                        $old_options = json_decode($options_json, true);

                        /**
                         * SETTING
                        */
                        $general_settings_option = [
                            'debug' => $old_options['vpdebug'] ?? 'no',
                            'enable_registration' => $old_options['vp_enable_registration'] ?? 'no',
                            'enable_email_verification' => $old_options['email_verification'] ?? 'no',
                            'refund_failed_transaction' => $old_options['auto_refund'] ?? 'no',
                            'idle_timeout' => $old_options['vtu_timeout'] ?? '0',
                            'admin_phone' => $old_options['vp_phone_line'] ?? '',
                            'admin_whatsapp' => $old_options['vp_whatsapp'] ?? '',
                            'whatsapp_group_link' => $old_options['vp_whatsapp_group'] ?? '',
                            'set_country' => $selected_country
                        ];

                        $settings_tb = $wpdb->prefix . 'vtupress_general_settings';

                        // Check if row exists
                        $exist = $wpdb->get_var("SELECT id FROM $settings_tb WHERE id = 1");
                        if($exist){
                            $wpdb->update($settings_tb, $general_settings_option, ['id' => 1]);
                        }
                        else{
                            $general_settings_option['id'] = 1;
                            $wpdb->insert($settings_tb, $general_settings_option);
                        }

                        /**
                         * PAYMENT GATEWAY
                        */
                        //add payment gateway
                        $this->migrate_payment_gateways($old_options);

                    }

                    //USERS
                    $users = new Users();
                    $users->syncUsers(true);

                    //LEVELS
                    $vp_levels = $wpdb->prefix . 'vp_levels';
                    
                    if($wpdb->get_var("SHOW TABLES LIKE '$vp_levels'") == $vp_levels) {
                        $custom_levels = $wpdb->get_col("SELECT name FROM $vp_levels WHERE name != 'customer' AND name != 'reseller'");
                        if(!empty($custom_levels)){
                             $this->migrate_levels($custom_levels,$selected_country);
                        }
                    }
                }
                 if ($setup_type == 'install_new') {
                   //Do fresh setup logic if needed
                }

                
                // 3. Delete Legacy DB if requested
                if ($delete_db) {
                    global $wpdb;
                    $prefix = $wpdb->prefix;
                    $tables = [
                        'vtupress_users', 'vtupress_transactions', 'vtupress_wallet_webhook', 
                        'vtupress_kyc', 'vtupress_kyc_settings', 'vtupress_levels', 
                        'vtupress_levelGeneration', 'vtupress_raptor_settings', 
                        'vtupress_userAccounts', 'vtupress_vend_lock', 'vtupress_general_settings'
                    ];

                    foreach ($tables as $table) {
                        $wpdb->query("DROP TABLE IF EXISTS {$prefix}{$table}");
                    }

                    delete_option('vtupress_gateway_migration_done'); // Reset migration flag
                }

                // 4. Mark Wizard as Done with detailed data
                $survey = get_option('vtupress_wizard_survey', []);

                $wizard_data = [
                    'status' => 'done',
                    'completed_at' => current_time('mysql'),
                    'setup_type' => $setup_type,
                    'deleted_legacy_db' => $delete_db,
                    'selected_country' => $selected_country,
                    'license_info' => [
                        'license_for' => $license_for,
                        'license_country' => $license_country
                    ],
                    'survey_data' => $survey
                ];

                Vtupress_Option::update('vtupress_custom_wizard', $wizard_data);

                // Clean up temp survey option
                // delete_option('vtupress_wizard_survey');

                wp_send_json_success();
        }

        wp_die();

    }

    public function migrate_payment_gateways($old_options = []) {
        if (Vtupress_Option::get('vtupress_gateway_migration_done', 'no') === 'yes') {
            return;
        }

        if(empty($old_options)){
             return;
        }

        // Gateways to migrate
        $gateways = [
            'paystack' => [
                'option_keys' => [
                    'public_key' => 'ppub',
                    'secret_key' => 'psec',
                    'charge' => 'paystack_charge_back', 
                    // 'paystack_charge_method' handled separately
                ],
                'enable_key' => 'enable_paystack'
            ],
            'monnify' => [
                'option_keys' => [
                    'api_key' => 'monnifyapikey',
                    'secret_key' => 'monnifysecretkey',
                    'contract_code' => 'monnifycontractcode',
                    'bvn' => 'monnifybvn',
                    'charge' => 'charge_back'
                ],
                'enable_key' => 'enable_monnify'
            ],
            'paymentpoint' => [
                'option_keys' => [
                    'business_id' => 'paymentpoint_businessid',
                    'admin_bvn' => 'paymentpoint_admin_bvn',
                    'api_key' => 'paymentpoint_apikey',
                    'secret_key' => 'paymentpoint_secretkey',
                    'charge' => 'paymentpoint_charge_back'
                ],
                'enable_key' => 'enable_paymentpoint',
                'custom_id' => 'paymentpoint'
            ],
            'nomba' => [
                'option_keys' => [
                    'business_id' => 'nomba_businessid',
                    'api_key' => 'nomba_apikey',
                    // 'nomba_sign' -> not directly used in new class? Checked code: used in handle_webhook if secret_key empty or as fallback. 
                    'admin_bvn' => 'nomba_admin_bvn',
                    'secret_key' => 'nomba_secretkey',
                    'charge' => 'nomba_charge_back'
                ],
                'enable_key' => 'enable_nomba',
                'custom_id' => 'nomba'
            ],
             'ncwallet' => [
                'option_keys' => [
                    'public_key' => 'ncwallet_apikey',
                    'transaction_pin' => 'ncwallet_pin',
                    'charge' => 'ncwallet_charge_back'
                ],
                'enable_key' => 'enable_ncwallet',
                'custom_id' => 'ncwallet'
            ]
        ];

        foreach ($gateways as $gateway_id => $config) {
            $settings = [];
            $enable_key = $config['enable_key'];
            $is_enabled = ($old_options[$enable_key] ?? 'no') === 'yes';
            
            // Set Status
            $settings['status'] = $is_enabled ? 'active' : 'inactive';

            // Enable Custom Option if needed
            if (isset($config['custom_id'])) {
                $custom_key = "vtupress_custom_{$config['custom_id']}";
                if (($old_options[$custom_key] ?? 'no') === 'yes') {
                     Vtupress_Option::add($custom_key, 'yes');
                }
            }

            // Map keys
            if (isset($config['option_keys'])) {
                foreach ($config['option_keys'] as $new_key => $old_key) {
                    $val = $old_options[$old_key] ?? '';
                    $settings[$new_key] = $val;
                }
            }

            // Handle Charge Method logic
            $charge_method_key = $gateway_id == 'monnify' ? 'charge_method' : $gateway_id . '_charge_method';
            $charge_method = $old_options[$charge_method_key] ?? 'fixed'; // 'percentage' or 'fixed'
            
            if ($charge_method === 'percentage') {
                if (isset($settings['charge'])) {
                    $settings['charge'] .= '%';
                }
            }

            
            $country = 'nigeria'; 
            if(class_exists('Vtupress_Country_Context')){
                 $country = Vtupress_Option::get('vtupress_business_country', 'nigeria');
            }
            
            $option_key = "vtupress_gateway_{$gateway_id}_{$country}";
            
            Vtupress_Option::update($option_key, $settings);
        }

        Vtupress_Option::update('vtupress_gateway_migration_done', 'yes');
    }

    public function migrate_levels($level_names = [],$selected_country = 'nigeria') {
        if (empty($level_names)) {
            return;
        }

        global $wpdb;
        $table_name = $wpdb->prefix . 'vtupress_levels';

        foreach ($level_names as $name) {
             $exists = $wpdb->get_var($wpdb->prepare("SELECT id FROM $table_name WHERE name = %s", $name));
             if (!$exists) {
                 $wpdb->insert($table_name, array(
                    'name' => $name,
                    'status' => "active",
                    'set_country' => $selected_country
                  ));
             }
        }
    }


    protected function verify_nonce($nonce_field_name = 'nonce')
    {
        return isset($_REQUEST[$nonce_field_name]) && wp_verify_nonce($_REQUEST[$nonce_field_name], 'vtupress_nonce');
    }

    /**
     * GLOBAL FUNCTIONS
     */

    public function country_data()
    {
        $country_array = Vtupress_Country_Manager::all();

        $country = isset($country_array[$this->country]) ? $country_array[$this->country] : false;

        $iso = $country["iso"] ?? '';
        $flag = $country["flag"] ?? '';
        $currency = $country["currency"];
        $currency_symbol = $country["symbol"];
        $country_code = $country["code"];
        $country_networks = $country["networks"] ?? '';
        $currency_name = $country["name"];
        $slogan = $country["slogan"];

        $country_json = json_encode($country_array);

        return [
            "country" => $this->country,
            "country_array" => $country_array,
            "country_json" => $country_json,
            "iso" => $iso,
            "flag" => $flag,
            "currency" => $currency,
            "currency_symbol" => $currency_symbol,
            "country_code" => $country_code,
            "country_networks" => $country_networks,
            "currency_name" => $currency_name,
            "slogan" => $slogan
        ];
    }

    public function levels()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . "vtupress_levels";
        return $wpdb->get_results("SELECT * FROM  $table_name WHERE set_country = '{$this->country}'");
    }

    public function services()
    {
        $services = Vtupress_Service_Container::all();

        return $services;
    }

    public static function vtupress_sortDbs()
    {
        include_once __DIR__ . '/database.php';
        vtupress_sortDbs();
    }

    public function vtupress_init()
    {

        ## START

        //admin init

        if (is_admin() && current_user_can('administrator')):

            if (Vtupress_Option::get("admin_db_version") != $this->admin_db_version):
                self::vtupress_sortDbs();

                Vtupress_option::update("admin_db_version", $this->admin_db_version);
            endif;
        endif;




        //general

        if (is_user_logged_in()):

            if (Vtupress_Option::get("general_init_version") != $this->general_init_version):

                Vtupress_option::update("general_init_version", $this->general_init_version);
            endif;

        endif;




        ##END
    }

    public function menus()
    {
        global $capabilities;
        $current_user = wp_get_current_user();
        $capabilities = $current_user->allcaps;
        $services = $this->services();
        $levels = $this->levels();

        // error_log(json_encode($services));

        $history = [];
        $history[] = [
            'title' => "Wallet",
            'icon' => "mdi mdi-wallet",
            'link' => "?page=vtupanel&adminpage=history&subpage=wallet",
        ];
        foreach ($services as $sv) {
            $history[] = [
                'title' => $sv->id,
                'icon' => $sv->icon,
                'link' => "?page=vtupanel&adminpage=history&subpage=$sv->id",
            ];
        }

        $history[]= [
                "title" => "Wallet Webhook",
                "icon" => "mdi mdi-webhook",
                "link" => "?page=vtupanel&adminpage=history&subpage=wallet-webhook"
        ];


        $links = [];

        $links[] = [
            "title" => "Dashboard",
            "icon" => "mdi mdi-home menu-icon",
            "link" => "?page=vtupanel"
        ];

        // $links[] = [
        //     "title" => "Messages",
        //     "icon" => "mdi mdi-message-text",
        //     "link" => "?page=vtupanel&adminpage=messages"
        // ];

        $links[] = [
            "title" => "Notifications",
            "icon" => "mdi mdi-bell",
            "link" => "?page=vtupanel&adminpage=notifications"
        ];
        if (check_cap("vtupress_access_users")):
            $links[] = [
                "title" => "User Package",
                "icon" => "mdi mdi-nature-people",
                "link" => "javascript:void(0)",
                "sub" => []
            ];
            $lastIndex = array_key_last($links);
            // $links[$lastIndex]['sub'] =  [];
            $levelLink = $links[$lastIndex]['sub'];
            foreach ($levels as $thisLevel) {
                $links[$lastIndex]['sub'][] = [
                    "title" => ucfirst($thisLevel->name),
                    "icon" => "#",
                    "link" => "?page=vtupanel&adminpage=settings&subpage=levels&level=" . $thisLevel->id,
                ];
            }

        endif;

        if (check_cap("vtupress_access_settings")):
            $links[] = [
                "title" => "Settings",
                "icon" => "mdi mdi-cog",
                "link" => "?page=vtupanel&adminpage=settings&subpage=all"
            ];
        endif;

        if (check_cap("vtupress_access_history")):
            $links2 = [];
            $links[] = [
                "title" => "History",
                "icon" => "mdi mdi-receipt",
                "link" => "javascript:void(0)",
                "sub" => $history
            ];
        endif;

        if (check_cap("vtupress_access_users")):
            $links[] = [
                "title" => "Users",
                "icon" => "fas fa-users",
                "link" => "javascript:void(0)",
                "sub" => [
                    [
                        "title" => "All",
                        "icon" => "mdi mdi-all-inclusive",
                        "link" => "?page=vtupanel&adminpage=users&subpage=all",
                    ],
                    [
                        "title" => "KYC",
                        "icon" => "mdi mdi-account-settings-variant",
                        "link" => "javascript:void(0)",
                        "sub-item" => [
                            "users-key" => "",
                            "other-link" => [
                                [
                                    "title" => "Settings",
                                    "icon" => "mdi mdi-account-settings",
                                    "link" => "?page=vtupanel&adminpage=users&subpage=settings"
                                ],
                            ],
                            "types" => [
                                "verifications"
                            ]
                        ]
                    ]
                ]
            ];
        endif;

        if (check_cap("vtupress_access_security")):

            // $links[] = [
            //     "title" => "Misc",
            //     "icon" => "mdi mdi-hand-pointing-right",
            //     "link" => "javascript:void(0)",
            //     "sub" => [
            //         [
            //             "title" => "Security",
            //             "icon" => "mdi mdi-security",
            //             "link" => "?page=vtupanel&adminpage=misc&subpage=security",
            //         ]
            //     ]
            // ];
        endif;

        if ($this->get_option("beast672f091682e47") == "yes"):
            $links[] = [
                "title" => "iSavings",
                "icon" => "mdi mdi-account-settings-variant",
                "link" => "javascript:void(0)",
                "sub" => [
                    "isavings-key" => "",
                    "types" => [
                        "daily",
                        "Fixed",
                        "History",
                        "Withdrawal"
                    ]
                ]
            ];
        endif;

        if (check_cap("vtupress_access_gateway")):
            $links[] = [
                "title" => "PIN Manager",
                "icon" => "mdi mdi-ticket-percent",
                "link" => "?page=vtupanel&adminpage=pin_manager"
            ];

            $links[] = [
                "title" => "Services",
                "icon" => "mdi mdi-network",
                "link" => "javascript:void(0)",
                "sub" => [
                    [
                        "title" => "All Services",
                        "icon" => "mdi mdi-plus-network",
                        "link" => "?page=vtupanel&adminpage=gateway&settings=create",
                    ],
                    [
                        "title" => "Services Settings",
                        "icon" => "mdi mdi-lan-connect",
                        "link" => "javascript:void(0)",
                        "sub-item" => []
                    ],
                ]
            ];
            $lastIndex = array_key_last($links);
            $links[$lastIndex]['sub'][1]["sub-item"] = [];
            $gates = $links[$lastIndex]['sub'][1]["sub-item"];
            foreach ($services as $value) {
                // ensure heavy logic is loaded
                $value->boot();

                $settings = $value->get_settings();

                $service_types = $settings['service_types'] ?? false;

                $public_name = capitalizeWords($value->name);
                $name = $value->id;

                if (!empty($value->custom_id)) {
                    if (Vtupress_option::get("vtupress_custom_{$value->custom_id}") != "yes") {
                        continue;
                    }
                }

                $icon = $value->icon ?? '';
                if ($service_types && !empty($service_types)) {
                    $links[$lastIndex]['sub'][1]["sub-item"][] = [
                        "title" => $public_name,
                        "icon" => $icon,
                        "link" => "javascript:void(0)",
                        "sub" => [],
                    ];
                    $lastgIndex = array_key_last($links[$lastIndex]['sub'][1]["sub-item"]);
                    $links[$lastIndex]['sub'][1]["sub-item"][$lastgIndex]['sub'] = [];
                    $subgates = $links[$lastIndex]['sub'][1]["sub-item"][$lastgIndex]['sub'];


                    foreach ($service_types as $value3) {
                        $public_name1 = capitalizeWords($value3);
                        $sub_name = strtolower($value3);

                        $links[$lastIndex]['sub'][1]["sub-item"][$lastgIndex]['sub'][] = [
                            "title" => $public_name1,
                            "icon" => $icon,
                            "link" => "?page=vtupanel&adminpage=gateway&service=$name&service_type=$sub_name"
                        ];
                    }
                } else {
                    $links[$lastIndex]['sub'][1]["sub-item"][] = [
                        "title" => $public_name,
                        "icon" => $icon,
                        "link" => "?page=vtupanel&adminpage=gateway&service={$value->id}"
                    ];
                }
            }


        endif;




        $fullLinks = apply_filters('vtupress_admin_menus', $links);
        return $fullLinks;

    }


    /**
     * REQUIRED ABSTRACT METHODS
     */

    //enqueue admin scripts
    abstract public function enqueue_admin_scripts($hook);

    //render admin page
    abstract public function render_admin_page();

    //user ajax
    abstract public function user_ajax();

    //guest ajax
    abstract public function guest_ajax();


    public function vtupress_remove_notices()
    {
        remove_all_actions('admin_notices');
        remove_all_actions('user_admin_notices');
    }

}



class Vtupress_Admin extends Admin_class
{
    public function __construct()
    {

        parent::__construct();

        $this->id = "main";
        $this->title = "Sleeky UI Admin";
        $this->description = "Vtu Press Admin";
        $this->admin_url = plugin_dir_url(dirname(__FILE__)) . 'admin/';
        $this->admin_path = dirname(__DIR__) . '/admin/';
        add_action('admin_init', [$this, 'vtupress_remove_notices']);
        add_action("admin_init", [$this, "vtupress_init"]);

    }

    public function enqueue_admin_scripts($hook)
    {
        //enqueue admin scripts here
        // Enqueue only on your specific admin page
        if ($hook !== 'toplevel_page_vtupanel') {
            return;
        }


        wp_enqueue_media(); // ✅ THIS IS REQUIRED for wp.media to exist


        $ver = defined('WP_DEBUG') && WP_DEBUG ? time() : '1.0.0';

        wp_enqueue_style('vtupress-materialdesignicons.min', $this->admin_url . '/assets/vendors/mdi/css/materialdesignicons.min.css', array(), $ver);
        wp_enqueue_style('vtupress-themify-icons', $this->admin_url . '/assets/vendors/ti-icons/css/themify-icons.css', array(), $ver);
        wp_enqueue_style('vtupress-vendor.bundle.base', $this->admin_url . '/assets/vendors/css/vendor.bundle.base.css', array(), $ver);
        wp_enqueue_style('vtupress-font-awesome.min', $this->admin_url . '/assets/vendors/font-awesome/css/font-awesome.min.css', array(), $ver);
        wp_enqueue_style('vtupress-style', $this->admin_url . '/assets/css/style.css', array(), $ver);
        wp_enqueue_style('vtupress-style-vertical', $this->admin_url . '/assets/css/vertical-light/style.css', array(), $ver);
        wp_enqueue_style('vtupress-flag-icons.min', $this->admin_url . '/assets/vendors/flag-icon-css/css/flag-icons.min.css', array(), $ver);
        wp_enqueue_style('vtupress-simple-line-icons', $this->admin_url . '/assets/vendors/simple-line-icons/css/simple-line-icons.css', array(), $ver);
        wp_enqueue_style('vtupress-bootstrap-datepicker.min', $this->admin_url . '/assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css', array(), $ver);
        wp_enqueue_style('vtupress-select2.min', $this->admin_url . '/assets/vendors/select2/select2.min.css', array(), $ver);
        wp_enqueue_style('vtupress-select2-bootstrap.min', $this->admin_url . '/assets/vendors/select2-bootstrap-theme/select2-bootstrap.min.css', array(), $ver);
        wp_enqueue_style('vtupress-dropzone', $this->admin_url . '/assets/vendors/dropzone/dropzone.css', array(), $ver);
        wp_enqueue_style('vtupress-bars-1to10', $this->admin_url . '/assets/vendors/jquery-bar-rating/bars-1to10.css', array(), $ver);
        wp_enqueue_style('vtupress-bars-horizontal', $this->admin_url . '/assets/vendors/jquery-bar-rating/bars-horizontal.css', array(), $ver);
        wp_enqueue_style('vtupress-bars-movie', $this->admin_url . '/assets/vendors/jquery-bar-rating/bars-movie.css', array(), $ver);
        wp_enqueue_style('vtupress-bars-pill', $this->admin_url . '/assets/vendors/jquery-bar-rating/bars-pill.css', array(), $ver);
        wp_enqueue_style('vtupress-bars-reversed', $this->admin_url . '/assets/vendors/jquery-bar-rating/bars-reversed.css', array(), $ver);
        wp_enqueue_style('vtupress-bars-square', $this->admin_url . '/assets/vendors/jquery-bar-rating/bars-square.css', array(), $ver);
        wp_enqueue_style('vtupress-bootstrap-stars', $this->admin_url . '/assets/vendors/jquery-bar-rating/bootstrap-stars.css', array(), $ver);
        wp_enqueue_style('vtupress-css-stars', $this->admin_url . '/assets/vendors/jquery-bar-rating/css-stars.css', array(), $ver);
        wp_enqueue_style('vtupress-examples', $this->admin_url . '/assets/vendors/jquery-bar-rating/examples.css', array(), $ver);
        wp_enqueue_style('vtupress-fontawesome-stars-o', $this->admin_url . '/assets/vendors/jquery-bar-rating/fontawesome-stars-o.css', array(), $ver);
        wp_enqueue_style('vtupress-fontawesome-stars', $this->admin_url . '/assets/vendors/jquery-bar-rating/fontawesome-stars.css', array(), $ver);
        wp_enqueue_style('vtupress-fontawesome', $this->admin_url . '/assets/fontawesome/css/all.min.css', array(), $ver);
        wp_enqueue_style('vtupress-asColorPicker.min', $this->admin_url . '/assets/vendors/jquery-asColorPicker/css/asColorPicker.min.css', array(), $ver);
        wp_enqueue_style('vtupress-bootstrap-editable', $this->admin_url . '/assets/vendors/x-editable/bootstrap-editable.css', array(), $ver);
        wp_enqueue_style('vtupress-dropify.min', $this->admin_url . '/assets/vendors/dropify/dropify.min.css', array(), $ver);
        wp_enqueue_style('vtupress-uploadfile', $this->admin_url . '/assets/vendors/jquery-file-upload/uploadfile.css', array(), $ver);
        wp_enqueue_style('vtupress-jquery.tagsinput.min', $this->admin_url . '/assets/vendors/jquery-tags-input/jquery.tagsinput.min.css', array(), $ver);
        wp_enqueue_style('vtupress-tempusdominus-bootstrap-4.min', $this->admin_url . '/assets/vendors/tempusdominus-bootstrap-4/tempusdominus-bootstrap-4.min.css', array(), $ver);
        wp_enqueue_style('vtupress-quill.snow', $this->admin_url . '/assets/vendors/quill/quill.snow.css', array(), $ver);
        wp_enqueue_style('vtupress-simplemde.min', $this->admin_url . '/assets/vendors/simplemde/simplemde.min.css', array(), $ver);
        wp_enqueue_style('vtupress-codemirror', $this->admin_url . '/assets/vendors/codemirror/codemirror.css', array(), $ver);
        wp_enqueue_style('vtupress-ambiance', $this->admin_url . '/assets/vendors/codemirror/ambiance.css', array(), $ver);
        wp_enqueue_style('vtupress-morris', $this->admin_url . '/assets/vendors/morris.js/morris.css', array(), $ver);
        wp_enqueue_style('vtupress-c3.min', $this->admin_url . '/assets/vendors/c3/c3.min.css', array(), $ver);
        wp_enqueue_style('vtupress-chartist.min', $this->admin_url . '/assets/vendors/chartist/chartist.min.css', array(), $ver);
        wp_enqueue_style('vtupress-dataTables.bootstrap4', $this->admin_url . '/assets/vendors/datatables.net-bs4/dataTables.bootstrap4.css', array(), $ver);
        wp_enqueue_style('vtupress-jsgrid.min', $this->admin_url . '/assets/vendors/jsgrid/jsgrid.min.css', array(), $ver);
        wp_enqueue_style('vtupress-jsgrid-theme.min', $this->admin_url . '/assets/vendors/jsgrid/jsgrid-theme.min.css', array(), $ver);
        wp_enqueue_style('vtupress-jquery-jvectormap', $this->admin_url . '/assets/vendors/jvectormap/jquery-jvectormap.css', array(), $ver);
        wp_enqueue_style('vtupress-lightgallery', $this->admin_url . '/assets/vendors/lightgallery/css/lightgallery.css', array(), $ver);
        wp_enqueue_style('vtupress-custom', $this->admin_url . '/assets/css/custom.css', array(), $ver);
        wp_enqueue_style('vtupress-toastcss', $this->admin_url . '/assets/css/toast.css', array(), $ver);





        wp_enqueue_script('vtupress-vendor.bundle.base', $this->admin_url . '/assets/vendors/js/vendor.bundle.base.js', array(), $ver, true);
        wp_enqueue_script('vtupress-off-canvas', $this->admin_url . '/assets/js/off-canvas.js', array(), $ver, true);
        wp_enqueue_script('vtupress-misc', $this->admin_url . '/assets/js/misc.js', array(), $ver, true);
        wp_enqueue_script('vtupress-hoverable-collapse', $this->admin_url . '/assets/js/hoverable-collapse.js', array(), $ver, true);
        wp_enqueue_script('vtupress-settings', $this->admin_url . '/assets/js/settings.js', array(), $ver, true);
        wp_enqueue_script('vtupress-todolist', $this->admin_url . '/assets/js/todolist.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.cookie', $this->admin_url . '/assets/js/jquery.cookie.js', array(), $ver, true);
        wp_enqueue_script('vtupress-modal-demo', $this->admin_url . '/assets/js/modal-demo.js', array(), $ver, true);
        wp_enqueue_script('vtupress-progressbar.min', $this->admin_url . '/assets/vendors/progressbar.js/progressbar.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-progress-bar', $this->admin_url . '/assets/js/progress-bar.js', array(), $ver, true);
        wp_enqueue_script('vtupress-paginate', $this->admin_url . '/assets/js/paginate.js', array(), $ver, true);
        wp_enqueue_script('vtupress-tabs', $this->admin_url . '/assets/js/tabs.js', array(), $ver, true);
        wp_enqueue_script('vtupress-tooltips', $this->admin_url . '/assets/js/tooltips.js', array(), $ver, true);
        wp_enqueue_script('vtupress-popover', $this->admin_url . '/assets/js/popover.js', array(), $ver, true);
        wp_enqueue_script('vtupress-chart.umd', $this->admin_url . '/assets/vendors/chart.js/chart.umd.js', array(), $ver, true);
        wp_enqueue_script('vtupress-bootstrap-datepicker.min', $this->admin_url . '/assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-dashboard', $this->admin_url . '/assets/js/dashboard.js', array(), $ver, true);
        wp_enqueue_script('vtupress-select2.min', $this->admin_url . '/assets/vendors/select2/select2.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-typeahead.bundle.min', $this->admin_url . '/assets/vendors/typeahead.js/typeahead.bundle.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-file-upload', $this->admin_url . '/assets/js/file-upload.js', array(), $ver, true);
        wp_enqueue_script('vtupress-typeahead', $this->admin_url . '/assets/js/typeahead.js', array(), $ver, true);
        wp_enqueue_script('vtupress-select2', $this->admin_url . '/assets/js/select2.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.barrating.min', $this->admin_url . '/assets/vendors/jquery-bar-rating/jquery.barrating.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery-asColor.min', $this->admin_url . '/assets/vendors/jquery-asColor/jquery-asColor.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery-asGradient.min', $this->admin_url . '/assets/vendors/jquery-asGradient/jquery-asGradient.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery-asColorPicker.min', $this->admin_url . '/assets/vendors/jquery-asColorPicker/jquery-asColorPicker.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-bootstrap-editable.min', $this->admin_url . '/assets/vendors/x-editable/bootstrap-editable.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-moment.min', $this->admin_url . '/assets/vendors/moment/moment.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-tempusdominus-bootstrap-4', $this->admin_url . '/assets/vendors/tempusdominus-bootstrap-4/tempusdominus-bootstrap-4.js', array(), $ver, true);
        wp_enqueue_script('vtupress-dropify.min', $this->admin_url . '/assets/vendors/dropify/dropify.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.uploadfile.min', $this->admin_url . '/assets/vendors/jquery-file-upload/jquery.uploadfile.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.tagsinput.min', $this->admin_url . '/assets/vendors/jquery-tags-input/jquery.tagsinput.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-dropzone', $this->admin_url . '/assets/vendors/dropzone/dropzone.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.repeater.min', $this->admin_url . '/assets/vendors/jquery.repeater/jquery.repeater.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.inputmask.min', $this->admin_url . '/assets/vendors/inputmask/jquery.inputmask.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-formpickers', $this->admin_url . '/assets/js/formpickers.js', array(), $ver, true);
        wp_enqueue_script('vtupress-form-addons', $this->admin_url . '/assets/js/form-addons.js', array(), $ver, true);
        wp_enqueue_script('vtupress-x-editable', $this->admin_url . '/assets/js/x-editable.js', array(), $ver, true);
        wp_enqueue_script('vtupress-dropify', $this->admin_url . '/assets/js/dropify.js', array(), $ver, true);
        wp_enqueue_script('vtupress-dropzone', $this->admin_url . '/assets/js/dropzone.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery-file-upload', $this->admin_url . '/assets/js/jquery-file-upload.js', array(), $ver, true);
        wp_enqueue_script('vtupress-form-repeater', $this->admin_url . '/assets/js/form-repeater.js', array(), $ver, true);
        wp_enqueue_script('vtupress-inputmask', $this->admin_url . '/assets/js/inputmask.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.validate.min', $this->admin_url . '/assets/vendors/jquery-validation/jquery.validate.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-bootstrap-maxlength.min', $this->admin_url . '/assets/vendors/bootstrap-maxlength/bootstrap-maxlength.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-form-validation', $this->admin_url . '/assets/js/form-validation.js', array(), $ver, true);
        wp_enqueue_script('vtupress-bt-maxLength', $this->admin_url . '/assets/js/bt-maxLength.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.steps.min', $this->admin_url . '/assets/vendors/jquery-steps/jquery.steps.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-wizard', $this->admin_url . '/assets/js/wizard.js', array(), $ver, true);
        wp_enqueue_script('vtupress-tinymce.min', $this->admin_url . '/assets/vendors/tinymce/tinymce.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-quill.min', $this->admin_url . '/assets/vendors/quill/quill.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-simplemde.min', $this->admin_url . '/assets/vendors/simplemde/simplemde.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-editorDemo', $this->admin_url . '/assets/js/editorDemo.js', array(), $ver, true);
        wp_enqueue_script('vtupress-ace', $this->admin_url . '/assets/vendors/ace-builds/src-min/ace.js', array(), $ver, true);
        wp_enqueue_script('vtupress-mode-javascript', $this->admin_url . '/assets/vendors/ace-builds/src-min/mode-javascript.js', array(), $ver, true);
        wp_enqueue_script('vtupress-theme-chaos', $this->admin_url . '/assets/vendors/ace-builds/src-min/theme-chaos.js', array(), $ver, true);
        wp_enqueue_script('vtupress-codemirror', $this->admin_url . '/assets/vendors/codemirror/codemirror.js', array(), $ver, true);
        wp_enqueue_script('vtupress-javascript', $this->admin_url . '/assets/vendors/codemirror/javascript.js', array(), $ver, true);
        wp_enqueue_script('vtupress-shell', $this->admin_url . '/assets/vendors/codemirror/shell.js', array(), $ver, true);
        wp_enqueue_script('vtupress-codeEditor', $this->admin_url . '/assets/js/codeEditor.js', array(), $ver, true);
        wp_enqueue_script('vtupress-chart', $this->admin_url . '/assets/js/chart.js', array(), $ver, true);
        wp_enqueue_script('vtupress-morris', $this->admin_url . '/assets/vendors/morris.js', array(), $ver, true);
        wp_enqueue_script('vtupress-raphael.min', $this->admin_url . '/assets/vendors/raphael/raphael.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-morris.min', $this->admin_url . '/assets/vendors/morris.js/morris.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-morris-js', $this->admin_url . '/assets/js/morris.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.flot', $this->admin_url . '/assets/vendors/flot/jquery.flot.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.flot.resize', $this->admin_url . '/assets/vendors/flot/jquery.flot.resize.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.flot.categories', $this->admin_url . '/assets/vendors/flot/jquery.flot.categories.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.flot.fillbetween', $this->admin_url . '/assets/vendors/flot/jquery.flot.fillbetween.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.flot.stack', $this->admin_url . '/assets/vendors/flot/jquery.flot.stack.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.flot.pie', $this->admin_url . '/assets/vendors/flot/jquery.flot.pie.js', array(), $ver, true);
        wp_enqueue_script('vtupress-flot-chart', $this->admin_url . '/assets/js/flot-chart.js', array(), $ver, true);
        wp_enqueue_script('vtupress-google-charts', $this->admin_url . '/assets/js/google-charts.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.sparkline.min', $this->admin_url . '/assets/vendors/jquery-sparkline/jquery.sparkline.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-sparkline', $this->admin_url . '/assets/js/sparkline.js', array(), $ver, true);
        wp_enqueue_script('vtupress-d3.min', $this->admin_url . '/assets/vendors/d3/d3.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-c3', $this->admin_url . '/assets/vendors/c3/c3.js', array(), $ver, true);
        wp_enqueue_script('vtupress-c3', $this->admin_url . '/assets/js/c3.js', array(), $ver, true);
        wp_enqueue_script('vtupress-chartist.min', $this->admin_url . '/assets/vendors/chartist/chartist.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-chartist', $this->admin_url . '/assets/js/chartist.js', array(), $ver, true);
        wp_enqueue_script('vtupress-raphael-2.1.4.min', $this->admin_url . '/assets/vendors/justgage/raphael-2.1.4.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-justgage', $this->admin_url . '/assets/vendors/justgage/justgage.js', array(), $ver, true);
        wp_enqueue_script('vtupress-just-gage', $this->admin_url . '/assets/js/just-gage.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.dataTables', $this->admin_url . '/assets/vendors/datatables.net/jquery.dataTables.js', array(), $ver, true);
        wp_enqueue_script('vtupress-dataTables.bootstrap4', $this->admin_url . '/assets/vendors/datatables.net-bs4/dataTables.bootstrap4.js', array(), $ver, true);
        wp_enqueue_script('vtupress-data-table', $this->admin_url . '/assets/js/data-table.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jsgrid.min', $this->admin_url . '/assets/vendors/jsgrid/jsgrid.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-js-grid', $this->admin_url . '/assets/js/js-grid.js', array(), $ver, true);
        wp_enqueue_script('vtupress-db', $this->admin_url . '/assets/js/db.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jq.tablesort', $this->admin_url . '/assets/js/jq.tablesort.js', array(), $ver, true);
        wp_enqueue_script('vtupress-tablesorter', $this->admin_url . '/assets/js/tablesorter.js', array(), $ver, true);
        wp_enqueue_script('vtupress-google-maps', $this->admin_url . '/assets/js/google-maps.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery.mapael.min', $this->admin_url . '/assets/vendors/jquery-mapael/jquery.mapael.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-world_countries.min', $this->admin_url . '/assets/vendors/jquery-mapael/world_countries.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-usa_states.min', $this->admin_url . '/assets/vendors/jquery-mapael/usa_states.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-france_departments.min', $this->admin_url . '/assets/vendors/jquery-mapael/france_departments.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-mapael', $this->admin_url . '/assets/js/mapael.js', array(), $ver, true);
        wp_enqueue_script('vtupress-mapael_example_1', $this->admin_url . '/assets/js/mapael_example_1.js', array(), $ver, true);
        wp_enqueue_script('vtupress-mapael_example_2', $this->admin_url . '/assets/js/mapael_example_2.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery-jvectormap.min', $this->admin_url . '/assets/vendors/jvectormap/jquery-jvectormap.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-jquery-jvectormap-world-mill-en', $this->admin_url . '/assets/vendors/jvectormap/jquery-jvectormap-world-mill-en.js', array(), $ver, true);
        wp_enqueue_script('vtupress-maps', $this->admin_url . '/assets/js/maps.js', array(), $ver, true);
        wp_enqueue_script('vtupress-lightgallery-all.min', $this->admin_url . '/assets/vendors/lightgallery/js/lightgallery-all.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-light-gallery', $this->admin_url . '/assets/js/light-gallery.js', array(), $ver, true);
        wp_enqueue_script('vtupress-calendar', $this->admin_url . '/assets/js/calendar.js', array(), $ver, true);
        wp_enqueue_script('vtupress-profile-demo', $this->admin_url . '/assets/js/profile-demo.js', array(), $ver, true);
        wp_enqueue_script('vtupress-widgets', $this->admin_url . '/assets/js/widgets.js', array(), $ver, true);
        wp_enqueue_script('vtupress-todo', $this->admin_url . '/assets/js/todo.js', array(), $ver, true);

        wp_enqueue_script('jquery');
        // wp_enqueue_script('vtupress-jquery', $this->admin_url . '/assets/js/jquery.js', array('jquery'), $ver, true);
        wp_enqueue_script('vtupress-customjs', $this->admin_url . '/assets/js/custom.js', array(), $ver, true);
        wp_enqueue_script('vtupress-pdfjs', $this->admin_url . '/assets/js/pdfjs', array(), $ver, true);
        wp_enqueue_script("global-pdf-js", "https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js", [], '0.10.1');
        wp_enqueue_script('vtupress-printjs', $this->admin_url . '/assets/js/print.js', array(), $ver, true);
        wp_enqueue_script('vtupress-sweetjs', $this->admin_url . '/assets/js/sweet.js', array(), $ver, true);
        wp_enqueue_script('vtupress-sweet2-min-js', $this->admin_url . '/assets/js/sweet2.min.js', array(), $ver, true);
        wp_enqueue_script('vtupress-toastjs', $this->admin_url . '/assets/js/toast.js', array(), $ver, true);
        wp_enqueue_script('vtupress-loaderjs', $this->admin_url . '/assets/js/loader.js', array(), $ver, true);
        wp_enqueue_script('vtupress-bootboxjs', $this->admin_url . '/assets/js/bootbox.js', array(), $ver, true);



        // Pass AJAX URL and nonce to JavaScript
        wp_localize_script('vtupress-customjs', 'vtupressInitPluginData', array(
            'sales_total' => $this->admin_url . '/loader/total.php',
            'nonce' => wp_create_nonce('vtupress_nonce'),
            'ajax_url' => admin_url('admin-ajax.php'),
        ));
    }

    public function admin_init()
    {
        if (!current_user_can('vtupress_admin') && !current_user_can('administrator')) {
            wp_send_json_error('Invalid nonce');
            wp_die();
        }
        $this->country = Vtupress_Country_Context::get();
        $this->country_data = $this->country_data();
        $this->license_country = Vtupress_Country_Context::$license_country;
        $this->license_for = Vtupress_Country_Context::$license_for;

        //get user id
        $id = get_current_user_id();

        // if (Vtupress_option::get('vtupress_custom_active', 'no') == "yes"):
            if ($id) {
                //sync
                $users = new Users();
                $user = $users->getUser($id, true, true);
                if (empty($user)) {
                    //include into db
                    global $wpdb;
                    $vtupress_table = $wpdb->prefix . 'vtupress_users';
                    // Example usage
                    $apiKey = generateApiKey();
                    $wpdb->insert(
                        $vtupress_table,
                        [
                            'userId' => $id,
                            'apikey' => $apiKey
                        ],
                        [
                            '%d',
                            '%s'
                        ]
                    );
                }
            }
        // endif;
    }

    public function render_admin_page()
    {

        $this->admin_init();
        $brun = ($this->get_option("vtupress_custom_active", false) == "yes") ? true : false;
        $country = $this->country_data['country'];
        $iso = $this->country_data['iso'];
        $flag = $this->country_data['flag'];
        $currency = $this->country_data['currency'];
        $currency_symbol = $this->country_data['currency_symbol'];
        $country_code = $this->country_data['country_code'];
        $slogan = $this->country_data['slogan'];
        $country_networks = $this->country_data['country_networks'];
        $currency_name = $this->country_data['currency_name'];
        global $images_url;
        $images_url = $this->images_url;

        include_once($this->globals_path . '/admin/admin_globals.php');
        include_once($this->globals_path . '/admin/admin.php');
    }

    public function user_ajax()
    {
        if (!$this->verify_nonce()) {
            wp_send_json_error('Invalid nonce');
            wp_die();
        }
        $this->admin_init();

        $country = $this->country_data['country'];
        $iso = $this->country_data['iso'];
        $flag = $this->country_data['flag'];
        $currency = $this->country_data['currency'];
        $currency_symbol = $this->country_data['currency_symbol'];
        $country_code = $this->country_data['country_code'];
        $slogan = $this->country_data['slogan'];
        $country_networks = $this->country_data['country_networks'];
        $currency_name = $this->country_data['currency_name'];

        include $this->globals_path . "/admin/process/control.php";
        wp_die();
    }

    public function guest_ajax()
    {
        if (!$this->verify_nonce()) {
            wp_send_json_error('Invalid nonce');
        }
        // include vtupress_globals_admin_path . "/process/control.php";
    }

}

function vtupress_admin_ui()
{
    static $admin_ui = null;

    if ($admin_ui !== null) {
        return $admin_ui;
    }

    $admin_ui = [];
    $admin_ui['admin'] = 'Vtupress_Admin';

    // Let other classes register safely
    $admin_ui = apply_filters('vtupress_get_admin_ui', $admin_ui);


    return $admin_ui;
}


add_action('wp_ajax_switch_admin_country', 'switch_admin_country');

function switch_admin_country()
{
    if (!is_admin()) {
        die("Not Admin");
    }

    $country = sanitize_text_field($_POST['country']);

    // 1. Update Global Option (Main Business Country)
    Vtupress_Option::update('vtupress_business_country', $country);

    // 2. Update Current User Meta (Per-User Context)
    $user_id = get_current_user_id();
    update_user_meta($user_id, 'set_country', $country);

    // 3. Initialize Defaults (Idempotent)
    if (class_exists('Vtupress_Country_Manager')) {
        Vtupress_Country_Manager::initialize_defaults($country);
    }

    echo "success";
    die();
}
