<?php

if (!defined('ABSPATH')) {
  die("Not Allowed");
}

require_once ABSPATH . 'wp-admin/includes/upgrade.php';



global $wpdb, $charset_collate, $country;
$country = Vtupress_Country_Context::get();
$charset_collate = $wpdb->get_charset_collate();
################
# 
# 
# UPGRADED DBS
# 
################
function create_serviceDatabases()
{

  global $wpdb, $charset_collate, $country;

  $table = $wpdb->prefix . 'vtupress_servicePlans';

  $sql = "CREATE TABLE IF NOT EXISTS $table (
    id int NOT NULL AUTO_INCREMENT,

    service_name VARCHAR(50) NOT NULL,
    service_type VARCHAR(50) NOT NULL DEFAULT '',

    plan_id VARCHAR(50) NOT NULL,
    plan_name VARCHAR(191) NOT NULL DEFAULT '',

    plan_price VARCHAR(50) NOT NULL DEFAULT '',
    listOrder INT NOT NULL DEFAULT 0,

    prefix VARCHAR(50) DEFAULT '',
    surfix VARCHAR(10) DEFAULT '',

    duration_figure INT NOT NULL DEFAULT 0,
    duration_time VARCHAR(20) NOT NULL DEFAULT '',

    network VARCHAR(50) NOT NULL DEFAULT '',

    set_country VARCHAR(100) NOT NULL DEFAULT '$country',

    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id),
    UNIQUE KEY service_plan_unique (service_name, service_type, plan_id),
    KEY service_lookup (service_name, service_type),
    KEY network_lookup (network)
) $charset_collate;";

  dbDelta($sql);


}

function create_userDatabase()
{
  //userId is the wordpress ID;
  global $wpdb, $charset_collate, $country, $status, $message, $level, $done_code;

  $vtupress_users_table = $wpdb->prefix . 'vtupress_users';


  $sql = "CREATE TABLE IF NOT EXISTS $vtupress_users_table(
  id int NOT NULL AUTO_INCREMENT,
  plan VARCHAR(100) NOT NULL DEFAULT 'customer',
  apikey VARCHAR(100) NOT NULL DEFAULT '',
  phone VARCHAR(100) NOT NULL DEFAULT '',
  pin INT NOT NULL DEFAULT '1234',
  balance DECIMAL(20,2) NOT NULL DEFAULT 0.00,
  referral_rewards DECIMAL(20,2) NOT NULL DEFAULT 0.00,
  last_name VARCHAR(100) NOT NULL DEFAULT '',
  first_name VARCHAR(100) NOT NULL DEFAULT '',
  referrer_id VARCHAR(50) NOT NULL DEFAULT 1,
  referrers VARCHAR(500) NOT NULL DEFAULT '[]',
  about text,
  indirect_referrers VARCHAR(500) NOT NULL DEFAULT '[]',
  other_referrers VARCHAR(500) NOT NULL DEFAULT '[]',
  referral_commission DECIMAL(20,2) NOT NULL DEFAULT 0.00,
  indirect_referral_commission DECIMAL(20,2) NOT NULL DEFAULT 0.00,
  other_referral_commission DECIMAL(20,2) NOT NULL DEFAULT 0.00,
  referee_transaction DECIMAL(20,2) NOT NULL DEFAULT 0.00,
  indirect_referee_transaction DECIMAL(20,2) NOT NULL DEFAULT 0.00,
  other_referee_transaction DECIMAL(20,2) NOT NULL DEFAULT 0.00,
  email_verified VARCHAR(10) NOT NULL DEFAULT 'no',
  beneficiaries text,
  fix_version text,
  all_plans text,
  run_code text,
  kyc_status text,
  address text,
  bvn VARCHAR(100) NOT NULL DEFAULT '',
  nin VARCHAR(100) NOT NULL DEFAULT '',
  userId int,
  reset_code text,
  photo LONGTEXT,
  raptor_response_status text,
  reset_code_for text,
  access_status VARCHAR(255) DEFAULT 'allowed',
  last_active TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id) )$charset_collate;";
  dbDelta($sql);
}
function create_s_transaction()
{

  global $wpdb, $charset_collate, $country;

  //service includes transfer, airtime, data and the likes
  $table_name = $wpdb->prefix . 'vtupress_transactions';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $table_name(
  id int NOT NULL AUTO_INCREMENT,
  user_id int,
  service VARCHAR(30) NOT NULL,
  recipient VARCHAR(100) NOT NULL,
  amount DECIMAL(10,2) NOT NULL,
  status VARCHAR(20) DEFAULT 'pending',
  via VARCHAR(20) DEFAULT 'frontend',
  reference VARCHAR(100) NOT NULL,
  response_message TEXT NULL,
  details JSON NULL,
  balance_before text,
  balance_now text,
  run_code text,
  profit BIGINT NOT NULL DEFAULT 0,
  description text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
  /*

  $wpdb->insert(
  $wpdb->prefix . 'vtupress_transactions',
  [
    'user_id'   => $user_id,
    'service'   => 'data',
    'service_type' => 'vtu',
    'recipient' => $phone,
    'amount'    => $amount,
    'status'    => 'success',
    'gateway'   => 'paystack',
    'details'   => wp_json_encode([
        'network' => 'mtn',
        'plan_id' => 1,
        'plan'    => '100GB'
    ]),
  ],
  ['%d','%s','%s','%s','%f','%s','%s','%s']
);


$tx = $wpdb->get_row("SELECT * FROM {$table} WHERE id = 100");

$details = json_decode($tx->details, true);

if ($tx->service === 'data') {
    echo $details['plan'];
}

if ($tx->service === 'airtime') {
    echo $details['network'];
}

  SELECT SUM(amount)
FROM wp_vtupress_transactions
WHERE service = 'data'
AND JSON_EXTRACT(details, '$.network') = 'mtn';

*/

  $table_name = $wpdb->prefix . 'vtupress_webhook';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $table_name(
  id int NOT NULL AUTO_INCREMENT,
  service text,
  service_id text,
  request_id text,
  response_id text,
  resp_log text,
  the_time text ,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  server_ip text,
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
}

function create_gatewaysApi()
{
  global $wpdb, $charset_collate, $status, $message, $level, $done_code;
}

function create_userAccounts()
{
  global $wpdb, $charset_collate, $country, $status, $message, $level, $done_code;

  $vtupress_userAccounts_table = $wpdb->prefix . 'vtupress_userAccounts';

  $sql = "CREATE TABLE IF NOT EXISTS $vtupress_userAccounts_table (
  id int NOT NULL AUTO_INCREMENT,
  userId text,
  bankName text,
  accountName text,
  accountNumber text,
  accountRef text,
  gateway text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id) )$charset_collate;";
  dbDelta($sql);

}

function create_generalSettingsDb()
{

  global $wpdb, $country;
  $stable_name = $wpdb->prefix . 'vtupress_general_settings';
  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE IF NOT EXISTS $stable_name(
  id int,
  debug text ,
  enable_registration text,
  enable_email_verification VARCHAR(50) NOT NULL DEFAULT 'no',
  refund_failed_transaction text,
  idle_timeout text,
  admin_phone text,
  admin_whatsapp text,
  whatsapp_group_link text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);


  $add = [
    'id' => 1,
    'debug' => 'true',
    'enable_registration' => 'true',
    'refund_failed_transaction' => 'yes',
    'idle_timeout' => '10',
    'admin_phone' => '+234800000000',
    'admin_whatsapp' => '+234900000000',
    'whatsapp_group_link' => 'https://chat.whatsapp.com/ABC123'

  ];

  $result = $wpdb->get_results("SELECT * FROM $stable_name WHERE id = '1'");
  if (empty($result)) {
    $wpdb->insert($stable_name, $add);
  } else {
    // Check if column exists, if not modify table
    $row = $wpdb->get_results("SHOW COLUMNS FROM $stable_name LIKE 'refund_failed_transaction'");
    if (empty($row)) {
      $wpdb->query("ALTER TABLE $stable_name ADD refund_failed_transaction text DEFAULT 'yes'");
    }
  }

}

function create_raptorSettingsDb()
{

  global $wpdb, $country;
  $stable_name = $wpdb->prefix . 'vtupress_raptor_settings';
  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE IF NOT EXISTS $stable_name(
  id int,
  enable_raptor text,
  enable_raptor_printing text,
  bvn_charge text,
  nin_charge text,
  custom_nin_charge text,
  custom_bvn_charge text,
  raptor_apiKey text,
  raproc text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  raptor_connectionid text,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);

  maybe_add_column($stable_name, "custom_bvn_charge", "ALTER TABLE $stable_name ADD custom_bvn_charge text");
  maybe_add_column($stable_name, "custom_nin_charge", "ALTER TABLE $stable_name ADD custom_nin_charge text");
  maybe_add_column($stable_name, "raproc", "ALTER TABLE $stable_name ADD raproc text");
  maybe_add_column($stable_name, "enable_raptor_printing", "ALTER TABLE $stable_name ADD enable_raptor_printing text");

  $add = [
    'id' => 1,
    'enable_raptor' => 'false',
    'bvn_charge' => '200',
    'nin_charge' => '200',
    'custom_nin_charge' => '200',
    'custom_bvn_charge' => '200',
    'raproc' => 'false',
    'enable_raptor_printing' => 'false',
    'raptor_apiKey' => 'your_raptor_api_key',
    'raptor_connectionid' => 'your_raptor_connectionid'
  ];
  $result = $wpdb->get_results("SELECT * FROM $stable_name WHERE id = '1'");
  if (empty($result)) {
    $wpdb->insert($stable_name, $add);
  }



}

function create_transactionSettingsDb()
{
  #fund_required forces users to fund their account to use service

  global $wpdb, $country;
  $stable_name = $wpdb->prefix . 'vtupress_transaction_settings';
  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE IF NOT EXISTS $stable_name(
  id int,
  hide_why text,
  enable_beneficiary text,
  auto_refund text,
  fund_required text,
  enable_total_spent text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
  $add = [
    'id' => 1,
    'hide_why' => 'false',
    'enable_beneficiary' => 'true',
    'auto_refund' => 'yes',
    'fund_required' => 'true'
  ];
  $result = $wpdb->get_results("SELECT * FROM $stable_name WHERE id = '1'");
  if (empty($result)) {
    $wpdb->insert($stable_name, $add);
  }

  maybe_add_column($stable_name, "enable_total_spent", "ALTER TABLE $stable_name ADD enable_total_spent text");


}

function create_notificationSettingsDb()
{
  #banking_notification - withdraw and transfer notifications
  #user/admin_notification - allow user or admin to receive a copy of the notification

  global $wpdb, $country;
  $stable_name = $wpdb->prefix . 'vtupress_notification_settings';
  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE IF NOT EXISTS $stable_name(
  id int,
  enable_email_notification text,
  enable_sms_notification text,
  popup_notification text,
  banking_notification text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  kyc_notification text,
  admin_notification text,
  user_notification text,
  popup_message text,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
  $add = [
    'id' => 1,
    'enable_email_notification' => 'no',
    'enable_sms_notification' => 'no',
    'popup_notification' => 'no',
    'banking_notification' => 'no',
    'kyc_notification' => 'no',
    'admin_notification' => 'no',
    'user_notification' => 'no',
    'popup_message' => 'Welcome to our site'
  ];
  $result = $wpdb->get_results("SELECT * FROM $stable_name WHERE id = '1'");
  if (empty($result)) {
    $wpdb->insert($stable_name, $add);
  }

}


function create_membership_rule_stats()
{
  global $wpdb, $country;
  $stable_name = $wpdb->prefix . 'vtupress_membership_rule_stats';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $stable_name(
  id int NOT NULL AUTO_INCREMENT,
  ref text ,
  transaction_number text ,
  transaction_amount text ,
  user_id int ,
  start_count text ,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
}

function create_vtupress_coupon()
{
  global $wpdb, $country;
  $stable_name = $wpdb->prefix . 'vtupress_coupon';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $stable_name(
  id int NOT NULL AUTO_INCREMENT,
  code text ,
  applicable_to text ,
  amount text ,
  used_by text,
  status text,
  the_time text ,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
}


function create_messagedb()
{
  global $wpdb, $country;
  $stable_name = $wpdb->prefix . 'vtupress_message';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $stable_name(
  id int NOT NULL AUTO_INCREMENT,
  user_id text ,
  user_name text ,
  user_token text ,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
}


function create_vend_lock_db()
{
  global $wpdb;
  $vend_lock = $wpdb->prefix . 'vtupress_vend_lock';
  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE IF NOT EXISTS $vend_lock (
      id BIGINT AUTO_INCREMENT PRIMARY KEY,
      vend VARCHAR(100) NOT NULL,
      user_id BIGINT NOT NULL,
      created_at DATETIME NOT NULL,
      UNIQUE KEY uniq_user (user_id)
  ) $charset_collate engine=InnoDB;";
  dbDelta($sql);
}

function vtupress_create_chat()
{
  global $wpdb, $country;
  $sd_name = $wpdb->prefix . 'vtupress_chat';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $sd_name(
  id int NOT NULL  AUTO_INCREMENT,
  user_id int,
  name text,
  message text,
  type text,
  status text,
  attachment text,
  the_time text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
}


function vtupress_verification()
{
  global $wpdb, $country;
  $sd_name = $wpdb->prefix . 'vtupress_verifications';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $sd_name(
  id int NOT NULL  AUTO_INCREMENT,
  user_id int,
  name text,
  card_type text,
  value text,
  type text,
  status text,
  fund_amount text,
  before_amount text,
  now_amount text,
  vDatas text,
  the_time text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  dbDelta($sql);
}


function vtupress_create_notification()
{
  global $wpdb, $country;
  $sd_name = $wpdb->prefix . 'vtupress_notifications';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $sd_name(
 id int NOT NULL AUTO_INCREMENT,
 user_id int,
 title text,
 type text,
 admin_link text,
 user_link text,
 status text,
 message text,
 the_time text,
 set_country VARCHAR(100) NOT NULL DEFAULT '$country',
 PRIMARY KEY (id))$charset_collate;";
  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  dbDelta($sql);
}

function vtupress_create_monwebhook()
{
  global $wpdb, $country;
  $sd_name = $wpdb->prefix . 'vtupress_wallet_webhook';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $sd_name(
  id int NOT NULL AUTO_INCREMENT,
  user_id int,
  gateway text,
  amount text,
  referrence text,
  status text,
  response text,
  the_time text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  dbDelta($sql);
}


function create_pv_rules()
{
  global $wpdb, $country;
  $sd_name = $wpdb->prefix . 'vtupress_pv_rules';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $sd_name(
  id int NOT NULL AUTO_INCREMENT,
  required_pv text,
  upgrade_plan text,
  upgrade_balance text,
  status text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
}


function vtupress_add_message()
{
  global $wpdb, $country;
  $sd_name = $wpdb->prefix . 'vtupress_chat';
  $wpdb->insert($sd_name, array(
    'user_id' => "1",
    'name' => 'Akor Victor',
    'message' => "Welcome To VTUPRESS. It is a priviledge to add this wonderful MINI chat system!",
    'type' => "received",
    'status' => "unread",
    'attachment' => "none",
    'the_time' => date(current_time('mysql') . ' A')
  ));
}

function vtupress_levels()
{
  //recurring is either yes or no
  //monthly_sales_target amount a user must buy in one month to maintain a plan
  global $wpdb, $country;
  $table_name = $wpdb->prefix . 'vtupress_levels';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $table_name(
  id int NOT NULL AUTO_INCREMENT,
  name text,
  status VARCHAR(255) NOT NULL DEFAULT 'inactive',
  renewal_airtime VARCHAR(255) NOT NULL DEFAULT '0',
  renewal_data VARCHAR(255) NOT NULL DEFAULT '0',
  renewal_data_type VARCHAR(255) NOT NULL DEFAULT 'sme',
  renewal_data_volume VARCHAR(255) NOT NULL DEFAULT 'mb',
  upgrade_amount VARCHAR(255) NOT NULL DEFAULT '1000',
  recurring VARCHAR(255) NOT NULL DEFAULT 'no',
  upgrade_bonus VARCHAR(255) NOT NULL DEFAULT '0',
  monthly_sales_target VARCHAR(255) NOT NULL DEFAULT '0',
  monthly_orders_target VARCHAR(255) NOT NULL DEFAULT '0',
  monthly_referer_target VARCHAR(255) NOT NULL DEFAULT '0',
  upgrade_pv VARCHAR(255) NOT NULL DEFAULT '0',
  developer VARCHAR(255) NOT NULL DEFAULT 'no',
  referer_upgrade_bonus VARCHAR(255) NOT NULL DEFAULT '0',
  referer_upgrade_pv VARCHAR(255) NOT NULL DEFAULT '0',
  referer_fund_bonus VARCHAR(255) NOT NULL DEFAULT '0',
  referer_fund_minimum VARCHAR(255) NOT NULL DEFAULT '0',
  referer_fund_count VARCHAR(255) NOT NULL DEFAULT '1',
  referer_transaction_bonus VARCHAR(255) NOT NULL DEFAULT '0',
  transfer VARCHAR(255) NOT NULL DEFAULT 'no',
  total_level INT NOT NULL DEFAULT '0',
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);

  maybe_add_column($table_name, "total_level", "ALTER TABLE $table_name ADD total_level INT NOT NULL DEFAULT '0'");

  global $wpdb;
  $table_name = $wpdb->prefix . "vtupress_levels";
  $customer = $wpdb->get_results("SELECT * FROM $table_name WHERE name = 'customer'");
  $reseller = $wpdb->get_results("SELECT * FROM $table_name WHERE name = 'reseller'");

  if ($reseller == NULL) {
    $wpdb->insert($table_name, array(
      'name' => "reseller",
      'status' => "active"
    ));
  }

  if ($customer == NULL) {
    $wpdb->insert($table_name, array(
      'name' => "customer",
      'status' => "active"
    ));
  }

  // LEVEL REF COM
  $vtupress_level_discount = $wpdb->prefix . 'vtupress_levelGeneration';

  $sql = "CREATE TABLE IF NOT EXISTS  $vtupress_level_discount(
    id int NOT NULL AUTO_INCREMENT,
    package_name text ,
    service_name text ,
    service_type text ,
    generation text,
    pv text,
    transaction_commission text,
    fund_commission text,
    fund_minimum text,
    fund_count text,
    set_country VARCHAR(100) NOT NULL DEFAULT '$country',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id) )$charset_collate;";
  dbDelta($sql);
  //LEVEL REF COM


}

function vtupress_level_service_rewards()
{
  global $wpdb, $country;
  $table_name = $wpdb->prefix . 'vtupress_level_service_rewards';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $table_name(
    id int NOT NULL AUTO_INCREMENT,
    level_name text,
    service_id text,
    bonus_value text,
    bonus_type VARCHAR(100) NOT NULL DEFAULT 'tiered',
    set_country VARCHAR(100) NOT NULL DEFAULT '$country',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);

  maybe_add_column($table_name, "bonus_type", "ALTER TABLE $table_name ADD bonus_type VARCHAR(100) NOT NULL DEFAULT 'tiered'");
}


function vtupress_kyc()
{
  global $wpdb, $country;
  $table_name = $wpdb->prefix . 'vtupress_kyc';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $table_name(
  id int NOT NULL AUTO_INCREMENT,
  name text,
  method text,
  selfie text,
  proof text,
  user_id int,
  status text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  the_time text NOT NULL,
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
}

function vtupress_kyc_settings()
{
  global $wpdb, $country;
  $table_name = $wpdb->prefix . 'vtupress_kyc_settings';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $table_name(
  id int NOT NULL AUTO_INCREMENT,
  enable text,
  duration text,
  kyc_limit text,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);

  global $wpdb;
  $kyc = $wpdb->get_results("SELECT * FROM $table_name WHERE id = 1");
  if ($kyc == NULL) {
    $wpdb->insert($table_name, array(
      'enable' => "no",
      'duration' => "day",
      'kyc_limit' => "1000"
    ));
  }


}


function create_walletDatabase()
{
  global $wpdb, $charset_collate;
  $table_name = $wpdb->prefix . 'vtupress_wallet';
  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE IF NOT EXISTS $table_name (
      id BIGINT(20) NOT NULL AUTO_INCREMENT,
      type VARCHAR(50) NOT NULL,
      name VARCHAR(255) NULL,
      fund_amount DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      before_amount DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      now_amount DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      user_id BIGINT(20) NOT NULL,
      status VARCHAR(50) NOT NULL DEFAULT 'success',
      the_time DATETIME DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (id)
  ) $charset_collate;";

  dbDelta($sql);
}

function create_vpaccount()
{

  $user_ID = 1;

  $query = new WP_Query(array('pagename' => 'vpaccount'));

  if (!$query->have_posts()) {
    $new_post = array(
      'post_title' => 'VTU DASHBOARD',
      'post_name' => 'vpaccount',
      'post_content' => '[vpaccount]',
      'post_status' => 'publish',
      'post_date' => date('Y-m-d H:i:s', time()),
      'post_author' => $user_ID,
      'post_type' => 'page'
    );
    $post_id = wp_insert_post($new_post);
  }


}


// function custom_vtupress_init(){

// global $wpdb;
// $vtupress_service_table = $wpdb->prefix.'vtupress_services';
// $wpdb->update($vtupress_service_table,["fixedPrice" => "no"],["name"=>"sms"]);





// }

function create_internal_pin_db()
{
  global $wpdb, $country;
  $table_name = $wpdb->prefix . 'vtupress_internal_pins';
  $charset_collate = $wpdb->get_charset_collate();
  $sql = "CREATE TABLE IF NOT EXISTS $table_name(
  id int NOT NULL AUTO_INCREMENT,
  service_id VARCHAR(50) NOT NULL,
  plan_id VARCHAR(50) NOT NULL,
  price INT NOT NULL DEFAULT 0,
  value VARCHAR(50) DEFAULT '',
  type VARCHAR(50) DEFAULT 'local',
  pin TEXT NOT NULL,
  serial TEXT,
  status VARCHAR(20) DEFAULT 'unused',
  used_by INT DEFAULT NULL,
  used_at DATETIME DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  set_country VARCHAR(100) NOT NULL DEFAULT '$country',
  PRIMARY KEY (id))$charset_collate;";
  dbDelta($sql);
}

function create_savings_tables()
{
  global $wpdb, $charset_collate;
  
  // Savings Products
  $table_products = $wpdb->prefix . 'vtupress_savings_products';
  $sql_products = "CREATE TABLE IF NOT EXISTS $table_products (
      id INT AUTO_INCREMENT PRIMARY KEY,
      name VARCHAR(191) NOT NULL,
      type VARCHAR(50) NOT NULL DEFAULT 'fixed',
      amount DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      cycle_value INT NOT NULL DEFAULT 30,
      cycle_type VARCHAR(20) NOT NULL DEFAULT 'day',
      liquidation_charge DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      liquidation_charge_type VARCHAR(20) NOT NULL DEFAULT 'percent',
      withdrawal_charge DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      withdrawal_charge_type VARCHAR(20) NOT NULL DEFAULT 'percent',
      interest_rate DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      status VARCHAR(20) NOT NULL DEFAULT 'active',
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
  ) $charset_collate;";
  dbDelta($sql_products);

  // Savings Accounts
  $table_accounts = $wpdb->prefix . 'vtupress_savings_accounts';
  $sql_accounts = "CREATE TABLE IF NOT EXISTS $table_accounts (
      id BIGINT AUTO_INCREMENT PRIMARY KEY,
      user_id BIGINT NOT NULL,
      product_id INT NOT NULL,
      balance DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      status VARCHAR(20) NOT NULL DEFAULT 'active',
      start_date DATETIME DEFAULT NULL,
      end_date DATETIME DEFAULT NULL,
      last_saving_date DATETIME DEFAULT NULL,
      auto_deduct_enabled VARCHAR(3) NOT NULL DEFAULT 'no',
      auto_deduct_amount DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      auto_deduct_frequency VARCHAR(20) DEFAULT NULL,
      next_auto_deduct_date DATETIME DEFAULT NULL,
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      KEY user_id (user_id),
      KEY product_id (product_id),
      KEY auto_deduct (auto_deduct_enabled, next_auto_deduct_date)
  ) $charset_collate;";
  dbDelta($sql_accounts);

  // Savings Transactions (History)
  $table_transactions = $wpdb->prefix . 'vtupress_savings_transactions';
  $sql_transactions = "CREATE TABLE IF NOT EXISTS $table_transactions (
      id BIGINT AUTO_INCREMENT PRIMARY KEY,
      account_id BIGINT NOT NULL,
      user_id BIGINT NOT NULL,
      type VARCHAR(50) NOT NULL,
      amount DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      balance_after DECIMAL(20,2) NOT NULL DEFAULT 0.00,
      description TEXT,
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      KEY account_id (account_id),
      KEY user_id (user_id)
  ) $charset_collate;";
  dbDelta($sql_transactions);
}

function vtupress_sortDbs()
{
  create_vpaccount();
  create_serviceDatabases();
  create_userDatabase();
  create_gatewaysApi();
  create_userAccounts();
  create_generalSettingsDb();
  create_raptorSettingsDb();
  create_transactionSettingsDb();
  create_notificationSettingsDb();
  create_membership_rule_stats();
  create_vtupress_coupon();
  vtupress_verification();
  vtupress_create_notification();
  vtupress_create_monwebhook();
  create_pv_rules();
  create_messagedb();
  vtupress_create_chat();
  create_walletDatabase();
  create_s_transaction();
  vtupress_add_message();
  vtupress_levels();
  vtupress_kyc();
  vtupress_kyc_settings();
  create_vend_lock_db();
  vtupress_level_service_rewards();
  create_internal_pin_db();
  create_savings_tables();
}




?>