<?php
/**
 * VTUPress Menu Walker Fix
 * * Fixed the issue where sub-menu items were not appearing due to redundant
 * container tags being generated in both start_el and start_lvl.
 */

defined( 'ABSPATH' ) || exit;

//OLD and deprecated
class VTUPress_Menu_Walker extends Walker_Nav_Menu {

    /**
     * Starts the list before the elements are added.
     * This handles the opening of the sub-menu container.
     */
    public function start_lvl( &$output, $depth = 0, $args = null ) {
        // We use the ID passed from start_el if we want to target specific collapses,
        // but typically standard Bootstrap walkers handle the wrapping here.
        $output .= '<div class="collapse" id="sub-menu-' . $depth . '"><ul class="nav nav-collapse">';
    }

    /**
     * Ends the list of after the elements are added.
     */
    public function end_lvl( &$output, $depth = 0, $args = null ) {
        $output .= '</ul></div>';
    }

    /**
     * Start the element output.
     */
    public function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        $has_children = in_array( 'menu-item-has-children', $item->classes );
        $url          = esc_url( $item->url );
        $title        = esc_html( $item->title );

        // Icon extraction: from CSS class OR default
        $icon = 'fas fa-angle-right';
        if ( ! empty( $item->classes ) ) {
            foreach ( $item->classes as $class ) {
                if ( strpos( $class, 'fa-' ) !== false ) {
                    $icon = esc_attr( $class );
                    break;
                }
            }
        }

        // Active state
        $active = $this->is_active( $item ) ? 'active' : '';
        
        // Unique ID for collapse functionality
        $control_id = 'vtupress_' . $item->ID;

        // Start Li
        $output .= '<li class="nav-item ' . $active . '">';

        if ( ! $has_children ) {
            // 🔹 SIMPLE ITEM
            $output .= '
                <a href="' . $url . '">
                    <i class="' . $icon . '"></i>
                    <p>' . $title . '</p>
                </a>';
        } else {
            // 🔹 DROPDOWN ITEM
            // We only output the Link here. The <ul> wrapper is handled by start_lvl.
            $output .= '
                <a data-toggle="collapse" href="#' . $control_id . 'Control" 
                   aria-expanded="false" aria-controls="' . $control_id . 'Control" class="collapsed">
                    <i class="' . $icon . '"></i>
                    <p>' . $title . '</p>
                    <span class="caret"></span>
                </a>';
            
            /**
             * CRITICAL CHANGE:
             * We do NOT open the <div><ul> here anymore. 
             * WordPress will automatically call start_lvl() immediately after this 
             * because $has_children is true.
             * * We just need to make sure start_lvl uses the correct ID.
             * Since start_lvl doesn't easily know the parent ID, we can adjust start_lvl 
             * or manually inject the opening div here if we want specific IDs.
             * * Updated strategy: Open the div here, but keep start_lvl for the <ul> only.
             */
             $output .= '<div class="collapse" id="' . $control_id . 'Control">';
        }
    }

    /**
     * End the element output.
     */
    public function end_el( &$output, $item, $depth = 0, $args = null ) {
        if ( in_array( 'menu-item-has-children', $item->classes ) ) {
            $output .= '</div>'; // Close the collapse div opened in start_el
        }
        $output .= '</li>';
    }

    /**
     * Logic for active menu items.
     */
    private function is_active( $item ) {
        if ( empty( $item->url ) || $item->url == '#' ) {
            return false;
        }
        
        $current_url = trim( parse_url( $_SERVER['REQUEST_URI'], PHP_URL_PATH ), '/' );
        $item_url    = trim( parse_url( $item->url, PHP_URL_PATH ), '/' );

        return $current_url === $item_url;
    }

    /**
     * Register locations.
     */
    public static function menus_location() {
        register_nav_menus( [
            'vtupress-main'   => __( 'Before Vtupress Services', 'vtupress' ),
            'vtupress-footer' => __( 'After Vtupress services', 'vtupress' ),
        ] );
    }
}