<?php

if (!defined('ABSPATH'))
    exit;

use Elementor\Plugin;

class Vtupress_Renderer
{

    /**
     * Preload Elementor assets for a given post ID.
     * IMPORTANT: This must be called before wp_head() in template.php
     */
    public static function preload($post_id = null)
    {
        if (!$post_id) {
            $post_id = get_the_ID();
        }

        if (self::is_elementor() && self::is_built_with_elementor($post_id)) {
            // Force Elementor to register its CSS for this specific ID
            if (class_exists('\Elementor\Core\Files\CSS\Post')) {
                $css_file = new \Elementor\Core\Files\CSS\Post($post_id);
                $css_file->enqueue();
            }

            // Enqueue core Elementor assets
            Plugin::instance()->frontend->enqueue_styles();
            Plugin::instance()->frontend->enqueue_scripts();
        }
    }

    /**
     * Render post content safely (Elementor-aware).
     * @param int|null $post_id Pass a specific ID to render content from another page
     */
    public static function render($post_id = null)
    {

        if (!$post_id) {
            return;
        }

        global $post;
        $post = get_post($post_id);

        if (!$post) {
            return;
        }

        setup_postdata($post);

        if (self::is_elementor() && self::is_built_with_elementor($post_id)) {

            // DO NOT use elementor_theme_do_location inside dashboard
            echo Plugin::instance()->frontend->get_builder_content($post_id, true);

        } else {

            echo apply_filters('the_content', $post->post_content);

        }

        wp_reset_postdata();
    }

    /**
     * Check if Elementor is active.
     */
    private static function is_elementor(): bool
    {
        return defined('ELEMENTOR_VERSION') && class_exists('\Elementor\Plugin');
    }

    /**
     * Check if current post is built with Elementor.
     */
    private static function is_built_with_elementor($post_id): bool
    {
        if (!did_action('elementor/loaded')) {
            return false;
        }

        // Using the DB check is more reliable for background rendering
        return Plugin::$instance->db->is_built_with_elementor($post_id);
    }
}