<?php
if (!defined("ABSPATH")):
    die("Not Allowed");
endif;

if (!is_user_logged_in()):
    include $template_login;
    return;
endif;

global $wpdb;

$id = get_current_user_id();
$current_timestamp = current_time('timestamp');
$vtupress_users_table = $wpdb->prefix . "vtupress_users";

function keyExists($key, $array)
{
    if (array_key_exists($key, $array)) {
        return $array[$key];
    } else {
        return "";
    }
}
global $wpdb;
$stable_name = $wpdb->prefix . 'vtupress_general_settings';
$settings = $wpdb->get_results("SELECT * FROM  $stable_name ", ARRAY_A);
$settings = $settings[0];



$oldUser = false;
$users = new Users();
$user = $users->getUser($id, true, true);
if (empty($user)) {
    wp_die("Your data has not been synced, please contact admin ");
}

#if user is banned

if (preg_match("/ban/", $user["access_status"]) && !current_user_can("administrator")):
    wp_die("Your account has been banned.");
endif;

#check last active
$idle_timeout = !empty($settings["idle_timeout"]) ? intval($settings["idle_timeout"]) : 5;
$last_active = !empty($user["updated_at"]) ? $user["updated_at"] : date("Y-m-d H:i:s");

if (strtotime($last_active) < (strtotime("-$idle_timeout minutes")) && $idle_timeout != "0" && !current_user_can('administrator') && !current_user_can("vtupress_admin")):
    wp_logout();
    wp_die("Your session has timed out. Please refresh and login again.");
else:
    $runcode = date('Ymd', $current_timestamp) . date('H', $current_timestamp) . date("i", $current_timestamp) . date("s", $current_timestamp);

    $users->update($id, ['run_code' => $runcode]);
endif;

##accounts loadup
$accounts_table = $wpdb->prefix . 'vtupress_userAccounts';
// Logic: $user is fetched above using getUser which returns VP user details. $user['id'] is the VP ID.
$vp_user_id = $user['id'];
$accounts_result = $wpdb->get_results("SELECT * FROM $accounts_table WHERE userId = '$vp_user_id'", ARRAY_A);
$my_accounts = [];
if (!empty($accounts_result)):
    $my_accounts = $accounts_result;
endif;


$users = new Users();
$user = $users->getUser($id, true, true);

#levels
global $wpdb;
$levels_table = $wpdb->prefix . "vtupress_levels";
$levels = $wpdb->get_results("SELECT * FROM  $levels_table WHERE name = '{$user["plan"]}'", ARRAY_A);


#notification
$ntb = $wpdb->prefix . 'vtupress_notification_settings';
$notification_settings = $wpdb->get_results("SELECT * FROM  $ntb WHERE id = '1'", ARRAY_A);

if (isset($notification_settings[0])) {
    $notification_settings = $notification_settings[0];
}

$ts = $wpdb->prefix . 'vtupress_transaction_settings';
$transaction_settings = $wpdb->get_results("SELECT * FROM  $ts WHERE id = '1'", ARRAY_A);

if (isset($transaction_settings[0])) {
    $transaction_settings = $transaction_settings[0];
}

$wpuserdata = get_userdata($id);

$services = Vtupress_Service_Container::all(true);

$services_array = [];
foreach ($services as $s) {
    $services_array[$s->id]['status'] = $s->status;
}

$gateway_array = Vtupress_Gateway_Container::all();
$manual_gateway = Vtupress_Gateway_Container::get("manual");
$manual_gateway = $manual_gateway->get_settings();
