<?php
if(!defined('ABSPATH')) exit;


// 1. CALL PRELOAD FIRST

/**
 * Get WordPress page content by URL
 *
 * @param string $url Full URL or relative URL (e.g., /form)
 * @return string|null Returns page content or null if not found
 */
function wp_get_content_by_url($url) {
    // Convert full URL to relative path if needed
    $home_url = home_url('/');
    if (strpos($url, $home_url) === 0) {
        $url = str_replace($home_url, '/', $url);
    }

    // Remove query string if present
    $url = strtok($url, '?');

    // Get the page slug from the URL
    $slug = trim($url, '/');

    if (empty($slug)) {
        return null; // probably home page
    }

    // Get the page by path
    $page = get_page_by_path($slug);

    if (!$page) {
        return null; // page not found
    }
    Vtupress_Renderer::preload($page->ID); 

    // Return the content, processed through WordPress filters
    // return apply_filters('the_content', $page->post_content);
    // 2. RENDER CONTENT
    Vtupress_Renderer::render($page->ID);

}



?>
<div class="container-md mt-3" style="margin-top: 100px !important;">
        <div class="mb-2">
<?php
    wp_get_content_by_url($url);

?>
        </div>
</div>